/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class PhpIntroduceBaseNameSuggestionProvider {
    private static final Set<String> PRIMITIVES = ContainerUtil.newHashSet((Object[])new String[]{"arr", "str", "obj", "c", "s", "i", "n", "b", "t", "f", "r", "v", "d"});
    protected final PhpIntroduceContext myIntroduceContext;
    protected final PhpNameUtil.NameSuggestionsManager myManager;
    protected final Collection<String> myOccupiedNames;

    public PhpIntroduceBaseNameSuggestionProvider(PhpIntroduceContext introduceContext, Set<? extends PhpNamedElement> declarations) {
        this.myIntroduceContext = introduceContext;
        this.myManager = new PhpNameUtil.NameSuggestionsManager();
        HashSet<String> occupiedNames = new HashSet<String>();
        for (PhpNamedElement phpNamedElement : declarations) {
            occupiedNames.add(phpNamedElement.getName());
        }
        this.myOccupiedNames = occupiedNames;
    }

    public PhpIntroduceBaseNameSuggestionProvider(PhpIntroduceContext introduceContext, Collection<String> occupiedNames) {
        this.myIntroduceContext = introduceContext;
        this.myManager = new PhpNameUtil.NameSuggestionsManager();
        this.myOccupiedNames = occupiedNames;
    }

    public final String @NotNull [] getSuggestedNames() {
        HashSet<String> occupiedNames = new HashSet<String>(this.myOccupiedNames);
        this.suggest();
        List<String> suggestedNames = this.myManager.getSuggestions();
        if (suggestedNames.size() == 0) {
            suggestedNames.add(this.getDefaultName());
        }
        PhpNameUtil.unique(suggestedNames, occupiedNames);
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)ContainerUtil.filter(suggestedNames, PhpLangUtil.PHP_IDENTIFIER_CONDITION));
        if (stringArray == null) {
            PhpIntroduceBaseNameSuggestionProvider.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @NotNull
    protected abstract String getDefaultName();

    protected abstract void suggest();

    protected final void suggestVariableByType(@NotNull PhpTypedElement typedElement) {
        if (typedElement == null) {
            PhpIntroduceBaseNameSuggestionProvider.$$$reportNull$$$0(1);
        }
        List<String> names = PhpNameSuggestionUtil.variableNameByType(typedElement, this.myIntroduceContext.getProject(), true);
        for (String name : names) {
            if (PRIMITIVES.contains(name)) {
                this.myManager.add(name, 3);
                continue;
            }
            this.myManager.add(name, 2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/PhpIntroduceBaseNameSuggestionProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/PhpIntroduceBaseNameSuggestionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableByType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

