/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseSettings;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpBaseInplaceIntroducer<V extends PhpNamedElement, S extends PhpIntroduceBaseSettings>
extends AbstractInplaceIntroducer<V, PsiElement> {
    protected final PhpIntroduceContext myContext;
    protected final S mySettings;
    private final PhpIntroduceBaseHandler<S, ?> myIntroduceHandler;
    private PsiFile myFile;

    public PhpBaseInplaceIntroducer(@NotNull PhpIntroduceBaseHandler<S, ?> handler, @NotNull PhpIntroduceContext context, @NotNull S settings) {
        if (handler == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(2);
        }
        super(context.getProject(), context.getEditor(), context.getPhysicalElement(), null, context.getOccurrencesWithLogicalElement(), handler.getRefactoringName(), (FileType)PhpFileType.INSTANCE);
        this.myIntroduceHandler = handler;
        this.myContext = context;
        this.mySettings = settings;
    }

    @NotNull
    protected PhpIntroduceBaseHandler.PhpIntroduceResult runRefactoring() {
        PhpIntroduceBaseHandler.PhpIntroduceResult introduceResult = (PhpIntroduceBaseHandler.PhpIntroduceResult)WriteAction.compute(() -> {
            PhpIntroduceBaseHandler.PhpIntroduceResult result = this.myIntroduceHandler.doRefactoring(this.myContext, this.mySettings);
            if (result == null) {
                return null;
            }
            PsiDocumentManager.getInstance((Project)this.myContext.getProject()).doPostponedOperationsAndUnblockDocument(this.myContext.getEditor().getDocument());
            return result;
        });
        assert (introduceResult != null) : "failed to run refactoring";
        PsiElement element = introduceResult.getIntroducedElement();
        assert (element != null) : "smart pointer didn't survive";
        this.myFile = element.getContainingFile();
        PhpIntroduceBaseHandler.PhpIntroduceResult phpIntroduceResult = introduceResult;
        if (phpIntroduceResult == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(3);
        }
        return phpIntroduceResult;
    }

    protected String getActionName() {
        return this.myTitle;
    }

    protected abstract String @NotNull [] suggestNames(boolean var1, @Nullable V var2);

    protected void performIntroduce() {
    }

    public boolean isReplaceAllOccurrences() {
        return this.mySettings.isReplaceAllOccurrences();
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    @Nullable
    protected JComponent getComponent() {
        return null;
    }

    protected void saveSettings(@NotNull V variable) {
        if (variable == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(4);
        }
    }

    @Nullable
    protected V getVariable() {
        return null;
    }

    public PsiElement restoreExpression(@NotNull PsiFile containingFile, @NotNull V variable, @NotNull RangeMarker marker, @Nullable String exprText) {
        if (containingFile == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(5);
        }
        if (variable == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(6);
        }
        if (marker == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(7);
        }
        return null;
    }

    protected void restoreState(@NotNull V psiField) {
        if (psiField == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        return this.myElementToRename.getContainingFile();
    }

    protected void addReferenceAtCaret(Collection<PsiReference> refs) {
    }

    protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
        if (stringUsages == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(9);
        }
    }

    @Nullable
    protected <T extends PsiElement> T restoreElementFromMarker(@NotNull RangeMarker marker, @NotNull Class<T> elementClass) {
        if (marker == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(10);
        }
        if (elementClass == null) {
            PhpBaseInplaceIntroducer.$$$reportNull$$$0(11);
        }
        if (this.myFile == null || !this.myFile.isValid()) {
            return null;
        }
        PsiElement element = this.myFile.findElementAt(marker.getStartOffset());
        return PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)elementClass::isInstance));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/PhpBaseInplaceIntroducer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/PhpBaseInplaceIntroducer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runRefactoring";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restoreExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalElementsToRename";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "restoreElementFromMarker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

