/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline.function;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionPresenter;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionProcessor;
import org.jetbrains.annotations.NotNull;

public class PhpInlineFunctionDialog
extends InlineOptionsDialog {
    private final Function myFunction;
    private final FunctionReference myReference;

    protected PhpInlineFunctionDialog(Project project, Editor editor, Function function, FunctionReference functionReference) {
        super(project, true, (PsiElement)function);
        this.myFunction = function;
        this.myReference = functionReference;
        this.myInvokedOnReference = functionReference != null;
        this.setTitle(PhpBundle.message("refactoring.inline.function.title", StringUtil.capitalize((String)PhpInlineFunctionDialog.getElementKindDescription(this.myFunction))));
        this.init();
    }

    protected String getNameLabelText() {
        return PhpInlineFunctionPresenter.getElementDescription(this.myFunction, true);
    }

    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.method.border.title");
    }

    protected String getInlineAllText() {
        return PhpBundle.message("refactoring.inline.function.all.invocations.and.remove.the.method", PhpInlineFunctionDialog.getElementKindDescription(this.myFunction));
    }

    protected String getKeepTheDeclarationText() {
        if (this.myFunction.isWritable()) {
            return PhpBundle.message("refactoring.inline.function.all.invocations.keep.the.method", PhpInlineFunctionDialog.getElementKindDescription(this.myFunction));
        }
        return super.getKeepTheDeclarationText();
    }

    protected String getInlineThisText() {
        return PhpBundle.message("refactoring.inline.function.this.invocation.only.and.keep.the.method", PhpInlineFunctionDialog.getElementKindDescription(this.myFunction));
    }

    protected boolean isInlineThis() {
        return false;
    }

    protected void doAction() {
        this.invokeRefactoring(new PhpInlineFunctionProcessor(this.getProject(), this.myFunction, this.myReference, this.isInlineThisOnly(), !this.isKeepTheDeclaration()));
    }

    protected String getHelpId() {
        return "refactoring.inlineMethod";
    }

    @NotNull
    private static String getElementKindDescription(Function function) {
        return function instanceof Method ? "method" : "function";
    }
}

