/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline.constant;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.core.CoreBundle;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.ClassConstImpl;
import com.jetbrains.php.refactoring.inline.PhpInlineActionHandler;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpInlineConstantHandler
extends PhpInlineActionHandler {
    private static final String REFACTORING_HELP_ID = null;

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        if (element == null) {
            PhpInlineConstantHandler.showErrorHint(project, editor, PhpBundle.message("refactoring.inline.constant.cannot.extract.value", new Object[0]));
            return;
        }
        PhpReference reference = (PhpReference)ObjectUtils.tryCast((Object)TargetElementUtil.findReference((Editor)editor), PhpReference.class);
        if (reference != null && !(element instanceof Constant) && !(element instanceof ClassConstImpl)) {
            Collection elements = reference.resolveGlobal(false);
            if (elements.isEmpty()) {
                PhpInlineConstantHandler.showErrorHint(project, editor, PhpBundle.message("refactoring.inline.constant.cannot.extract.value", new Object[0]));
            } else if (elements.size() == 1) {
                this.invoke(project, editor, (PsiElement)ContainerUtil.getFirstItem((Collection)elements), reference);
            } else {
                this.showDeclarationChooser(project, editor, reference, elements);
            }
        } else {
            this.invoke(project, editor, element, reference);
        }
    }

    private void showDeclarationChooser(final Project project, final Editor editor, final @Nullable PhpReference reference, @NotNull Collection<? extends PhpNamedElement> elements) {
        if (elements == null) {
            PhpInlineConstantHandler.$$$reportNull$$$0(0);
        }
        Pass<PsiElement> callback = new Pass<PsiElement>(){

            public void pass(PsiElement constant) {
                PhpInlineConstantHandler.this.invoke(project, editor, constant, reference);
            }
        };
        JBPopupFactory.getInstance().createPopupChooserBuilder(new ArrayList<PhpNamedElement>(elements)).setTitle(CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setRenderer((ListCellRenderer)new DefaultPsiElementCellRenderer()).setItemChosenCallback(arg_0 -> PhpInlineConstantHandler.lambda$showDeclarationChooser$0((Pass)callback, arg_0)).createPopup().showInBestPositionFor(editor);
    }

    protected abstract void invoke(Project var1, Editor var2, @NotNull PsiElement var3, @Nullable PhpReference var4);

    public static void showErrorHint(Project project, Editor editor, @NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)message), (String)PhpInlineConstantHandler.getRefactoringName(), (String)REFACTORING_HELP_ID);
    }

    public static boolean validate(Project project, Editor editor, @NotNull PhpNamedElement constant, @Nullable PsiElement constantValue, @Nullable PhpReference reference) {
        if (constant == null) {
            PhpInlineConstantHandler.$$$reportNull$$$0(1);
        }
        if (reference != null && !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)reference)) {
            PhpInlineConstantHandler.showErrorHint(project, editor, CoreBundle.message((String)"editing.read.only.file.hint", (Object[])new Object[0]));
            return false;
        }
        if (constantValue == null) {
            PhpInlineConstantHandler.showErrorHint(project, editor, PhpBundle.message("refactoring.inline.constant.cannot.extract.value", new Object[0]));
            return false;
        }
        if (ReferencesSearch.search((PsiElement)constant, (SearchScope)ProjectScope.getProjectScope((Project)project), (boolean)false).findFirst() == null) {
            PhpInlineConstantHandler.showErrorHint(project, editor, PhpBundle.message("refactoring.inline.constant.is.never.used", constant.getName()));
            return false;
        }
        return true;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return PhpBundle.message("refactoring.inline.constant.name", new Object[0]);
    }

    private static /* synthetic */ void lambda$showDeclarationChooser$0(Pass callback, PhpNamedElement expr) {
        if (expr.isValid()) {
            callback.pass((Object)expr);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/inline/constant/PhpInlineConstantHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showDeclarationChooser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

