/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline.constant;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.ClassConstImpl;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.inline.constant.PhpInlineConstantHandler;
import com.jetbrains.php.refactoring.inline.constant.PhpInlineConstantProcessor;
import com.jetbrains.php.refactoring.inline.constant.classScope.PhpInlineClassConstantProcessor;
import com.jetbrains.php.refactoring.inline.constant.fileScope.PhpInlineFileConstantProcessor;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInlineConstantDialog
extends InlineOptionsDialog {
    protected final boolean myIsWritable;
    @Nullable
    protected final PhpReference myReference;
    private final String myConstantName;

    public PhpInlineConstantDialog(Project project, @NotNull PhpNamedElement element, @Nullable PhpReference reference) {
        if (element == null) {
            PhpInlineConstantDialog.$$$reportNull$$$0(0);
        }
        super(project, true, (PsiElement)element);
        this.setTitle(PhpInlineConstantHandler.getRefactoringName());
        this.myConstantName = element.getName();
        this.myIsWritable = PhpInlineConstantDialog.isInProject(project, (PsiElement)element) && element.isWritable();
        this.myReference = reference;
        this.myInvokedOnReference = reference != null;
        this.init();
    }

    protected String getNameLabelText() {
        return PhpBundle.message("constant.0", this.myConstantName);
    }

    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.field.border.title");
    }

    protected String getInlineThisText() {
        return PhpBundle.message("refactoring.inline.constant.this.reference.only", new Object[0]);
    }

    protected String getInlineAllText() {
        if (this.myIsWritable) {
            return PhpBundle.message("refactoring.inline.constant.all.references.and.remove", new Object[0]);
        }
        return RefactoringBundle.message((String)"all.invocations.in.project");
    }

    protected String getKeepTheDeclarationText() {
        if (this.myIsWritable) {
            return PhpBundle.message("refactoring.inline.constant.all.references.and.keep", new Object[0]);
        }
        return super.getKeepTheDeclarationText();
    }

    protected boolean isInlineThis() {
        return PhpRefactoringSettings.getInstance().INLINE_LOCAL_THIS;
    }

    protected void doAction() {
        PhpInlineConstantProcessor processor = this.createProcessor();
        if (processor != null) {
            this.invokeRefactoring(processor);
        }
    }

    @Nullable
    private PhpInlineConstantProcessor createProcessor() {
        boolean isInlineThisOnly = this.isInlineThisOnly();
        boolean needDeleteDeclaration = this.needDeleteDeclaration();
        if (this.myElement instanceof ClassConstImpl) {
            return new PhpInlineClassConstantProcessor(this.myProject, (ClassConstImpl)this.myElement, this.myReference, isInlineThisOnly, needDeleteDeclaration, this.myIsWritable);
        }
        if (this.myElement instanceof Constant) {
            return new PhpInlineFileConstantProcessor(this.myProject, (Constant)this.myElement, this.myReference, isInlineThisOnly, needDeleteDeclaration, this.myIsWritable);
        }
        return null;
    }

    protected boolean allowInlineAll() {
        return true;
    }

    protected boolean needDeleteDeclaration() {
        return this.myIsWritable && this.myRbInlineAll.isSelected();
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        Collection declarations;
        PsiReference firstUsage;
        if (this.myReference == null && (firstUsage = (PsiReference)ReferencesSearch.search((PsiElement)this.myElement, (SearchScope)ProjectScope.getProjectScope((Project)this.myProject), (boolean)false).findFirst()) instanceof PhpReference && (declarations = ((PhpReference)firstUsage).resolveGlobal(false)).size() > 1) {
            String message = PhpBundle.message("refactoring.inline.constant.multiple.declarations", new Object[0]);
            JBLabel warning = new JBLabel(message, AllIcons.General.BalloonWarning, 10);
            return JBUI.Panels.simplePanel().addToCenter((Component)warning);
        }
        return null;
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.inlineVariable";
    }

    public static boolean isInProject(Project project, @NotNull PsiElement element) {
        VirtualFile virtualFile;
        PsiFile containingFile;
        if (element == null) {
            PhpInlineConstantDialog.$$$reportNull$$$0(1);
        }
        return (containingFile = element.getContainingFile()) == null || (virtualFile = containingFile.getVirtualFile()) == null || ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/jetbrains/php/refactoring/inline/constant/PhpInlineConstantDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

