/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.inline.PhpInlineActionHandler;
import com.jetbrains.php.refactoring.inline.PhpInlineVariableDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInlineVariableHandler
extends PhpInlineActionHandler {
    public static final String REFACTORING_HELP_ID = "refactoring.inlineVariable";
    public static final String FEATURE_ID = "refactoring.inlineVariable";

    private static boolean isClosedDoubleQuotedString(@NotNull StringLiteralExpression stringLiteralExpression) {
        if (stringLiteralExpression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(0);
        }
        PsiElement lastChild = stringLiteralExpression.getLastChild();
        return PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.chRDOUBLE_QUOTE);
    }

    private static boolean isClosedHeredoc(@NotNull StringLiteralExpression stringLiteralExpression) {
        if (stringLiteralExpression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(1);
        }
        PsiElement lastChild = stringLiteralExpression.getLastChild();
        return PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.HEREDOC_END);
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof Variable && ((Variable)element).canReadName() || element instanceof Parameter;
    }

    public void inlineElement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(4);
        }
        try {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.inlineVariable");
            PhpInlineVariableHandler.invoke(project, editor);
        }
        catch (PhpRefactoringErrorException e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)e.getMessage()), (String)PhpBundle.message("dialog.title.inline.variable", new Object[0]), (String)"refactoring.inlineVariable");
        }
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor) throws PhpRefactoringErrorException {
        PsiReference psiReference;
        if (project == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(6);
        }
        if (!((psiReference = TargetElementUtil.findReference((Editor)editor)) instanceof Variable)) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.cannot.find.variable.to.inline", new Object[0]));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        PhpInlineVariableHandler.invoke(project, editor, (Variable)psiReference);
    }

    public static void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull Variable variable) throws PhpRefactoringErrorException {
        int i;
        boolean deleteInitializer;
        CharSequence variableName;
        if (project == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(7);
        }
        if (variable == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(8);
        }
        if ((variableName = variable.getNameCS()).length() == 0) {
            return;
        }
        PhpAccessVariableInstruction accessVariableInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        if (accessVariableInstruction == null) {
            return;
        }
        List<PhpAccessVariableInstruction> latestWriteAccesses = PhpInlineVariableHandler.getLatestVariableWriteAccess(accessVariableInstruction);
        if (latestWriteAccesses.size() != 1) {
            throw new PhpRefactoringErrorException(RefactoringBundle.message((String)"variable.has.no.dominating.definition"));
        }
        PhpAccessVariableInstruction latestWriteAccess = latestWriteAccesses.get(0);
        Ref initializerRef = new Ref();
        Ref valueRef = new Ref();
        PhpPsiElement writeVariable = latestWriteAccess.getAnchor();
        PsiElement parent = writeVariable.getParent();
        PhpAccessInstruction.Access access = latestWriteAccess.getAccess();
        if (access.isReadRef() || access.isReadWrite() || access.isWriteRef()) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.cannot.extract.value", variableName));
        }
        if (parent instanceof AssignmentExpression) {
            if (PhpElementTypes.MULTIASSIGNMENT_EXPRESSION == parent.getNode().getElementType()) {
                throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.cannot.extract.value", variableName));
            }
            valueRef.set((Object)((AssignmentExpression)parent).getValue());
            initializerRef.set((Object)((AssignmentExpression)parent));
        }
        if (valueRef.isNull()) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.cannot.extract.value", variableName));
        }
        List<PhpAccessVariableInstruction> followingReadAccesses = PhpInlineVariableHandler.getFollowingVariableReadAccess(latestWriteAccess);
        int readAccessSizeBeforeFiltering = followingReadAccesses.size();
        for (int i2 = followingReadAccesses.size() - 1; i2 >= 0; --i2) {
            PhpAccessVariableInstruction readAccess = followingReadAccesses.get(i2);
            if (!PhpInlineVariableHandler.isPossibleToInline(readAccess, PhpPsiUtil.unparenthesize((PsiElement)valueRef.get()))) {
                followingReadAccesses.remove(i2);
                continue;
            }
            List<PhpAccessVariableInstruction> writeAccesses = PhpInlineVariableHandler.getLatestVariableWriteAccess(readAccess);
            if (writeAccesses.size() == 1) continue;
            followingReadAccesses.remove(i2);
        }
        if (accessVariableInstruction == latestWriteAccess) {
            if (followingReadAccesses.size() == 0) {
                throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.no.occurrences", new Object[0]));
            }
        } else if (!followingReadAccesses.contains(accessVariableInstruction)) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.no.occurrences", variableName));
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
        boolean bl = deleteInitializer = scopeHolder != null && !PhpInlineVariableHandler.isReferenced(scopeHolder, latestWriteAccess) && readAccessSizeBeforeFiltering == followingReadAccesses.size();
        if (PhpInlineVariableHandler.editorIsAvailable(editor)) {
            boolean hasOccurrencesToReplace;
            highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{latestWriteAccess.getAnchor()}, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, true, null);
            Variable[] occurrences = new Variable[followingReadAccesses.size()];
            for (i = 0; i < followingReadAccesses.size(); ++i) {
                occurrences[i] = followingReadAccesses.get(i).getAnchor();
            }
            highlightManager.addOccurrenceHighlights(editor, (PsiElement[])occurrences, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            boolean invokedOnReference = followingReadAccesses.contains(accessVariableInstruction);
            boolean bl2 = hasOccurrencesToReplace = deleteInitializer || occurrences.length > 1;
            if (invokedOnReference && EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog() && hasOccurrencesToReplace) {
                PhpInlineVariableDialog dialog = new PhpInlineVariableDialog(project, variable, occurrences.length);
                if (!dialog.showAndGet()) {
                    PhpInlineVariableHandler.showAdviseToRemoveHighlighting(project);
                    return;
                }
                if (dialog.isInlineThis()) {
                    PhpInlineVariableHandler.replaceInstructionsWithOnlyCurrent(accessVariableInstruction, followingReadAccesses);
                    deleteInitializer = false;
                }
            }
        } else if (ApplicationManager.getApplication().isUnitTestMode() && PhpRefactoringSettings.getInstance().INLINE_LOCAL_THIS) {
            PhpInlineVariableHandler.replaceInstructionsWithOnlyCurrent(accessVariableInstruction, followingReadAccesses);
            deleteInitializer = false;
        }
        MultiMap variablesInString = new MultiMap();
        for (i = followingReadAccesses.size() - 1; i >= 0; --i) {
            PhpAccessVariableInstruction readAccess = followingReadAccesses.get(i);
            PhpPsiElement anchor = readAccess.getAnchor();
            StringLiteralExpression stringParent = (StringLiteralExpression)PhpPsiUtil.getParentByCondition((PsiElement)anchor, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF);
            if (stringParent == null) continue;
            followingReadAccesses.remove(i);
            variablesInString.putValue((Object)stringParent, (Object)((Variable)anchor));
        }
        PsiElement[] replacedOccurrences = new PsiElement[followingReadAccesses.size() + variablesInString.size()];
        boolean finalDeleteInitializer = deleteInitializer;
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            for (int i = 0; i < followingReadAccesses.size(); ++i) {
                PsiElement expression;
                PhpAccessVariableInstruction readAccess = (PhpAccessVariableInstruction)followingReadAccesses.get(i);
                PhpPsiElement anchor = readAccess.getAnchor();
                if (PhpInlineVariableHandler.isNecessaryToParenthesize(anchor, expression = (PsiElement)valueRef.get())) {
                    String parenthesizedText = "(" + expression.getText() + ")";
                    ParenthesizedExpression newElement = PhpPsiElementFactory.createPhpPsiFromText(project, ParenthesizedExpression.class, parenthesizedText);
                    replacedOccurrences[i] = PhpCodeEditUtil.replace((PsiElement)anchor, (PsiElement)newElement);
                    continue;
                }
                replacedOccurrences[i] = PhpCodeEditUtil.replace((PsiElement)anchor, expression);
            }
            for (StringLiteralExpression literalExpression : variablesInString.keySet()) {
                replacedOccurrences[i++] = PhpInlineVariableHandler.replaceVariableInString(literalExpression, variablesInString.get((Object)literalExpression), (PsiElement)valueRef.get());
            }
            if (finalDeleteInitializer) {
                PhpInlineVariableHandler.deleteExpression((PhpExpression)initializerRef.get());
            }
        }), RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{variableName}), null);
        if (PhpInlineVariableHandler.editorIsAvailable(editor)) {
            highlightManager.addOccurrenceHighlights(editor, replacedOccurrences, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            PhpInlineVariableHandler.showAdviseToRemoveHighlighting(project);
        }
    }

    private static boolean isReferenced(@NotNull PhpScopeHolder scopeHolder, @NotNull PhpAccessVariableInstruction accessInstruction) {
        if (scopeHolder == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(9);
        }
        if (accessInstruction == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(10);
        }
        if (accessInstruction.getAccess().isWriteRef()) {
            return true;
        }
        Function function = (Function)ObjectUtils.tryCast((Object)scopeHolder, Function.class);
        Variable variable = (Variable)ObjectUtils.tryCast((Object)accessInstruction.getAnchor(), Variable.class);
        if (function == null || variable == null) {
            return false;
        }
        if (!variable.canReadName()) {
            return false;
        }
        if (PhpControlFlowUtil.isReferencedInUseList(function, variable) || PhpControlFlowUtil.isPassByRefParameter(variable)) {
            return true;
        }
        if (!PhpControlFlowUtil.hasPredecessorWithRefAccess(accessInstruction, variable).booleanValue()) {
            return false;
        }
        return PhpInlineVariableHandler.hasWriteRefInScope(scopeHolder);
    }

    private static boolean hasWriteRefInScope(@NotNull PhpScopeHolder scopeHolder) {
        if (scopeHolder == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(11);
        }
        return StreamEx.of((Object[])scopeHolder.getControlFlow().getInstructions()).select(PhpAccessInstruction.class).anyMatch(instruction -> instruction.getAccess().isWriteRef());
    }

    private static void replaceInstructionsWithOnlyCurrent(PhpAccessVariableInstruction accessVariableInstruction, List<PhpAccessVariableInstruction> followingReadAccesses) {
        followingReadAccesses.clear();
        followingReadAccesses.add(accessVariableInstruction);
    }

    private static void showAdviseToRemoveHighlighting(@NotNull Project project) {
        if (project == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(12);
        }
        WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    private static boolean editorIsAvailable(@Nullable Editor editor) {
        return editor != null && !ApplicationManager.getApplication().isUnitTestMode();
    }

    private static boolean isPossibleToInline(@NotNull PhpAccessVariableInstruction instruction, @NotNull PsiElement value) {
        IElementType variableParentType;
        PhpPsiElement anchor;
        if (instruction == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(13);
        }
        if (value == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(14);
        }
        if (!((anchor = instruction.getAnchor()) instanceof Variable)) {
            return false;
        }
        if (instruction.getAccess().isLightRead()) {
            return false;
        }
        PsiElement variableParent = anchor.getParent();
        if (variableParent instanceof Variable || variableParent instanceof PhpUseList) {
            return false;
        }
        Object parentString = PhpPsiUtil.getParentByCondition(variableParent, false, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF);
        if (variableParent instanceof MemberReference) {
            if (((MemberReference)variableParent).getClassReference() != anchor || value instanceof StringLiteralExpression) {
                return false;
            }
        } else {
            if (variableParent instanceof FunctionReference) {
                return false;
            }
            if (variableParent instanceof ClassReference) {
                return false;
            }
            if (variableParent instanceof AssignmentExpression) {
                return !PhpWorkaroundUtil.isAssignByReference((AssignmentExpression)variableParent);
            }
        }
        if (PhpElementTypes.tsARRAY_EXPRESSIONS.contains(variableParentType = variableParent.getNode().getElementType())) {
            return value instanceof Variable;
        }
        if (parentString instanceof StringLiteralExpression) {
            IElementType parentType = parentString.getNode().getElementType();
            if (PhpElementTypes.HEREDOC.equals(parentType) && PhpInlineVariableHandler.isClosedHeredoc((StringLiteralExpression)parentString) || PhpElementTypes.STRING.equals(parentType) && PhpInlineVariableHandler.isClosedDoubleQuotedString((StringLiteralExpression)parentString)) {
                if (value instanceof StringLiteralExpression) {
                    return value.getChildren().length == 0;
                }
                return !PhpPsiUtil.isOfType(value, PhpElementTypes.FUNCTION_CALL, PhpElementTypes.NEW_EXPRESSION, PhpElementTypes.CLOSURE);
            }
            return false;
        }
        return true;
    }

    private static boolean isNecessaryToParenthesize(@NotNull PhpPsiElement variable, @NotNull PsiElement targetExpression) {
        if (variable == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(15);
        }
        if (targetExpression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(16);
        }
        if (targetExpression instanceof NewExpression && !(targetExpression.getParent() instanceof ParenthesizedExpression)) {
            return variable.getParent() instanceof MemberReference;
        }
        return false;
    }

    private static PsiElement replaceVariableInString(@NotNull StringLiteralExpression stringLiteral, @NotNull Collection<Variable> variables, @NotNull PsiElement value) {
        if (stringLiteral == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(17);
        }
        if (variables == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(18);
        }
        if (value == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(19);
        }
        String parentText = stringLiteral.getText();
        int parentStartOffset = stringLiteral.getTextRange().getStartOffset();
        String stringValue = PhpCodeInsightUtil.toString(value);
        StringBuilder builder = new StringBuilder();
        int lastEnd = 0;
        ArrayList<Variable> sortedVariables = new ArrayList<Variable>(variables);
        ContainerUtil.sort(sortedVariables, Comparator.comparing(v -> PhpInlineVariableHandler.getVariableRange(parentStartOffset, (PsiElement)v), Comparator.comparingInt(TextRange::getStartOffset)));
        for (Variable variable : sortedVariables) {
            PsiElement topmostVariable = PhpInlineVariableHandler.findTopmostVariable((PsiElement)variable);
            TextRange topmostVariableRange = PhpInlineVariableHandler.getVariableRange(parentStartOffset, topmostVariable);
            TextRange innerVariableRange = PhpInlineVariableHandler.getVariableRange(parentStartOffset, (PsiElement)variable);
            builder.append(parentText, lastEnd, topmostVariableRange.getStartOffset());
            if (stringValue == null) {
                builder.append("{");
                builder.append(value.getText());
                TextRange tailRange = TextRange.create((int)innerVariableRange.getEndOffset(), (int)topmostVariableRange.getEndOffset());
                if (!tailRange.isEmpty()) {
                    int endOffsetOfTopmostVariableContent = PhpPsiUtil.isOfType(topmostVariable.getLastChild(), PhpTokenTypes.chRBRACE) ? tailRange.getEndOffset() - 1 : tailRange.getEndOffset();
                    builder.append(parentText, tailRange.getStartOffset(), endOffsetOfTopmostVariableContent);
                }
                builder.append("}");
                lastEnd = tailRange.getEndOffset();
                continue;
            }
            builder.append(stringValue);
            lastEnd = innerVariableRange.getEndOffset();
        }
        builder.append(parentText, lastEnd, parentText.length());
        StringLiteralExpression newStringLiteral = PhpPsiElementFactory.createPhpPsiFromText(stringLiteral.getProject(), StringLiteralExpression.class, builder.toString());
        return stringLiteral.replace((PsiElement)newStringLiteral);
    }

    @NotNull
    private static PsiElement findTopmostVariable(@NotNull PsiElement variable) {
        if (variable == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(20);
        }
        while (!(variable.getParent() instanceof StringLiteralExpression)) {
            variable = variable.getParent();
        }
        PsiElement psiElement = variable;
        if (psiElement == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    @NotNull
    private static TextRange getVariableRange(int parentStartOffset, PsiElement variable) {
        TextRange textRange = variable.getTextRange().shiftLeft(parentStartOffset);
        if (textRange == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(22);
        }
        return textRange;
    }

    private static List<PhpAccessVariableInstruction> getLatestVariableWriteAccess(@NotNull PhpAccessVariableInstruction instruction) {
        if (instruction == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(23);
        }
        final CharSequence variableName = instruction.getVariableName();
        final ArrayList<PhpAccessVariableInstruction> latestWriteAccess = new ArrayList<PhpAccessVariableInstruction>();
        final Ref isEntryPointReached = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, true, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName()) && (access.isWrite() || access.isWriteRef() || access.isReadWrite() || access.isReadRef())) {
                    latestWriteAccess.add(instruction);
                    return false;
                }
                return true;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                isEntryPointReached.set((Object)true);
                return false;
            }
        });
        if (latestWriteAccess.size() == 0 || ((Boolean)isEntryPointReached.get()).booleanValue()) {
            return Collections.emptyList();
        }
        return latestWriteAccess;
    }

    private static List<PhpAccessVariableInstruction> getFollowingVariableReadAccess(@NotNull PhpAccessVariableInstruction instruction) {
        if (instruction == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(24);
        }
        final CharSequence variableName = instruction.getVariableName();
        final ArrayList<PhpAccessVariableInstruction> followingReadAccess = new ArrayList<PhpAccessVariableInstruction>();
        PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                    if (!(instruction.getAccess().isWrite() || instruction.getAccess().isWriteRef() || instruction.getAccess().isReadRef())) {
                        followingReadAccess.add(instruction);
                        return true;
                    }
                    return false;
                }
                return true;
            }
        });
        if (followingReadAccess.size() == 0) {
            return Collections.emptyList();
        }
        return followingReadAccess;
    }

    private static void deleteExpression(@NotNull PhpExpression expression) {
        if (expression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(25);
        }
        PsiElement parent = expression.getParent();
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.STATEMENT, PhpElementTypes.STATIC_STATEMENT)) {
            PsiElement nextSibling = parent.getNextSibling();
            if (nextSibling instanceof PsiWhiteSpace) {
                nextSibling.delete();
            }
            parent.getParent().deleteChildRange(parent, parent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteralExpression";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessInstruction";
                break;
            }
            case 13: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/inline/PhpInlineVariableHandler";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/inline/PhpInlineVariableHandler";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopmostVariable";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClosedDoubleQuotedString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isClosedHeredoc";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inlineElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isReferenced";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasWriteRefInScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showAdviseToRemoveHighlighting";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleToInline";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isNecessaryToParenthesize";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceVariableInString";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostVariable";
                break;
            }
            case 21: 
            case 22: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLatestVariableWriteAccess";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFollowingVariableReadAccess";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deleteExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

