/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.importReferences;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceExtractor;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceStorage;
import com.jetbrains.php.refactoring.move.function.PhpMoveFunctionProcessor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassReferenceResolver
extends PhpClassReferenceExtractor {
    protected final Set<String> mySkipReferences;
    private final PhpClassReferenceStorage myCandidatesToImportStorage = new PhpClassReferenceStorage();

    public PhpClassReferenceResolver() {
        this.mySkipReferences = new THashSet();
    }

    public void setProcessKwParent(boolean processKwParent) {
        this.myProcessKwParent = processKwParent;
    }

    public void processElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(0);
        }
        this.processElement(element, true);
    }

    @Override
    public void processElement(@NotNull PsiElement element, boolean withPhpDoc) {
        if (element == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(1);
        }
        if (element instanceof PhpClass) {
            this.mySkipReferences.add(((PhpClass)element).getFQN());
        }
        super.processElement(element, withPhpDoc);
    }

    public void processElements(@NotNull Collection<? extends PsiElement> originalElements) {
        if (originalElements == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(2);
        }
        this.processElements(originalElements, true);
    }

    @Override
    public void processElements(@NotNull Collection<? extends PsiElement> originalElements, boolean withPhpDoc) {
        if (originalElements == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(3);
        }
        super.processElements(originalElements, withPhpDoc);
    }

    @Override
    @Deprecated
    protected void processReference(@NotNull String name, @NotNull String fqn, @NotNull PsiElement identifier) {
        if (name == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(5);
        }
        if (identifier == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void processReference(@NotNull String name, @NotNull String fqn, @NotNull PsiElement identifier, @NotNull PhpReference reference) {
        if (name == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(7);
        }
        if (fqn == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(8);
        }
        if (identifier == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(9);
        }
        if (reference == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(10);
        }
        if (!this.skipReference(fqn, reference) && !PhpType.isPrimitiveType((String)name)) {
            this.myCandidatesToImportStorage.processReference(name, fqn, identifier, reference);
        }
    }

    protected boolean skipReference(@NotNull String fqn, @NotNull PhpReference reference) {
        if (fqn == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(11);
        }
        if (reference == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(12);
        }
        if (!(reference instanceof ClassReference || PhpLangUtil.isThisReference((PsiElement)reference) || reference instanceof PhpDocType)) {
            return true;
        }
        return this.mySkipReferences.contains(fqn);
    }

    @Nullable
    private static String alreadyImported(@NotNull PhpPsiElement scopeHolder, @NotNull Map<String, String> aliases, @NotNull String fqn, @NotNull String name) {
        boolean isSameNamespace;
        if (scopeHolder == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(13);
        }
        if (aliases == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(14);
        }
        if (fqn == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(15);
        }
        if (name == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(16);
        }
        if ((isSameNamespace = PhpCodeInsightUtil.isSameNamespace(scopeHolder, fqn)) && PhpLangUtil.equalsClassNames(PhpLangUtil.toShortName(fqn), name)) {
            return name;
        }
        boolean isNonCompound = PhpClassReferenceResolver.isNonCompoundUseName(scopeHolder, fqn, name);
        if (isNonCompound) {
            return name;
        }
        for (Map.Entry<String, String> alias : aliases.entrySet()) {
            if (!PhpLangUtil.equalsClassNames(alias.getValue(), fqn)) continue;
            return alias.getKey();
        }
        return null;
    }

    public static boolean isNonCompoundUseName(@NotNull PhpPsiElement scopeHolder, @NotNull String fqn, @NotNull String name) {
        if (scopeHolder == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(17);
        }
        if (fqn == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(18);
        }
        if (name == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(19);
        }
        String currentNamespaceName = scopeHolder instanceof PhpNamespace ? ((PhpNamespace)scopeHolder).getFQN() : "";
        return "\\".equals(currentNamespaceName) && PhpLangUtil.equalsClassNames(fqn, PhpLangUtil.toFQN(name));
    }

    public void importReferences(@NotNull PhpPsiElement scopeHolder, @NotNull List<PsiElement> movedElements) {
        Map<Pair<String, PhpGroupUseElement.PhpUseKeyword>, String> referencesToReplace;
        if (scopeHolder == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(20);
        }
        if (movedElements == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(21);
        }
        if (!(referencesToReplace = this.importWithConflictResolve(scopeHolder)).isEmpty()) {
            PhpClassReferenceRenamer renamer = new PhpClassReferenceRenamer(scopeHolder.getProject(), referencesToReplace);
            renamer.processElements(movedElements, true);
        }
    }

    public void importReferences(@NotNull PhpPsiElement scopeHolder, @NotNull PsiElement movedElement) {
        Map<Pair<String, PhpGroupUseElement.PhpUseKeyword>, String> referencesToReplace;
        if (scopeHolder == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(22);
        }
        if (movedElement == null) {
            PhpClassReferenceResolver.$$$reportNull$$$0(23);
        }
        if (!(referencesToReplace = this.importWithConflictResolve(scopeHolder)).isEmpty()) {
            PhpClassReferenceRenamer renamer = new PhpClassReferenceRenamer(scopeHolder.getProject(), referencesToReplace);
            renamer.processElement(movedElement, true);
        }
    }

    private Map<Pair<String, PhpGroupUseElement.PhpUseKeyword>, String> importWithConflictResolve(PhpPsiElement scopeHolder) {
        THashMap referencesToReplace = new THashMap();
        boolean autoImport = PhpCodeInsightUtil.isAutoImportEnabled(scopeHolder);
        for (String name : this.myCandidatesToImportStorage.getNames()) {
            String originalFqn = this.myCandidatesToImportStorage.getFqnByName(name);
            PhpGroupUseElement.PhpUseKeyword keyword = this.myCandidatesToImportStorage.getUseKeywordByName(name);
            Map<String, String> aliases = PhpCodeInsightUtil.getAliasesInScope(scopeHolder, keyword);
            assert (originalFqn != null);
            String alias = PhpClassReferenceResolver.alreadyImported(scopeHolder, aliases, originalFqn, name);
            if (alias != null) {
                if (PhpLangUtil.equalsClassNames(name, alias)) continue;
                referencesToReplace.put(Pair.create((Object)name, (Object)((Object)keyword)), alias);
                continue;
            }
            if (!autoImport) {
                referencesToReplace.put(Pair.create((Object)name, (Object)((Object)keyword)), originalFqn);
                continue;
            }
            String importedFqn = aliases.get(name);
            if (PhpLangUtil.equalsClassNames(importedFqn, originalFqn)) continue;
            if (importedFqn != null && keyword == PhpGroupUseElement.PhpUseKeyword.CLASS) {
                String originalName = PhpLangUtil.toShortName(originalFqn);
                String fqnForOriginalName = aliases.get(originalName);
                if (fqnForOriginalName == null || PhpLangUtil.equalsClassNames(fqnForOriginalName, originalFqn)) {
                    referencesToReplace.put(Pair.create((Object)name, (Object)((Object)keyword)), originalName);
                    if (fqnForOriginalName != null) continue;
                    PhpClassReferenceResolver.insertUseStatement(scopeHolder, keyword.getValue(), originalName, originalFqn);
                    continue;
                }
                referencesToReplace.put(Pair.create((Object)name, (Object)((Object)keyword)), originalFqn);
                continue;
            }
            PhpClassReferenceResolver.insertUseStatement(scopeHolder, keyword.getValue(), name, originalFqn);
        }
        return referencesToReplace;
    }

    private static void insertUseStatement(PhpPsiElement scopeHolder, String keyword, String aliasName, String originalFqn) {
        String originalName = PhpLangUtil.toShortName(originalFqn);
        if (PhpLangUtil.equalsClassNames(originalName, aliasName)) {
            PhpAliasImporter.insertUseStatementWithKeyword(keyword, originalFqn, null, scopeHolder);
        } else {
            PhpAliasImporter.insertUseStatementWithKeyword(keyword, originalFqn, aliasName, scopeHolder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElements";
                break;
            }
            case 4: 
            case 7: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 13: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedElements";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/importReferences/PhpClassReferenceResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processReference";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "skipReference";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "alreadyImported";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isNonCompoundUseName";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "importReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PhpClassReferenceRenamer
    extends PhpClassReferenceExtractor {
        private final Project myProject;
        private final Map<Pair<String, PhpGroupUseElement.PhpUseKeyword>, String> myRefToRename;

        private PhpClassReferenceRenamer(Project project, Map<Pair<String, PhpGroupUseElement.PhpUseKeyword>, String> replaceWithFqn) {
            this.myProject = project;
            this.myRefToRename = replaceWithFqn;
        }

        @Override
        @Deprecated
        protected void processReference(@NotNull String name, @NotNull String fqn, @NotNull PsiElement identifier) {
            if (name == null) {
                PhpClassReferenceRenamer.$$$reportNull$$$0(0);
            }
            if (fqn == null) {
                PhpClassReferenceRenamer.$$$reportNull$$$0(1);
            }
            if (identifier == null) {
                PhpClassReferenceRenamer.$$$reportNull$$$0(2);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        protected void processReference(@NotNull String name, @NotNull String referenceName, @NotNull PsiElement identifier, @NotNull PhpReference reference) {
            Pair key;
            if (name == null) {
                PhpClassReferenceRenamer.$$$reportNull$$$0(3);
            }
            if (referenceName == null) {
                PhpClassReferenceRenamer.$$$reportNull$$$0(4);
            }
            if (identifier == null) {
                PhpClassReferenceRenamer.$$$reportNull$$$0(5);
            }
            if (reference == null) {
                PhpClassReferenceRenamer.$$$reportNull$$$0(6);
            }
            if (this.myRefToRename.containsKey(key = Pair.create((Object)name, (Object)((Object)PhpBaseImportQuickFix.getKeyword(reference))))) {
                Object oldReference;
                PsiElement newReference;
                String fqn = this.myRefToRename.get(key);
                if (PhpPsiUtil.isOfType(identifier, PhpTokenTypes.IDENTIFIER) || identifier instanceof ClassReference) {
                    newReference = this.createNewReference(reference, fqn);
                    oldReference = PhpPsiUtil.getParentByCondition(identifier, false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                } else {
                    newReference = PhpPsiElementFactory.createPhpDocType(this.myProject, fqn);
                    oldReference = PhpPsiUtil.getParentByCondition(identifier, false, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF);
                }
                assert (newReference != null);
                assert (oldReference != null);
                PsiElement added = oldReference.addRange(newReference.getFirstChild(), newReference.getLastChild());
                oldReference.deleteChildRange(oldReference.getFirstChild(), added.getPrevSibling());
            }
        }

        @Nullable
        private PsiElement createNewReference(@NotNull PhpReference reference, String newFqn) {
            if (reference == null) {
                PhpClassReferenceRenamer.$$$reportNull$$$0(7);
            }
            if (reference instanceof FunctionReference) {
                return PhpMoveFunctionProcessor.createFunctionCall(this.myProject, newFqn, (FunctionReference)reference, true);
            }
            return PhpPsiElementFactory.createClassReference(this.myProject, newFqn);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifier";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceName";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/importReferences/PhpClassReferenceResolver$PhpClassReferenceRenamer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processReference";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNewReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

