/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractMethod;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.core.CoreBundle;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpBreakContinueInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInterruptScriptInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpThrowInstruction;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpMissingFieldTypeInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.RWAccess;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.DeclareImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodBlockCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodDialog;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodExpressionCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodParameterInfo;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodSettings;
import com.jetbrains.php.refactoring.extractMethod.PhpParametersFolder;
import com.jetbrains.php.refactoring.extractMethod.PhpSimpleDuplicatesFinder;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.validation.PhpFunctionInScopeConflictDetector;
import com.jetbrains.php.refactoring.validation.PhpMethodConflictDetector;
import com.jetbrains.php.ui.PhpUiUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractMethodHandler
implements RefactoringActionHandler {
    private static final PhpFunctionCodeGenerator IMPLEMENTATION = new PhpFunctionCodeGenerator.PhpFunctionImplementationGenerator(){

        @Override
        protected void appendReturnTypePart(StringBuilder builder, String returnTypeText) {
        }
    };
    private static final Logger LOG = Logger.getInstance(PhpExtractMethodHandler.class);
    private static final String HELP_ID = "refactoring.extractMethod";

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(0);
        }
        this.invoke(project, editor, file);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(2);
        }
    }

    public final void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(5);
        }
        try {
            this._invoke(editor, file);
        }
        catch (PhpRefactoringErrorException e) {
            String errorMessage = e.getMessage();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException(errorMessage);
            }
            String message = RefactoringBundle.getCannotRefactorMessage((String)errorMessage);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)PhpExtractMethodHandler.getRefactoringName(), (String)HELP_ID);
        }
    }

    private void _invoke(final @NotNull Editor editor, final @NotNull PsiFile file) throws PhpRefactoringErrorException {
        Project project;
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(6);
        }
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(7);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)(project = file.getProject()), (PsiElement)file)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CoreBundle.message((String)"editing.read.only.file.hint", (Object[])new Object[0]), (String)PhpExtractMethodHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            List<PhpExpression> expressions = PhpExtractMethodHandler.collectExtractableExpressions(file, selectionModel.getSelectionStart());
            if (expressions.size() == 1) {
                this.extractFromExpression(editor, file, (PhpExpression)ContainerUtil.getOnlyItem(expressions));
                return;
            }
            if (expressions.size() > 1) {
                IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<PhpExpression>(){

                    public void pass(PhpExpression expression) {
                        PhpExtractMethodHandler.this.extractFromExpression(editor, file, expression);
                    }
                }, PhpIntroduceBaseHandler::getTrimmedText);
                return;
            }
            editor.getSelectionModel().selectLineAtCaret();
        }
        int startOffset = selectionModel.getSelectionStart();
        int endOffset = selectionModel.getSelectionEnd();
        PsiElement startElement = file.findElementAt(startOffset);
        PsiElement endElement = file.findElementAt(endOffset - 1);
        if (startElement instanceof PsiWhiteSpace) {
            startOffset = startElement.getTextRange().getEndOffset();
            startElement = file.findElementAt(startOffset);
        }
        if (endElement instanceof PsiWhiteSpace) {
            endOffset = endElement.getTextRange().getStartOffset();
            endElement = file.findElementAt(endOffset - 1);
        }
        if (startElement == null || startElement.getTextRange().getStartOffset() != startOffset || endElement == null || endElement.getTextRange().getEndOffset() != endOffset) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.extract.method.error.selected.block.should.represent.a.set.of.statement.or.an.expression", new Object[0]));
        }
        PhpExtractMethodBlockCodeFragment codeFragment = PhpExtractMethodHandler.tryToDetectBlockRangeElements(file, startElement, endElement);
        if (codeFragment != null) {
            if (codeFragment.getStartElement().getParent() != codeFragment.getEndElement().getParent() || codeFragment.getStartStatement().getParent() != codeFragment.getStartStatement().getParent()) {
                throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.extract.method.error.a.set.of.statements.should.be.from.the.same.code.block", new Object[0]));
            }
            this.extractFromCodeBlock(editor, codeFragment);
            return;
        }
        this.tryExtractFromExpression(editor, file, startOffset, endOffset);
    }

    private void extractFromExpression(@NotNull Editor editor, @NotNull PsiFile file, PhpExpression expression) {
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(9);
        }
        PhpScopeHolder scopeHolder = (PhpScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)expression, PhpScopeHolder.class, (boolean)false, (Class[])new Class[]{PhpClass.class});
        assert (scopeHolder != null);
        this.extractFromExpression(editor, new PhpExtractMethodExpressionCodeFragment(file, scopeHolder, expression));
    }

    @Nullable
    public static PhpExtractMethodBlockCodeFragment tryToDetectBlockRangeElements(@NotNull PsiFile file, PsiElement startElement, PsiElement endElement) {
        Statement endStatement;
        PsiComment blockEndElement;
        PsiElement directive;
        Statement startStatement;
        PsiComment blockStartElement;
        PsiComment startComment;
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(10);
        }
        if ((startComment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiComment.class, (boolean)false)) != null) {
            blockStartElement = startComment;
            startStatement = PhpExtractMethodHandler.findEndStatement(null, PhpPsiUtil.getNextSibling((PsiElement)blockStartElement, PhpPsiUtil.PSI_COMMENT_INSTANCEOF, PhpPsiUtil.PSI_WHITE_SPACE_INSTANCEOF));
        } else {
            startStatement = PhpExtractMethodHandler.findStartStatement(startElement);
            blockStartElement = startStatement;
        }
        if (startStatement instanceof Declare && (directive = DeclareImpl.getStrictTypesDirective((Declare)startStatement)) != null) {
            return null;
        }
        PsiComment endComment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)endElement, PsiComment.class, (boolean)false);
        if (endComment != null) {
            blockEndElement = endComment;
            endStatement = PhpExtractMethodHandler.findEndStatement((PsiElement)blockStartElement, PhpPsiUtil.getPrevSibling((PsiElement)blockEndElement, PhpPsiUtil.PSI_COMMENT_INSTANCEOF, PhpPsiUtil.PSI_WHITE_SPACE_INSTANCEOF));
        } else {
            endStatement = PhpExtractMethodHandler.findEndStatement((PsiElement)blockStartElement, endElement);
            blockEndElement = endStatement;
        }
        PhpScopeHolder scopeHolder = (PhpScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)startStatement, PhpScopeHolder.class, (boolean)false);
        if (scopeHolder != null && blockEndElement != null && endStatement != null) {
            return new PhpExtractMethodBlockCodeFragment(file, scopeHolder, (PsiElement)blockStartElement, (PsiElement)blockEndElement, startStatement, endStatement);
        }
        return null;
    }

    public static List<PhpExpression> collectExtractableExpressions(@NotNull PsiFile file, int offset) {
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(11);
        }
        PsiElement elementAtCaret = file.findElementAt(offset);
        ArrayList<PhpExpression> expressions = new ArrayList<PhpExpression>();
        PhpExpression expression = (PhpExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PhpExpression.class);
        while (expression != null) {
            if (!(expressions.contains(expression) || expression instanceof ParenthesizedExpression || expression instanceof ArrayIndex || PhpIntroduceBaseHandler.isThisReferenceInMemberContext((PsiElement)expression, expression.getParent()) || !PhpExtractMethodHandler.isExtractable(expression))) {
                expressions.add(expression);
            }
            expression = (PhpExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PhpExpression.class);
        }
        return expressions;
    }

    public static boolean isExtractable(@NotNull PhpExpression expression) {
        if (expression == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(12);
        }
        PhpScopeHolder scopeHolder = (PhpScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)expression, PhpScopeHolder.class, (boolean)false, (Class[])new Class[]{PhpClass.class});
        return PhpExtractMethodHandler.validateExpression(expression.getContainingFile(), scopeHolder, expression, expression.getTextRange().getEndOffset()) == null;
    }

    private void tryExtractFromExpression(@NotNull Editor editor, @NotNull PsiFile file, int startOffset, int endOffset) throws PhpRefactoringErrorException {
        PhpExpression expression;
        PhpScopeHolder scopeHolder;
        String error;
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(13);
        }
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(14);
        }
        if ((error = PhpExtractMethodHandler.validateExpression(file, scopeHolder = (PhpScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)(expression = (PhpExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, PhpExpression.class)), PhpScopeHolder.class, (boolean)false, (Class[])new Class[]{PhpClass.class}), expression, endOffset)) != null) {
            throw new PhpRefactoringErrorException(error);
        }
        assert (scopeHolder != null);
        PhpExtractMethodExpressionCodeFragment fragment = new PhpExtractMethodExpressionCodeFragment(file, scopeHolder, expression);
        this.extractFromExpression(editor, fragment);
    }

    @Nullable
    private static String validateExpression(@NotNull PsiFile file, @Nullable PhpScopeHolder scopeHolder, @Nullable PhpExpression expression, int endOffset) {
        if (file == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(15);
        }
        if (expression == null || expression.getTextRange().getEndOffset() != endOffset) {
            return PhpBundle.message("refactoring.extract.method.error.selected.block.should.represent.a.set.of.statement.or.an.expression", new Object[0]);
        }
        if (scopeHolder == null || scopeHolder instanceof Function && FunctionImpl.isShortArrowFunction((Function)scopeHolder)) {
            return PhpBundle.message("refactoring.common.not.supported.context", PhpExtractMethodHandler.getRefactoringName());
        }
        if (!PhpRefactoringUtil.isExtractableExpression(expression)) {
            return PhpBundle.message("refactoring.common.not.extractable.expression", new Object[0]);
        }
        if (expression instanceof RWAccess && ((RWAccess)expression).isWriteAccess()) {
            return PhpBundle.message("refactoring.common.not.extractable.expression", new Object[0]);
        }
        if (PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)((Condition)PhpAttribute.class::isInstance)) != null) {
            return PhpBundle.message("refactoring.common.not.supported.context", PhpExtractMethodHandler.getRefactoringName());
        }
        if (PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF) != null) {
            return PhpBundle.message("refactoring.extract.method.error.selected.block.should.represent.a.set.of.statement.or.an.expression", new Object[0]);
        }
        if (PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)PhpUse.INSTANCEOF) != null) {
            return PhpBundle.message("refactoring.common.not.supported.context", PhpExtractMethodHandler.getRefactoringName());
        }
        if (expression instanceof ClassReference) {
            return PhpBundle.message("refactoring.common.not.extractable.expression", new Object[0]);
        }
        if (expression instanceof Variable && StringUtil.isEmpty((String)expression.getName()) || expression instanceof AssignmentExpression) {
            return PhpBundle.message("refactoring.common.not.extractable.expression", new Object[0]);
        }
        if (PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)((Condition)e -> e instanceof Parameter || e instanceof Constant || e instanceof Field)) != null) {
            return PhpBundle.message("refactoring.common.not.supported.context", PhpExtractMethodHandler.getRefactoringName());
        }
        PhpExtractMethodExpressionCodeFragment fragment = new PhpExtractMethodExpressionCodeFragment(file, scopeHolder, expression);
        String error = fragment.validate();
        if (StringUtil.isNotEmpty((String)error)) {
            LOG.error(error);
            return PhpBundle.message("refactoring.common.fail.to.extract.expression", new Object[0]);
        }
        return null;
    }

    private void extractFromCodeBlock(@NotNull Editor editor, @NotNull PhpExtractMethodBlockCodeFragment blockCodeFragment) throws PhpRefactoringErrorException {
        String error;
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(16);
        }
        if (blockCodeFragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(17);
        }
        if (StringUtil.isNotEmpty((String)(error = blockCodeFragment.validate()))) {
            LOG.error(error);
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.extract.method.error.can.not.extract.statements", new Object[0]));
        }
        int length = blockCodeFragment.getEndOffset() - blockCodeFragment.getStartOffset();
        if (length < 0) {
            LOG.error("Can not extract text from: '" + blockCodeFragment.getStartElement().getText() + "', to: '" + blockCodeFragment.getEndElement().getText() + "'");
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.extract.method.error.can.not.extract.statements", new Object[0]));
        }
        this.extractFromBlock(editor, blockCodeFragment);
    }

    @Nullable
    private static Statement findStartStatement(@Nullable PsiElement startElement) {
        if (startElement == null) {
            return null;
        }
        int startOffset = startElement.getTextRange().getStartOffset();
        Statement prevStatement = null;
        Statement curStatement = (Statement)PsiTreeUtil.getParentOfType((PsiElement)startElement, Statement.class, (boolean)false);
        while (curStatement != null && curStatement.getTextRange().getStartOffset() == startOffset) {
            if (!(curStatement instanceof GroupStatement)) {
                prevStatement = curStatement;
            }
            curStatement = (Statement)PsiTreeUtil.getParentOfType((PsiElement)curStatement, Statement.class);
        }
        return prevStatement;
    }

    @Nullable
    private static Statement findEndStatement(@Nullable PsiElement startElement, @Nullable PsiElement endElement) {
        TextRange startElementRange;
        if (endElement == null) {
            return null;
        }
        int endOffset = endElement.getTextRange().getEndOffset();
        Statement prevElement = null;
        Statement curStatement = (Statement)PsiTreeUtil.getParentOfType((PsiElement)endElement, Statement.class, (boolean)false);
        TextRange textRange = startElementRange = startElement == null ? null : startElement.getTextRange();
        while (curStatement != null && curStatement.getTextRange().getEndOffset() == endOffset && !PhpExtractMethodHandler.strictContains((PsiElement)curStatement, startElementRange)) {
            if (!(curStatement instanceof GroupStatement)) {
                prevElement = curStatement;
            }
            curStatement = (Statement)PsiTreeUtil.getParentOfType((PsiElement)curStatement, Statement.class);
        }
        return prevElement;
    }

    private static boolean strictContains(@NotNull PsiElement element, @Nullable TextRange textRange) {
        if (element == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(18);
        }
        TextRange elementTextRange = element.getTextRange();
        return textRange != null && !elementTextRange.equalsToRange(textRange.getStartOffset(), textRange.getEndOffset()) && elementTextRange.contains(textRange);
    }

    private void extractFromExpression(@NotNull Editor editor, @NotNull PhpExtractMethodExpressionCodeFragment fragment) {
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(19);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(20);
        }
        Statement anchorStatement = (Statement)PsiTreeUtil.getParentOfType((PsiElement)fragment.getExpression(), Statement.class);
        assert (anchorStatement != null);
        Project project = fragment.getScopeHolder().getProject();
        PhpExtractMethodSettings settings = this._getSettings(fragment);
        if (settings == null) {
            return;
        }
        fragment.setPassOutputByRefParam(settings.isPassOutputByReference());
        WriteCommandAction.runWriteCommandAction((Project)project, (String)PhpExtractMethodHandler.getRefactoringName(), (String)HELP_ID, () -> {
            PhpExpression elementToReplace;
            Ref callElementOffset = Ref.create();
            PhpExtractMethodHandler.addRestoreSelectionAndCaretUndoableAction(project, editor, (Ref<Integer>)callElementOffset);
            PhpExpression callExpression = PhpExtractMethodHandler.createCallExpression(fragment, settings);
            PsiElement functionDefinition = PhpExtractMethodHandler.addFunctionDefinition(fragment, settings, (PsiElement)anchorStatement);
            PhpExpression expression = fragment.getExpression();
            Object object = elementToReplace = expression instanceof ArrayIndex ? ((ArrayIndex)expression).getValue() : expression;
            assert (elementToReplace != null);
            PsiElement callElement = elementToReplace.replace((PsiElement)callExpression);
            callElementOffset.set((Object)callElement.getTextOffset());
            PhpExtractMethodHandler.removeSelectionAndMoveCaretToElement(editor, callElement);
            if (settings.processDuplicates()) {
                PhpExtractMethodHandler.processDuplicates(functionDefinition, callElement, fragment, editor);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    @NotNull
    public static PhpSimpleDuplicatesFinder createDuplicatesFinder(@NotNull PhpExtractMethodCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(21);
        }
        return new PhpSimpleDuplicatesFinder(fragment.getStartStatement(), fragment.getEndStatement(), PhpExtractMethodHandler.transform(PhpExtractMethodHandler.getInputVariables(fragment)), PhpExtractMethodHandler.castOutput(PhpExtractMethodHandler.getOutputVariables(fragment)));
    }

    private void extractFromBlock(@NotNull Editor editor, final @NotNull PhpExtractMethodBlockCodeFragment fragment) throws PhpRefactoringErrorException {
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(22);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(23);
        }
        editor.getSelectionModel().setSelection(fragment.getStartOffset(), fragment.getEndOffset());
        PhpScopeHolder scopeHolder = fragment.getScopeHolder();
        Project project = scopeHolder.getProject();
        PhpControlFlow controlFlow = scopeHolder.getControlFlow();
        PhpStatementInstruction startInstruction = PhpControlFlowUtil.getStatementInstruction(controlFlow, fragment.getStartStatement());
        PhpStatementInstruction endInstruction = PhpControlFlowUtil.getStatementInstruction(controlFlow, fragment.getEndStatement());
        if (startInstruction == null || endInstruction == null) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.extract.method.error.a.set.of.statements.should.be.from.the.same.code.block", new Object[0]));
        }
        final Ref isBreakContinueOutExistsRef = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)startInstruction, true, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                return fragment.contains(instruction.getStatement().getTextRange());
            }

            public boolean processBreakContinueInstruction(PhpBreakContinueInstruction gotoInstruction) {
                Statement targetStatement = gotoInstruction.getTargetStatement();
                if (targetStatement != null && !fragment.contains(targetStatement.getTextRange())) {
                    isBreakContinueOutExistsRef.set((Object)true);
                }
                return true;
            }
        });
        if (((Boolean)isBreakContinueOutExistsRef.get()).booleanValue()) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.extract.method.error.there.are.break.continue.operators.which.can.interrupt.execution", new Object[0]));
        }
        final Ref isOutStatementReachableRef = new Ref((Object)false);
        final Ref isReturnReachableRef = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)startInstruction, true, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                if (!fragment.contains(instruction.getStatement().getTextRange())) {
                    isOutStatementReachableRef.set((Object)true);
                    return false;
                }
                return true;
            }

            public boolean processThrowInstruction(PhpThrowInstruction instruction) {
                return false;
            }

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                isReturnReachableRef.set((Object)true);
                return false;
            }
        });
        if (((Boolean)isOutStatementReachableRef.get()).booleanValue() && ((Boolean)isReturnReachableRef.get()).booleanValue()) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.extract.method.error.inconsistent.return.points.in.selected.code.fragment", new Object[0]));
        }
        PhpExtractMethodSettings settings = this._getSettings(fragment);
        if (settings == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)PhpExtractMethodHandler.getRefactoringName(), (String)HELP_ID, () -> {
            Ref callElementOffset = Ref.create();
            PhpExtractMethodHandler.addRestoreSelectionAndCaretUndoableAction(project, editor, (Ref<Integer>)callElementOffset);
            Statement callStatement = PhpExtractMethodHandler.createCallStatement(fragment, settings);
            PsiElement anchor = PhpExtractMethodHandler.findAnchor(fragment);
            PsiElement functionDefinition = PhpExtractMethodHandler.addFunctionDefinition(fragment, settings, anchor);
            PsiElement callElement = PhpExtractMethodHandler.replaceWithCall(callStatement, fragment.getStartElement(), fragment);
            callElementOffset.set((Object)callElement.getTextOffset());
            PhpExtractMethodHandler.removeSelectionAndMoveCaretToElement(editor, callElement);
            if (settings.processDuplicates()) {
                PhpExtractMethodHandler.processDuplicates(functionDefinition, callElement, fragment, editor);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private static void addRestoreSelectionAndCaretUndoableAction(Project project, final @NotNull Editor editor, final @NotNull Ref<Integer> redoOffset) {
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(24);
        }
        if (redoOffset == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(25);
        }
        final int start = editor.getSelectionModel().getSelectionStart();
        final int end = editor.getSelectionModel().getSelectionEnd();
        final boolean ltrSelection = editor.getSelectionModel().getLeadSelectionOffset() != end;
        final int caretOffset = editor.getCaretModel().getOffset();
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() {
                if (ltrSelection) {
                    editor.getSelectionModel().setSelection(start, end);
                } else {
                    editor.getSelectionModel().setSelection(end, start);
                }
                editor.getCaretModel().moveToOffset(caretOffset);
            }

            public void redo() {
                if (!redoOffset.isNull()) {
                    editor.getCaretModel().moveToOffset(((Integer)redoOffset.get()).intValue());
                }
            }
        });
    }

    @NotNull
    private static PsiElement findAnchor(@NotNull PhpExtractMethodBlockCodeFragment fragment) {
        PsiElement anchor;
        PhpScopeHolder nonClosureScopeHolder;
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(26);
        }
        if ((nonClosureScopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(PhpExtractMethodHandler.takeExternalScopeHolder(anchor = fragment.getStartElement()))) instanceof Function) {
            PhpScopeHolder phpScopeHolder = nonClosureScopeHolder;
            if (phpScopeHolder == null) {
                PhpExtractMethodHandler.$$$reportNull$$$0(27);
            }
            return phpScopeHolder;
        }
        PsiElement psiElement = anchor;
        if (psiElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(28);
        }
        return psiElement;
    }

    private static PhpScopeHolder takeExternalScopeHolder(PsiElement anchor) {
        return (PhpScopeHolder)PhpPsiUtil.getParentByCondition(anchor, true, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpScopeHolder));
    }

    private static void processDuplicates(@NotNull PsiElement functionDefinition, @NotNull PsiElement callElement, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull Editor editor) {
        if (functionDefinition == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(29);
        }
        if (callElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(30);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(31);
        }
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(32);
        }
        PhpSimpleDuplicatesFinder finder = PhpExtractMethodHandler.createDuplicatesFinder(fragment);
        finder.setReplacement(callElement);
        PhpScopeHolder holder = PhpPsiUtil.getScopeHolder(callElement);
        List<PsiElement> elements = PhpExtractMethodHandler.collectDuplicateScopes(holder, functionDefinition);
        callElement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)callElement);
        ExtractMethodHelper.processDuplicates((PsiElement)callElement, (PsiElement)functionDefinition, elements, (SimpleDuplicatesFinder)finder, (Editor)editor, pair -> PhpExtractMethodHandler.replaceElements((SimpleMatch)pair.first, ((PsiElement)pair.second).copy()));
    }

    @NotNull
    static List<PsiElement> collectDuplicateScopes(@Nullable PhpScopeHolder holder, @NotNull PsiElement functionDefinition) {
        if (functionDefinition == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(33);
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        elements.add((PsiElement)holder);
        PhpClass phpClass = (PhpClass)PhpPsiUtil.getParentByCondition(functionDefinition, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        if (phpClass != null) {
            for (Method it : phpClass.getMethods()) {
                if (it.equals(functionDefinition) || it.equals(holder)) continue;
                elements.add((PsiElement)it);
            }
        }
        ArrayList<PsiElement> arrayList = elements;
        if (arrayList == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    private static void replaceElements(@NotNull SimpleMatch match, @NotNull PsiElement callElement) {
        if (match == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(35);
        }
        if (callElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(36);
        }
        List elementsRange = PsiTreeUtil.getElementsOfRange((PsiElement)match.getStartElement(), (PsiElement)match.getEndElement());
        PhpExtractMethodHandler.replaceElements(elementsRange, callElement);
    }

    @NotNull
    private static PsiElement replaceElements(@NotNull List<? extends PsiElement> elementsRange, @NotNull PsiElement callElement) {
        if (elementsRange == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(37);
        }
        if (callElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(38);
        }
        callElement = elementsRange.get(0).replace(callElement);
        if (elementsRange.size() > 1) {
            callElement.getParent().deleteChildRange(elementsRange.get(1), elementsRange.get(elementsRange.size() - 1));
        }
        PsiElement psiElement = callElement;
        if (psiElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(39);
        }
        return psiElement;
    }

    @NotNull
    private static List<String> castOutput(Set<PhpPsiElement> arg) {
        List list = ContainerUtil.map(arg, e -> e.getName());
        if (list == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(40);
        }
        return list;
    }

    private static AbstractVariableData[] transform(Set<PhpPsiElement> inputVars) {
        Set inputVarSet = ContainerUtil.map2Set(inputVars, NavigationItem::getName);
        AbstractVariableData[] answer = new AbstractVariableData[inputVarSet.size()];
        int i = 0;
        for (String it : inputVarSet) {
            answer[i] = new AbstractVariableData();
            answer[i].name = it;
            answer[i].originalName = it;
            answer[i].passAsParameter = true;
            ++i;
        }
        return answer;
    }

    private static PsiElement replaceWithCall(Statement callStatement, PsiElement startElement, @NotNull PhpExtractMethodBlockCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(41);
        }
        PsiElement callElement = startElement.getParent().addBefore((PsiElement)callStatement, startElement);
        startElement.getParent().deleteChildRange(startElement, fragment.getEndElement());
        return callElement;
    }

    private static void removeSelectionAndMoveCaretToElement(@NotNull Editor editor, @NotNull PsiElement callElement) {
        if (editor == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(42);
        }
        if (callElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(43);
        }
        editor.getSelectionModel().removeSelection();
        editor.getCaretModel().moveToOffset(callElement.getTextOffset());
    }

    private static PsiElement addFunctionDefinition(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpExtractMethodSettings settings, @NotNull PsiElement anchorElement) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(44);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(45);
        }
        if (anchorElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(46);
        }
        PsiElement function = PhpExtractMethodHandler.insertDefinition(fragment, settings, anchorElement);
        PhpExtractMethodHandler.renameParametersInFunction(function, settings.getParameters());
        settings.getParameterFolder().foldParameterUsagesInBodyIfNeeded(function, settings.getInputVariables());
        if (settings.generatePhpDoc()) {
            PhpDocComment comment = PhpDocCommentGenerator.constructDocComment(anchorElement.getProject(), function, false);
            PsiElement parent = function.getParent();
            if (parent != null && !PhpExtractMethodHandler.isEmptyComment(comment)) {
                parent.addBefore((PsiElement)comment, function);
            }
        }
        if (function instanceof Function) {
            String retType;
            PhpType localType = ((Function)function).getLocalType(true).global(function.getProject());
            if (PhpType.isArray((PhpType)localType)) {
                localType = PhpType.ARRAY;
            }
            if ((retType = PhpExtractMethodHandler.getReturnTypePresentation(function.getProject(), localType, (Function)function)) != null) {
                PhpExtractMethodHandler.insertReturnType(function, retType);
            }
        }
        return function;
    }

    @Nullable
    public static String getReturnTypePresentation(Project project, @NotNull PhpType localType, Function function) {
        if (localType == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(47);
        }
        if (!PhpLanguageFeature.RETURN_TYPES.isSupported(project)) {
            return null;
        }
        PhpType composedType = PhpMissingFieldTypeInspection.composeType(project, localType, PhpType::isAnonymousClass);
        String retType = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, composedType, (PsiElement)function);
        if (StringUtil.isEmpty((String)retType)) {
            return null;
        }
        if (retType.equals("$this") && function instanceof Method) {
            PhpClass containingClass = ((Method)function).getContainingClass();
            return containingClass != null ? containingClass.getName() : retType;
        }
        boolean isUnionType = retType.contains("|");
        if (composedType.getTypes().contains("\\mixed") && !PhpLanguageFeature.MIXED_TYPE_HINT.isSupported(project) || composedType.getTypes().contains("\\void") && (!PhpLanguageFeature.RETURN_VOID.isSupported(project) || isUnionType)) {
            return null;
        }
        return retType;
    }

    private static void insertReturnType(PsiElement function, String retType) {
        PsiElement lastChild = function.getLastChild();
        if (lastChild instanceof GroupStatement) {
            function.addBefore(PhpPsiElementFactory.createFromText(function.getProject(), PhpTokenTypes.opCOLON, ":"), lastChild);
            function.addBefore((PsiElement)PhpPsiElementFactory.createReturnType(function.getProject(), retType), lastChild);
        }
    }

    private static boolean isEmptyComment(@Nullable PhpDocComment comment) {
        return comment == null || comment.getParamTags().size() == 0 && comment.getReturnTag() == null;
    }

    private static PsiElement insertDefinition(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpExtractMethodSettings settings, @NotNull PsiElement anchorElement) {
        PsiElement curChild;
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(48);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(49);
        }
        if (anchorElement == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(50);
        }
        PhpScopeHolder scopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(fragment.getScopeHolder());
        Function definition = PhpExtractMethodHandler.createDefinition(scopeHolder.getProject(), settings, scopeHolder instanceof Method);
        PhpExtractMethodHandler.patchDefinition(settings, (PhpScopeHolder)definition);
        if (scopeHolder instanceof Method) {
            PhpClass clazz = ((Method)scopeHolder).getContainingClass();
            assert (clazz != null);
            return PhpCodeEditUtil.insertClassMember(clazz, (PsiElement)definition);
        }
        if (scopeHolder instanceof Function && !((Function)scopeHolder).isClosure()) {
            return scopeHolder.getParent().addAfter((PsiElement)definition, (PsiElement)scopeHolder);
        }
        GroupStatement groupStatement = (GroupStatement)PsiTreeUtil.findChildOfType((PsiElement)scopeHolder, GroupStatement.class);
        assert (groupStatement != null);
        for (curChild = groupStatement.getFirstChild(); curChild != null && !PsiTreeUtil.isAncestor((PsiElement)curChild, (PsiElement)anchorElement, (boolean)false); curChild = curChild.getNextSibling()) {
        }
        assert (curChild != null);
        return groupStatement.addBefore((PsiElement)definition, curChild);
    }

    @NotNull
    public static Function createDefinition(@NotNull Project project, @NotNull PhpExtractMethodSettings settings, boolean method) {
        if (project == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(51);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(52);
        }
        if (method) {
            Method method2 = PhpPsiElementFactory.createMethod(project, PhpExtractMethodHandler.generateFunctionText(settings));
            if (method2 == null) {
                PhpExtractMethodHandler.$$$reportNull$$$0(53);
            }
            return method2;
        }
        Function function = PhpPsiElementFactory.createFunction(project, PhpExtractMethodHandler.generateFunctionText(settings));
        if (function == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(54);
        }
        return function;
    }

    private static void patchDefinition(@NotNull PhpExtractMethodSettings settings, @NotNull PhpScopeHolder function) {
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(55);
        }
        if (function == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(56);
        }
        String returnArgument = PhpExtractMethodHandler.generateReturnArgument(settings);
        if (!settings.isReplaceBreakContinueWithReturn()) {
            PhpExtractMethodHandler.addReturnStatementToEndOfFunctionIfNeeded(returnArgument, function);
        } else {
            final HashSet breakStatements = new HashSet();
            PhpExitPointInstruction exitPoint = function.getControlFlow().getExitPoint();
            PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)exitPoint, false, new PhpInstructionProcessor(){

                public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                    Statement statement = instruction.getStatement();
                    if (statement instanceof PhpBreak) {
                        breakStatements.add(statement);
                    }
                    return false;
                }
            });
            PhpReturn returnStatement = PhpPsiElementFactory.createReturnStatement(function.getProject(), returnArgument);
            for (Statement breakStatement : breakStatements) {
                breakStatement.replace((PsiElement)returnStatement);
            }
            if (breakStatements.size() < exitPoint.getPredecessors().size()) {
                PhpExtractMethodHandler.addReturnStatementToEndOfFunctionIfNeeded(returnArgument, function);
            }
        }
    }

    @Nullable
    private static String generateReturnArgument(@NotNull PhpExtractMethodSettings settings) {
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(57);
        }
        if (settings.isPassOutputByReference()) {
            return null;
        }
        StringBuilder returnArgumentBuilder = new StringBuilder();
        Set<PhpPsiElement> outputVariables = settings.getOutputVariables();
        if (outputVariables.size() == 0) {
            return null;
        }
        if (outputVariables.size() == 1) {
            returnArgumentBuilder.append("$");
            returnArgumentBuilder.append(outputVariables.iterator().next().getName());
        } else {
            returnArgumentBuilder.append("array(");
            Iterator<PhpPsiElement> iterator = outputVariables.iterator();
            while (iterator.hasNext()) {
                returnArgumentBuilder.append("$").append(iterator.next().getName());
                if (!iterator.hasNext()) continue;
                returnArgumentBuilder.append(",");
            }
            returnArgumentBuilder.append(")");
        }
        return returnArgumentBuilder.toString();
    }

    private static void addReturnStatementToEndOfFunctionIfNeeded(String returnArgument, @NotNull PhpScopeHolder function) {
        if (function == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(58);
        }
        if (returnArgument != null) {
            GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildOfType((PsiElement)function, PhpElementTypes.ANY_GROUP_STATEMENT);
            assert (groupStatement != null);
            Object child = PhpPsiUtil.getPrevSiblingByCondition(groupStatement.getLastChild(), (Condition<? super PsiElement>)((Condition)e -> !(e instanceof PhpDocPsiElement) && e instanceof PhpPsiElement));
            if (child != null && !(child instanceof PhpReturn)) {
                PhpReturn returnStatement = PhpPsiElementFactory.createReturnStatement(function.getProject(), returnArgument);
                groupStatement.addAfter((PsiElement)returnStatement, child);
            }
        }
    }

    private static Statement createCallStatement(@NotNull PhpExtractMethodBlockCodeFragment fragment, @NotNull PhpExtractMethodSettings settings) {
        Statement callStatement;
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(59);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(60);
        }
        PhpScopeHolder scopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(fragment.getScopeHolder());
        Project project = scopeHolder.getProject();
        if (scopeHolder instanceof Method) {
            String methodCallStatementText = PhpExtractMethodHandler.generateMethodCallStatementText(settings, fragment);
            callStatement = PhpPsiElementFactory.createStatement(project, methodCallStatementText);
        } else {
            String functionCallStatementText = PhpExtractMethodHandler.generateFunctionCallStatementText(settings, fragment);
            callStatement = PhpPsiElementFactory.createStatement(project, functionCallStatementText);
        }
        return callStatement;
    }

    private static PhpExpression createCallExpression(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpExtractMethodSettings settings) {
        PhpScopeHolder scopeHolder;
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(61);
        }
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(62);
        }
        Object callExpression = (scopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(fragment.getScopeHolder())) instanceof Method ? PhpPsiElementFactory.createMethodReference(scopeHolder.getProject(), PhpExtractMethodHandler.generateMethodCallText(settings)) : PhpPsiElementFactory.createFunctionReference(scopeHolder.getProject(), PhpExtractMethodHandler.generateFunctionCallText(settings));
        return callExpression;
    }

    @Nullable
    private PhpExtractMethodSettings _getSettings(@NotNull PhpExtractMethodCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(63);
        }
        Set<PhpPsiElement> inputVariables = PhpExtractMethodHandler.getInputVariables(fragment);
        Set<PhpPsiElement> outputVariables = PhpExtractMethodHandler.getOutputVariables(fragment);
        if (LOG.isDebugEnabled()) {
            LOG.debug("input variables:" + inputVariables);
            LOG.debug("output variables:" + outputVariables);
        }
        return this.getSettings(fragment, inputVariables, outputVariables);
    }

    private static void renameParametersInFunction(@Nullable PsiElement element, @Nullable List<? extends PhpExtractMethodParameterInfo> newParameters) {
        if (element == null || newParameters == null) {
            return;
        }
        Parameter[] parameters = ((Function)element).getParameters();
        assert (parameters.length == newParameters.size());
        for (int i = 0; i < parameters.length; ++i) {
            PhpExtractMethodParameterInfo newParameter = newParameters.get(i);
            if (!newParameter.nameWasChanged()) continue;
            Parameter parameter = parameters[i];
            CharSequence newName = newParameter.getNewName();
            if (StringUtil.isEmpty((CharSequence)newName)) continue;
            ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).findAll()) {
                if (reference.getElement() == parameter) continue;
                list.add(new UsageInfo(reference));
            }
            PhpExtractMethodHandler.renameParameter(parameter, newName.toString(), list.toArray(UsageInfo.EMPTY_ARRAY));
        }
    }

    private static void renameParameter(Parameter parameter, String newName, UsageInfo[] infos) {
        RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)parameter);
        processor.renameElement((PsiElement)parameter, newName, infos, null);
    }

    @NotNull
    public PhpExtractMethodDialog createSettings(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables) {
        PhpExtractMethodDialog dialog;
        boolean isReplacedBreakContinueWithReturnEnabled;
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(64);
        }
        if (inputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(65);
        }
        if (outputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(66);
        }
        PhpScopeHolder scopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(fragment.getScopeHolder());
        Project project = scopeHolder.getProject();
        String dummyFunctionText = PhpExtractMethodHandler.generateDummyFunction(fragment);
        Function dummyFunction = PhpPsiElementFactory.createFunction(project, dummyFunctionText);
        final Ref breakContinueTarget = new Ref();
        PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)dummyFunction.getControlFlow().getExitPoint(), false, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                return false;
            }

            public boolean processInterruptScriptInstruction(PhpInterruptScriptInstruction instruction) {
                return false;
            }

            public boolean processBreakContinueInstruction(PhpBreakContinueInstruction instruction) {
                breakContinueTarget.set((Object)instruction.getTargetStatement());
                return false;
            }
        });
        boolean bl = isReplacedBreakContinueWithReturnEnabled = breakContinueTarget.get() != null;
        if (scopeHolder instanceof Method) {
            boolean isDeclareStatic;
            boolean isDeclareStaticEnabled;
            Method method = (Method)scopeHolder;
            if (method.isStatic()) {
                isDeclareStaticEnabled = false;
                isDeclareStatic = true;
            } else {
                final Ref isDynamicContext = new Ref((Object)false);
                PhpControlFlowUtil.processFlow(dummyFunction.getControlFlow(), new PhpInstructionProcessor(){

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        if (PhpLangUtil.equalsVariableNames("this", instruction.getVariableName())) {
                            isDynamicContext.set((Object)true);
                            return false;
                        }
                        return true;
                    }
                });
                isDeclareStaticEnabled = (Boolean)isDynamicContext.get() == false;
                isDeclareStatic = false;
            }
            PhpClass containingClass = method.getContainingClass();
            assert (containingClass != null);
            dialog = PhpExtractMethodDialog.createExtractMethodDialog(project, fragment, inputVariables, outputVariables, new PhpMethodConflictDetector(containingClass), isReplacedBreakContinueWithReturnEnabled, isDeclareStaticEnabled, isDeclareStatic, method.getAccess());
        } else {
            PhpScopeHolder externalScope = PhpExtractMethodHandler.getExternalScopeHolder(scopeHolder);
            dialog = PhpExtractMethodDialog.createExtractFunctionDialog(project, fragment, inputVariables, outputVariables, new PhpFunctionInScopeConflictDetector(externalScope), isReplacedBreakContinueWithReturnEnabled);
        }
        PhpExtractMethodDialog phpExtractMethodDialog = dialog;
        if (phpExtractMethodDialog == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(67);
        }
        return phpExtractMethodDialog;
    }

    @Nullable
    protected PhpExtractMethodSettings getSettings(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(68);
        }
        if (inputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(69);
        }
        if (outputVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(70);
        }
        PhpExtractMethodDialog dialog = this.createSettings(fragment, inputVariables, outputVariables);
        PhpUiUtil.show((DialogWrapper)dialog);
        if (!dialog.isOK()) {
            return null;
        }
        return dialog;
    }

    private static PhpScopeHolder getNearestNonClosureScopeHolder(PhpScopeHolder holder) {
        if (holder instanceof Function && ((Function)holder).isClosure()) {
            return (PhpScopeHolder)PhpPsiUtil.getParentByCondition((PsiElement)holder, true, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpScopeHolder && (!(e instanceof Function) || !((Function)e).isClosure())));
        }
        return holder;
    }

    @Nullable
    private static PhpScopeHolder getExternalScopeHolder(@NotNull PhpScopeHolder scopeHolder) {
        Object namespace;
        if (scopeHolder == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(71);
        }
        if ((namespace = PhpPsiUtil.getParentByCondition((PsiElement)scopeHolder, false, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF)) != null) {
            return (PhpNamespace)namespace;
        }
        PsiFile file = scopeHolder.getContainingFile();
        return file instanceof PhpFile ? (PhpFile)file : null;
    }

    @NotNull
    private static Set<PhpPsiElement> getInputVariables(final @NotNull PhpExtractMethodCodeFragment fragment) {
        THashSet scopeParameters;
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(72);
        }
        PhpScopeHolder scopeHolder = fragment.getScopeHolder();
        PhpScopeHolder externalScopeHolder = PhpExtractMethodHandler.getNearestNonClosureScopeHolder(scopeHolder);
        final Set predefinedVariables = externalScopeHolder.getPredefinedVariables();
        if (scopeHolder instanceof Function) {
            Parameter[] parameters = ((Function)scopeHolder).getParameters();
            scopeParameters = new THashSet();
            for (Parameter parameter : parameters) {
                String parameterName = parameter.getName();
                if (StringUtil.isEmptyOrSpaces((String)parameterName)) continue;
                scopeParameters.add(parameterName);
            }
        } else {
            scopeParameters = Collections.emptySet();
        }
        LinkedHashSet<PhpPsiElement> inputVariables = new LinkedHashSet<PhpPsiElement>();
        THashSet names = new THashSet();
        PhpControlFlowUtil.processFlow(scopeHolder.getControlFlow(), new PhpInstructionProcessor((Set)scopeParameters, (Set)names, inputVariables){
            final /* synthetic */ Set val$scopeParameters;
            final /* synthetic */ Set val$names;
            final /* synthetic */ Set val$inputVariables;
            {
                this.val$scopeParameters = set2;
                this.val$names = set3;
                this.val$inputVariables = set4;
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                CharSequence variableName;
                PhpAccessInstruction.Access access;
                PhpPsiElement anchor = instruction.getAnchor();
                if (fragment.contains(anchor.getTextRange()) && ((access = instruction.getAccess()).isRead() || access.isLightRead() || access.isReadWrite() || access.isReadRef()) && !PhpExtractMethodHandler.isIgnoredVariables(variableName = instruction.getVariableName(), predefinedVariables)) {
                    final Ref hasWriteAccessInsideFragment = new Ref((Object)false);
                    final Ref hasWriteAccessOutsideFragment = new Ref((Object)false);
                    PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction curInstruction) {
                            PhpAccessInstruction.Access curAccess = curInstruction.getAccess();
                            if (PhpLangUtil.equalsVariableNames(variableName, curInstruction.getVariableName()) && (curAccess.isWrite() || curAccess.isWriteRef() || curAccess.isReadWrite() || PhpWorkaroundUtil.getArrayAccess(curInstruction).isWrite())) {
                                if (fragment.contains(curInstruction.getAnchor().getTextRange())) {
                                    hasWriteAccessInsideFragment.set((Object)true);
                                } else {
                                    hasWriteAccessOutsideFragment.set((Object)true);
                                }
                            }
                            return true;
                        }
                    });
                    if (PhpWorkaroundUtil.getArrayAccess(instruction).isWrite()) {
                        if ((((Boolean)hasWriteAccessOutsideFragment.get()).booleanValue() || this.val$scopeParameters.contains(variableName)) && this.val$names.add(variableName.toString())) {
                            this.val$inputVariables.add(anchor);
                        }
                    } else if ((!((Boolean)hasWriteAccessInsideFragment.get()).booleanValue() || this.val$scopeParameters.contains(variableName)) && this.val$names.add(variableName.toString())) {
                        this.val$inputVariables.add(anchor);
                    }
                }
                return true;
            }
        });
        LinkedHashSet<PhpPsiElement> linkedHashSet = inputVariables;
        if (linkedHashSet == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(73);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<PhpPsiElement> getOutputVariables(final @NotNull PhpExtractMethodCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(74);
        }
        final PhpScopeHolder scopeHolder = fragment.getScopeHolder();
        final Set predefinedVariables = scopeHolder.getPredefinedVariables();
        LinkedHashSet<PhpPsiElement> set = new LinkedHashSet<PhpPsiElement>();
        THashSet names = new THashSet();
        PhpControlFlowUtil.processFlow(scopeHolder.getControlFlow(), new PhpInstructionProcessor((Set)names, set){
            final /* synthetic */ Set val$names;
            final /* synthetic */ Set val$set;
            {
                this.val$names = set2;
                this.val$set = set3;
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                CharSequence variableName;
                PhpAccessInstruction.Access access;
                PhpPsiElement anchor = instruction.getAnchor();
                if (fragment.contains(anchor.getTextRange()) && ((access = instruction.getAccess()).isWrite() || access.isWriteRef() || access.isReadWrite() || access.isReadRef() || access.isUnset() || !PhpWorkaroundUtil.getArrayAccess(instruction).isRead()) && !PhpExtractMethodHandler.isIgnoredVariables(variableName = instruction.getVariableName(), predefinedVariables)) {
                    final Ref hasReadAccess = new Ref((Object)false);
                    PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction curInstruction) {
                            if (PhpLangUtil.equalsVariableNames(variableName, curInstruction.getVariableName()) && !fragment.contains(curInstruction.getAnchor().getTextRange())) {
                                if (access.isReadRef()) {
                                    hasReadAccess.set((Object)true);
                                } else {
                                    PhpAccessInstruction.Access curAccess = curInstruction.getAccess();
                                    if (curAccess.isRead() || curAccess.isReadRef() || curAccess.isLightRead() || curAccess.isReadWrite()) {
                                        hasReadAccess.set((Object)true);
                                    }
                                }
                            }
                            return true;
                        }
                    });
                    if ((((Boolean)hasReadAccess.get()).booleanValue() || PhpControlFlowUtil.isReferenced(scopeHolder, instruction)) && this.val$names.add(variableName.toString())) {
                        this.val$set.add(anchor);
                    }
                }
                return true;
            }
        });
        LinkedHashSet<PhpPsiElement> linkedHashSet = set;
        if (linkedHashSet == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(75);
        }
        return linkedHashSet;
    }

    private static boolean isIgnoredVariables(@NotNull CharSequence variableName, @NotNull Set<CharSequence> predefinedVariables) {
        if (variableName == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(76);
        }
        if (predefinedVariables == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(77);
        }
        return PhpLangUtil.isSuperGlobal(variableName) || predefinedVariables.contains(variableName);
    }

    private static String generateDummyFunction(@NotNull PhpExtractMethodCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(78);
        }
        return "public function dummyFunction() {" + fragment.generateCodeText() + "}";
    }

    @NotNull
    private static String generateFunctionText(@NotNull PhpExtractMethodSettings extractMethodSettings) {
        if (extractMethodSettings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(79);
        }
        String functionText = IMPLEMENTATION.generate(extractMethodSettings);
        if (LOG.isDebugEnabled()) {
            LOG.debug("function: " + functionText);
        }
        String string = functionText;
        if (string == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(80);
        }
        return string;
    }

    private static void appendCallStatementPrefix(@NotNull PhpExtractMethodSettings settings, @NotNull PhpExtractMethodBlockCodeFragment fragment, @NotNull StringBuilder builder) {
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(81);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(82);
        }
        if (builder == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(83);
        }
        if (PhpExtractMethodHandler.isReturnValueInside(fragment)) {
            builder.append("return ");
        } else {
            Set<PhpPsiElement> outputVariables = settings.getOutputVariables();
            if (outputVariables.size() > 0 && !settings.isPassOutputByReference()) {
                if (outputVariables.size() == 1) {
                    Iterator<PhpPsiElement> iterator = outputVariables.iterator();
                    builder.append("$").append(iterator.next().getName());
                } else {
                    builder.append("list(");
                    Iterator<PhpPsiElement> iterator = outputVariables.iterator();
                    while (iterator.hasNext()) {
                        builder.append("$").append(iterator.next().getName());
                        if (!iterator.hasNext()) continue;
                        builder.append(",");
                    }
                    builder.append(")");
                }
                builder.append("=");
            }
        }
    }

    @NotNull
    private static String generateMethodCallStatementText(@NotNull PhpExtractMethodSettings settings, @NotNull PhpExtractMethodBlockCodeFragment fragment) {
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(84);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(85);
        }
        StringBuilder methodCallStatementBuilder = new StringBuilder();
        PhpExtractMethodHandler.appendCallStatementPrefix(settings, fragment, methodCallStatementBuilder);
        methodCallStatementBuilder.append(PhpExtractMethodHandler.generateMethodCallText(settings)).append(";");
        if (LOG.isDebugEnabled()) {
            LOG.debug("method call statement: " + methodCallStatementBuilder);
        }
        String string = methodCallStatementBuilder.toString();
        if (string == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(86);
        }
        return string;
    }

    @NotNull
    private static String generateMethodCallText(@NotNull PhpExtractMethodSettings extractMethodSettings) {
        if (extractMethodSettings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(87);
        }
        StringBuilder methodCallBuilder = new StringBuilder();
        if (extractMethodSettings.isDeclareStatic()) {
            methodCallBuilder.append("self::");
        } else {
            methodCallBuilder.append("$this->");
        }
        methodCallBuilder.append(PhpExtractMethodHandler.generateCall(extractMethodSettings));
        if (LOG.isDebugEnabled()) {
            LOG.debug("method call: " + methodCallBuilder);
        }
        String string = methodCallBuilder.toString();
        if (string == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(88);
        }
        return string;
    }

    private static String generateCall(@NotNull PhpExtractMethodSettings extractMethodSettings) {
        if (extractMethodSettings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(89);
        }
        PhpParametersFolder folder = extractMethodSettings.getParameterFolder();
        return extractMethodSettings.getName() + "(" + String.join((CharSequence)", ", folder.generateCallArguments(extractMethodSettings.getParameters())) + ");";
    }

    @NotNull
    private static String generateFunctionCallStatementText(@NotNull PhpExtractMethodSettings settings, @NotNull PhpExtractMethodBlockCodeFragment fragment) {
        if (settings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(90);
        }
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(91);
        }
        StringBuilder functionCallStatementBuilder = new StringBuilder();
        PhpExtractMethodHandler.appendCallStatementPrefix(settings, fragment, functionCallStatementBuilder);
        functionCallStatementBuilder.append(PhpExtractMethodHandler.generateFunctionCallText(settings)).append(";");
        if (LOG.isDebugEnabled()) {
            LOG.debug("function call statement: " + functionCallStatementBuilder);
        }
        String string = functionCallStatementBuilder.toString();
        if (string == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(92);
        }
        return string;
    }

    private static boolean isReturnValueInside(@NotNull PhpExtractMethodCodeFragment fragment) {
        if (fragment == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(93);
        }
        final Ref isReturn = new Ref((Object)false);
        fragment.getScopeHolder().acceptChildren((PsiElementVisitor)new PhpExtractMethodCodeFragmentRecursiveElementVisitor(fragment, new PhpElementVisitor(){

            public void visitPhpReturn(PhpReturn returnStatement) {
                if (returnStatement.getArgument() != null) {
                    isReturn.set((Object)true);
                }
            }
        }));
        if (LOG.isDebugEnabled()) {
            LOG.debug("return value inside: " + isReturn.get());
        }
        return (Boolean)isReturn.get();
    }

    @NotNull
    private static String generateFunctionCallText(@NotNull PhpExtractMethodSettings extractMethodSettings) {
        if (extractMethodSettings == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(94);
        }
        StringBuilder functionCallBuilder = new StringBuilder();
        functionCallBuilder.append(PhpExtractMethodHandler.generateCall(extractMethodSettings));
        if (LOG.isDebugEnabled()) {
            LOG.debug("function call: " + functionCallBuilder);
        }
        String string = functionCallBuilder.toString();
        if (string == null) {
            PhpExtractMethodHandler.$$$reportNull$$$0(95);
        }
        return string;
    }

    @NlsContexts.Command
    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return PhpBundle.message("refactoring.extract.method.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 28: 
            case 34: 
            case 39: 
            case 40: 
            case 53: 
            case 54: 
            case 67: 
            case 73: 
            case 75: 
            case 80: 
            case 86: 
            case 88: 
            case 92: 
            case 95: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 28: 
            case 34: 
            case 39: 
            case 40: 
            case 53: 
            case 54: 
            case 67: 
            case 73: 
            case 75: 
            case 80: 
            case 86: 
            case 88: 
            case 92: 
            case 95: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockCodeFragment";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 31: 
            case 41: 
            case 44: 
            case 48: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 68: 
            case 72: 
            case 74: 
            case 78: 
            case 82: 
            case 85: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "redoOffset";
                break;
            }
            case 27: 
            case 28: 
            case 34: 
            case 39: 
            case 40: 
            case 53: 
            case 54: 
            case 67: 
            case 73: 
            case 75: 
            case 80: 
            case 86: 
            case 88: 
            case 92: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodHandler";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDefinition";
                break;
            }
            case 30: 
            case 36: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsRange";
                break;
            }
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 81: 
            case 84: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorElement";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localType";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 65: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 66: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputVariables";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedVariables";
                break;
            }
            case 79: 
            case 87: 
            case 89: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractMethodSettings";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodHandler";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnchor";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDuplicateScopes";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceElements";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "castOutput";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefinition";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputVariables";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFunctionText";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodCallStatementText";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodCallText";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFunctionCallStatementText";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFunctionCallText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "_invoke";
                break;
            }
            case 8: 
            case 9: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "extractFromExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryToDetectBlockRangeElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectExtractableExpressions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isExtractable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryExtractFromExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "validateExpression";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractFromCodeBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "strictContains";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDuplicatesFinder";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extractFromBlock";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addRestoreSelectionAndCaretUndoableAction";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findAnchor";
                break;
            }
            case 27: 
            case 28: 
            case 34: 
            case 39: 
            case 40: 
            case 53: 
            case 54: 
            case 67: 
            case 73: 
            case 75: 
            case 80: 
            case 86: 
            case 88: 
            case 92: 
            case 95: {
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicates";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collectDuplicateScopes";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "replaceElements";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithCall";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectionAndMoveCaretToElement";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionDefinition";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypePresentation";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "insertDefinition";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createDefinition";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "patchDefinition";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "generateReturnArgument";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "addReturnStatementToEndOfFunctionIfNeeded";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createCallStatement";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createCallExpression";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "_getSettings";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createSettings";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getExternalScopeHolder";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getInputVariables";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getOutputVariables";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredVariables";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "generateDummyFunction";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "generateFunctionText";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "appendCallStatementPrefix";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodCallStatementText";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodCallText";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "generateCall";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "generateFunctionCallStatementText";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isReturnValueInside";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "generateFunctionCallText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 28: 
            case 34: 
            case 39: 
            case 40: 
            case 53: 
            case 54: 
            case 67: 
            case 73: 
            case 75: 
            case 80: 
            case 86: 
            case 88: 
            case 92: 
            case 95: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpExtractMethodCodeFragmentRecursiveElementVisitor
    extends PhpRecursiveElementVisitor {
        private final PhpExtractMethodCodeFragment myFragment;
        private final PhpElementVisitor myVisitor;

        private PhpExtractMethodCodeFragmentRecursiveElementVisitor(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpElementVisitor visitor) {
            if (fragment == null) {
                PhpExtractMethodCodeFragmentRecursiveElementVisitor.$$$reportNull$$$0(0);
            }
            if (visitor == null) {
                PhpExtractMethodCodeFragmentRecursiveElementVisitor.$$$reportNull$$$0(1);
            }
            this.myFragment = fragment;
            this.myVisitor = visitor;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                PhpExtractMethodCodeFragmentRecursiveElementVisitor.$$$reportNull$$$0(2);
            }
            if (this.myFragment.contains(element.getTextRange())) {
                element.accept((PsiElementVisitor)this.myVisitor);
            }
            super.visitElement(element);
        }

        public void visitPhpFunction(Function function) {
            this.checkIsInTheSameScope((PhpScopeHolder)function);
        }

        public void visitPhpMethod(Method method) {
            this.checkIsInTheSameScope((PhpScopeHolder)method);
        }

        private void checkIsInTheSameScope(PhpScopeHolder holder) {
            if (holder == this.myFragment.getScopeHolder()) {
                super.visitElement((PsiElement)holder);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodHandler$PhpExtractMethodCodeFragmentRecursiveElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

