/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractMethod;

import com.intellij.DynamicBundle;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodDialogOptionsLogger;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodExpressionCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodHandler;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodParameterInfo;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodParamsTable;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodSettings;
import com.jetbrains.php.refactoring.extractMethod.PhpParametersFolder;
import com.jetbrains.php.refactoring.ui.PhpCodeComponentsFactory;
import com.jetbrains.php.refactoring.validation.PhpNameConflictDetector;
import com.jetbrains.php.refactoring.validation.PhpParameterValidator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractMethodDialog
extends RefactoringDialog
implements PhpExtractMethodSettings {
    private static final String HELP_ID = "refactoring.extractMethod";
    private static final String DIMENSION_SERVICE_KEY_BASE = "#com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodDialog#";
    private static Font defaultTableFont = EditorFontType.getGlobalPlainFont();
    private final NameSuggestionsField myNameSuggestionField;
    private final String[] myNameSuggestions;
    private PhpModifier.Access myDefaultVisibility;
    private JCheckBox myDeclareStaticCheckBox;
    private JRadioButton myPublicRadioButton;
    private JRadioButton myProtectedRadioButton;
    private JRadioButton myPrivateRadioButton;
    private JBTable myParametersTable;
    private JPanel myVisibilityPanel;
    private JPanel myNamePanel;
    private JCheckBox myReplaceBreakContinueWithReturnCheckBox;
    private JRadioButton myOutputByParametersRadioButton;
    private JRadioButton myOutputByReturnRadioButton;
    private JPanel myTransformationOptionsPanel;
    private JTextArea myOutputVariablesArea;
    private JPanel myOutputVariablesPanel;
    private JPanel mySignaturePreviewPanel;
    private JPanel myTopPanel;
    private JCheckBox myGeneratePhpDoc;
    private JPanel myDuplicatesPanel;
    private JPanel myNameTextFieldPanel;
    private JBCheckBox myDuplicatesCheckBox;
    private JBCheckBox myFoldParametersCheckBox;
    private final PhpExtractMethodCodeFragment myFragment;
    private final PhpNameConflictDetector myNameConflictDetector;
    private List<PhpExtractMethodParameterInfo> myParameters;
    private ParametersTableModel myParametersTableModel;
    private final Set<PhpPsiElement> myOutputVariables;
    @NotNull
    private final Set<PhpPsiElement> myInputVariables;
    private final String myDimensionServiceKey;
    private MethodSignatureComponent mySignatureComponent;
    @NotNull
    private final PhpParametersFolder myParameterFolder;

    protected PhpExtractMethodDialog(@NotNull Project project, @NotNull Set<PhpPsiElement> outputVariables, @NotNull Set<PhpPsiElement> inputVariables, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpNameConflictDetector nameConflictDetector, boolean isReplaceBreakContinueWithReturnAllowed, boolean isDeclareStaticEnabled, boolean isDeclareStatic, @Nullable PhpModifier.Access visibility, @NotNull @NlsContexts.BorderTitle String nameBorderTitle, @NotNull String dimensionServiceKeyPrefix) {
        String[] stringArray;
        if (project == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(0);
        }
        if (outputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(1);
        }
        if (inputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(2);
        }
        if (fragment == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(3);
        }
        if (nameConflictDetector == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(4);
        }
        if (nameBorderTitle == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(5);
        }
        if (dimensionServiceKeyPrefix == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(6);
        }
        super(project, false);
        this.myFragment = fragment;
        this.myNameConflictDetector = nameConflictDetector;
        this.myOutputVariables = outputVariables;
        this.myInputVariables = inputVariables;
        this.$$$setupUI$$$();
        int outputVariablesSize = outputVariables.size();
        boolean isOutputValuesExists = outputVariablesSize > 0;
        this.myDimensionServiceKey = DIMENSION_SERVICE_KEY_BASE + dimensionServiceKeyPrefix + (isOutputValuesExists ? "1" : "0");
        StringBuilder outputVariablesBuilder = new StringBuilder();
        Iterator<PhpPsiElement> iterator = outputVariables.iterator();
        while (iterator.hasNext()) {
            outputVariablesBuilder.append("$").append(iterator.next().getName());
            if (!iterator.hasNext()) continue;
            outputVariablesBuilder.append(", ");
        }
        this.myOutputVariablesArea.setText(outputVariablesBuilder.toString());
        this.myOutputByReturnRadioButton.setSelected(true);
        this.myOutputVariablesPanel.setVisible(isOutputValuesExists);
        this.myTransformationOptionsPanel.setVisible(isReplaceBreakContinueWithReturnAllowed);
        boolean isExtractMethod = visibility != null;
        this.myDeclareStaticCheckBox.setVisible(isExtractMethod);
        this.myDeclareStaticCheckBox.setEnabled(isDeclareStaticEnabled);
        this.myDeclareStaticCheckBox.setSelected(isDeclareStatic);
        PhpRefactoringSettings settings = PhpRefactoringSettings.getInstance();
        this.myGeneratePhpDoc.setSelected(settings.EXTRACT_METHOD_GENERATE_PHPDOC);
        this.myDefaultVisibility = null;
        if (isExtractMethod) {
            block0 : switch (visibility) {
                case PUBLIC: {
                    PhpModifier.Access defaultVisibility;
                    this.myDefaultVisibility = defaultVisibility = settings.EXTRACT_METHOD_DEFAULT_VISIBILITY;
                    switch (defaultVisibility) {
                        case PUBLIC: {
                            this.myPublicRadioButton.setSelected(true);
                            break block0;
                        }
                        case PROTECTED: {
                            this.myProtectedRadioButton.setSelected(true);
                            break block0;
                        }
                        case PRIVATE: {
                            this.myPrivateRadioButton.setSelected(true);
                        }
                    }
                    break;
                }
                case PROTECTED: {
                    this.myDefaultVisibility = PhpModifier.Access.PROTECTED;
                    this.myProtectedRadioButton.setSelected(true);
                    break;
                }
                case PRIVATE: {
                    this.myDefaultVisibility = PhpModifier.Access.PRIVATE;
                    this.myPrivateRadioButton.setSelected(true);
                }
            }
        } else {
            this.myVisibilityPanel.setVisible(false);
        }
        this.myNamePanel.setBorder(IdeBorderFactory.createTitledBorder((String)nameBorderTitle));
        this.installValidationOnParametersTable(project);
        this.initDuplicatesCountLabel(project, isExtractMethod);
        String[] suggestions = ArrayUtil.toStringArray(fragment.suggestMethodNames());
        String uniqueDefaultName = PhpNameUtil.unique("extracted", "", "", (Condition<? super String>)((Condition)s -> StringUtil.isNotEmpty((String)this.myNameConflictDetector.findConflicts((String)s))));
        if (suggestions.length != 0) {
            stringArray = suggestions;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = uniqueDefaultName;
        }
        this.myNameSuggestions = stringArray;
        this.myNameSuggestionField = new NameSuggestionsField(this.myNameSuggestions, project, (FileType)PhpFileType.INSTANCE);
        this.myNameTextFieldPanel.add((Component)this.myNameSuggestionField);
        this.myParameterFolder = new PhpParametersFolder();
    }

    private void initDuplicatesCountLabel(final Project project, final boolean method) {
        this.myDuplicatesCheckBox.setVisible(false);
        final PhpExtractMethodDialog settings = this;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, PhpBundle.message("PhpExtractMethodDialog.duplicates.pending", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                int duplicatesCount;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((duplicatesCount = ((Integer)ReadAction.compute(() -> {
                    Function definition = PhpExtractMethodHandler.createDefinition(project, PhpExtractMethodDialog.createDummySettings(settings), method);
                    List<PsiElement> scopes = PhpExtractMethodHandler.collectDuplicateScopes(PhpExtractMethodDialog.this.myFragment.getScopeHolder(), (PsiElement)PhpExtractMethodDialog.this.myFragment.getScopeHolder());
                    return PhpExtractMethodHandler.createDuplicatesFinder(PhpExtractMethodDialog.this.myFragment).findDuplicates(scopes, (PsiElement)definition).size();
                })).intValue()) > 0) {
                    PhpExtractMethodDialog.this.myDuplicatesCheckBox.setVisible(true);
                    PhpExtractMethodDialog.this.myDuplicatesCheckBox.setText(PhpBundle.message("PhpExtractMethodDialog.duplicates.count", duplicatesCount));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodDialog$1", "run"));
            }
        });
    }

    @Override
    public boolean processDuplicates() {
        return this.myDuplicatesCheckBox.isSelected();
    }

    @Override
    @NotNull
    public PhpParametersFolder getParameterFolder() {
        PhpParametersFolder phpParametersFolder = this.myParameterFolder;
        if (phpParametersFolder == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(7);
        }
        return phpParametersFolder;
    }

    private static PhpExtractMethodSettings createDummySettings(final PhpExtractMethodDialog settings) {
        return new PhpExtractMethodSettings(){

            @Override
            @NotNull
            public Set<PhpPsiElement> getOutputVariables() {
                Set<PhpPsiElement> set = settings.myOutputVariables;
                if (set == null) {
                    2.$$$reportNull$$$0(0);
                }
                return set;
            }

            @Override
            @NotNull
            public Set<PhpPsiElement> getInputVariables() {
                Set<PhpPsiElement> set = settings.myInputVariables;
                if (set == null) {
                    2.$$$reportNull$$$0(1);
                }
                return set;
            }

            @Override
            public boolean isPassOutputByReference() {
                return settings.isPassOutputByReference();
            }

            @Override
            public boolean isReplaceBreakContinueWithReturn() {
                return settings.isReplaceBreakContinueWithReturn();
            }

            @Override
            public boolean generatePhpDoc() {
                return false;
            }

            @Override
            @NotNull
            public PhpParametersFolder getParameterFolder() {
                PhpParametersFolder phpParametersFolder = settings.myParameterFolder;
                if (phpParametersFolder == null) {
                    2.$$$reportNull$$$0(2);
                }
                return phpParametersFolder;
            }

            @Override
            @NotNull
            public String getName() {
                return "dummy";
            }

            @Override
            @NotNull
            public List<PhpExtractMethodParameterInfo> getParameters() {
                List<PhpExtractMethodParameterInfo> list = settings.getParameters();
                if (list == null) {
                    2.$$$reportNull$$$0(3);
                }
                return list;
            }

            @Override
            @Nullable
            public PhpModifier.Access getVisibility() {
                return settings.getVisibility();
            }

            @Override
            public boolean isDeclareStatic() {
                return settings.isDeclareStatic();
            }

            @Override
            public boolean useTrailingCommaInParametersList() {
                return false;
            }

            @Override
            @NotNull
            public String getFunctionBody() {
                String string = settings.getFunctionBody();
                if (string == null) {
                    2.$$$reportNull$$$0(4);
                }
                return string;
            }

            @Override
            @NotNull
            public String getReturnType() {
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodDialog$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOutputVariables";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInputVariables";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParameterFolder";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParameters";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionBody";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private void installValidationOnParametersTable(final @NotNull Project project) {
        if (project == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(8);
        }
        final JTextField cellEditor = this.createParameterCellEditor(project);
        TableColumn col0 = this.myParametersTable.getColumnModel().getColumn(0);
        col0.setCellEditor(new DefaultCellEditor(cellEditor));
        final Color defaultForeground = new DefaultTableCellRenderer().getForeground();
        col0.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.height = Math.max(size.height, cellEditor.getPreferredSize().height);
                return size;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                ValidationInfo simpleValidation = PhpExtractMethodDialog.validateParameterText(project, (String)value);
                if (simpleValidation != null) {
                    component.setForeground((Color)JBColor.RED);
                } else {
                    component.setForeground(defaultForeground);
                }
                return component;
            }
        });
    }

    @NotNull
    private JTextField createParameterCellEditor(final @NotNull Project project) {
        if (project == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(9);
        }
        final JTextField cellEditor = new JTextField();
        cellEditor.putClientProperty("JComponent.compactHeight", Boolean.TRUE);
        cellEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ValidationInfo simpleValidation;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                cellEditor.putClientProperty("JComponent.outline", (simpleValidation = PhpExtractMethodDialog.validateParameterText(project, cellEditor.getText())) != null ? "error" : null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodDialog$4", "textChanged"));
            }
        });
        new ComponentValidator(this.getDisposable()).withValidator(() -> PhpExtractMethodDialog.withComponent(PhpExtractMethodDialog.validateParameterText(project, cellEditor.getText()), cellEditor)).installOn((JComponent)cellEditor);
        cellEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                ComponentValidator.getInstance((JComponent)cellEditor).ifPresent(ComponentValidator::revalidate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodDialog$5", "textChanged"));
            }
        });
        JTextField jTextField = cellEditor;
        if (jTextField == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(10);
        }
        return jTextField;
    }

    private static ValidationInfo validateParameterText(@NotNull Project project, String text) {
        if (project == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(11);
        }
        Parameter parameter = PhpExtractMethodParameterInfo.constructParameter(project, text);
        return PhpParameterValidator.validateParameter(project, parameter, text, null);
    }

    @Nullable
    private static ValidationInfo withComponent(@Nullable ValidationInfo info, @Nullable JTextField cellEditor) {
        return info != null ? new ValidationInfo(info.message, (JComponent)cellEditor) : null;
    }

    private void createUIComponents() {
        this.myParametersTableModel = new ParametersTableModel();
        this.myParametersTable = new PhpExtractMethodParamsTable(this.myParametersTableModel);
        this.myParametersTable.setRowHeight(20);
    }

    @NotNull
    public static PhpExtractMethodDialog createExtractFunctionDialog(@NotNull Project project, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables, @NotNull PhpNameConflictDetector nameConflictDetector, boolean isReplaceBreakContinueWithReturnEnabled) {
        if (project == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(12);
        }
        if (fragment == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(13);
        }
        if (inputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(14);
        }
        if (outputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(15);
        }
        if (nameConflictDetector == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(16);
        }
        PhpExtractMethodDialog dialog = new PhpExtractMethodDialog(project, outputVariables, inputVariables, fragment, nameConflictDetector, isReplaceBreakContinueWithReturnEnabled, false, false, null, PhpBundle.message("PhpExtractMethodDialog.function", new Object[0]), "function");
        dialog.init(fragment, inputVariables, outputVariables);
        dialog.setTitle(PhpBundle.message("PhpExtractMethodDialog.extract.function", new Object[0]));
        dialog.init();
        PhpExtractMethodDialog phpExtractMethodDialog = dialog;
        if (phpExtractMethodDialog == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(17);
        }
        return phpExtractMethodDialog;
    }

    @NotNull
    public static PhpExtractMethodDialog createExtractMethodDialog(@NotNull Project project, @NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, Set<PhpPsiElement> outputVariables, @NotNull PhpNameConflictDetector nameConflictDetector, boolean isReplaceBreakContinueWithReturnEnabled, boolean isDeclareStaticEnabled, boolean isDeclareStatic, @NotNull PhpModifier.Access visibility) {
        if (project == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(18);
        }
        if (fragment == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(19);
        }
        if (inputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(20);
        }
        if (nameConflictDetector == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(21);
        }
        if (visibility == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(22);
        }
        PhpExtractMethodDialog dialog = new PhpExtractMethodDialog(project, outputVariables, inputVariables, fragment, nameConflictDetector, isReplaceBreakContinueWithReturnEnabled, isDeclareStaticEnabled, isDeclareStatic, visibility, PhpBundle.message("PhpExtractMethodDialog.method", new Object[0]), "method");
        dialog.init(fragment, inputVariables, outputVariables);
        dialog.setTitle(PhpBundle.message("PhpExtractMethodDialog.extract.method", new Object[0]));
        dialog.init();
        PhpExtractMethodDialog phpExtractMethodDialog = dialog;
        if (phpExtractMethodDialog == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(23);
        }
        return phpExtractMethodDialog;
    }

    private void init(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables) {
        if (fragment == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(24);
        }
        if (inputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(25);
        }
        if (outputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(26);
        }
        this.myParameters = PhpExtractMethodDialog.getParameterItems(fragment, inputVariables, outputVariables, this.myParameterFolder);
        this.myParametersTableModel.init(this.myParameters);
        this.myParametersTable.setModel((TableModel)((Object)this.myParametersTableModel));
        this.configureTableSelectionModel();
        this.myNameSuggestionField.addDataChangedListener(() -> this.updateSignaturePreview());
        ActionListener updateActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpExtractMethodDialog.this.updateSignaturePreview();
            }
        };
        ActionListener updateTableModelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isPassByReference = PhpExtractMethodDialog.this.isPassOutputByReference();
                List<PhpExtractMethodParameterInfo> infos = PhpExtractMethodDialog.this.getParametersByReturnType(isPassByReference);
                PhpExtractMethodDialog.this.updateParameters(infos, isPassByReference);
                PhpExtractMethodDialog.this.myParametersTableModel.setReturnByRefMode(isPassByReference);
                PhpExtractMethodDialog.this.updateSignaturePreview();
            }
        };
        this.myOutputByParametersRadioButton.addActionListener(updateTableModelListener);
        this.myOutputByParametersRadioButton.addActionListener(updateActionListener);
        this.myOutputByReturnRadioButton.addActionListener(updateTableModelListener);
        this.myOutputByReturnRadioButton.addActionListener(updateActionListener);
        this.myDeclareStaticCheckBox.addActionListener(updateActionListener);
        this.myPublicRadioButton.addActionListener(updateActionListener);
        this.myProtectedRadioButton.addActionListener(updateActionListener);
        this.myPrivateRadioButton.addActionListener(updateActionListener);
        this.myParametersTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PhpExtractMethodDialog.this.updateSignaturePreview();
            }
        });
        this.myFoldParametersCheckBox.setVisible(this.myParameterFolder.isParametersFoldable());
        this.myFoldParametersCheckBox.addActionListener(e -> {
            this.myParameterFolder.setFoldingSelected(this.myFoldParametersCheckBox.isSelected());
            this.myParameters = PhpExtractMethodDialog.getParameterItems(this.myFragment, inputVariables, outputVariables, this.myParameterFolder);
            this.myParametersTableModel.init(this.myParameters);
            this.updateSignaturePreview();
        });
        this.initSignaturePanel();
        this.updateSignaturePreview();
    }

    private void configureTableSelectionModel() {
        ListSelectionModel model = this.myParametersTable.getSelectionModel();
        model.setSelectionMode(0);
        model.setSelectionInterval(0, 0);
        this.myParametersTable.setSelectionModel(model);
        TableColumnModel columnModel = this.myParametersTable.getColumnModel();
        ListSelectionModel columnSelectionModel = columnModel.getSelectionModel();
        columnSelectionModel.setSelectionInterval(0, 0);
        this.myParametersTable.setColumnModel(columnModel);
    }

    protected JComponent createNorthPanel() {
        JPanel northPanel = new JPanel(new BorderLayout(0, 2));
        northPanel.add((Component)this.myTopPanel, "North");
        northPanel.add((Component)this.myOutputVariablesPanel, "South");
        return northPanel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.createParametersPanel(), "Center");
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 1));
        bottom.add(this.myTransformationOptionsPanel);
        bottom.add(this.mySignaturePreviewPanel);
        bottom.add(this.myDuplicatesPanel);
        panel2.add((Component)bottom, "South");
        panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        return panel2;
    }

    private JPanel createParametersPanel() {
        this.myParametersTable.setFont(defaultTableFont);
        this.myParametersTable.setShowGrid(false);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myParametersTable);
        decorator.disableAddAction();
        decorator.disableRemoveAction();
        return decorator.createPanel();
    }

    private void initSignaturePanel() {
        Dimension size = new Dimension(-1, 130);
        this.mySignaturePreviewPanel.setPreferredSize(size);
        this.mySignaturePreviewPanel.setMinimumSize(size);
        this.mySignatureComponent = PhpCodeComponentsFactory.createPhpMethodSignaturePreview(this.myProject);
        this.mySignaturePreviewPanel.add((Component)this.mySignatureComponent);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameSuggestionField.getFocusableComponent();
    }

    protected String getHelpId() {
        return HELP_ID;
    }

    private void updateParameters(@NotNull List<PhpExtractMethodParameterInfo> parameters, boolean isReturnByRef) {
        if (parameters == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(27);
        }
        for (PhpExtractMethodParameterInfo parameter : parameters) {
            parameter.setIsReturnByRefMode(this.myProject, isReturnByRef);
        }
    }

    private void updateSignaturePreview() {
        if (this.mySignatureComponent != null) {
            this.mySignatureComponent.setSignature(PhpFunctionCodeGenerator.PREVIEW.generate(this));
        }
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected ValidationInfo doValidate() {
        String nameConflicts;
        String nameValidation = this.getNameValidation();
        if (nameValidation != null) {
            return new ValidationInfo(nameValidation, this.myNameSuggestionField.getFocusableComponent());
        }
        if ((!this.myNameSuggestionField.getFocusableComponent().hasFocus() || StringUtil.isNotEmpty((String)this.getName())) && (nameConflicts = this.myNameConflictDetector.findConflicts(this.getName())) != null) {
            return new ValidationInfo(nameConflicts, this.myNameSuggestionField.getFocusableComponent());
        }
        return PhpParameterValidator.validate(this.myProject, this.myParametersTableModel.getItems());
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.getRefactorAction();
        if (action == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(28);
        }
        return action;
    }

    @NlsContexts.DialogMessage
    private String validateAndCommitData() {
        String nameValidation = this.getNameValidation();
        if (nameValidation != null) {
            return nameValidation;
        }
        ValidationInfo info = PhpParameterValidator.validateAndCommit(this.myProject, this.myParametersTableModel.getItems(), PhpNamedElementImpl.getNamespace(this.myFragment.getStartStatement()));
        return info == null ? null : info.message;
    }

    @Nullable
    @NlsContexts.DialogMessage
    private String getNameValidation() {
        String newName = this.getName();
        if (!PhpNameUtil.isValidFunctionName(newName)) {
            return PhpBundle.message("validation.invalid.identifier", newName);
        }
        return null;
    }

    protected void doAction() {
        if (this.myParametersTable != null) {
            TableUtil.stopEditing((JTable)this.myParametersTable);
        }
        PhpRefactoringSettings settings = PhpRefactoringSettings.getInstance();
        settings.EXTRACT_METHOD_GENERATE_PHPDOC = this.myGeneratePhpDoc.isSelected();
        String message = this.validateAndCommitData();
        if (StringUtil.isNotEmpty((String)message)) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
        } else {
            PhpModifier.Access visibility = this.getVisibility();
            if (visibility != null) {
                settings.EXTRACT_METHOD_DEFAULT_VISIBILITY = visibility;
            }
            this.close(0);
        }
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myNameSuggestionField.getEnteredName().trim();
        if (string == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Override
    @NotNull
    public List<PhpExtractMethodParameterInfo> getParameters() {
        List list = ((ListTableModel)this.myParametersTable.getModel()).getItems();
        if (list == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(30);
        }
        return list;
    }

    private List<PhpExtractMethodParameterInfo> getParametersByReturnType(boolean returnByRef) {
        return PhpExtractMethodDialog.filterParametersByReturnType(this.myParameters, returnByRef);
    }

    protected static List<PhpExtractMethodParameterInfo> filterParametersByReturnType(List<? extends PhpExtractMethodParameterInfo> parameters, boolean returnByRef) {
        ArrayList<PhpExtractMethodParameterInfo> parameterForReturnType = new ArrayList<PhpExtractMethodParameterInfo>(parameters.size());
        for (PhpExtractMethodParameterInfo phpExtractMethodParameterInfo : parameters) {
            if (!phpExtractMethodParameterInfo.isEnabled(returnByRef)) continue;
            parameterForReturnType.add(phpExtractMethodParameterInfo);
        }
        return parameterForReturnType;
    }

    @Override
    @Nullable
    public PhpModifier.Access getVisibility() {
        if (this.myPublicRadioButton.isSelected()) {
            return PhpModifier.Access.PUBLIC;
        }
        if (this.myProtectedRadioButton.isSelected()) {
            return PhpModifier.Access.PROTECTED;
        }
        if (this.myPrivateRadioButton.isSelected()) {
            return PhpModifier.Access.PRIVATE;
        }
        return null;
    }

    @Override
    public boolean isDeclareStatic() {
        return this.myDeclareStaticCheckBox.isSelected();
    }

    @Override
    public boolean useTrailingCommaInParametersList() {
        return false;
    }

    @Override
    @NotNull
    public String getFunctionBody() {
        String string = this.myFragment.generateCodeText();
        if (string == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    private PhpType getPreviewReturnType() {
        PhpPsiElement next;
        if (this.isPassOutputByReference()) {
            PhpType phpType = PhpType.VOID;
            if (phpType == null) {
                PhpExtractMethodDialog.$$$reportNull$$$0(32);
            }
            return phpType;
        }
        if (this.myFragment instanceof PhpExtractMethodExpressionCodeFragment) {
            PhpType phpType = ((PhpExtractMethodExpressionCodeFragment)this.myFragment).getExpression().getType();
            if (phpType == null) {
                PhpExtractMethodDialog.$$$reportNull$$$0(33);
            }
            return phpType;
        }
        Set<PhpPsiElement> variables = this.getOutputVariables();
        if (variables.size() == 1 && (next = variables.iterator().next()) instanceof PhpTypedElement) {
            PhpType phpType = ((PhpTypedElement)next).getType();
            if (phpType == null) {
                PhpExtractMethodDialog.$$$reportNull$$$0(34);
            }
            return phpType;
        }
        if (variables.size() > 1) {
            PhpType phpType = PhpType.ARRAY;
            if (phpType == null) {
                PhpExtractMethodDialog.$$$reportNull$$$0(35);
            }
            return phpType;
        }
        PhpType phpType = PhpType.VOID;
        if (phpType == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(36);
        }
        return phpType;
    }

    @Override
    @NotNull
    public String getReturnType() {
        PhpType type = this.getPreviewReturnType();
        Function function = (Function)ObjectUtils.tryCast((Object)this.myFragment.getScopeHolder(), Function.class);
        String string = StringUtil.notNullize((String)PhpExtractMethodHandler.getReturnTypePresentation(this.myProject, type, function));
        if (string == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(37);
        }
        return string;
    }

    @Override
    public boolean isPassOutputByReference() {
        return this.myOutputByParametersRadioButton.isSelected();
    }

    @Override
    public boolean isReplaceBreakContinueWithReturn() {
        return this.myReplaceBreakContinueWithReturnCheckBox.isSelected();
    }

    @Override
    public boolean generatePhpDoc() {
        return this.myGeneratePhpDoc.isSelected();
    }

    @Override
    @NotNull
    public Set<PhpPsiElement> getOutputVariables() {
        Set<PhpPsiElement> set = this.myOutputVariables;
        if (set == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(38);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<PhpPsiElement> getInputVariables() {
        Set<PhpPsiElement> set = this.myInputVariables;
        if (set == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(39);
        }
        return set;
    }

    public void show() {
        super.show();
        this.collectStatistics();
    }

    private void collectStatistics() {
        ArrayList<EventPair> data = new ArrayList<EventPair>();
        boolean isExtractMethod = this.myDefaultVisibility != null;
        data.add(PhpExtractMethodDialogOptionsLogger.IS_EXTRACT_FUNCTION.with((Object)(!isExtractMethod ? 1 : 0)));
        data.add(PhpExtractMethodDialogOptionsLogger.RENAMED.with((Object)(!ArrayUtil.contains((String)this.getName(), (String[])this.myNameSuggestions) ? 1 : 0)));
        if (this.myDeclareStaticCheckBox.isVisible() && this.myDeclareStaticCheckBox.isEnabled()) {
            data.add(PhpExtractMethodDialogOptionsLogger.MAKE_STATIC.with((Object)this.myDeclareStaticCheckBox.isSelected()));
        }
        data.add(PhpExtractMethodDialogOptionsLogger.GENERATE_DOC.with((Object)this.myGeneratePhpDoc.isSelected()));
        if (this.myOutputVariablesPanel.isVisible()) {
            data.add(PhpExtractMethodDialogOptionsLogger.OUTPUT_BY_PARAMETER_REF.with((Object)this.myOutputByParametersRadioButton.isSelected()));
        }
        if (this.myFoldParametersCheckBox.isVisible()) {
            data.add(PhpExtractMethodDialogOptionsLogger.FOLD_PARAMETERS.with((Object)this.myFoldParametersCheckBox.isSelected()));
        }
        if (this.myDuplicatesCheckBox.isVisible()) {
            data.add(PhpExtractMethodDialogOptionsLogger.REPLACE_DUPLICATES.with((Object)this.myDuplicatesCheckBox.isSelected()));
        }
        if (this.myTransformationOptionsPanel.isVisible()) {
            data.add(PhpExtractMethodDialogOptionsLogger.REPLACE_BREAK_CONTINUE.with((Object)this.myReplaceBreakContinueWithReturnCheckBox.isSelected()));
        }
        if (isExtractMethod) {
            data.add(PhpExtractMethodDialogOptionsLogger.VISIBILITY_CHANGED.with((Object)(this.myDefaultVisibility != this.getVisibility() ? 1 : 0)));
        }
        List<PhpExtractMethodParameterInfo> newParams = this.getParameters();
        if (!this.myParameters.isEmpty()) {
            boolean renamed = ContainerUtil.exists(newParams, PhpExtractMethodParameterInfo::nameWasChanged);
            boolean initializerChanged = ContainerUtil.exists(newParams, PhpExtractMethodParameterInfo::initializerWasChanged);
            boolean typeChanged = ContainerUtil.exists(newParams, PhpExtractMethodParameterInfo::typeWasChanged);
            data.add(PhpExtractMethodDialogOptionsLogger.PARAMS_RENAMED.with((Object)renamed));
            data.add(PhpExtractMethodDialogOptionsLogger.PARAMS_INITIALIZER_CHANGED.with((Object)initializerChanged));
            data.add(PhpExtractMethodDialogOptionsLogger.PARAMS_TYPE_CHANGED.with((Object)typeChanged));
        }
        if (this.myParameters.size() > 1) {
            boolean reordered = false;
            for (Pair newToOld : ContainerUtil.zip(newParams, this.myParameters)) {
                if (((PhpExtractMethodParameterInfo)newToOld.first).getName().equals(((PhpExtractMethodParameterInfo)newToOld.second).getName())) continue;
                reordered = true;
                break;
            }
            data.add(PhpExtractMethodDialogOptionsLogger.PARAMS_REORDERED.with((Object)reordered));
        }
        data.add(PhpExtractMethodDialogOptionsLogger.REFACTORING_APPLIED.with((Object)this.isOK()));
        PhpExtractMethodDialogOptionsLogger.DIALOG_CLOSED.log(this.myProject, data);
    }

    @NotNull
    public static List<PhpExtractMethodParameterInfo> getParameterItems(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables, @NotNull PhpParametersFolder parameterFolder) {
        String name;
        if (fragment == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(40);
        }
        if (inputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(41);
        }
        if (outputVariables == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(42);
        }
        if (parameterFolder == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(43);
        }
        Set outputVariablesNames = ContainerUtil.map2Set(outputVariables, NavigationItem::getName);
        ArrayList<PhpExtractMethodParameterInfo> parameterInfos = new ArrayList<PhpExtractMethodParameterInfo>();
        THashSet addedVariables = new THashSet();
        PhpScopeHolder scopeHolder = fragment.getScopeHolder();
        for (PhpPsiElement inputVariable : inputVariables) {
            name = StringUtil.notNullize((String)inputVariable.getName());
            if (!addedVariables.add(name)) continue;
            PhpExtractMethodParameterInfo.ParameterType parameterType = outputVariablesNames.contains(name) ? PhpExtractMethodParameterInfo.ParameterType.RETURN_BY_REF_OR_VALUE : PhpExtractMethodParameterInfo.ParameterType.NOT_FOR_RETURN;
            Project project = inputVariable.getProject();
            String typeHint = PhpAddMethodDeclarationQuickFix.createTypeHint(project, new PhpType().add((PsiElement)inputVariable).global(project), (PsiElement)scopeHolder, false, PhpLanguageFeature.UNION_TYPES.isSupported(project));
            parameterInfos.add(new PhpExtractMethodParameterInfo(parameterType, typeHint, name, false, inputVariable));
        }
        for (PhpPsiElement outputVariable : outputVariables) {
            name = StringUtil.notNullize((String)outputVariable.getName());
            if (addedVariables.contains(name)) continue;
            parameterInfos.add(new PhpExtractMethodParameterInfo(PhpExtractMethodParameterInfo.ParameterType.RETURN_BY_REF, "", name, true, null));
        }
        parameterFolder.foldParametersIfNeeded(fragment, inputVariables, parameterInfos);
        List list = ContainerUtil.filter(parameterInfos, parameterInfo -> !parameterFolder.isParameterSafeToDelete(fragment, (PhpExtractMethodParameterInfo)parameterInfo));
        if (list == null) {
            PhpExtractMethodDialog.$$$reportNull$$$0(44);
        }
        return list;
    }

    static {
        defaultTableFont = new Font(defaultTableFont.getFontName(), defaultTableFont.getStyle(), 12);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 17: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 17: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 15: 
            case 26: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputVariables";
                break;
            }
            case 2: 
            case 14: 
            case 20: 
            case 25: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 3: 
            case 13: 
            case 19: 
            case 24: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 4: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameConflictDetector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameBorderTitle";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimensionServiceKeyPrefix";
                break;
            }
            case 7: 
            case 10: 
            case 17: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodDialog";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterFolder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterCellEditor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractFunctionDialog";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractMethodDialog";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionBody";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewReturnType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputVariables";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 10: 
            case 17: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installValidationOnParametersTable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createParameterCellEditor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateParameterText";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createExtractFunctionDialog";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createExtractMethodDialog";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateParameters";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getParameterItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 17: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextArea jTextArea;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        JPanel jPanel4;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel5;
        JBCheckBox jBCheckBox2;
        JPanel jPanel6;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel7;
        JPanel jPanel8;
        this.createUIComponents();
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTopPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myNamePanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.name"));
        jPanel7.add((Component)jBLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myDeclareStaticCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.declare.static"));
        jPanel7.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGeneratePhpDoc = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.generate.php.doc"));
        jPanel7.add((Component)jCheckBox2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNameTextFieldPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel6, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myFoldParametersCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/RefactoringBundle", PhpExtractMethodDialog.class).getString("declare.folded.parameters"));
        jPanel7.add((Component)jBCheckBox2, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myVisibilityPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "");
        jPanel8.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 1, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPublicRadioButton = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.public"));
        jPanel5.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProtectedRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.protected"));
        jPanel5.add((Component)jRadioButton4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPrivateRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.private"));
        jPanel5.add((Component)jRadioButton3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.visibility"));
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySignaturePreviewPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel9.add((Component)jPanel4, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.signature.preview"), (int)0, (int)0, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel10).setVisible(true);
        jPanel10.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel9.add((Component)jPanel10, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.parameters"), (int)0, (int)0, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel11.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = this.myParametersTable;
        jBTable.setShowVerticalLines(true);
        jBTable.setToolTipText(ResourceBundle.getBundle("messages/PhpBundle").getString("refactoring.extract.method.tooltip"));
        jBScrollPane.setViewportView((Component)jBTable);
        this.myTransformationOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel9.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.transformation.options"), (int)0, (int)0, null, null));
        this.myReplaceBreakContinueWithReturnCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.replace.tail.break.continue.with.return"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOutputVariablesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel9.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.output.variables"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myOutputVariablesArea = jTextArea = new JTextArea();
        jTextArea.setColumns(10);
        jTextArea.setEditable(false);
        jTextArea.setRows(1);
        jTextArea.setText("");
        jTextArea.setWrapStyleWord(true);
        jBScrollPane2.setViewportView(jTextArea);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.return.output.through"));
        jPanel12.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel12.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myOutputByReturnRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.return.output.through.return"));
        jPanel12.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myOutputByParametersRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpExtractMethodDialog.class).getString("PhpExtractMethodDialog.return.output.through.ref.parameters"));
        jPanel12.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myDuplicatesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myDuplicatesCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jPanel.add((Component)jBCheckBox, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class ParameterColumnInfo
    extends ColumnInfo<PhpExtractMethodParameterInfo, String> {
        private ParameterColumnInfo() {
            super(PhpBundle.message("extract.method.parameter.name.column.title", new Object[0]));
        }

        public String valueOf(PhpExtractMethodParameterInfo parameterInfo) {
            return parameterInfo.getParameterPreviewText();
        }

        public boolean isCellEditable(PhpExtractMethodParameterInfo info) {
            return true;
        }

        public void setValue(PhpExtractMethodParameterInfo info, String value) {
            info.setParameterText(value);
        }
    }

    private static class ParametersTableModel
    extends ListTableModel<PhpExtractMethodParameterInfo> {
        private final Map<Integer, PhpExtractMethodParameterInfo> rowNumToParameter = new THashMap();
        private int rowCount = 0;
        private boolean myReturnByRefMode = true;

        ParametersTableModel() {
            super(new ColumnInfo[]{new ParameterColumnInfo()});
        }

        public void init(@NotNull List<PhpExtractMethodParameterInfo> parameterInfos) {
            if (parameterInfos == null) {
                ParametersTableModel.$$$reportNull$$$0(0);
            }
            this.rowCount = parameterInfos.size();
            this.setItems(parameterInfos);
            this.setReturnByRefMode(false);
        }

        public void setReturnByRefMode(boolean returnByRefMode) {
            if (returnByRefMode != this.myReturnByRefMode) {
                List currentItems = this.getItems();
                ArrayList<PhpExtractMethodParameterInfo> resultItems = new ArrayList<PhpExtractMethodParameterInfo>(10);
                if (returnByRefMode) {
                    int addedFromCurrent = 0;
                    for (int i = 0; i < this.rowCount; ++i) {
                        if (this.rowNumToParameter.containsKey(i)) {
                            resultItems.add(this.rowNumToParameter.remove(i));
                            continue;
                        }
                        resultItems.add((PhpExtractMethodParameterInfo)currentItems.get(addedFromCurrent));
                        ++addedFromCurrent;
                    }
                    this.setItems(resultItems);
                } else {
                    for (int i = 0; i < currentItems.size(); ++i) {
                        PhpExtractMethodParameterInfo item = (PhpExtractMethodParameterInfo)currentItems.get(i);
                        if (item.isEnabled(returnByRefMode)) {
                            resultItems.add(item);
                            continue;
                        }
                        this.rowNumToParameter.put(i, item);
                    }
                }
                this.setItems(resultItems);
                this.myReturnByRefMode = returnByRefMode;
                this.fireTableDataChanged();
            }
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            super.setValueAt(aValue, rowIndex, columnIndex);
            this.fireTableDataChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterInfos", "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodDialog$ParametersTableModel", "init"));
        }
    }
}

