/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractClass;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.extractClass.PhpExtractMembersToClassProcessor;
import com.jetbrains.php.refactoring.ui.PhpMemberSelectionPanel;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import com.jetbrains.php.roots.ui.PhpPsrNamespacePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB\u001b\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\n\u0010!\u001a\u0004\u0018\u00010 H\u0002J\b\u0010\"\u001a\u00020\u0003H\u0014J\n\u0010#\u001a\u0004\u0018\u00010\u001cH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\b\u0010%\u001a\u00020&H\u0014J\u0012\u0010'\u001a\u00020\u001e2\b\b\u0001\u0010(\u001a\u00020\u0003H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0010\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/php/refactoring/extractClass/PhpExtractMembersToClassDialog;", "Lcom/intellij/refactoring/ui/RefactoringDialog;", "myClassName", "", "function", "Lcom/jetbrains/php/lang/psi/elements/PhpClassMember;", "memberInfos", "", "Lcom/jetbrains/php/refactoring/PhpMemberInfo;", "(Ljava/lang/String;Lcom/jetbrains/php/lang/psi/elements/PhpClassMember;Ljava/util/List;)V", "initialMember", "(Lcom/jetbrains/php/lang/psi/elements/PhpClassMember;Ljava/util/List;)V", "myClassNameToTextField", "Lcom/intellij/ui/components/JBTextField;", "myClassToPanel", "Ljavax/swing/JPanel;", "myContainingClass", "Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "Lorg/jetbrains/annotations/Nullable;", "myGenerateAccessors", "Ljavax/swing/JCheckBox;", "myMemberInfos", "myPsrNamespacePanel", "Lcom/jetbrains/php/roots/ui/PhpPsrNamespacePanel;", "mySelectedMember", "mySelectedMembersPanel", "Lcom/jetbrains/php/refactoring/ui/PhpMemberSelectionPanel;", "createCenterPanel", "Ljavax/swing/JComponent;", "doAction", "", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "findValidationError", "getHelpId", "getPreferredFocusedComponent", "getSelectedMemberInfos", "postponeValidation", "", "showErrorMessage", "message", "intellij.php.impl"})
public final class PhpExtractMembersToClassDialog
extends RefactoringDialog {
    private final PhpClassMember mySelectedMember;
    private final PhpClass myContainingClass;
    private List<? extends PhpMemberInfo> myMemberInfos;
    private final JPanel myClassToPanel;
    private JBTextField myClassNameToTextField;
    private PhpPsrNamespacePanel myPsrNamespacePanel;
    private PhpMemberSelectionPanel mySelectedMembersPanel;
    private JCheckBox myGenerateAccessors;

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myClassNameToTextField;
    }

    protected void doAction() {
        ValidationInfo error = this.findValidationError();
        if (error != null) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)error.message, (String)this.getHelpId(), (Project)this.myProject);
            return;
        }
        try {
            Project project = this.mySelectedMember.getProject();
            PhpClass phpClass = this.myContainingClass;
            Intrinsics.checkNotNull((Object)phpClass);
            this.invokeRefactoring(new PhpExtractMembersToClassProcessor(project, phpClass, this.getSelectedMemberInfos(), this.myClassNameToTextField.getText(), this.myPsrNamespacePanel.getNamespaceName(), PhpFileCreationInfo.generateConfiguration(this.myProject, this.myPsrNamespacePanel.getSelectedDirectory(), this.myClassNameToTextField.getText() + ".php"), this.myGenerateAccessors.isSelected()));
        }
        catch (PhpFilePathValidationException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            this.showErrorMessage(string);
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ PhpExtractMembersToClassDialog this$0;
            {
                this.this$0 = phpExtractMembersToClassDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)PhpExtractMembersToClassDialog.access$getMyPsrNamespacePanel$p(this.this$0), (CCFlags[])new CCFlags[]{$this$row.getGrow()}, null, null, (int)6, null);
            }
        }), (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ PhpExtractMembersToClassDialog this$0;
            {
                this.this$0 = phpExtractMembersToClassDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)PhpExtractMembersToClassDialog.access$getMyClassToPanel$p(this.this$0), (CCFlags[])new CCFlags[]{$this$row.getGrowX()}, null, null, (int)6, null);
            }
        }), (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ PhpExtractMembersToClassDialog this$0;
            {
                this.this$0 = phpExtractMembersToClassDialog;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Row $this$row) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Row row = $this$row;
                boolean isVerticalFlow$iv = true;
                boolean isFullWidth$iv = false;
                boolean $i$f$cell = false;
                this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                boolean bl = false;
                Cell.invoke$default((Cell)((Cell)$this$cell), (JComponent)PhpExtractMembersToClassDialog.access$getMySelectedMembersPanel$p(this.this$0), (CCFlags[])new CCFlags[]{$this$cell.getGrow()}, null, null, (int)6, null);
                this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
            }
        }), (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ PhpExtractMembersToClassDialog this$0;
            {
                this.this$0 = phpExtractMembersToClassDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)PhpExtractMembersToClassDialog.access$getMyGenerateAccessors$p(this.this$0), (CCFlags[])new CCFlags[]{$this$row.getGrowX()}, null, null, (int)6, null);
            }
        }), (int)3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        return (JComponent)panel$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PhpMemberInfo> getSelectedMemberInfos() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.myMemberInfos;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PhpMemberInfo it = (PhpMemberInfo)element$iv$iv;
            boolean bl = false;
            if (!it.isChecked()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void showErrorMessage(@NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.findValidationError();
    }

    protected boolean postponeValidation() {
        return false;
    }

    @NotNull
    protected String getHelpId() {
        return "refactorj.extractClass";
    }

    private final ValidationInfo findValidationError() {
        String string = this.myPsrNamespacePanel.getNamespaceName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myPsrNamespacePanel.namespaceName");
        String namespaceName = string;
        String string2 = this.myClassNameToTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myClassNameToTextField.text");
        String className = string2;
        if (!PhpNameUtil.isValidClassName(className)) {
            return new ValidationInfo(PhpBundle.message("validation.class.not.valid.name", className), (JComponent)this.myClassNameToTextField);
        }
        if (StringUtil.isNotEmpty((String)namespaceName) && !PhpNameUtil.isValidNamespaceFullName(namespaceName)) {
            return new ValidationInfo(PhpBundle.message("refactoring.common.validation.namespace.name", namespaceName), (JComponent)((Object)this.myPsrNamespacePanel.getNamespaceField()));
        }
        PhpClass phpClass = this.myContainingClass;
        Intrinsics.checkNotNull((Object)phpClass);
        if (phpClass.findFieldByName((CharSequence)className, false) != null) {
            return new ValidationInfo(PhpBundle.message("refactoring.validation.class.error.property.with.name.0.is.already.exists", className), (JComponent)this.myClassNameToTextField);
        }
        return null;
    }

    public PhpExtractMembersToClassDialog(@NotNull PhpClassMember initialMember, @NotNull List<? extends PhpMemberInfo> memberInfos) {
        Intrinsics.checkNotNullParameter((Object)initialMember, (String)"initialMember");
        Intrinsics.checkNotNullParameter(memberInfos, (String)"memberInfos");
        super(initialMember.getProject(), false);
        this.mySelectedMember = initialMember;
        this.myContainingClass = initialMember.getContainingClass();
        Project project = this.mySelectedMember.getProject();
        Object object = this.myContainingClass;
        if (object == null || (object = object.getNamespaceName()) == null) {
            object = "";
        }
        this.myPsrNamespacePanel = new PhpPsrNamespacePanel(project, (String)object, this.mySelectedMember.getContainingFile());
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myPsrNamespacePanel);
        this.myMemberInfos = memberInfos;
        this.mySelectedMembersPanel = new PhpMemberSelectionPanel(PhpBundle.message("refactoring.extract.class.dialog.members.to.be.extracted", new Object[0]), this.myMemberInfos, null);
        this.mySelectedMembersPanel.setPreferredSize(new Dimension(200, 200));
        this.myClassNameToTextField = new JBTextField();
        JLabel interfaceLabel = (JLabel)new JBLabel(PhpBundle.message("refactoring.extract.class.dialog.class", new Object[0]));
        this.myClassToPanel = new JPanel(new BorderLayout());
        this.myClassToPanel.add((Component)interfaceLabel, "North");
        this.myClassToPanel.add((Component)this.myClassNameToTextField, "Center");
        this.myGenerateAccessors = new JCheckBox(PhpBundle.message("refactoring.extract.class.dialog.generate.accessors", new Object[0]), true);
        this.myGenerateAccessors.setMnemonic('G');
        this.setTitle(PhpBundle.message("refactoring.extract.class.extract.to.class", new Object[0]));
        this.init();
    }

    public PhpExtractMembersToClassDialog(@NotNull String myClassName, @NotNull PhpClassMember function, @NotNull List<? extends PhpMemberInfo> memberInfos) {
        Intrinsics.checkNotNullParameter((Object)myClassName, (String)"myClassName");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(memberInfos, (String)"memberInfos");
        this(function, memberInfos);
        this.myClassNameToTextField.setText(myClassName);
    }

    public static final /* synthetic */ PhpPsrNamespacePanel access$getMyPsrNamespacePanel$p(PhpExtractMembersToClassDialog $this) {
        return $this.myPsrNamespacePanel;
    }

    public static final /* synthetic */ void access$setMyPsrNamespacePanel$p(PhpExtractMembersToClassDialog $this, PhpPsrNamespacePanel phpPsrNamespacePanel) {
        $this.myPsrNamespacePanel = phpPsrNamespacePanel;
    }

    public static final /* synthetic */ JPanel access$getMyClassToPanel$p(PhpExtractMembersToClassDialog $this) {
        return $this.myClassToPanel;
    }

    public static final /* synthetic */ PhpMemberSelectionPanel access$getMySelectedMembersPanel$p(PhpExtractMembersToClassDialog $this) {
        return $this.mySelectedMembersPanel;
    }

    public static final /* synthetic */ void access$setMySelectedMembersPanel$p(PhpExtractMembersToClassDialog $this, PhpMemberSelectionPanel phpMemberSelectionPanel) {
        $this.mySelectedMembersPanel = phpMemberSelectionPanel;
    }

    public static final /* synthetic */ JCheckBox access$getMyGenerateAccessors$p(PhpExtractMembersToClassDialog $this) {
        return $this.myGenerateAccessors;
    }

    public static final /* synthetic */ void access$setMyGenerateAccessors$p(PhpExtractMembersToClassDialog $this, JCheckBox jCheckBox) {
        $this.myGenerateAccessors = jCheckBox;
    }
}

