/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractClass;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.extractClass.PhpExtractFunctionsToClassProcessor;
import com.jetbrains.php.refactoring.extractClass.PhpFunctionInfo;
import com.jetbrains.php.refactoring.extractClass.PhpFunctionSelectionPanel;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import com.jetbrains.php.roots.ui.PhpNamespaceComboBox;
import com.jetbrains.php.roots.ui.PhpPsrNamespacePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nB\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0014J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0017H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010 \u001a\u00020!H\u0014J\u0012\u0010\"\u001a\u00020\u00192\b\b\u0001\u0010#\u001a\u00020\u0003H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/php/refactoring/extractClass/PhpExtractFunctionsToClassDialog;", "Lcom/intellij/refactoring/ui/RefactoringDialog;", "myClassName", "", "myNamespace", "function", "Lcom/jetbrains/php/lang/psi/elements/Function;", "functionInfos", "", "Lcom/jetbrains/php/refactoring/extractClass/PhpFunctionInfo;", "(Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/php/lang/psi/elements/Function;Ljava/util/List;)V", "(Lcom/jetbrains/php/lang/psi/elements/Function;Ljava/util/List;)V", "myClassNameToTextField", "Lcom/intellij/ui/components/JBTextField;", "myClassToPanel", "Ljavax/swing/JPanel;", "myFunctionInfos", "myPsrNamespacePanel", "Lcom/jetbrains/php/roots/ui/PhpPsrNamespacePanel;", "mySelectedMember", "mySelectedMembersPanel", "Lcom/jetbrains/php/refactoring/extractClass/PhpFunctionSelectionPanel;", "createCenterPanel", "Ljavax/swing/JComponent;", "doAction", "", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "findValidationError", "getHelpId", "getPreferredFocusedComponent", "getSelectedMemberInfos", "postponeValidation", "", "showErrorMessage", "message", "intellij.php.impl"})
public final class PhpExtractFunctionsToClassDialog
extends RefactoringDialog {
    private final Function mySelectedMember;
    private List<? extends PhpFunctionInfo> myFunctionInfos;
    private final JPanel myClassToPanel;
    private JBTextField myClassNameToTextField;
    private PhpPsrNamespacePanel myPsrNamespacePanel;
    private PhpFunctionSelectionPanel mySelectedMembersPanel;

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myClassNameToTextField;
    }

    @NotNull
    protected String getHelpId() {
        return "refactorj.extractClass";
    }

    protected void doAction() {
        ValidationInfo error = this.findValidationError();
        if (error != null) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)error.message, (String)this.getHelpId(), (Project)this.myProject);
            return;
        }
        try {
            this.invokeRefactoring(new PhpExtractFunctionsToClassProcessor(this.mySelectedMember.getProject(), this.getSelectedMemberInfos(), this.myClassNameToTextField.getText(), this.myPsrNamespacePanel.getNamespaceName(), PhpFileCreationInfo.generateConfiguration(this.myProject, this.myPsrNamespacePanel.getSelectedDirectory(), this.myClassNameToTextField.getText() + ".php")));
        }
        catch (PhpFilePathValidationException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            this.showErrorMessage(string);
        }
    }

    private final void showErrorMessage(@NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PhpFunctionInfo> getSelectedMemberInfos() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.myFunctionInfos;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PhpFunctionInfo it = (PhpFunctionInfo)element$iv$iv;
            boolean bl = false;
            if (!it.isChecked()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ PhpExtractFunctionsToClassDialog this$0;
            {
                this.this$0 = phpExtractFunctionsToClassDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)PhpExtractFunctionsToClassDialog.access$getMyPsrNamespacePanel$p(this.this$0), (CCFlags[])new CCFlags[]{$this$row.getGrow()}, null, null, (int)6, null);
            }
        }), (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ PhpExtractFunctionsToClassDialog this$0;
            {
                this.this$0 = phpExtractFunctionsToClassDialog;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)PhpExtractFunctionsToClassDialog.access$getMyClassToPanel$p(this.this$0), (CCFlags[])new CCFlags[]{$this$row.getGrowX()}, null, null, (int)6, null);
            }
        }), (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ PhpExtractFunctionsToClassDialog this$0;
            {
                this.this$0 = phpExtractFunctionsToClassDialog;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Row $this$row) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Row row = $this$row;
                boolean isVerticalFlow$iv = true;
                boolean isFullWidth$iv = false;
                boolean $i$f$cell = false;
                this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                boolean bl = false;
                Cell.invoke$default((Cell)((Cell)$this$cell), (JComponent)PhpExtractFunctionsToClassDialog.access$getMySelectedMembersPanel$p(this.this$0), (CCFlags[])new CCFlags[]{$this$cell.getGrow()}, null, null, (int)6, null);
                this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
            }
        }), (int)3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        return (JComponent)panel$iv;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.findValidationError();
    }

    protected boolean postponeValidation() {
        return false;
    }

    private final ValidationInfo findValidationError() {
        String string = this.myPsrNamespacePanel.getNamespaceName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myPsrNamespacePanel.namespaceName");
        String namespaceName = string;
        String string2 = this.myClassNameToTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myClassNameToTextField.text");
        String className = string2;
        if (!PhpNameUtil.isValidClassName(className)) {
            return new ValidationInfo(PhpBundle.message("validation.class.not.valid.name", className), (JComponent)this.myClassNameToTextField);
        }
        if (StringUtil.isNotEmpty((String)namespaceName) && !PhpNameUtil.isValidNamespaceFullName(namespaceName)) {
            String string3 = PhpBundle.message("refactoring.common.validation.namespace.name", namespaceName);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PhpBundle.message(\"refac\u2026ace.name\", namespaceName)");
            String message = string3;
            return new ValidationInfo(message, (JComponent)((Object)this.myPsrNamespacePanel.getNamespaceField()));
        }
        return null;
    }

    public PhpExtractFunctionsToClassDialog(@NotNull Function function, @NotNull List<? extends PhpFunctionInfo> functionInfos) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(functionInfos, (String)"functionInfos");
        super(function.getProject(), false);
        this.mySelectedMember = function;
        this.myPsrNamespacePanel = new PhpPsrNamespacePanel(this.mySelectedMember.getProject(), "", this.mySelectedMember.getContainingFile());
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myPsrNamespacePanel);
        this.myFunctionInfos = functionInfos;
        this.mySelectedMembersPanel = new PhpFunctionSelectionPanel(PhpBundle.message("functions.to.be.extracted", new Object[0]), this.myFunctionInfos, null);
        this.mySelectedMembersPanel.setPreferredSize(new Dimension(200, 200));
        this.myClassNameToTextField = new JBTextField();
        JLabel interfaceLabel = (JLabel)new JBLabel(PhpBundle.message("refactoring.extract.class.dialog.class", new Object[0]));
        this.myClassToPanel = new JPanel(new BorderLayout());
        this.myClassToPanel.add((Component)interfaceLabel, "North");
        this.myClassToPanel.add((Component)this.myClassNameToTextField, "Center");
        this.setTitle(PhpBundle.message("refactoring.extract.class.extract.to.class", new Object[0]));
        this.init();
    }

    public PhpExtractFunctionsToClassDialog(@NotNull String myClassName, @NotNull String myNamespace, @NotNull Function function, @NotNull List<? extends PhpFunctionInfo> functionInfos) {
        Intrinsics.checkNotNullParameter((Object)myClassName, (String)"myClassName");
        Intrinsics.checkNotNullParameter((Object)myNamespace, (String)"myNamespace");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(functionInfos, (String)"functionInfos");
        this(function, functionInfos);
        this.myClassNameToTextField.setText(myClassName);
        PhpNamespaceComboBox phpNamespaceComboBox = this.myPsrNamespacePanel.getNamespaceField();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)phpNamespaceComboBox), (String)"myPsrNamespacePanel.namespaceField");
        EditorTextField editorTextField = phpNamespaceComboBox.getEditorTextField();
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"myPsrNamespacePanel.namespaceField.editorTextField");
        editorTextField.setText(myNamespace);
    }

    public static final /* synthetic */ PhpPsrNamespacePanel access$getMyPsrNamespacePanel$p(PhpExtractFunctionsToClassDialog $this) {
        return $this.myPsrNamespacePanel;
    }

    public static final /* synthetic */ void access$setMyPsrNamespacePanel$p(PhpExtractFunctionsToClassDialog $this, PhpPsrNamespacePanel phpPsrNamespacePanel) {
        $this.myPsrNamespacePanel = phpPsrNamespacePanel;
    }

    public static final /* synthetic */ JPanel access$getMyClassToPanel$p(PhpExtractFunctionsToClassDialog $this) {
        return $this.myClassToPanel;
    }

    public static final /* synthetic */ PhpFunctionSelectionPanel access$getMySelectedMembersPanel$p(PhpExtractFunctionsToClassDialog $this) {
        return $this.mySelectedMembersPanel;
    }

    public static final /* synthetic */ void access$setMySelectedMembersPanel$p(PhpExtractFunctionsToClassDialog $this, PhpFunctionSelectionPanel phpFunctionSelectionPanel) {
        $this.mySelectedMembersPanel = phpFunctionSelectionPanel;
    }
}

