/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractClass;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.newClassDataProvider.ClassCreationType;
import com.jetbrains.php.lang.inspections.quickfix.createClass.PhpCreateClassQuickFix;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpBaseRefactoringProcessor;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.extractClass.PhpExtractFunctionsToClassProcessor;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpExtractClassBaseProcessor
extends PhpBaseRefactoringProcessor {
    protected static final Logger LOG = Logger.getInstance(PhpExtractFunctionsToClassProcessor.class);
    @NotNull
    protected final String myTargetClassName;
    @NotNull
    protected final String myNamespaceName;
    @NotNull
    protected final PhpFileCreationInfo myFileCreationInfo;
    @Nullable
    protected PhpClass myTargetClass;

    public PhpExtractClassBaseProcessor(Project project, @NotNull String className, @NotNull String namespace, @NotNull PhpFileCreationInfo fileCreationInfo) {
        if (className == null) {
            PhpExtractClassBaseProcessor.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            PhpExtractClassBaseProcessor.$$$reportNull$$$0(1);
        }
        if (fileCreationInfo == null) {
            PhpExtractClassBaseProcessor.$$$reportNull$$$0(2);
        }
        super(project);
        this.myTargetClassName = className;
        this.myNamespaceName = namespace;
        this.myFileCreationInfo = fileCreationInfo;
    }

    @Override
    protected boolean forceOptimizeImports() {
        return true;
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpBundle.message("php.extract.class", new Object[0]);
        if (string == null) {
            PhpExtractClassBaseProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected boolean tryToCreateClass() {
        PsiFile file = PhpExtractClassBaseProcessor.createFile(this.myProject, this.myTargetClassName, this.myNamespaceName, this.myFileCreationInfo);
        if (file instanceof PhpFile) {
            this.myTargetClass = PhpPsiUtil.findClass((PhpFile)file, (Condition<? super PhpClass>)Conditions.alwaysTrue());
        }
        if (file == null) {
            LOG.error(PhpBundle.message("refactoring.extract.class.error.failed.to.create.file", new Object[0]));
            return false;
        }
        return true;
    }

    protected void reformatCreatedFileAndNavigate() {
        PsiFile createdFile = Objects.requireNonNull(this.myTargetClass).getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(createdFile);
        if (document != null) {
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(document);
            CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)createdFile);
        }
        this.myTargetClass.navigate(true);
    }

    @Nullable
    public static PsiFile createFile(Project project, String className, String namespace, PhpFileCreationInfo info) {
        Properties properties = PhpExtractClassBaseProcessor.createClassProperties(className, namespace);
        return PhpCreateClassQuickFix.createClassInSeparateFile(project, properties, info.getRelativePath(), info.getBaseDirectory(), PhpBundle.message("php.extract.class", new Object[0]), ClassCreationType.CLASS.getTemplateName());
    }

    @NotNull
    private static Properties createClassProperties(String className, String namespace) {
        Properties properties = new Properties();
        properties.setProperty("NAME", className);
        if (!namespace.isEmpty()) {
            properties.setProperty("NAMESPACE", namespace);
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpExtractClassBaseProcessor.$$$reportNull$$$0(4);
        }
        return properties2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCreationInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractClass/PhpExtractClassBaseProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractClass/PhpExtractClassBaseProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

