/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extract.extractInterface;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.PhpDependencyMemberInfoModel;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.extract.extractInterface.PhpExtractInterfaceProcessor;
import com.jetbrains.php.refactoring.ui.PhpMemberSelectionPanel;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import com.jetbrains.php.roots.ui.PhpPsrNamespacePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractInterfaceDialog
extends RefactoringDialog {
    private static final String HELP_ID = "refactoring.extractInterface";
    private static final String DIMENSION_SERVICE_KEY = "#com.jetbrains.php.refactoring.extract.interface.PhpExtractInterfaceDialog#";
    private JTextField myInterfaceTextField;
    private NonFocusableCheckBox myReplaceClassReference;
    private final PhpPsrNamespacePanel myDirectoryChoosePanel;
    protected MemberInfoModel<PhpClassMember, PhpMemberInfo> myMemberInfoModel;
    private final PhpClass myClass;
    protected List<PhpMemberInfo> myMemberInfos;
    private JRadioButton myDoNothingButton;
    private JRadioButton myMoveButton;

    public PhpExtractInterfaceDialog(@NotNull Project project, @NotNull PhpClass clazz, List<PhpMemberInfo> memberInfos) {
        if (project == null) {
            PhpExtractInterfaceDialog.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            PhpExtractInterfaceDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myClass = clazz;
        this.myMemberInfos = memberInfos;
        this.myDirectoryChoosePanel = new PhpPsrNamespacePanel(this.myProject, this.myClass.getNamespaceName(), this.myClass.getContainingFile());
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myDirectoryChoosePanel);
        this.setTitle(PhpBundle.message("refactoring.extract.interface.title", this.myClass.getName()));
        this.init();
    }

    @NotNull
    private static String generateDefaultInterfaceName(@NotNull String className) {
        if (className == null) {
            PhpExtractInterfaceDialog.$$$reportNull$$$0(2);
        }
        String string = className;
        if (string == null) {
            PhpExtractInterfaceDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void doAction() {
        String namespaceName = this.myDirectoryChoosePanel.getNamespaceName();
        ValidationInfo error = this.findValidationError();
        if (error != null) {
            this.showErrorMessage(error.message);
            return;
        }
        try {
            String interfaceName = this.myInterfaceTextField.getText();
            String fileName = interfaceName + "." + PhpFileType.INSTANCE.getDefaultExtension();
            PhpFileCreationInfo newFileConfiguration = PhpFileCreationInfo.generateConfiguration(this.myProject, this.myDirectoryChoosePanel.getSelectedDirectory(), fileName);
            boolean replaceClassReferences = this.myReplaceClassReference.isSelected();
            PhpExtractInterfaceProcessor.PhpDocRefactoringType docRefactoringType = this.getPhpDocRefactoringType();
            PhpExtractInterfaceProcessor processor = new PhpExtractInterfaceProcessor(this.myProject, this.myClass, interfaceName, namespaceName, newFileConfiguration, this.getSelectedMemberInfos(), docRefactoringType, replaceClassReferences);
            if (replaceClassReferences) {
                this.setPreviewResults(true);
            }
            this.invokeRefactoring(processor);
        }
        catch (PhpFilePathValidationException e) {
            this.showErrorMessage(e.getMessage());
        }
    }

    private PhpExtractInterfaceProcessor.PhpDocRefactoringType getPhpDocRefactoringType() {
        if (this.myDoNothingButton.isSelected()) {
            return PhpExtractInterfaceProcessor.PhpDocRefactoringType.DO_NOTHING;
        }
        if (this.myMoveButton.isSelected()) {
            return PhpExtractInterfaceProcessor.PhpDocRefactoringType.MOVE;
        }
        return PhpExtractInterfaceProcessor.PhpDocRefactoringType.COPY;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo error = this.findValidationError();
        if (error != null) {
            return error;
        }
        String interfaceName = this.myInterfaceTextField.getText();
        String namespaceName = this.myDirectoryChoosePanel.getNamespaceName();
        String newInterfaceFqn = PhpLangUtil.toFQN(namespaceName + "\\" + interfaceName);
        Collection classes = PhpIndex.getInstance((Project)this.myProject).getAnyByFQN(newInterfaceFqn);
        if (!classes.isEmpty()) {
            String fileName = ((PhpClass)classes.iterator().next()).getContainingFile().getName();
            String message = PhpBundle.message("validation.class.already.exists", fileName);
            return new ValidationInfo(message, (JComponent)this.myInterfaceTextField);
        }
        for (PhpMemberInfo info : this.getSelectedMemberInfos()) {
            PhpModifier modifier = ((PhpClassMember)info.getMember()).getModifier();
            if (modifier.isPublic()) continue;
            return new ValidationInfo(PhpBundle.message("refactoring.extract.interface.validation.members.modifier", new Object[0]));
        }
        return super.doValidate();
    }

    private ValidationInfo findValidationError() {
        String interfaceName = this.myInterfaceTextField.getText();
        if (!PhpNameUtil.isValidClassName(interfaceName)) {
            return new ValidationInfo(PhpBundle.message("validation.class.not.valid.name", interfaceName), (JComponent)this.myInterfaceTextField);
        }
        String namespaceName = this.myDirectoryChoosePanel.getNamespaceName();
        String newInterfaceFqn = PhpLangUtil.toFQN(namespaceName + "\\" + interfaceName);
        if (PhpLangUtil.equalsClassNames(this.myClass.getFQN(), newInterfaceFqn)) {
            String fileName = this.myClass.getContainingFile().getName();
            String message = PhpBundle.message("validation.class.already.exists", fileName);
            return new ValidationInfo(message, (JComponent)this.myInterfaceTextField);
        }
        return this.myDirectoryChoosePanel.getValidationInfo();
    }

    protected boolean postponeValidation() {
        return false;
    }

    private void showErrorMessage(@NotNull @NlsContexts.DialogMessage String message) {
        if (message == null) {
            PhpExtractInterfaceDialog.$$$reportNull$$$0(4);
        }
        CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        String className = this.myClass.getName();
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel interfacePanel = this.createInterfacePanel(className);
        panel2.add((Component)interfacePanel, "Center");
        JPanel south = new JPanel(new BorderLayout());
        PhpMemberSelectionPanel memberSelectionPanel = new PhpMemberSelectionPanel(PhpBundle.message("refactoring.extract.interface.members.title", new Object[0]), this.myMemberInfos, null);
        this.myMemberInfoModel = new PhpDependencyMemberInfoModel(this.myClass);
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        memberSelectionPanel.getTable().setMemberInfoModel(this.myMemberInfoModel);
        memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        south.add((Component)memberSelectionPanel, "West");
        JPanel phpDocPanel = this.createPhpDocPanel();
        south.add((Component)phpDocPanel, "East");
        panel2.add((Component)south, "South");
        return panel2;
    }

    @NotNull
    private JPanel createPhpDocPanel() {
        this.myDoNothingButton = new JRadioButton(PhpBundle.message("refactoring.extract.interface.phpdoc.do.nothing", new Object[0]));
        this.myMoveButton = new JRadioButton(PhpBundle.message("refactoring.extract.interface.phpdoc.move", new Object[0]));
        JRadioButton copyButton = new JRadioButton(PhpBundle.message("refactoring.extract.interface.phpdoc.copy", new Object[0]), true);
        ButtonGroup phpDocButtonGroup = new ButtonGroup();
        phpDocButtonGroup.add(this.myDoNothingButton);
        phpDocButtonGroup.add(copyButton);
        phpDocButtonGroup.add(this.myMoveButton);
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 5, true, false));
        String title = PhpBundle.message("refactoring.extract.interface.phpdoc.title", new Object[0]);
        IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder((String)title, (boolean)false);
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 5, 5, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder((Border)titledBorder, emptyBorder);
        panel2.setBorder(border);
        panel2.add(this.myDoNothingButton);
        panel2.add(copyButton);
        panel2.add(this.myMoveButton);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            PhpExtractInterfaceDialog.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    private JPanel createInterfacePanel(@NotNull @NlsSafe String className) {
        if (className == null) {
            PhpExtractInterfaceDialog.$$$reportNull$$$0(6);
        }
        JPanel subPanel = new JPanel(new BorderLayout());
        JBLabel interfaceLabel = new JBLabel(PhpBundle.message("refactoring.extract.interface.field", new Object[0]));
        String interfaceName = PhpExtractInterfaceDialog.generateDefaultInterfaceName(className);
        this.myInterfaceTextField = new JBTextField(interfaceName);
        interfaceLabel.setLabelFor(this.myInterfaceTextField);
        subPanel.add((Component)interfaceLabel, "North");
        subPanel.add((Component)this.myInterfaceTextField, "Center");
        this.myReplaceClassReference = new NonFocusableCheckBox(PhpBundle.message("refactoring.extract.replace.class.reference", new Object[0]));
        subPanel.add((Component)this.myReplaceClassReference, "South");
        JPanel interfacePanel = new JPanel(new BorderLayout());
        interfacePanel.add((Component)subPanel, "North");
        interfacePanel.add((Component)this.myDirectoryChoosePanel, "Center");
        JPanel jPanel = interfacePanel;
        if (jPanel == null) {
            PhpExtractInterfaceDialog.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY;
    }

    @Nullable
    protected String getHelpId() {
        return HELP_ID;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myInterfaceTextField;
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    @NotNull
    public List<PhpMemberInfo> getSelectedMemberInfos() {
        ArrayList<PhpMemberInfo> list = new ArrayList<PhpMemberInfo>(this.myMemberInfos.size());
        for (PhpMemberInfo info : this.myMemberInfos) {
            if (!info.isChecked() || !this.myMemberInfoModel.isMemberEnabled((MemberInfoBase)info)) continue;
            list.add(info);
        }
        ArrayList<PhpMemberInfo> arrayList = list;
        if (arrayList == null) {
            PhpExtractInterfaceDialog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extract/extractInterface/PhpExtractInterfaceDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extract/extractInterface/PhpExtractInterfaceDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefaultInterfaceName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPhpDocPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterfacePanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMemberInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateDefaultInterfaceName";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInterfacePanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

