/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.google.common.base.Strings;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeInfo
implements ChangeInfo {
    private final Function myMethod;
    private final boolean myIsConstructor;
    private final PhpParameterInfo[] myNewParameterInfo;
    private final String myNewReturnTypeText;
    private final String myNewName;
    private final String myNewVisibility;
    private final int myNewParametersCount;
    private int myOldParametersCount;
    private boolean[] myOldIsPassByRef;
    private boolean[] myOldIsVariadic;
    private String[] myOldParameterNames;
    private String[] myOldParameterTypes;
    private String[] myOldParameterInitializers;
    private final String myOldReturnTypeText;
    private boolean myIsParameterNameChanged;
    private boolean myIsParameterTypeChanged;
    private boolean myIsParameterInitializerChanged;
    private boolean myIsParameterPassByRefChanged;
    private boolean myIsParameterVariadicChanged;
    private boolean myIsParameterSetOrOrderChanged;
    private final boolean myIsReturnTypeChanged;
    private final boolean myIsNameChanged;
    private boolean myUpdatePhpDoc;
    private final boolean myIsVisibilityChanged;
    private final boolean myInitializeProperties;
    private final boolean[] toRemove;
    private final Set<Function> myFunctionsToPropagation;
    final boolean[] myRemainingParameters;

    public PhpChangeInfo(@NotNull PhpMethodDescriptor descriptor, PhpParameterInfo @NotNull [] newParameterInfo, @Nullable String newVisibility, @NotNull String newName, @Nullable String returnTypeText, @Nullable Set<Function> functionsToPropagation, boolean initializeProperties, boolean updatePhpDoc) {
        if (descriptor == null) {
            PhpChangeInfo.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            PhpChangeInfo.$$$reportNull$$$0(1);
        }
        if (newParameterInfo == null) {
            PhpChangeInfo.$$$reportNull$$$0(2);
        }
        this.myMethod = descriptor.getMethod();
        this.myIsConstructor = descriptor.isConstructor();
        this.myNewParameterInfo = newParameterInfo;
        this.myNewName = newName;
        this.myNewVisibility = newVisibility;
        this.myNewParametersCount = PhpChangeInfo.countNewValues(newParameterInfo);
        this.myNewReturnTypeText = returnTypeText;
        this.myIsNameChanged = !PhpLangUtil.equalsFunctionNames(newName, this.myMethod.getName());
        this.myUpdatePhpDoc = updatePhpDoc;
        PhpTypeDeclaration returnType = this.myMethod.getTypeDeclaration();
        this.myOldReturnTypeText = returnType != null ? returnType.getText() : null;
        this.myIsReturnTypeChanged = !Strings.nullToEmpty((String)returnTypeText).equals(Strings.nullToEmpty((String)this.myOldReturnTypeText));
        this.myIsVisibilityChanged = this.myMethod instanceof Method && !newVisibility.equals(descriptor.getVisibility());
        Parameter[] oldParameters = this.myMethod.getParameters();
        this.fillOldValues(oldParameters);
        this.toRemove = new boolean[this.myOldParameterNames.length];
        Arrays.fill(this.toRemove, true);
        for (PhpParameterInfo it : this.myNewParameterInfo) {
            if (it.isNew()) continue;
            this.toRemove[it.getOldIndex()] = false;
        }
        if (oldParameters.length != newParameterInfo.length) {
            this.myIsParameterSetOrOrderChanged = true;
        } else {
            this.myIsParameterSetOrOrderChanged = false;
            for (int i = 0; i < newParameterInfo.length; ++i) {
                PhpParameterInfo parameterInfo = newParameterInfo[i];
                if (i != parameterInfo.getOldIndex()) {
                    this.myIsParameterSetOrOrderChanged = true;
                    break;
                }
                if (!parameterInfo.getName().equals(this.myOldParameterNames[i])) {
                    this.myIsParameterNameChanged = true;
                }
                if (!parameterInfo.getTypeText().equals(this.myOldParameterTypes[i])) {
                    this.myIsParameterTypeChanged = true;
                }
                if (!Strings.nullToEmpty((String)parameterInfo.getInitializer()).equals(Strings.nullToEmpty((String)this.myOldParameterInitializers[i]))) {
                    this.myIsParameterInitializerChanged = true;
                }
                if (parameterInfo.isPassByRef() != this.myOldIsPassByRef[i]) {
                    this.myIsParameterPassByRefChanged = true;
                }
                if (parameterInfo.isVariadic() == this.myOldIsVariadic[i]) continue;
                this.myIsParameterVariadicChanged = true;
                this.myIsParameterSetOrOrderChanged = true;
            }
        }
        this.myFunctionsToPropagation = functionsToPropagation == null ? new THashSet() : functionsToPropagation;
        this.myInitializeProperties = initializeProperties;
        this.myRemainingParameters = new boolean[oldParameters.length];
        for (PhpParameterInfo info : newParameterInfo) {
            if (info.getOldIndex() < 0 || info.getOldIndex() >= this.myRemainingParameters.length) continue;
            this.myRemainingParameters[info.getOldIndex()] = true;
        }
    }

    public String getNewReturnTypeText() {
        return this.myNewReturnTypeText;
    }

    public String getOldReturnTypeText() {
        return this.myOldReturnTypeText;
    }

    public boolean[] getRemainingParameters() {
        return this.myRemainingParameters;
    }

    public boolean isUpdatePhpDoc() {
        return this.myUpdatePhpDoc;
    }

    private static int countNewValues(PhpParameterInfo[] newParameterInfo) {
        int counter = 0;
        for (PhpParameterInfo parameterInfo : newParameterInfo) {
            if (!parameterInfo.isNew()) continue;
            ++counter;
        }
        return counter;
    }

    private void fillOldValues(Parameter[] oldParameters) {
        this.myOldParametersCount = oldParameters.length;
        this.myOldParameterNames = new String[this.myOldParametersCount];
        this.myOldParameterTypes = new String[this.myOldParametersCount];
        this.myOldParameterInitializers = new String[this.myOldParametersCount];
        this.myOldIsPassByRef = new boolean[this.myOldParametersCount];
        this.myOldIsVariadic = new boolean[this.myOldParametersCount];
        for (int i = 0; i < this.myOldParametersCount; ++i) {
            String oldName;
            Parameter parameter = oldParameters[i];
            this.myOldParameterNames[i] = oldName = StringUtil.notNullize((String)parameter.getName());
            this.myOldParameterTypes[i] = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter);
            this.myOldParameterInitializers[i] = PhpFunctionCodeGenerator.getInitializer(parameter);
            this.myOldIsPassByRef[i] = parameter.isPassByRef();
            this.myOldIsVariadic[i] = parameter.isVariadic();
        }
    }

    public Function getMethod() {
        return this.myMethod;
    }

    public boolean isConstructor() {
        return this.myIsConstructor;
    }

    public PhpParameterInfo @NotNull [] getNewParameters() {
        if (this.myNewParameterInfo == null) {
            PhpChangeInfo.$$$reportNull$$$0(3);
        }
        return this.myNewParameterInfo;
    }

    public String getNewName() {
        return this.myNewName;
    }

    public String getNewVisibility() {
        return this.myNewVisibility;
    }

    public int getOldParametersCount() {
        return this.myOldParametersCount;
    }

    public String getOldParameterNames(int i) {
        return this.myOldParameterNames[i];
    }

    public String getOldParameterTypes(int i) {
        return this.myOldParameterTypes[i];
    }

    public String getOldParameterInitializers(int i) {
        return this.myOldParameterInitializers[i];
    }

    public boolean getOldParameterPassByRef(int i) {
        return this.myOldIsPassByRef[i];
    }

    public boolean getOldParameterVariadic(int i) {
        return this.myOldIsVariadic[i];
    }

    public boolean isParameterSetOrOrderChanged() {
        return this.myIsParameterSetOrOrderChanged;
    }

    public boolean isParameterTypesChanged() {
        return this.myIsParameterTypeChanged;
    }

    public boolean isParameterNamesChanged() {
        return this.myIsParameterNameChanged;
    }

    public boolean isParameterInitializerChanged() {
        return this.myIsParameterInitializerChanged;
    }

    public boolean isParametersChanged() {
        return this.isParameterNamesChanged() || this.isParameterTypesChanged() || this.isParameterInitializerChanged() || this.myIsParameterPassByRefChanged || this.myIsParameterVariadicChanged;
    }

    public boolean isVisibilityChanged() {
        return this.myIsVisibilityChanged;
    }

    public boolean isNameChanged() {
        return this.myIsNameChanged;
    }

    public boolean isFunctionToPropagation(Function function) {
        return this.myFunctionsToPropagation.contains(function);
    }

    public boolean isInitializeProperties() {
        return this.myInitializeProperties;
    }

    public Set<Function> getFunctionsToPropagation() {
        return this.myFunctionsToPropagation;
    }

    public int getNewParametersCount() {
        return this.myNewParametersCount;
    }

    public boolean isGenerateDelegate() {
        return false;
    }

    public boolean isReturnTypeChanged() {
        return this.myIsReturnTypeChanged;
    }

    public Language getLanguage() {
        return PhpFileType.INSTANCE.getLanguage();
    }

    public boolean[] toRemoveParams() {
        return this.toRemove;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameterInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

