/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpChangeVisibilityIntentionBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpMoveClassMemberBase {
    protected static final Logger LOG = Logger.getInstance(PhpMoveClassMemberBase.class);
    private static final TokenSet FIELD_LIST_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS});
    private static final Condition<PsiElement> FIELD_LIST_CONDITION = element -> {
        ASTNode node = element.getNode();
        IElementType elementType = node == null ? null : node.getElementType();
        return FIELD_LIST_TOKEN_SET.contains(elementType);
    };
    protected PhpClass myTargetClass;
    protected boolean myShouldWeakAccess;

    private PhpMoveClassMemberBase(PhpClass targetClass, boolean shouldWeakAccess) {
        this.myTargetClass = targetClass;
        this.myShouldWeakAccess = shouldWeakAccess;
    }

    @NotNull
    public static PhpMoveClassMemberBase getInstance(@NotNull PhpClass targetClass, boolean shouldWeakAccess) {
        if (targetClass == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(0);
        }
        if (targetClass.isInterface()) {
            return new PhpMoveClassMemberToInterface(targetClass, shouldWeakAccess);
        }
        return new PhpMoveClassMember(targetClass, shouldWeakAccess);
    }

    public static void removeMembers(@NotNull List<? extends PhpClassMember> members, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(1);
        }
        for (PhpClassMember phpClassMember : members) {
            if (phpClassMember instanceof Field) {
                PhpMoveClassMemberBase.removeFieldWithPhpDoc((Field)phpClassMember);
                continue;
            }
            if (!shouldRemoveMethods || !(phpClassMember instanceof Method)) continue;
            PhpMoveClassMemberBase.removeFunctionWithPhpDoc((Function)((Method)phpClassMember));
        }
    }

    public static void removeFieldWithPhpDoc(Field field) {
        PsiElement fieldList = PhpMoveClassMemberBase.getFieldListElement(field);
        LOG.assertTrue(fieldList != null);
        if (PhpMoveClassMemberBase.isSingleFieldList(fieldList)) {
            PsiElement parent = fieldList.getParent();
            PhpDocComment comment = field.getDocComment();
            parent.deleteChildRange((PsiElement)(comment == null ? fieldList : comment), fieldList);
        } else {
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)field, PhpTokenTypes.opCOMMA);
        }
    }

    public static void removeFunctionWithPhpDoc(Function function) {
        PsiElement methodParent = function.getParent();
        if (function instanceof PhpDocMethod) {
            methodParent.getParent().deleteChildRange(methodParent, methodParent);
            return;
        }
        PhpDocComment comment = function.getDocComment();
        methodParent.deleteChildRange((PsiElement)(comment != null ? comment : function), (PsiElement)function);
    }

    @NotNull
    public List<PsiElement> move(@NotNull List<PhpClassMember> members, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(2);
        }
        List<PsiElement> list = this.cutAndMove(members, shouldRemoveMethods);
        if (list == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> move(@NotNull List<PhpClassMember> members, PhpModifier.Access access, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(4);
        }
        for (PhpClassMember memberIt : members) {
            PhpMoveClassMemberBase.changeMemberVisibility(access, memberIt);
        }
        List<PsiElement> list = this.cutAndMove(members, shouldRemoveMethods);
        if (list == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static void changeMemberVisibility(PhpModifier.Access access, PhpClassMember member) {
        PsiElement modifierList;
        PhpModifier modifier = member.getModifier();
        PhpModifierList newModifierList = PhpPsiElementFactory.createModifierList(member.getProject(), PhpModifier.instance((PhpModifier.Access)access, (PhpModifier.Abstractness)modifier.getAbstractness(), (PhpModifier.State)modifier.getState()));
        PhpClassMember element = member;
        if (member instanceof Field) {
            element = member.getParent();
        }
        if ((modifierList = PhpPsiUtil.getChildOfType((PsiElement)element, PhpElementTypes.MODIFIER_LIST)) instanceof PhpModifierList) {
            PsiElement replace = modifierList.replace((PsiElement)newModifierList);
            if (modifierList.getTextRange().isEmpty()) {
                replace.getParent().addAfter((PsiElement)PhpPsiElementFactory.createWhiteSpace(replace.getProject()), replace);
            }
        }
    }

    public List<PsiElement> move(List<PhpClassMember> members) {
        PhpClassReferenceResolver referenceResolver = new PhpClassReferenceResolver();
        referenceResolver.processElements(members);
        boolean hasAbstractMembers = false;
        ArrayList<PsiElement> movedMembers = new ArrayList<PsiElement>();
        for (PhpClassMember member : members) {
            if (member instanceof Method) {
                movedMembers.add((PsiElement)this.moveMethod((Method)member, members));
                hasAbstractMembers = hasAbstractMembers || ((Method)member).isAbstract();
                continue;
            }
            movedMembers.add(this.moveField((Field)member));
        }
        if (hasAbstractMembers && !this.myTargetClass.isAbstract()) {
            PsiElement abstractClass = PhpPsiElementFactory.createFromText(this.myTargetClass.getProject(), PhpTokenTypes.kwABSTRACT, "abstract class A {}");
            PsiElement child = this.myTargetClass.getFirstChild();
            if (child != null) {
                this.myTargetClass.addBefore(abstractClass, child);
            }
        }
        PhpPsiElement scopeHolder = PhpMoveClassMemberBase.getScopeHolder(this.myTargetClass);
        referenceResolver.importReferences(scopeHolder, movedMembers);
        return movedMembers;
    }

    @NotNull
    public List<PsiElement> cutAndMove(@NotNull List<PhpClassMember> members, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(6);
        }
        List<PsiElement> movedMembers = this.move(members);
        PhpMoveClassMemberBase.removeMembers(members, shouldRemoveMethods);
        List<PsiElement> list = movedMembers;
        if (list == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static PhpPsiElement getScopeHolder(@NotNull PhpClass targetClass) {
        if (targetClass == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(8);
        }
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)targetClass);
        assert (scopeHolder != null);
        PhpPsiElement phpPsiElement = scopeHolder;
        if (phpPsiElement == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(9);
        }
        return phpPsiElement;
    }

    @NotNull
    protected abstract Method moveMethod(@NotNull Method var1, List<PhpClassMember> var2);

    @NotNull
    private PsiElement moveField(@NotNull Field field) {
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(10);
        }
        return PhpMoveClassMemberBase.addField(this.myTargetClass, this.myShouldWeakAccess, field);
    }

    protected void updateMethodAccess(@NotNull Method method, @NotNull String currentAccess, @NotNull String destinationAccess) {
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(11);
        }
        if (currentAccess == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(12);
        }
        if (destinationAccess == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(13);
        }
        String methodCode = method.getText().replaceFirst(currentAccess, destinationAccess);
        Method newMethod = PhpPsiElementFactory.createMethod(method.getProject(), methodCode);
        method.replace((PsiElement)newMethod);
    }

    @NotNull
    private static <T extends Function> Method addMethodUp(@NotNull PhpClass clazz, @NotNull T method, @NotNull String methodCode, @Nullable String currentAccess, @NotNull String destinationAccess) {
        if (clazz == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(14);
        }
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(15);
        }
        if (methodCode == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(16);
        }
        if (destinationAccess == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(17);
        }
        if (!(method instanceof PhpDocMethod)) {
            if (currentAccess != null) {
                methodCode = methodCode.replaceFirst(currentAccess, destinationAccess);
            }
            return PhpMoveClassMemberBase.addMethodWithPhpDoc(clazz, method, methodCode);
        }
        PhpCodeEditUtil.insertDocMethodBeforeClass(clazz, method.getParent());
        PhpDocMethod phpDocMethod = (PhpDocMethod)method;
        if (phpDocMethod == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(18);
        }
        return phpDocMethod;
    }

    @NotNull
    private static PsiElement addField(@NotNull PhpClass clazz, boolean moveUp, @NotNull Field field) {
        if (clazz == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(19);
        }
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(20);
        }
        PsiElement fieldList = PhpMoveClassMemberBase.getFieldListElement(field);
        assert (fieldList != null);
        PhpPsiElement newField = PhpMoveClassMemberBase.constructField(field, moveUp);
        PhpDocComment comment = PhpMoveClassMemberBase.isSingleFieldList(fieldList) ? field.getDocComment() : null;
        PsiElement insertedField = PhpCodeEditUtil.insertClassMemberWithPhpDoc(clazz, (PsiElement)newField, comment);
        assert (insertedField != null);
        PsiElement psiElement = insertedField;
        if (psiElement == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    @NotNull
    public static PhpPsiElement constructField(@NotNull Field field, boolean moveUp) {
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(22);
        }
        Project project = field.getProject();
        PhpModifier modifier = field.getModifier();
        PhpModifier.Access access = modifier.isPrivate() && moveUp ? PhpModifier.Access.PROTECTED : modifier.getAccess();
        String defaultValueText = PhpChangeVisibilityIntentionBase.getDefaultValueText(field);
        if (field.isConstant()) {
            PhpPsiElement phpPsiElement = PhpPsiElementFactory.createClassConstant(project, (PhpModifier.Access)(PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY.isSupported(project) ? access : null), field.getName(), StringUtil.notNullize((String)defaultValueText));
            if (phpPsiElement == null) {
                PhpMoveClassMemberBase.$$$reportNull$$$0(23);
            }
            return phpPsiElement;
        }
        PhpPsiElement phpPsiElement = PhpPsiElementFactory.createClassField(project, PhpModifier.instance((PhpModifier.Access)access, (PhpModifier.Abstractness)modifier.getAbstractness(), (PhpModifier.State)modifier.getState()), field.getName(), defaultValueText, PhpMoveClassMemberBase.getFieldTypeText(field));
        if (phpPsiElement == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(24);
        }
        return phpPsiElement;
    }

    @Nullable
    private static String getFieldTypeText(@NotNull Field field) {
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(25);
        }
        PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)field, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
        return typeDeclaration == null ? null : typeDeclaration.getText();
    }

    @Nullable
    public static PsiElement getFieldListElement(@NotNull Field field) {
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(26);
        }
        return PhpPsiUtil.getParentByCondition((PsiElement)field, false, FIELD_LIST_CONDITION);
    }

    public static boolean isSingleFieldList(@NotNull PsiElement fieldList) {
        List childFields;
        if (fieldList == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(27);
        }
        return (childFields = PhpPsiUtil.getChildren(fieldList, (Condition<? super PsiElement>)Field.INSTANCEOF)).size() <= 1;
    }

    @NotNull
    private static Method addMethodWithPhpDoc(@NotNull PhpClass clazz, @NotNull Function method, @NotNull String methodCode) {
        if (clazz == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(28);
        }
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(29);
        }
        if (methodCode == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(30);
        }
        Method newMethod = PhpPsiElementFactory.createMethod(clazz.getProject(), methodCode);
        PsiElement insertedMethod = PhpCodeEditUtil.insertClassMemberWithPhpDoc(clazz, (PsiElement)newMethod, method.getDocComment());
        assert (insertedMethod instanceof Method);
        Method method2 = (Method)insertedMethod;
        if (method2 == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(31);
        }
        return method2;
    }

    public static <T extends Function> T resolvePhpDoc(final T method) {
        PhpDocComment doc = method.getDocComment();
        if (doc != null) {
            doc.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

                public void visitPhpDocType(PhpDocType type) {
                    PhpMoveClassMemberBase.resolveReferencesInDoc(type, method);
                }
            });
        }
        return method;
    }

    protected static <T extends Function> T refactorInternalReferences(final @NotNull T method, final @Nullable PhpClass fromClass, final PhpClass targetClass, final List<PhpClassMember> members) {
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(32);
        }
        method.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFieldReference(@NotNull FieldReference fieldReference) {
                if (fieldReference == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.refactorInternalReference((MemberReference)fieldReference);
            }

            public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                this.refactorInternalReference((MemberReference)constantReference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.refactorInternalReference((MemberReference)reference);
                super.visitPhpMethodReference(reference);
            }

            public void visitPhpClassReference(ClassReference classReference) {
                this.refactorInternalClassReference(classReference);
            }

            public void visitPhpDocType(PhpDocType type) {
                PhpMoveClassMemberBase.resolveReferencesInDoc(type, method);
            }

            private void refactorInternalClassReference(@NotNull ClassReference reference) {
                if (reference == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!(reference.getParent() instanceof MemberReference)) {
                    String newName;
                    PhpClass resolvedClass;
                    PsiElement element = reference.resolve();
                    String classReferenceName = reference.getName();
                    if (element != null && (resolvedClass = (PhpClass)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null && !(newName = resolvedClass.getName()).isEmpty() && classReferenceName != null && (classReferenceName.equalsIgnoreCase("parent") || classReferenceName.equalsIgnoreCase("self"))) {
                        reference.getElement().replace((PsiElement)PhpPsiElementFactory.createClassReference(reference.getProject(), newName));
                    }
                }
            }

            private void refactorInternalReference(@NotNull MemberReference reference) {
                if (reference == null) {
                    2.$$$reportNull$$$0(2);
                }
                PhpExpression classRefExpression = reference.getClassReference();
                PsiElement resolvedMember = reference.resolve();
                if (classRefExpression != null) {
                    PhpClass refClass;
                    PsiElement lastChild = reference.getLastChild();
                    PsiElement psiElement = resolvedMember = fromClass != null ? PhpMoveClassMemberBase.refactorClassKeyword(reference, resolvedMember, lastChild, fromClass) : resolvedMember;
                    if (resolvedMember != null && (refClass = (PhpClass)PhpPsiUtil.getParentByCondition(resolvedMember, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null) {
                        String name = classRefExpression.getName();
                        if (refClass.getManager().areElementsEquivalent((PsiElement)refClass, (PsiElement)targetClass)) {
                            name = "self";
                        }
                        if (name != null && PhpMoveClassMemberBase.shouldBeReplacedByClassName(refClass, name, fromClass) && !name.equalsIgnoreCase("static") && !resolvedMember.getManager().areElementsEquivalent(resolvedMember, (PsiElement)method)) {
                            if (resolvedMember instanceof PhpClassMember) {
                                if (((PhpClassMember)resolvedMember).getModifier().isStatic()) {
                                    PsiElement firstChild = classRefExpression.getFirstChild();
                                    String newName = members.contains(resolvedMember) && name.equalsIgnoreCase("self") ? "self" : refClass.getName();
                                    firstChild.replace(PhpPsiElementFactory.createFromText(reference.getProject(), PhpTokenTypes.IDENTIFIER, newName));
                                }
                            } else {
                                PsiElement firstChild = classRefExpression.getFirstChild();
                                firstChild.replace(PhpPsiElementFactory.createFromText(reference.getProject(), PhpTokenTypes.IDENTIFIER, refClass.getName()));
                            }
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fieldReference";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPhpFieldReference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "refactorInternalClassReference";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "refactorInternalReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return method;
    }

    private static PsiElement refactorClassKeyword(MemberReference reference, PsiElement resolvedMember, PsiElement lastChild, PhpClass fromClass) {
        if (resolvedMember == null && PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.kwCLASS)) {
            PsiElement firstChild = reference.getFirstChild();
            String firstChildText = firstChild.getText();
            if (firstChildText.equalsIgnoreCase("self")) {
                resolvedMember = fromClass;
            }
            if (firstChildText.equalsIgnoreCase("$this")) {
                resolvedMember = fromClass;
            }
            if (firstChildText.equalsIgnoreCase("parent")) {
                resolvedMember = fromClass.getSuperClass();
            }
        }
        return resolvedMember;
    }

    public static boolean shouldBeReplacedByClassName(@Nullable PhpClass refClass, String name, @Nullable PhpClass fromClass) {
        if (fromClass == null) {
            return false;
        }
        if (refClass != null) {
            return PhpLangUtil.isClassNameSpecial(name) || refClass.getManager().areElementsEquivalent((PsiElement)refClass, (PsiElement)fromClass) || PhpClassHierarchyUtils.isSuperClass((PhpClass)refClass, (PhpClass)fromClass, (boolean)true);
        }
        return true;
    }

    private static void resolveReferencesInDoc(PhpDocType type, Function method) {
        PhpClass fromClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)method, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        if (fromClass != null) {
            PhpDocType element;
            PhpClass parentClass = fromClass.getSuperClass();
            String fromClassName = fromClass.getName();
            String parentClassName = null;
            if (parentClass != null) {
                parentClassName = parentClass.getName();
            }
            Object object = element = type.getText().equalsIgnoreCase("$this") ? type : PhpPsiUtil.getChildOfType((PsiElement)type, PhpDocTokenTypes.DOC_IDENTIFIER);
            if (element != null) {
                if (element.getText().equalsIgnoreCase("self")) {
                    element.replace(PhpPsiElementFactory.createFromText(type.getProject(), PhpDocTokenTypes.DOC_IDENTIFIER, "/** " + fromClassName + "*/"));
                }
                if (element.getText().equalsIgnoreCase("parent") && parentClassName != null) {
                    element.replace(PhpPsiElementFactory.createFromText(type.getProject(), PhpDocTokenTypes.DOC_IDENTIFIER, "/** " + parentClassName + "*/"));
                }
                if (element.getText().equalsIgnoreCase("$this")) {
                    element.replace(PhpPsiElementFactory.createFromText(type.getProject(), PhpDocTokenTypes.DOC_IDENTIFIER, "/** " + fromClassName + "*/"));
                }
            }
        }
    }

    public static <T extends Function> T resolveAliasesInParameters(@NotNull T method, PhpClass targetClass) {
        Parameter[] parameters;
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(33);
        }
        for (Parameter it : parameters = method.getParameters()) {
            PhpClass phpClass;
            PsiReference reference;
            ClassReference firstChild;
            PsiElement typeDeclaration = it.getFirstChild();
            if (!(typeDeclaration instanceof PhpTypeDeclaration) || (firstChild = (ClassReference)ContainerUtil.getFirstItem((Collection)((PhpTypeDeclaration)typeDeclaration).getClassReferences())) == null || (reference = firstChild.getReference()) == null || (phpClass = (PhpClass)reference.resolve()) == null) continue;
            String name = phpClass.getName();
            if (!phpClass.getNamespaceName().equals(targetClass.getNamespaceName())) continue;
            firstChild.replace((PsiElement)PhpPsiElementFactory.createClassReference(method.getProject(), name));
        }
        return method;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase";
                break;
            }
            case 10: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 11: 
            case 15: 
            case 29: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentAccess";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationAccess";
                break;
            }
            case 14: 
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 16: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCode";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "move";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "cutAndMove";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeHolder";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addMethodUp";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "addField";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "constructField";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "addMethodWithPhpDoc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeMembers";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 31: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cutAndMove";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getScopeHolder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveField";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateMethodAccess";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addMethodUp";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addField";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "constructField";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFieldTypeText";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFieldListElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isSingleFieldList";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addMethodWithPhpDoc";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "refactorInternalReferences";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "resolveAliasesInParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpMoveClassMemberToInterface
    extends PhpMoveClassMemberBase {
        private static final String DESTINATION_ACCESS = "public";

        PhpMoveClassMemberToInterface(PhpClass clazz, boolean shouldWeakAccess) {
            super(clazz, shouldWeakAccess);
        }

        @Override
        @NotNull
        protected Method moveMethod(@NotNull Method method, List<PhpClassMember> members) {
            if (method == null) {
                PhpMoveClassMemberToInterface.$$$reportNull$$$0(0);
            }
            String methodCode = PhpFunctionCodeGenerator.DECLARATION.generate((Function)method) + ";";
            PhpModifier.Access access = method.getAccess();
            String currentAccess = !this.myShouldWeakAccess || access.isPublic() ? null : StringUtil.toLowerCase((String)access.toString());
            Method declaration = PhpMoveClassMemberBase.addMethodUp(this.myTargetClass, method, methodCode, currentAccess, DESTINATION_ACCESS);
            if (currentAccess != null) {
                this.updateMethodAccess(method, currentAccess, DESTINATION_ACCESS);
            }
            Method method2 = declaration;
            if (method2 == null) {
                PhpMoveClassMemberToInterface.$$$reportNull$$$0(1);
            }
            return method2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMemberToInterface";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMemberToInterface";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moveMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "moveMethod";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class PhpMoveClassMember
    extends PhpMoveClassMemberBase {
        private PhpMoveClassMember(PhpClass targetClass, boolean shouldWeakAccess) {
            super(targetClass, shouldWeakAccess);
        }

        @Override
        @NotNull
        protected Method moveMethod(@NotNull Method method, List<PhpClassMember> members) {
            if (method == null) {
                PhpMoveClassMember.$$$reportNull$$$0(0);
            }
            PhpModifier.Access access = method.getAccess();
            String currentAccess = this.myShouldWeakAccess && access.isPrivate() ? StringUtil.toLowerCase((String)access.toString()) : null;
            PhpClass fromClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)method, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            PhpClass targetClass = this.myTargetClass;
            return PhpMoveClassMember.copyAsMethodToTargetClass((Function)method, currentAccess, fromClass, targetClass, members);
        }

        @NotNull
        public static Method copyAsMethodToTargetClass(@NotNull Function function, @Nullable String currentAccess, @Nullable PhpClass fromClass, PhpClass targetClass, List<PhpClassMember> members) {
            if (function == null) {
                PhpMoveClassMember.$$$reportNull$$$0(1);
            }
            function = PhpMoveClassMember.resolveAliasesInParameters(function, targetClass);
            function = PhpMoveClassMember.resolvePhpDoc(function);
            function = PhpMoveClassMember.refactorInternalReferences(function, fromClass, targetClass, members);
            Method method = PhpMoveClassMemberBase.addMethodUp(targetClass, function, function.getText(), currentAccess, "protected");
            if (method == null) {
                PhpMoveClassMember.$$$reportNull$$$0(2);
            }
            return method;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMember";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMember";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyAsMethodToTargetClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "moveMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "copyAsMethodToTargetClass";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

