/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.refactoring.PhpFunctionTemplate;
import com.jetbrains.php.refactoring.PhpParameterTemplate;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpFunctionCodeGenerator {
    public static final PhpFunctionCodeGenerator PREVIEW = new PhpFunctionPreviewGenerator("\n   ", "\n", "\n   ");
    public static final PhpFunctionCodeGenerator DECLARATION = new PhpFunctionDeclarationGenerator();
    public static final PhpFunctionCodeGenerator CALL = new PhpFunctionCallGenerator();
    private final String myStartBoundedSeparator;
    private final String myEndBoundedSeparator;
    private final String myParameterSeparator;

    private PhpFunctionCodeGenerator(@NotNull String startBoundedSeparator, @NotNull String endBoundedSeparator, @NotNull String parameterSeparator) {
        if (startBoundedSeparator == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(0);
        }
        if (endBoundedSeparator == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(1);
        }
        if (parameterSeparator == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(2);
        }
        this.myStartBoundedSeparator = startBoundedSeparator;
        this.myEndBoundedSeparator = endBoundedSeparator;
        this.myParameterSeparator = parameterSeparator;
    }

    private PhpFunctionCodeGenerator() {
        this.myStartBoundedSeparator = "";
        this.myEndBoundedSeparator = "";
        this.myParameterSeparator = "";
    }

    public String generate(final @NotNull String name, final @NotNull List<? extends PhpParameterTemplate> parameters, final @NotNull String returnType, final boolean useTrailingCommaInParametersList) {
        if (name == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(4);
        }
        if (returnType == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(5);
        }
        PhpFunctionTemplate template = new PhpFunctionTemplate(){

            @Override
            @NotNull
            public String getName() {
                String string = name;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public List getParameters() {
                List list = parameters;
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            public PhpModifier.Access getVisibility() {
                return null;
            }

            @Override
            public boolean isDeclareStatic() {
                return false;
            }

            @Override
            public boolean useTrailingCommaInParametersList() {
                return useTrailingCommaInParametersList;
            }

            @Override
            @NotNull
            public String getFunctionBody() {
                return "";
            }

            @Override
            @NotNull
            public String getReturnType() {
                String string = returnType;
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParameters";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReturnType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        return this.generate(template);
    }

    public String generate(@NotNull Function function, @Nullable String returnTypeText) {
        if (function == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(6);
        }
        StringBuilder builder = new StringBuilder();
        this.appendFunctionPrefix(builder, function);
        builder.append(function.getName());
        builder.append("(");
        this.generateParameterList(builder, function);
        builder.append(")");
        this.appendReturnTypePart(builder, returnTypeText);
        return builder.toString();
    }

    @NlsSafe
    public String generate(@NotNull Function function) {
        PhpTypeDeclaration returnType;
        if (function == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(7);
        }
        if ((returnType = function.getTypeDeclaration()) != null) {
            return this.generate(function, returnType.getText());
        }
        return this.generate(function, null);
    }

    public String generate(@NotNull PhpFunctionTemplate template) {
        if (template == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(8);
        }
        StringBuilder builder = new StringBuilder();
        this.appendFunctionPrefix(builder, template);
        builder.append(template.getName());
        builder.append("(");
        this.generateParameterList(builder, template);
        builder.append(")");
        this.appendReturnTypePart(builder, template.getReturnType());
        this.appendFunctionBody(builder, template);
        return builder.toString();
    }

    protected void appendReturnTypePart(StringBuilder builder, String returnTypeText) {
        if (StringUtil.isNotEmpty((String)returnTypeText)) {
            builder.append(": ").append(returnTypeText);
        }
    }

    private void generateParameterList(@NotNull StringBuilder builder, @NotNull Function function) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(9);
        }
        if (function == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(10);
        }
        Parameter[] parameters = this.getParameters(function);
        builder.append(this.myStartBoundedSeparator);
        int size = parameters.length;
        for (int i = 0; i < size; ++i) {
            Parameter parameter = parameters[i];
            if (i > 0) {
                builder.append(",");
                builder.append(this.myParameterSeparator);
            }
            this.appendParameter(builder, parameter);
        }
        if (parameters.length > 0 && PhpFunctionCodeGenerator.useTrailingCommaInParametersList(function)) {
            builder.append(",");
        }
        builder.append(this.myEndBoundedSeparator);
    }

    @NotNull
    protected Parameter[] getParameters(@NotNull Function function) {
        if (function == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(11);
        }
        Parameter[] parameterArray = function.getParameters();
        if (parameterArray == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(12);
        }
        return parameterArray;
    }

    private void generateParameterList(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate<? extends PhpParameterTemplate> template) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(13);
        }
        if (template == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(14);
        }
        List<? extends PhpParameterTemplate> parameters = template.getParameters();
        builder.append(this.myStartBoundedSeparator);
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            PhpParameterTemplate parameter = parameters.get(i);
            if (i > 0) {
                builder.append(",");
                builder.append(this.myParameterSeparator);
            }
            this.appendParameter(builder, parameter);
        }
        if (!parameters.isEmpty() && template.useTrailingCommaInParametersList()) {
            builder.append(",");
        }
        builder.append(this.myEndBoundedSeparator);
    }

    public static String generateParameter(@NotNull PhpParameterTemplate parameter) {
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(15);
        }
        StringBuilder builder = new StringBuilder();
        PhpFunctionCodeGenerator.appendParameter(builder, parameter, parameter.getName());
        return builder.toString();
    }

    public static String generateParameter(@NotNull PhpParameterTemplate parameter, @NotNull CharSequence newName) {
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(16);
        }
        if (newName == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(17);
        }
        StringBuilder builder = new StringBuilder();
        PhpFunctionCodeGenerator.appendParameter(builder, parameter, newName);
        return builder.toString();
    }

    private static void appendParameter(@NotNull StringBuilder builder, @NotNull PhpParameterTemplate parameter, @NotNull CharSequence name) {
        CharSequence type;
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(18);
        }
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(19);
        }
        if (name == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(20);
        }
        if (!StringUtil.isEmpty((CharSequence)(type = parameter.getTypeText()))) {
            builder.append(type);
            builder.append(" ");
        }
        builder.append(PhpFunctionCodeGenerator.getParameterNameWithInitializer(parameter, name));
    }

    public static String getParameterNameWithInitializer(@NotNull PhpParameterTemplate parameter, @NotNull CharSequence name) {
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(21);
        }
        if (name == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(22);
        }
        StringBuilder builder = new StringBuilder();
        if (parameter.isPassByRef()) {
            builder.append("&");
        }
        if (parameter.isVariadic()) {
            builder.append("...");
        }
        PhpFunctionCodeGenerator.appendParameterName(builder, name);
        CharSequence initializer = parameter.getInitializer();
        if (!StringUtil.isEmpty((CharSequence)initializer)) {
            builder.append(" = ");
            builder.append(initializer);
        }
        return builder.toString();
    }

    private static void appendParameterName(@NotNull StringBuilder builder, @NotNull CharSequence name) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(23);
        }
        if (name == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(24);
        }
        builder.append("$");
        builder.append(name);
    }

    private static void appendParameterName(@NotNull StringBuilder builder, @NotNull Parameter parameter) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(25);
        }
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(26);
        }
        builder.append("$");
        builder.append(parameter.getName());
    }

    @NotNull
    public static String getInitializer(@NotNull Parameter parameter) {
        PsiElement defaultValue;
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(27);
        }
        String string = (defaultValue = parameter.getDefaultValue()) == null ? "" : defaultValue.getText();
        if (string == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(28);
        }
        return string;
    }

    protected void appendFunctionPrefix(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
        PhpModifier.Access visibility;
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(29);
        }
        if (template == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(30);
        }
        if ((visibility = template.getVisibility()) != null) {
            builder.append(StringUtil.toLowerCase((String)visibility.toString()));
            builder.append(" ");
        }
        if (template.isDeclareStatic()) {
            builder.append("static ");
        }
        builder.append("function ");
    }

    protected void appendFunctionPrefix(@NotNull StringBuilder builder, @NotNull Function function) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(31);
        }
        if (function == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(32);
        }
        if (function instanceof Method) {
            Method method = (Method)function;
            PhpModifier.Access visibility = method.getAccess();
            if (PhpFunctionCodeGenerator.shouldAddVisibility(method) && visibility != null) {
                builder.append(StringUtil.toLowerCase((String)visibility.toString()));
                builder.append(" ");
            }
            if (method.isStatic()) {
                builder.append("static ");
            }
        }
        builder.append("function ");
    }

    protected static boolean shouldAddVisibility(@NotNull Method method) {
        if (method == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(33);
        }
        if (method.getAccess().isPublic()) {
            PhpModifierList modifier = (PhpModifierList)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF);
            PsiElement accessElement = modifier == null ? null : PhpFunctionCodeGenerator.getFirstChildMatchedText((PsiElement)modifier, PhpModifier.Access.PUBLIC.toString());
            return accessElement != null;
        }
        return true;
    }

    @Nullable
    public static PsiElement getFirstChildMatchedText(@NotNull PsiElement element, @NotNull String text) {
        if (element == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(34);
        }
        if (text == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(35);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getText().equalsIgnoreCase(text)) continue;
            return child;
        }
        return null;
    }

    protected void appendParameter(@NotNull StringBuilder builder, @NotNull PhpParameterTemplate parameter) {
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(36);
        }
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(37);
        }
        PhpFunctionCodeGenerator.appendParameter(builder, parameter, parameter.getName());
    }

    protected void appendParameter(@NotNull StringBuilder builder, @NotNull Parameter parameter) {
        String type;
        if (builder == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(38);
        }
        if (parameter == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(39);
        }
        if (!StringUtil.isEmpty((CharSequence)(type = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter)))) {
            builder.append((CharSequence)type);
            builder.append(" ");
        }
        builder.append(PhpFunctionCodeGenerator.getParameterNameWithInitializer(new PhpParameterInfo(-1, parameter), parameter.getName()));
    }

    protected abstract void appendFunctionBody(@NotNull StringBuilder var1, @NotNull PhpFunctionTemplate var2);

    public static boolean useTrailingCommaInParametersList(@NotNull Function function) {
        if (function == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(40);
        }
        ParameterListImpl parameterList = (ParameterListImpl)((Object)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)((Condition)ParameterListImpl.class::isInstance)));
        return parameterList != null && PhpFunctionCodeGenerator.useTrailingCommaInParametersList(parameterList);
    }

    public static boolean useTrailingCommaInParametersList(@NotNull ParameterListImpl parameterList) {
        if (parameterList == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(41);
        }
        return PhpLanguageFeature.TRAILING_COMMA_IN_PARAMETER_LIST.isSupported(parameterList.getProject()) && parameterList.hasTrailingComma();
    }

    public static boolean useTrailingCommaInArgsList(@NotNull ParameterListImpl parameterList) {
        if (parameterList == null) {
            PhpFunctionCodeGenerator.$$$reportNull$$$0(42);
        }
        return PhpLanguageFeature.TRAILING_COMMA_IN_FUNCTION_CALL.isSupported(parameterList.getProject()) && parameterList.hasTrailingComma();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startBoundedSeparator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endBoundedSeparator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterSeparator";
                break;
            }
            case 3: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 32: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: 
            case 14: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 23: 
            case 25: 
            case 29: 
            case 31: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 26: 
            case 27: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateParameterList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 12: 
            case 28: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateParameter";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "appendParameter";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNameWithInitializer";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getInitializer";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionPrefix";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddVisibility";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildMatchedText";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "useTrailingCommaInParametersList";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "useTrailingCommaInArgsList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpFunctionImplementationGenerator
    extends PhpFunctionCodeGenerator {
        @Override
        protected void appendFunctionBody(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
            if (builder == null) {
                PhpFunctionImplementationGenerator.$$$reportNull$$$0(0);
            }
            if (template == null) {
                PhpFunctionImplementationGenerator.$$$reportNull$$$0(1);
            }
            builder.append("{\n");
            builder.append(template.getFunctionBody());
            builder.append("\n}");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "template";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator$PhpFunctionImplementationGenerator";
            objectArray[2] = "appendFunctionBody";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpFunctionDeclarationGenerator
    extends PhpFunctionCodeGenerator {
        protected PhpFunctionDeclarationGenerator() {
            super("", "", " ");
        }

        @Override
        protected void appendFunctionBody(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
            if (builder == null) {
                PhpFunctionDeclarationGenerator.$$$reportNull$$$0(0);
            }
            if (template == null) {
                PhpFunctionDeclarationGenerator.$$$reportNull$$$0(1);
            }
            builder.append(";");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "template";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator$PhpFunctionDeclarationGenerator";
            objectArray[2] = "appendFunctionBody";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpFunctionPreviewGenerator
    extends PhpFunctionCodeGenerator {
        protected PhpFunctionPreviewGenerator(@NotNull String startBoundedSeparator, @NotNull String endBoundedSeparator, @NotNull String parameterSeparator) {
            if (startBoundedSeparator == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(0);
            }
            if (endBoundedSeparator == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(1);
            }
            if (parameterSeparator == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(2);
            }
            super(startBoundedSeparator, endBoundedSeparator, parameterSeparator);
        }

        @Override
        protected void appendFunctionBody(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
            if (builder == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(3);
            }
            if (template == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(4);
            }
        }

        @Override
        protected void appendParameter(@NotNull StringBuilder builder, @NotNull PhpParameterTemplate parameter) {
            if (builder == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(5);
            }
            if (parameter == null) {
                PhpFunctionPreviewGenerator.$$$reportNull$$$0(6);
            }
            builder.append(parameter.getParameterPreviewText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startBoundedSeparator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endBoundedSeparator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterSeparator";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator$PhpFunctionPreviewGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendFunctionBody";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpFunctionCallGenerator
    extends PhpFunctionCodeGenerator {
        @Override
        protected void appendFunctionPrefix(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
            if (builder == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(0);
            }
            if (template == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(1);
            }
        }

        @Override
        protected void appendFunctionPrefix(@NotNull StringBuilder builder, @NotNull Function template) {
            if (builder == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(2);
            }
            if (template == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(3);
            }
        }

        @Override
        protected void appendFunctionBody(@NotNull StringBuilder builder, @NotNull PhpFunctionTemplate template) {
            if (builder == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(4);
            }
            if (template == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(5);
            }
            builder.append(";");
        }

        @Override
        protected void appendParameter(@NotNull StringBuilder builder, @NotNull PhpParameterTemplate parameter) {
            if (builder == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(6);
            }
            if (parameter == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(7);
            }
            PhpFunctionCodeGenerator.appendParameterName(builder, parameter.getName());
        }

        @Override
        protected void appendParameter(@NotNull StringBuilder builder, @NotNull Parameter parameter) {
            if (builder == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(8);
            }
            if (parameter == null) {
                PhpFunctionCallGenerator.$$$reportNull$$$0(9);
            }
            PhpFunctionCodeGenerator.appendParameterName(builder, parameter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/PhpFunctionCodeGenerator$PhpFunctionCallGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendFunctionPrefix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendFunctionBody";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

