/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpImportOptimizer;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAliasImporter {
    private static final Logger LOG = Logger.getInstance(PhpAliasImporter.class);

    public static void insertUseStatement(@NotNull String fqn, @NotNull PhpPsiElement scopeForUseOperator) {
        if (fqn == null) {
            PhpAliasImporter.$$$reportNull$$$0(0);
        }
        if (scopeForUseOperator == null) {
            PhpAliasImporter.$$$reportNull$$$0(1);
        }
        PhpAliasImporter.insertUseStatementWithKeyword(null, fqn, null, scopeForUseOperator);
    }

    public static void insertUseStatement(@NotNull String fqn, @Nullable String alias, @NotNull PhpPsiElement scopeForUseOperator) {
        if (fqn == null) {
            PhpAliasImporter.$$$reportNull$$$0(2);
        }
        if (scopeForUseOperator == null) {
            PhpAliasImporter.$$$reportNull$$$0(3);
        }
        PhpAliasImporter.insertUseStatementWithKeyword(null, fqn, alias, scopeForUseOperator);
    }

    public static void insertUseStatementWithKeyword(@Nullable String keyword, @NotNull String fqn, @Nullable String alias, @NotNull PhpPsiElement scopeForUseOperator) {
        List<PhpUseList> imports;
        if (fqn == null) {
            PhpAliasImporter.$$$reportNull$$$0(4);
        }
        if (scopeForUseOperator == null) {
            PhpAliasImporter.$$$reportNull$$$0(5);
        }
        if (scopeForUseOperator instanceof PhpExpressionCodeFragment) {
            return;
        }
        Project project = scopeForUseOperator.getProject();
        if (PhpAliasImporter.insertInGroupUse(project, keyword, fqn, alias, imports = PhpCodeInsightUtil.collectImports(scopeForUseOperator))) {
            return;
        }
        PhpUseList useList = PhpPsiElementFactory.createUseStatementWithKeyword(project, keyword, fqn, alias);
        PhpGroupUseElement useForInsert = PhpAliasImporter.getGroupUseElement(useList);
        assert (useForInsert != null);
        Comparator<PhpGroupUseElement> comparator = PhpImportOptimizer.getComparator(scopeForUseOperator.getContainingFile());
        for (PhpUseList anImport : imports) {
            PhpGroupUseElement declaration = PhpAliasImporter.getGroupUseElement(anImport);
            if (declaration == null || comparator.compare(useForInsert, declaration) >= 0) continue;
            anImport.getParent().addBefore((PsiElement)useList, (PsiElement)anImport);
            return;
        }
        if (imports.size() > 0) {
            PhpUseList anImport = imports.get(imports.size() - 1);
            anImport.getParent().addAfter((PsiElement)useList, (PsiElement)anImport);
            return;
        }
        GroupStatement groupStatement = (GroupStatement)PsiTreeUtil.findChildOfType((PsiElement)scopeForUseOperator, GroupStatement.class);
        LOG.assertTrue(groupStatement != null, (Object)DebugUtil.psiToString((PsiElement)scopeForUseOperator, (boolean)true));
        PhpPsiElement firstPsiChild = groupStatement.getFirstPsiChild();
        if (firstPsiChild == null) {
            PsiElement openingTag = PhpPsiUtil.getChildOfType((PsiElement)groupStatement, PhpTokenTypes.PHP_OPENING_TAG);
            new InsertPlace(openingTag, InsertPlace.InsertElementType.AFTER).insert((PsiElement)useList, (PsiElement)groupStatement);
        } else if (PhpAliasImporter.shouldInsertUseStatementInSeparatePhpBlock((PsiElement)groupStatement)) {
            GroupStatement newImportInTags = PhpPsiElementFactory.createFromText(project, GroupStatement.class, useList.getText() + "\n?>\n");
            assert (newImportInTags != null);
            groupStatement.addRangeBefore(newImportInTags.getFirstChild(), newImportInTags.getLastChild(), groupStatement.getFirstChild());
        } else {
            PhpAliasImporter.findPlaceToInsert(scopeForUseOperator, firstPsiChild).insert((PsiElement)useList, (PsiElement)groupStatement);
        }
    }

    @Nullable
    public static PhpGroupUseElement getGroupUseElement(@NotNull PhpUseList useList) {
        Object[] declarations;
        PhpUse element;
        if (useList == null) {
            PhpAliasImporter.$$$reportNull$$$0(6);
        }
        return (element = (PhpUse)ArrayUtil.getFirstElement((Object[])(declarations = useList.getDeclarations()))) != null ? new PhpGroupUseElement(PhpGroupUseElement.getKeyword(element, useList), PhpUseImpl.getReferenceText(element), element.getAliasName()) : null;
    }

    private static boolean shouldInsertUseStatementInSeparatePhpBlock(@NotNull PsiElement groupStatement) {
        if (groupStatement == null) {
            PhpAliasImporter.$$$reportNull$$$0(7);
        }
        PsiElement echoTag = PhpPsiUtil.getChildOfType(groupStatement, PhpTokenTypes.PHP_ECHO_OPENING_TAG);
        PsiElement closingTag = PhpPsiUtil.getChildOfType(groupStatement, PhpTokenTypes.PHP_CLOSING_TAG);
        return echoTag != null && (closingTag == null || echoTag.getTextOffset() < closingTag.getTextOffset());
    }

    private static boolean insertInGroupUse(@NotNull Project project, @Nullable String keyword, @NotNull String fqn, @Nullable String alias, @NotNull Collection<PhpUseList> imports) {
        if (project == null) {
            PhpAliasImporter.$$$reportNull$$$0(8);
        }
        if (fqn == null) {
            PhpAliasImporter.$$$reportNull$$$0(9);
        }
        if (imports == null) {
            PhpAliasImporter.$$$reportNull$$$0(10);
        }
        if (PhpLanguageFeature.GROUPED_USE.isSupported(project)) {
            HashMap<String, PhpUseList> fqnToGroupUse = new HashMap<String, PhpUseList>();
            for (PhpUseList phpUseList : imports) {
                PhpNamespaceReference namespaceReference = phpUseList.getNamespaceReference();
                if (namespaceReference == null || !PhpGroupUseElement.getKeyword(null, phpUseList).equals(StringUtil.notNullize((String)keyword))) continue;
                fqnToGroupUse.put(PhpLangUtil.toFQN(namespaceReference.getFullName()), phpUseList);
            }
            String parentFqn = null;
            for (String currentFqn : fqnToGroupUse.keySet()) {
                if (!fqn.startsWith(currentFqn) || currentFqn.length() <= StringUtil.length(parentFqn)) continue;
                parentFqn = currentFqn;
            }
            if (parentFqn != null) {
                PhpUseList phpUseList = (PhpUseList)fqnToGroupUse.get(parentFqn);
                ArrayList<PhpGroupUseElement> uses = new ArrayList<PhpGroupUseElement>();
                String newName = fqn.substring(parentFqn.length());
                boolean added = false;
                for (PhpUse use : phpUseList.getDeclarations()) {
                    String name = PhpUseImpl.getReferenceText(use);
                    if (!added && PhpLangUtil.compareFQN(PhpLangUtil.toFQN(name), PhpLangUtil.toFQN(newName)) > 0) {
                        added = uses.add(new PhpGroupUseElement(null, newName, alias));
                    }
                    uses.add(new PhpGroupUseElement(use));
                }
                if (!added) {
                    uses.add(new PhpGroupUseElement(null, newName, alias));
                }
                phpUseList.replace((PsiElement)PhpPsiElementFactory.createGroupUseStatementWithKeyword(project, keyword, parentFqn, uses));
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static InsertPlace findPlaceToInsert(@NotNull PhpPsiElement scopeForUseOperator, @NotNull PhpPsiElement firstChild) {
        PhpPsiElement sibling;
        PhpPsiElement anchor;
        if (scopeForUseOperator == null) {
            PhpAliasImporter.$$$reportNull$$$0(11);
        }
        if (firstChild == null) {
            PhpAliasImporter.$$$reportNull$$$0(12);
        }
        if (PhpPsiUtil.isOfType((PsiElement)(anchor = firstChild), PhpElementTypes.GLOBAL)) {
            sibling = anchor.getNextPsiSibling();
            if (sibling == null) {
                return new InsertPlace((PsiElement)anchor, InsertPlace.InsertElementType.AFTER);
            }
            anchor = sibling;
        }
        while (PhpPsiUtil.isOfType((PsiElement)anchor, PhpElementTypes.DECLARE) || PhpPsiUtil.isOfType((PsiElement)anchor, PhpElementTypes.HTML) || PhpAliasImporter.isDocInFileScope(scopeForUseOperator, anchor)) {
            sibling = anchor.getNextPsiSibling();
            if (sibling == null || PhpPsiUtil.isOfType((PsiElement)sibling, PhpElementTypes.HTML)) {
                return new InsertPlace((PsiElement)anchor, InsertPlace.InsertElementType.AFTER);
            }
            PhpEchoStatement echoStatement = (PhpEchoStatement)ObjectUtils.tryCast((Object)sibling, PhpEchoStatement.class);
            if (echoStatement != null && echoStatement.isShorthand()) {
                PsiElement lastClosingTag = PhpPsiUtil.getPrevSibling((PsiElement)anchor, e -> !PhpPsiUtil.isOfType(e, PhpTokenTypes.PHP_CLOSING_TAG));
                return new InsertPlace(lastClosingTag, InsertPlace.InsertElementType.BEFORE);
            }
            anchor = sibling;
        }
        return new InsertPlace((PsiElement)anchor, InsertPlace.InsertElementType.BEFORE);
    }

    private static boolean isDocInFileScope(@NotNull PhpPsiElement scopeForUseOperator, @NotNull PhpPsiElement anchor) {
        if (scopeForUseOperator == null) {
            PhpAliasImporter.$$$reportNull$$$0(13);
        }
        if (anchor == null) {
            PhpAliasImporter.$$$reportNull$$$0(14);
        }
        return anchor instanceof PhpDocComment && scopeForUseOperator instanceof PhpFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupStatement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstChild";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/PhpAliasImporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "insertUseStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "insertUseStatementWithKeyword";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupUseElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldInsertUseStatementInSeparatePhpBlock";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "insertInGroupUse";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findPlaceToInsert";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocInFileScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class InsertPlace {
        private final PsiElement myAnchor;
        private final InsertElementType myDirection;

        private InsertPlace(PsiElement anchor, InsertElementType direction) {
            this.myAnchor = anchor;
            this.myDirection = direction;
        }

        public PsiElement insert(@NotNull PsiElement element, @NotNull PsiElement parent) {
            if (element == null) {
                InsertPlace.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                InsertPlace.$$$reportNull$$$0(1);
            }
            if (this.myDirection == InsertElementType.BEFORE) {
                PhpDocComment comment;
                PhpDocComment phpDocComment = comment = this.myAnchor instanceof PhpNamedElement ? ((PhpNamedElement)this.myAnchor).getDocComment() : null;
                if (comment != null) {
                    return comment.getParent().addRangeBefore(element.getPrevSibling(), element, (PsiElement)comment);
                }
                return parent.addBefore(element, this.myAnchor);
            }
            return parent.addRangeAfter(element.getPrevSibling(), element, this.myAnchor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/PhpAliasImporter$InsertPlace";
            objectArray[2] = "insert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum InsertElementType {
            BEFORE,
            AFTER;

        }
    }
}

