/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.projectView;

import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.projectView.PhpFileNode;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTreeStructureProvider
implements SelectableTreeStructureProvider,
DumbAware {
    public PsiElement getTopLevelElement(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (!(containingFile instanceof PhpFile)) {
            return null;
        }
        ArrayList<PhpNamedElement> parents = new ArrayList<PhpNamedElement>();
        PhpNamedElement container = (PhpNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, PhpNamedElement.class);
        while (container != null && !(container instanceof PhpFile)) {
            parents.add(0, container);
            container = (PhpNamedElement)PsiTreeUtil.getParentOfType((PsiElement)container, PhpNamedElement.class);
        }
        for (PsiElement psiElement : parents) {
            if (psiElement instanceof PhpClass) {
                return psiElement;
            }
            if (!(psiElement instanceof Method)) continue;
            return psiElement;
        }
        if (parents.size() > 0) {
            return (PsiElement)parents.get(parents.size() - 1);
        }
        return containingFile;
    }

    @Nullable
    public Object getData(@NotNull Collection<AbstractTreeNode<?>> selected, @NotNull String dataId) {
        if (selected == null) {
            PhpTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (dataId == null) {
            PhpTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List result = JBIterable.from(selected).filter(PsiDirectoryNode.class).filterMap(AbstractTreeNode::getValue).filterMap(it -> {
                Consumer action;
                String text;
                Project project = it.getProject();
                final VirtualFile vFile = it.getVirtualFile();
                if (VfsUtilCore.isUnder((VirtualFile)vFile, PhpRuntimeLibraryRootsProvider.getLibraryRoots(project))) {
                    text = PhpBundle.message("action.configure.php.runtime.text", new Object[0]);
                    action = o -> {
                        PhpProjectConfigurable configurable = new PhpProjectConfigurable(project);
                        configurable.openPhpRuntimeTab(false, o.getName());
                        PhpUiUtil.editConfigurable(project, (Configurable)configurable);
                    };
                } else {
                    if (!PlatformUtils.isPhpStorm()) {
                        return null;
                    }
                    if (ProjectRootsUtil.isModuleContentRoot((VirtualFile)vFile, (Project)project) || ProjectRootsUtil.isSourceRoot((VirtualFile)vFile, (Project)project) || ProjectRootsUtil.isInTestSource((VirtualFile)vFile, (Project)project) || WebResourcesPathsConfiguration.getInstance((Project)project).hasResourceRootPath(vFile.getUrl())) {
                        text = PhpBundle.message("action.configure.project.directories.text", new Object[0]);
                        action = o -> ShowSettingsUtil.getInstance().showSettingsDialog(project, PhpBundle.message("directories", new Object[0]));
                    } else {
                        return null;
                    }
                }
                return new NavigatableWithText(){

                    public String getNavigateActionText(boolean focusEditor) {
                        return text;
                    }

                    public void navigate(boolean requestFocus) {
                        action.consume((Object)vFile);
                    }

                    public boolean canNavigate() {
                        return true;
                    }

                    public boolean canNavigateToSource() {
                        return false;
                    }
                };
            }).toList();
            return result.isEmpty() ? null : result.toArray(new Navigatable[0]);
        }
        return null;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        Project myProject;
        if (parent == null) {
            PhpTreeStructureProvider.$$$reportNull$$$0(2);
        }
        if (children == null) {
            PhpTreeStructureProvider.$$$reportNull$$$0(3);
        }
        if ((myProject = parent.getProject()) != null && DumbService.getInstance((Project)myProject).isDumb()) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                PhpTreeStructureProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }
        ArrayList newChildren = new ArrayList(children.size());
        for (AbstractTreeNode<?> child : children) {
            if (child instanceof PsiFileNode && ((PsiFileNode)child).getValue() instanceof PhpFile) {
                PsiFile value = (PsiFile)((PsiFileNode)child).getValue();
                if (value == null) continue;
                newChildren.add((AbstractTreeNode<?>)new PhpFileNode(parent.getProject(), value, settings));
                continue;
            }
            newChildren.add(child);
        }
        ArrayList arrayList = newChildren;
        if (arrayList == null) {
            PhpTreeStructureProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/projectView/PhpTreeStructureProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/projectView/PhpTreeStructureProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

