/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.xdebug.model2.storage;

import com.intellij.util.containers.HashSetInterner;
import com.intellij.util.containers.Interner;
import com.jetbrains.php.profiler.xdebug.model2.XCall;
import com.jetbrains.php.profiler.xdebug.model2.XCallable;
import com.jetbrains.php.profiler.xdebug.model2.storage.XLeafCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XLeafMemoryCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XLeafMultitimeCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XLeafMultitimeMemoryCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XMiddleCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XMiddleLongCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XMiddleLongMemoryCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XMiddleMemoryCall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class XModelStorage {
    public final Collection<XCall> myTreeRoots = new ArrayList<XCall>();
    public final List<XCall> myCalls = new ArrayList<XCall>();
    public final Interner<XCallable> myCallables = new HashSetInterner();
    public final Interner<XCall> myLeafCallsInterner = new HashSetInterner();
    private boolean myIsWithMemory;

    public void setWithMemory(boolean isWithMemory) {
        this.myIsWithMemory = isWithMemory;
    }

    public boolean isWithMemory() {
        return this.myIsWithMemory;
    }

    public XCallable createOrGet(XCallable callable) {
        return (XCallable)this.myCallables.intern((Object)callable);
    }

    public int store(Collection<XCall> calls) {
        this.myCalls.addAll(calls);
        return this.myCalls.size();
    }

    public int getStorageSize() {
        return this.myCalls.size();
    }

    public void addTreeRoots(Collection<XCall> treeRoots) {
        this.myTreeRoots.addAll(treeRoots);
    }

    public Collection<XCall> getTreeRoots() {
        return this.myTreeRoots;
    }

    public XCall createMiddleCall(XCallable callable, Collection<XCall> children, long myOwnTime, long myCumulativeTime) {
        if (myCumulativeTime > Integer.MAX_VALUE || myOwnTime > Integer.MAX_VALUE) {
            return new XMiddleLongCall(callable, children, myOwnTime, myCumulativeTime, this);
        }
        return new XMiddleCall(callable, children, (int)myOwnTime, (int)myCumulativeTime, this);
    }

    public XCall createMiddleMemoryCall(XCallable callable, Collection<XCall> children, long myOwnTime, long myCumulativeTime, long myOwnMemory, long myCumulativeMemory) {
        if (myCumulativeTime > Integer.MAX_VALUE || myOwnTime > Integer.MAX_VALUE) {
            return new XMiddleLongMemoryCall(callable, children, myOwnTime, myCumulativeTime, myOwnMemory, myCumulativeMemory, this);
        }
        return new XMiddleMemoryCall(callable, children, (int)myOwnTime, (int)myCumulativeTime, myOwnMemory, myCumulativeMemory, this);
    }

    public XCall createLeafCall(XCallable function, int ownTime) {
        return (XCall)this.myLeafCallsInterner.intern((Object)new XLeafCall(function, ownTime));
    }

    public XCall createLeafCall(XCallable function, int ownTime, int ownMemory) {
        return (XCall)this.myLeafCallsInterner.intern((Object)new XLeafMemoryCall(function, ownTime, ownMemory));
    }

    public XCall createLeafMultitimeCall(XCallable callable, int myCumulativeTime, int invocationCount) {
        return (XCall)this.myLeafCallsInterner.intern((Object)new XLeafMultitimeCall(callable, myCumulativeTime, invocationCount));
    }

    public XCall createLeafMultitimeCall(XCallable callable, int myCumulativeTime, int myCumulativeMemory, int invocationCount) {
        return (XCall)this.myLeafCallsInterner.intern((Object)new XLeafMultitimeMemoryCall(callable, myCumulativeTime, myCumulativeMemory, invocationCount));
    }
}

