/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.xdebug.model2;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.php.profiler.xdebug.model2.XCallable;
import com.jetbrains.php.profiler.xdebug.model2.XModel;
import com.jetbrains.php.profiler.xdebug.model2.storage.XLeafCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XModelStorage;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface XCall {
    public long getOwnTime();

    public long getCumulativeTime();

    public long getOwnMemory();

    public long getCumulativeMemory();

    public List<XCall> getChildren(XModel var1);

    public XCallable getCallable();

    default public long getInvocationCount() {
        return 1L;
    }

    public static class Builder {
        private static final Logger LOG = Logger.getInstance(Builder.class);
        XCallable myFunction;
        final Collection<XCall> myChildren = new ArrayList<XCall>();
        final Map<XLeafCall, LeafCallData> myLeafChildren = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<XLeafCall>(){

            public int computeHashCode(XLeafCall object) {
                return object.getCallable().hashCode();
            }

            public boolean equals(XLeafCall o1, XLeafCall o2) {
                return o1.getCallable().equals(o2.getCallable());
            }
        });
        long myOwnTime;
        long myCumulativeTime;
        long myOwnMemory;
        long myCumulativeMemory;

        public Builder setOwnTime(long ownTime) {
            this.myOwnTime = ownTime;
            return this;
        }

        public Builder setFunction(XCallable function) {
            this.myFunction = function;
            return this;
        }

        public Builder setCumulativeTime(long cumulativeTime) {
            this.myCumulativeTime = cumulativeTime;
            return this;
        }

        public Builder setOwnMemory(long ownMemory) {
            this.myOwnMemory = ownMemory;
            return this;
        }

        public Builder setCumulativeMemory(long cumulativeMemory) {
            this.myCumulativeMemory = cumulativeMemory;
            return this;
        }

        public Builder addChild(XCall call) {
            if (call instanceof XLeafCall) {
                LeafCallData callData = this.myLeafChildren.get(call);
                if (callData == null) {
                    this.myLeafChildren.put((XLeafCall)call, new LeafCallData((int)call.getOwnTime()));
                } else {
                    ++callData.myInvocationCount;
                    callData.myCumulativeTime = (int)((long)callData.myCumulativeTime + call.getCumulativeTime());
                }
            } else {
                this.myChildren.add(call);
            }
            return this;
        }

        public Builder addChildren(Collection<XCall> calls) {
            for (XCall it : calls) {
                this.addChild(it);
            }
            return this;
        }

        public void clear() {
            this.myCumulativeTime = 0L;
            this.myOwnTime = 0L;
            this.myFunction = null;
            this.myChildren.clear();
            this.myLeafChildren.clear();
        }

        public boolean isClear() {
            return this.myOwnTime == 0L && this.myCumulativeTime == 0L && this.myFunction == null && this.myChildren.isEmpty() && this.myLeafChildren.isEmpty();
        }

        public XCall build(XModelStorage storage) {
            XCall call;
            if (!this.myChildren.isEmpty() || !this.myLeafChildren.isEmpty()) {
                this.shrinkLeafsAndAddToChildren(storage);
                call = storage.isWithMemory() ? storage.createMiddleMemoryCall(this.myFunction, this.myChildren, this.myOwnTime, this.myCumulativeTime, this.myOwnMemory, this.myCumulativeMemory) : storage.createMiddleCall(this.myFunction, this.myChildren, this.myOwnTime, this.myCumulativeTime);
            } else {
                if (this.myOwnTime > Integer.MAX_VALUE) {
                    LOG.warn("Leaf call time overflow: " + this.myOwnTime);
                }
                if (this.myOwnMemory > Integer.MAX_VALUE) {
                    LOG.warn("Leaf call time overflow: " + this.myOwnMemory);
                }
                call = storage.isWithMemory() ? storage.createLeafCall(this.myFunction, (int)this.myOwnTime, (int)this.myOwnMemory) : storage.createLeafCall(this.myFunction, (int)this.myOwnTime);
            }
            return call;
        }

        private void shrinkLeafsAndAddToChildren(XModelStorage storage) {
            for (Map.Entry<XLeafCall, LeafCallData> it : this.myLeafChildren.entrySet()) {
                int invocationCount = it.getValue().myInvocationCount;
                if (invocationCount > 1) {
                    XCall call = storage.isWithMemory() ? storage.createLeafMultitimeCall(it.getKey().getCallable(), it.getValue().myCumulativeTime, it.getValue().myCumulativeMemory, invocationCount) : storage.createLeafMultitimeCall(it.getKey().getCallable(), it.getValue().myCumulativeTime, invocationCount);
                    this.myChildren.add(call);
                    continue;
                }
                this.myChildren.add(it.getKey());
            }
        }

        private static final class LeafCallData {
            int myInvocationCount = 1;
            int myCumulativeTime;
            int myCumulativeMemory;

            LeafCallData(int cumulativeTime) {
                this(cumulativeTime, 0);
            }

            LeafCallData(int cumulativeTime, int cumulativeMemory) {
                this.myCumulativeTime = cumulativeTime;
                this.myCumulativeMemory = cumulativeMemory;
            }
        }
    }
}

