/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.xdebug;

import com.google.common.io.CountingInputStream;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.profiler.PhpSnapshotFormatException;
import com.jetbrains.php.profiler.ProfilerUtil;
import com.jetbrains.php.profiler.xdebug.XdebugProfilerSnapshotReader;
import com.jetbrains.php.profiler.xdebug.model2.XModelBuilder;
import com.jetbrains.php.profiler.xdebug.model2.XModelBuilderInterface;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.jetbrains.annotations.NotNull;

public class XdebugAnalyzeProfilerSnapshotAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(XdebugAnalyzeProfilerSnapshotAction.class);
    public static final String UNDEFINED_NAME = "<Undefined>";
    private static final String FILE_NAME_PATTERN = "fl=";
    private static final String FUNCTION_NAME_PATTERN = "fn=";
    private static final String CALLEE_FILE_NAME_PATTERN = "cfl=";
    private static final String CALLEE_FUNCTION_NAME_PATTERN = "cfn=";
    private static final String CALLS_PATTERN = "calls=";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        assert (project != null);
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleFilesNoJarsDescriptor();
        fileChooserDescriptor.setTitle(PhpBundle.message("profiler.xdebug.file.chooser.title", new Object[0]));
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)project, null);
        XdebugAnalyzeProfilerSnapshotAction.processFiles(project, files);
    }

    public static void processFiles(final Project project, final VirtualFile[] files) {
        if (files.length == 0) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, PhpBundle.message("profiler.xdebug.task.title", new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                XModelBuilder snapshotBuilder;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (XdebugAnalyzeProfilerSnapshotAction.buildModel(indicator, snapshotBuilder = new XModelBuilder(), files, project)) {
                    return;
                }
                Object fileName = files.length == 1 ? files[0].getName() : files[0].getName() + "...";
                snapshotBuilder.onFinished();
                ProfilerUtil.openProfilerXDebugSnapshot(project, (String)fileName, snapshotBuilder.getModel());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/profiler/xdebug/XdebugAnalyzeProfilerSnapshotAction$1", "run"));
            }
        });
    }

    public static boolean buildModel(@NotNull ProgressIndicator indicator, XModelBuilder snapshotBuilder, VirtualFile[] files, Project project) {
        if (indicator == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(1);
        }
        long summarySize = 0L;
        for (VirtualFile file : files) {
            summarySize += file.getLength();
            snapshotBuilder.addVirtualFile(file);
        }
        long summaryTime = 1L;
        try {
            for (VirtualFile file : files) {
                String fileName = file.getName();
                LOG.debug("Start parsing '" + fileName + "' size: " + file.getLength() / 0x100000L);
                long beginTime = System.currentTimeMillis();
                indicator.setText(PhpBundle.message("profiler.xdebug.task.parsing", fileName));
                indicator.setIndeterminate(false);
                HashMap<Integer, String> fileNames = new HashMap<Integer, String>();
                HashMap<Integer, String> functionNames = new HashMap<Integer, String>();
                XdebugAnalyzeProfilerSnapshotAction.parse(file, snapshotBuilder, indicator, fileNames, functionNames);
                long endTime = System.currentTimeMillis();
                long time = endTime - beginTime;
                summaryTime += time;
                LOG.debug("Analyzing xdebug profiler snapshot took " + (double)time / 1000.0 + " s.");
            }
        }
        catch (PhpSnapshotFormatException e) {
            ProfilerUtil.showErrorNotification(project, PhpBundle.message("notification.title.incorrect.profiler.snapshot.format", new Object[0]), e.getMessage());
            LOG.debug((Throwable)e);
            return true;
        }
        catch (IOException e) {
            ProfilerUtil.showErrorNotification(project, PhpBundle.message("notification.title.cannot.read.snapshot", new Object[0]), e.getMessage());
            LOG.debug((Throwable)e);
            return true;
        }
        LOG.debug("summary time: " + summaryTime / 1000L + "s. summary size: " + summarySize / 0x100000L + " mb.");
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(@NotNull VirtualFile file, @NotNull XModelBuilderInterface builder, @NotNull ProgressIndicator indicator, Map<Integer, String> fileNames, Map<Integer, String> methodNames) throws PhpSnapshotFormatException, IOException {
        CountingInputStream fileDataStreamWithOffset;
        if (file == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(5);
        }
        CountingInputStream initialFileCountingInputStream = new CountingInputStream(file.getInputStream());
        try {
            CompressorInputStream decompressedStream = new CompressorStreamFactory().createCompressorInputStream((InputStream)initialFileCountingInputStream);
            fileDataStreamWithOffset = new CountingInputStream((InputStream)decompressedStream);
        }
        catch (CompressorException e) {
            fileDataStreamWithOffset = initialFileCountingInputStream;
        }
        try {
            XdebugAnalyzeProfilerSnapshotAction.parseFile(builder, new XdebugProfilerSnapshotReader(fileDataStreamWithOffset, initialFileCountingInputStream, file.getLength()), indicator, fileNames, methodNames);
        }
        finally {
            fileDataStreamWithOffset.close();
            initialFileCountingInputStream.close();
        }
    }

    public static void parseFile(@NotNull XModelBuilderInterface builder, @NotNull XdebugProfilerSnapshotReader reader, @NotNull ProgressIndicator indicator, Map<Integer, String> fileNames, Map<Integer, String> methodNames) throws PhpSnapshotFormatException, IOException {
        String line;
        if (builder == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(6);
        }
        if (reader == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(8);
        }
        if ((line = reader.nextLine()).length() == 0) {
            while (StringUtil.equals((CharSequence)reader.rawNextLine(), (CharSequence)"==== NEW PROFILING FILE ==============================================")) {
                XdebugAnalyzeProfilerSnapshotAction.parseSnapshot(builder, reader, indicator, fileNames, methodNames);
            }
        } else {
            XdebugAnalyzeProfilerSnapshotAction.parseSnapshot(builder, reader, indicator, fileNames, methodNames);
        }
    }

    private static void parseSnapshot(@NotNull XModelBuilderInterface builder, @NotNull XdebugProfilerSnapshotReader reader, @NotNull ProgressIndicator indicator, Map<Integer, String> fileNames, Map<Integer, String> methodNames) throws PhpSnapshotFormatException, IOException {
        if (builder == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(9);
        }
        if (reader == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(11);
        }
        builder.onSnapshotStarted();
        XdebugAnalyzeProfilerSnapshotAction.skipHeaders(reader);
        indicator.setFraction(reader.getFraction());
        Set<String> events = XdebugAnalyzeProfilerSnapshotAction.parseEvents(reader);
        indicator.setFraction(reader.getFraction());
        boolean withMemoryData = events.size() > 1;
        builder.getModel().myXModelStorage.setWithMemory(withMemoryData);
        while (XdebugAnalyzeProfilerSnapshotAction.parseCall(builder, reader, fileNames, methodNames, withMemoryData)) {
            indicator.checkCanceled();
            indicator.setFraction(reader.getFraction());
        }
        builder.onSnapshotFinished();
    }

    private static void skipHeaders(@NotNull XdebugProfilerSnapshotReader reader) throws IOException {
        if (reader == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(12);
        }
        while (reader.nextLine().length() != 0) {
        }
    }

    private static Set<String> parseEvents(@NotNull XdebugProfilerSnapshotReader reader) throws IOException {
        if (reader == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(13);
        }
        String eventString = reader.nextLine();
        HashSet events = ContainerUtil.newHashSet((Object[])eventString.split(" "));
        events.remove("events:");
        reader.nextLine();
        return events;
    }

    private static boolean parseCall(@NotNull XModelBuilderInterface builder, @NotNull XdebugProfilerSnapshotReader reader, Map<Integer, String> fileNames, Map<Integer, String> methodNames, boolean withMemory) throws PhpSnapshotFormatException, IOException {
        List<String> data;
        long ownTime;
        int lineNumber;
        String nextLine;
        if (builder == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(14);
        }
        if (reader == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(15);
        }
        if ((nextLine = reader.rawNextLine()) == null || nextLine.length() == 0 || nextLine.startsWith("summary:")) {
            return false;
        }
        String fileName = XdebugProfilerSnapshotReader.parseLine(nextLine, FILE_NAME_PATTERN, "incorrect file name");
        String functionName = reader.parseNextLine(FUNCTION_NAME_PATTERN, "incorrect function name");
        if (UNDEFINED_NAME.equals(fileName = XdebugAnalyzeProfilerSnapshotAction.getName(fileNames, fileName))) {
            LOG.warn("Empty file name at offset: " + reader.getOffset());
        }
        if (UNDEFINED_NAME.equals(functionName = XdebugAnalyzeProfilerSnapshotAction.getName(methodNames, functionName))) {
            LOG.warn("Empty function name at offset: " + reader.getOffset());
        }
        String parameterString = "";
        if ("{main}".equals(functionName) && (parameterString = reader.nextLine()).isEmpty()) {
            reader.nextLine();
            reader.nextLine();
        }
        long ownMemory = 0L;
        try {
            if (parameterString.isEmpty()) {
                parameterString = reader.rawNextLine();
            }
            assert (parameterString != null);
            List parameters = StringUtil.split((String)parameterString, (String)" ");
            lineNumber = Integer.parseInt((String)parameters.get(0));
            ownTime = XdebugAnalyzeProfilerSnapshotAction.parseOwnTime((String)parameters.get(1));
            if (withMemory) {
                ownMemory = XdebugAnalyzeProfilerSnapshotAction.parseOwnMemory((String)parameters.get(2));
            }
        }
        catch (Exception e) {
            throw new PhpSnapshotFormatException(e.getMessage());
        }
        if (withMemory) {
            builder.callStarted(fileName, functionName, lineNumber, ownTime, ownMemory);
        } else {
            builder.callStarted(fileName, functionName, lineNumber, ownTime);
        }
        ArrayList<Long> timeList = new ArrayList<Long>();
        ArrayList<Long> memoryList = new ArrayList<Long>();
        do {
            if ((data = XdebugAnalyzeProfilerSnapshotAction.readSubCallData(reader)) == null) continue;
            long subCallTime = XdebugAnalyzeProfilerSnapshotAction.parseOwnTime(data.get(1));
            if (subCallTime >= 0L) {
                timeList.add(subCallTime);
            }
            if (data.size() <= 2) continue;
            long subCallMemory = XdebugAnalyzeProfilerSnapshotAction.parseOwnMemory(data.get(2));
            memoryList.add(subCallMemory);
        } while (data != null);
        for (int i = timeList.size() - 1; i >= 0; --i) {
            if (withMemory) {
                builder.processSubCall((Long)timeList.get(i), (Long)memoryList.get(i));
                continue;
            }
            builder.processSubCall((Long)timeList.get(i));
        }
        builder.callFinished(withMemory);
        return true;
    }

    private static long parseOwnTime(String ownTimeText) {
        return XdebugAnalyzeProfilerSnapshotAction.parseLongData(ownTimeText);
    }

    private static long parseOwnMemory(String ownTimeText) {
        return Math.abs(XdebugAnalyzeProfilerSnapshotAction.parseLongData(ownTimeText));
    }

    private static long parseLongData(String dataText) {
        long time;
        try {
            time = Long.parseLong(dataText);
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Unable to parse own time");
            time = 0L;
        }
        return time;
    }

    @NotNull
    private static String getName(Map<Integer, String> names, String argName) {
        String[] ans = argName.split(" ");
        if (ans.length > 1) {
            String name = argName.substring(ans[0].length() + 1);
            String number = ans[0];
            if (number.startsWith("(") && number.endsWith(")")) {
                String numberString = number.substring(1, number.length() - 1);
                Integer num = Integer.parseInt(numberString);
                names.put(num, name);
                String string = name;
                if (string == null) {
                    XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(16);
                }
                return string;
            }
            String string = argName;
            if (string == null) {
                XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(17);
            }
            return string;
        }
        String name = ans[0];
        if (name.startsWith("(") && name.endsWith(")")) {
            String numberString = name.substring(1, name.length() - 1);
            Integer num = Integer.parseInt(numberString);
            String fileName = names.get(num);
            if (fileName != null) {
                String string = fileName;
                if (string == null) {
                    XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(18);
                }
                return string;
            }
            return UNDEFINED_NAME;
        }
        String string = name;
        if (string == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static List<String> readSubCallData(@NotNull XdebugProfilerSnapshotReader reader) throws PhpSnapshotFormatException, IOException {
        List parameters;
        String nextLine;
        if (reader == null) {
            XdebugAnalyzeProfilerSnapshotAction.$$$reportNull$$$0(20);
        }
        if ((nextLine = reader.nextLine()).length() == 0) {
            return null;
        }
        String calleeFunctionNameLine = XdebugProfilerSnapshotReader.tryParseLine(nextLine, CALLEE_FILE_NAME_PATTERN) == null ? nextLine : reader.nextLine();
        XdebugProfilerSnapshotReader.parseLine(calleeFunctionNameLine, CALLEE_FUNCTION_NAME_PATTERN, "incorrect callee function name");
        reader.parseNextLine(CALLS_PATTERN, "incorrect callee parameters");
        try {
            String rawNextLine = reader.rawNextLine();
            assert (rawNextLine != null);
            parameters = StringUtil.split((String)rawNextLine, (String)" ");
        }
        catch (Exception e) {
            throw new PhpSnapshotFormatException(e.getMessage() + " ");
        }
        return parameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/profiler/xdebug/XdebugAnalyzeProfilerSnapshotAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/profiler/xdebug/XdebugAnalyzeProfilerSnapshotAction";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseSnapshot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "skipHeaders";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseEvents";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseCall";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readSubCallData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

