/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.ui.xmodel;

import com.google.common.collect.ImmutableList;
import com.intellij.DynamicBundle;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.profiler.ProfilerSnapshotFileEditor;
import com.jetbrains.php.profiler.ProfilerUtil;
import com.jetbrains.php.profiler.ui.ProfilerSimpleLazyNode;
import com.jetbrains.php.profiler.ui.ProfilerTimeMeasurementComboBox;
import com.jetbrains.php.profiler.ui.ProfilerTimeMeasurementUnit;
import com.jetbrains.php.profiler.ui.ProfilerTreeNode;
import com.jetbrains.php.profiler.ui.ProfilerTreeNodeColumnInfo;
import com.jetbrains.php.profiler.ui.ProfilerTreeTableModel;
import com.jetbrains.php.profiler.ui.ProfilerTreeTableView;
import com.jetbrains.php.profiler.ui.TreeTableColumnInfo;
import com.jetbrains.php.profiler.ui.xmodel.XProfilerViewFacade;
import com.jetbrains.php.profiler.ui.xmodel.callTree.TreeTableRowSorter;
import com.jetbrains.php.profiler.ui.xmodel.presenter.ProfilerNodePresenter;
import com.jetbrains.php.profiler.xdebug.XdebugAnalyzeProfilerSnapshotAction;
import com.jetbrains.php.profiler.xdebug.model2.XCall;
import com.jetbrains.php.profiler.xdebug.model2.XCallable;
import com.jetbrains.php.profiler.xdebug.model2.XModel;
import com.jetbrains.php.ui.PhpServerComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XProfilerView
extends ProfilerSnapshotFileEditor
implements XProfilerViewFacade {
    private static final Convertor<TreePath, String> TREE_SPEED_SEARCH_CONVERTOR = new Convertor<TreePath, String>(){

        public String convert(TreePath o) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o.getLastPathComponent();
            if (node != null) {
                return (String)TABLE_SPEED_SEARCH_CONVERTOR.convert(node.getUserObject());
            }
            return "";
        }
    };
    private static final Convertor<Object, String> TABLE_SPEED_SEARCH_CONVERTOR = o -> {
        if (o instanceof XCallable) {
            return ProfilerNodePresenter.getSearchKey((XCallable)o);
        }
        if (o instanceof XCall) {
            return ProfilerNodePresenter.getSearchKey((XCall)o);
        }
        return "";
    };
    private static final Comparator<XCallable> TABLE_CALLABLE_SEARCH_KEY_COMPARATOR = (o1, o2) -> {
        String o1key = ProfilerNodePresenter.getSearchKey(o1);
        String o2key = ProfilerNodePresenter.getSearchKey(o2);
        return o1key.compareTo(o2key);
    };
    private static final String EXECUTION_STATISTICS_CONTENT = "ExecutionStatisticsContent";
    private static final String CALL_TREE_CONTENT = "CallTreeContent";
    private static final String CALLEES_TREE_CONTENT = "CalleesContent";
    private static final String CALLERS_TREE_CONTENT = "CallersContent";
    private JPanel myMainPanel;
    private JTabbedPane myGlobalViewsTabbedPane;
    private JTabbedPane myLocalViewsTabbedPane;
    private JPanel myExecutionStatisticsPanel;
    private JPanel myCallTreePanel;
    private JPanel myCalleesPanel;
    private JPanel myCallersPanel;
    private PhpServerComboBox myServerComboBox;
    private ProfilerTimeMeasurementComboBox myProfilerTimeMeasurementComboBox;
    private JButton myRefreshButton;
    private final Alarm myAlarm;
    private final EventDispatcher<CallSelectedListener> myDispatcher;
    private RunnerLayoutUi myUi;
    private ExecutionStatisticView myExecutionStatisticsView;
    private CallTreeView myCallTreeView;
    private CalleesTreeView myCalleesTreeView;
    private CallersTreeView myCallersTreeView;
    private XModel myModel;

    public XProfilerView(final @NotNull Project project, final @NotNull VirtualFile file, final @NotNull XModel model) {
        if (project == null) {
            XProfilerView.$$$reportNull$$$0(0);
        }
        if (file == null) {
            XProfilerView.$$$reportNull$$$0(1);
        }
        if (model == null) {
            XProfilerView.$$$reportNull$$$0(2);
        }
        super(project, file);
        this.$$$setupUI$$$();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myDispatcher = EventDispatcher.create(CallSelectedListener.class);
        this.create(project, model);
        this.myProfilerTimeMeasurementComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XProfilerView.this.repaintViews();
            }
        });
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Set<VirtualFile> virtualFiles = model.getVirtualFiles();
                VirtualFile[] virtualFilesArray = virtualFiles.toArray(VirtualFile.EMPTY_ARRAY);
                VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])virtualFilesArray);
                LocalFileSystem.getInstance().refreshFiles(virtualFiles, true, true, () -> {
                    FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx((Project)project);
                    EditorWindow editorWindow = fileEditorManager.getCurrentWindow();
                    editorWindow.closeFile(file);
                    XdebugAnalyzeProfilerSnapshotAction.processFiles(project, virtualFilesArray);
                });
            }
        });
        this.buildContents();
        this.buildUi();
        this.installPopups();
    }

    public void create(@NotNull Project project, @NotNull XModel model) {
        if (project == null) {
            XProfilerView.$$$reportNull$$$0(3);
        }
        if (model == null) {
            XProfilerView.$$$reportNull$$$0(4);
        }
        this.myModel = model;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("", "", "", (Disposable)this);
        this.myExecutionStatisticsView = new ExecutionStatisticView(this);
        this.myCallTreeView = new CallTreeView(this);
        this.myCalleesTreeView = new CalleesTreeView(this);
        this.myCallersTreeView = new CallersTreeView(this);
        this.myDispatcher.addListener((EventListener)this.myCalleesTreeView, (Disposable)this);
        this.myDispatcher.addListener((EventListener)this.myCallersTreeView, (Disposable)this);
        this.myExecutionStatisticsView.getSelectionModel().addListSelectionListener(new MyListSelectionListener((JTable)((Object)this.myExecutionStatisticsView)));
        this.myCallTreeView.getSelectionModel().addListSelectionListener(new MyListSelectionListener((JTable)((Object)this.myCallTreeView)));
    }

    private void repaintViews() {
        this.myExecutionStatisticsView.repaint();
        this.myCallTreeView.repaint();
        this.myCalleesTreeView.repaint();
        this.myCallersTreeView.repaint();
    }

    private void buildContents() {
        Content executionStatisticsContent = this.myUi.createContent(EXECUTION_STATISTICS_CONTENT, (JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myExecutionStatisticsView)), PhpBundle.message("execution.statistics", new Object[0]), null, null);
        executionStatisticsContent.setCloseable(false);
        executionStatisticsContent.setPinned(true);
        this.myUi.addContent(executionStatisticsContent, 0, PlaceInGrid.left, false);
        Content callTreeContent = this.myUi.createContent(CALL_TREE_CONTENT, (JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCallTreeView)), PhpBundle.message("call.tree", new Object[0]), null, null);
        callTreeContent.setCloseable(false);
        callTreeContent.setPinned(true);
        this.myUi.addContent(callTreeContent, 0, PlaceInGrid.left, false);
        Content calleesTreeContent = this.myUi.createContent(CALLEES_TREE_CONTENT, (JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCalleesTreeView)), PhpBundle.message("callees", new Object[0]), null, null);
        calleesTreeContent.setCloseable(false);
        calleesTreeContent.setPinned(true);
        this.myUi.addContent(calleesTreeContent, 0, PlaceInGrid.bottom, false);
        Content callersTreeContent = this.myUi.createContent(CALLERS_TREE_CONTENT, (JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCallersTreeView)), PhpBundle.message("callers", new Object[0]), null, null);
        callersTreeContent.setCloseable(false);
        callersTreeContent.setPinned(true);
        this.myUi.addContent(callersTreeContent, 0, PlaceInGrid.bottom, false);
    }

    private void buildUi() {
        this.myServerComboBox.reset(this.getProject());
        this.myExecutionStatisticsPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myExecutionStatisticsView)), "Center");
        this.myCallTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCallTreeView)), "Center");
        this.myCalleesPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCalleesTreeView)), "Center");
        this.myCallersPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCallersTreeView)), "Center");
    }

    private void installPopups() {
        PopupHandler.installPopupHandler((JComponent)((Object)this.myExecutionStatisticsView), (String)"ProfilerPopupActions", (String)"ExecutionStatisticsViewPopup");
        PopupHandler.installPopupHandler((JComponent)((Object)this.myCallTreeView), (String)"ProfilerPopupActions", (String)"CallTreeViewPopup");
        PopupHandler.installPopupHandler((JComponent)((Object)this.myCalleesTreeView), (String)"ProfilerPopupActions", (String)"CalleesTreeViewPopup");
        PopupHandler.installPopupHandler((JComponent)((Object)this.myCallersTreeView), (String)"ProfilerPopupActions", (String)"CallersTreeViewPopup");
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            XProfilerView.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExecutionStatisticsView;
    }

    @Override
    @NotNull
    public XModel getModel() {
        XModel xModel = this.myModel;
        if (xModel == null) {
            XProfilerView.$$$reportNull$$$0(6);
        }
        return xModel;
    }

    @Override
    public PhpServer getServer() {
        return this.myServerComboBox.getSelectedServer();
    }

    @Override
    @NotNull
    public ProfilerTimeMeasurementUnit getTimeMeasurementUnit() {
        ProfilerTimeMeasurementUnit profilerTimeMeasurementUnit = this.myProfilerTimeMeasurementComboBox.getTimeMeasurementUnit();
        if (profilerTimeMeasurementUnit == null) {
            XProfilerView.$$$reportNull$$$0(7);
        }
        return profilerTimeMeasurementUnit;
    }

    @Nullable
    public static PsiElement findElement(@NotNull XProfilerViewFacade viewFacade, @Nullable XCall call) {
        if (viewFacade == null) {
            XProfilerView.$$$reportNull$$$0(8);
        }
        if (call == null) {
            return null;
        }
        return XProfilerView.findElement(viewFacade, call.getCallable());
    }

    public static PsiElement findElement(@NotNull XProfilerViewFacade viewFacade, @Nullable XCallable call) {
        if (viewFacade == null) {
            XProfilerView.$$$reportNull$$$0(9);
        }
        if (call == null) {
            return null;
        }
        Project project = viewFacade.getProject();
        return ProfilerNodePresenter.findElement(project, ProfilerUtil.createFileLocator(viewFacade), call);
    }

    private static XCallable getSelectedCallable(JTable table) {
        int selectedRow = table.getSelectedRow();
        if (selectedRow > -1) {
            try {
                Object valueAt = table.getModel().getValueAt(table.convertRowIndexToModel(selectedRow), 0);
                if (valueAt instanceof XCallable) {
                    return (XCallable)valueAt;
                }
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static XCall getSelectedCall(@NotNull JTable table) {
        int selectedRow;
        if (table == null) {
            XProfilerView.$$$reportNull$$$0(10);
        }
        if ((selectedRow = table.getSelectedRow()) > -1) {
            try {
                Object valueAt = table.getModel().getValueAt(table.convertRowIndexToModel(selectedRow), 0);
                if (valueAt instanceof XCall) {
                    return (XCall)valueAt;
                }
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    public void onCallSelected(@NotNull XCall call) {
        if (call == null) {
            XProfilerView.$$$reportNull$$$0(11);
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> ((CallSelectedListener)this.myDispatcher.getMulticaster()).onCallSelected(call), 200, ModalityState.current());
    }

    public void onCallableSelected(@NotNull XCallable call) {
        if (call == null) {
            XProfilerView.$$$reportNull$$$0(12);
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> ((CallSelectedListener)this.myDispatcher.getMulticaster()).onCallableSelected(call), 200, ModalityState.current());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFacade";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeMeasurementUnit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedCall";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onCallSelected";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onCallableSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        ProfilerTimeMeasurementComboBox profilerTimeMeasurementComboBox;
        PhpServerComboBox phpServerComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDoubleBuffered(true);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setOrientation(0);
        jSplitPane.setResizeWeight(0.5);
        jPanel5.add((Component)jSplitPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, new Dimension(200, 200), null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        this.myGlobalViewsTabbedPane = jBTabbedPane;
        jSplitPane.setLeftComponent((Component)jBTabbedPane);
        this.myExecutionStatisticsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", XProfilerView.class).getString("profiler.view.execution.statistics.title"), null, jPanel4, null);
        this.myCallTreePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", XProfilerView.class).getString("profiler.view.call.tree.title"), null, jPanel3, null);
        JBTabbedPane jBTabbedPane2 = new JBTabbedPane();
        this.myLocalViewsTabbedPane = jBTabbedPane2;
        jSplitPane.setRightComponent((Component)jBTabbedPane2);
        this.myCalleesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jBTabbedPane2.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", XProfilerView.class).getString("profiler.view.callees.title"), null, jPanel2, null);
        this.myCallersPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jBTabbedPane2.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", XProfilerView.class).getString("profiler.view.callers.title"), null, jPanel, null);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(10, 10, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myServerComboBox = phpServerComboBox = new PhpServerComboBox();
        jPanel7.add((Component)((Object)phpServerComboBox), new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", XProfilerView.class).getString("RunConfigurationEditor.server"));
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel8, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", XProfilerView.class).getString("profiler.label.time"));
        jPanel8.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProfilerTimeMeasurementComboBox = profilerTimeMeasurementComboBox = new ProfilerTimeMeasurementComboBox();
        jPanel8.add((Component)((Object)profilerTimeMeasurementComboBox), new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel9, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRefreshButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/PhpBundle", XProfilerView.class).getString("profiler.button.refresh"));
        jPanel9.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel.setLabelFor((Component)((Object)phpServerComboBox));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private final class MyListSelectionListener
    implements ListSelectionListener {
        @NotNull
        private final JTable myTable;

        private MyListSelectionListener(JTable table) {
            if (table == null) {
                MyListSelectionListener.$$$reportNull$$$0(0);
            }
            this.myTable = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                XCallable callable;
                XCall call = XProfilerView.getSelectedCall(this.myTable);
                if (call != null) {
                    XProfilerView.this.onCallSelected(call);
                }
                if ((callable = XProfilerView.getSelectedCallable(this.myTable)) != null) {
                    XProfilerView.this.onCallableSelected(callable);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$MyListSelectionListener", "<init>"));
        }
    }

    private static final class CallerTreeNode
    extends ProfilerSimpleLazyNode<XCallable> {
        XModel myModel;

        CallerTreeNode(@Nullable XCallable callee, XModel model) {
            super(callee);
            this.myModel = model;
        }

        @Override
        protected void appendChildren(@NotNull Collection<MutableTreeNode> children) {
            if (children == null) {
                CallerTreeNode.$$$reportNull$$$0(0);
            }
            XCallable callee = this.getCallee();
            Set<XCallable> set = this.myModel.getCallers(callee);
            for (XCallable it : set) {
                children.add(new CallerTreeNode(it, this.myModel));
            }
        }

        @Nullable
        public XCallable getCallee() {
            return (XCallable)this.getObject();
        }

        @Override
        @Nullable
        public Object getUserObject() {
            return this.getCallee();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$CallerTreeNode", "appendChildren"));
        }
    }

    private static final class CalleeTreeNode
    extends ProfilerSimpleLazyNode<XCallable> {
        private final XProfilerViewFacade myFacade;

        CalleeTreeNode(@Nullable XCallable caller, XProfilerViewFacade facade) {
            super(caller);
            this.myFacade = facade;
        }

        @Override
        protected void appendChildren(@NotNull Collection<MutableTreeNode> children) {
            XCallable caller;
            if (children == null) {
                CalleeTreeNode.$$$reportNull$$$0(0);
            }
            if ((caller = this.getCaller()) != null) {
                Set<XCallable> set = this.myFacade.getModel().getCallees(caller);
                for (XCallable it : set) {
                    children.add(new CalleeTreeNode(it, this.myFacade));
                }
            }
        }

        @Nullable
        public XCallable getCaller() {
            return (XCallable)this.getObject();
        }

        @Override
        @Nullable
        public Object getUserObject() {
            return this.getCaller();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$CalleeTreeNode", "appendChildren"));
        }
    }

    private static final class CallTreeNode
    extends ProfilerSimpleLazyNode<XCall> {
        @NotNull
        private final XCall myCall;
        private final XProfilerViewFacade myFacade;

        CallTreeNode(@NotNull XCall call, XProfilerViewFacade facade) {
            if (call == null) {
                CallTreeNode.$$$reportNull$$$0(0);
            }
            super(call);
            this.myCall = call;
            this.myFacade = facade;
        }

        @Override
        protected void appendChildren(@NotNull Collection<MutableTreeNode> children) {
            if (children == null) {
                CallTreeNode.$$$reportNull$$$0(1);
            }
            for (XCall it : this.myCall.getChildren(this.myFacade.getModel())) {
                children.add(new CallTreeNode(it, this.myFacade));
            }
        }

        @NotNull
        public XCall getCall() {
            XCall xCall = this.myCall;
            if (xCall == null) {
                CallTreeNode.$$$reportNull$$$0(2);
            }
            return xCall;
        }

        @Override
        public Object getUserObject() {
            return this.myCall;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$CallTreeNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$CallTreeNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "appendChildren";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyTableCellRenderer
    extends ColoredTableCellRenderer {
        private MyTableCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (table == null) {
                MyTableCellRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof XCallable) {
                ProfilerNodePresenter.computePresentation((SimpleColoredComponent)this, (XCallable)value);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$MyTableCellRenderer", "customizeCellRenderer"));
        }
    }

    private static final class CallersTreeTableModel
    extends XProfilerTreeTableModel {
        private CallersTreeTableModel(CallerTreeNode root) {
            super((TreeNode)root, new ColumnInfo[]{new CallableTreeTableColumnInfo()});
        }
    }

    public static class CallersTreeView
    extends ProfilerTreeTableView
    implements CallSelectedListener,
    DataProvider {
        @NotNull
        final XModel myModel;
        final XProfilerViewFacade myProfilerViewFacade;

        public CallersTreeView(@NotNull XProfilerViewFacade facade) {
            if (facade == null) {
                CallersTreeView.$$$reportNull$$$0(0);
            }
            super(new CallersTreeTableModel(new CallerTreeNode(XCallable.CALLABLE_ROOT, facade.getModel())));
            this.myModel = facade.getModel();
            this.myProfilerViewFacade = facade;
            this.onModelUpdated();
            new TreeTableSpeedSearch((TreeTable)this, TREE_SPEED_SEARCH_CONVERTOR);
        }

        @Override
        public void onCallSelected(@NotNull XCall call) {
            if (call == null) {
                CallersTreeView.$$$reportNull$$$0(1);
            }
            this.onCallableSelected(call.getCallable());
        }

        @Override
        public void onCallableSelected(@NotNull XCallable callable) {
            if (callable == null) {
                CallersTreeView.$$$reportNull$$$0(2);
            }
            this.setModel(new CallersTreeTableModel(new CallerTreeNode(callable, this.myModel)));
            this.onModelUpdated();
        }

        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                CallersTreeView.$$$reportNull$$$0(3);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                XCallable callable = CallersTreeView.getSelectedCallable((JTable)((Object)this));
                return callable != null ? XProfilerView.findElement(this.myProfilerViewFacade, callable) : null;
            }
            return null;
        }

        private static XCallable getSelectedCallable(@NotNull JTable table) {
            Object valueAt;
            int selectedRow;
            if (table == null) {
                CallersTreeView.$$$reportNull$$$0(4);
            }
            if ((selectedRow = table.getSelectedRow()) > -1 && (valueAt = table.getModel().getValueAt(table.convertRowIndexToModel(selectedRow), 0)) instanceof XCallable) {
                return (XCallable)valueAt;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$CallersTreeView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCallSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCallableSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedCallable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CalleesTreeView
    extends ProfilerTreeTableView
    implements DataProvider,
    CallSelectedListener {
        @NotNull
        protected final XProfilerViewFacade myProfilerViewFacade;

        public CalleesTreeView(@NotNull XProfilerViewFacade profilerViewFacade) {
            if (profilerViewFacade == null) {
                CalleesTreeView.$$$reportNull$$$0(0);
            }
            this(new CalleesTreeTableModel(profilerViewFacade, new CalleeTreeNode(XCallable.CALLABLE_ROOT, profilerViewFacade)), profilerViewFacade);
        }

        protected CalleesTreeView(@NotNull CalleesTreeTableModel treeTableModel, @NotNull XProfilerViewFacade profilerViewFacade) {
            if (treeTableModel == null) {
                CalleesTreeView.$$$reportNull$$$0(1);
            }
            if (profilerViewFacade == null) {
                CalleesTreeView.$$$reportNull$$$0(2);
            }
            super(treeTableModel);
            this.myProfilerViewFacade = profilerViewFacade;
            this.onModelUpdated();
            new TreeTableSpeedSearch((TreeTable)this, TREE_SPEED_SEARCH_CONVERTOR);
        }

        public Object getData(@NotNull @NonNls String dataId) {
            XCall call;
            if (dataId == null) {
                CalleesTreeView.$$$reportNull$$$0(3);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && (call = XProfilerView.getSelectedCall((JTable)((Object)this))) != null) {
                return XProfilerView.findElement(this.myProfilerViewFacade, call);
            }
            return null;
        }

        @Override
        public void onCallSelected(@NotNull XCall call) {
            if (call == null) {
                CalleesTreeView.$$$reportNull$$$0(4);
            }
            this.onCallableSelected(call.getCallable());
            this.onModelUpdated();
        }

        @Override
        public void onCallableSelected(@NotNull XCallable callable) {
            if (callable == null) {
                CalleesTreeView.$$$reportNull$$$0(5);
            }
            this.setModel(new CalleesTreeTableModel(this.myProfilerViewFacade, new CalleeTreeNode(callable, this.myProfilerViewFacade)));
            this.onModelUpdated();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerViewFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeTableModel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$CalleesTreeView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCallSelected";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCallableSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SummaryTimeTreeTableColumnInfo<E>
    extends ProfilerTreeNodeColumnInfo<E> {
        @NotNull
        private final XProfilerViewFacade myProfilerViewFacade;
        private final ColoredTableCellRenderer myRenderer;
        private final Comparator<ProfilerTreeNode<E>> myComparator;
        @NotNull
        private final SummaryCumulativeTimeTableColumnInfo myColumnInfo;

        private SummaryTimeTreeTableColumnInfo(final @NotNull XProfilerViewFacade profilerViewFacade, Comparator<ProfilerTreeNode<E>> comparator) {
            if (profilerViewFacade == null) {
                SummaryTimeTreeTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.time.title", new Object[0]));
            this.myColumnInfo = new SummaryCumulativeTimeTableColumnInfo(profilerViewFacade);
            this.myProfilerViewFacade = profilerViewFacade;
            this.myComparator = comparator;
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    XCallable caller;
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof CallTreeNode) {
                        XCall call = ((CallTreeNode)value).getCall();
                        long summaryTime = myProfilerViewFacade.getModel().getCumulativeTime();
                        ProfilerUtil.renderRelation(call.getCumulativeTime(), summaryTime, profilerViewFacade.getTimeMeasurementUnit(), (SimpleColoredComponent)this);
                    } else if (value instanceof CalleeTreeNode && (caller = ((CalleeTreeNode)value).getCaller()) != null) {
                        long callerSummaryTime = myProfilerViewFacade.getModel().getCumulativeTime(caller);
                        long summaryTime = myProfilerViewFacade.getModel().getCumulativeTime();
                        ProfilerUtil.renderRelation(callerSummaryTime, summaryTime, profilerViewFacade.getTimeMeasurementUnit(), (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryTimeTreeTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public TableCellRenderer getRenderer(@NotNull ProfilerTreeNode<E> treeNode) {
            if (treeNode == null) {
                SummaryTimeTreeTableColumnInfo.$$$reportNull$$$0(1);
            }
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            return this.myColumnInfo.getWidth(table);
        }

        @Nullable
        public Comparator<ProfilerTreeNode<E>> getComparator() {
            return this.myComparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerViewFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeNode";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryTimeTreeTableColumnInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SummaryInvocationCountTreeTableColumnInfo<E>
    extends ProfilerTreeNodeColumnInfo<E> {
        @NotNull
        private final XProfilerViewFacade myProfilerViewFacade;
        private final ColoredTableCellRenderer myRenderer;
        @NotNull
        private final SummaryInvocationCountTableColumnInfo myColumnInfo;
        private final Comparator<ProfilerTreeNode<E>> myComparator;

        private SummaryInvocationCountTreeTableColumnInfo(@NotNull XProfilerViewFacade profilerViewFacade, Comparator<ProfilerTreeNode<E>> comparator) {
            if (profilerViewFacade == null) {
                SummaryInvocationCountTreeTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.invocation.count.title", new Object[0]));
            this.myProfilerViewFacade = profilerViewFacade;
            this.myColumnInfo = new SummaryInvocationCountTableColumnInfo(profilerViewFacade.getModel());
            this.myComparator = comparator;
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    long summaryInvocationCount;
                    Object call;
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof CallTreeNode) {
                        call = ((CallTreeNode)value).getCall();
                        summaryInvocationCount = myProfilerViewFacade.getModel().myXModelStatistics.getSnapshotSummaryData().getNumberOfCalls();
                        ProfilerUtil.renderRelation(call.getCallable() == XCallable.CALLABLE_ROOT ? summaryInvocationCount : call.getInvocationCount(), summaryInvocationCount, (SimpleColoredComponent)this);
                    }
                    if (value instanceof CalleeTreeNode && (call = ((CalleeTreeNode)value).getCaller()) != null) {
                        summaryInvocationCount = myProfilerViewFacade.getModel().myXModelStatistics.getSnapshotSummaryData().getNumberOfCalls();
                        ProfilerUtil.renderRelation(myProfilerViewFacade.getModel().getInvocationCount((XCallable)call), summaryInvocationCount, (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryInvocationCountTreeTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        @Nullable
        public Comparator<ProfilerTreeNode<E>> getComparator() {
            return this.myComparator;
        }

        public TableCellRenderer getRenderer(@NotNull ProfilerTreeNode<E> treeNode) {
            if (treeNode == null) {
                SummaryInvocationCountTreeTableColumnInfo.$$$reportNull$$$0(1);
            }
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            return this.myColumnInfo.getWidth(table);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerViewFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeNode";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryInvocationCountTreeTableColumnInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CallableTreeTableColumnInfo
    extends TreeTableColumnInfo<XCallable> {
        private CallableTreeTableColumnInfo() {
            super(PhpBundle.message("profiler.column.invocation.callable", new Object[0]));
        }

        @Override
        public Comparator<XCallable> getAspectComparator() {
            return TABLE_CALLABLE_SEARCH_KEY_COMPARATOR;
        }
    }

    private static final class CallTreeTableColumnInfo
    extends TreeTableColumnInfo<XCall> {
        private CallTreeTableColumnInfo() {
            super(PhpBundle.message("profiler.column.invocation.callable", new Object[0]));
        }

        @Override
        public Comparator<XCall> getAspectComparator() {
            return (e1, e2) -> TABLE_CALLABLE_SEARCH_KEY_COMPARATOR.compare(e1.getCallable(), e2.getCallable());
        }
    }

    private static final class CalleesTreeTableModel
    extends XProfilerTreeTableModel {
        private CalleesTreeTableModel(@NotNull XProfilerViewFacade profilerViewFacade, TreeNode root) {
            if (profilerViewFacade == null) {
                CalleesTreeTableModel.$$$reportNull$$$0(0);
            }
            super(root, new ColumnInfo[]{new CallableTreeTableColumnInfo(), new SummaryTimeTreeTableColumnInfo(profilerViewFacade, Comparator.comparingLong(o -> profilerViewFacade.getModel().getCumulativeTime((XCallable)o.getObject()))), new SummaryInvocationCountTreeTableColumnInfo(profilerViewFacade, Comparator.comparingLong(o -> profilerViewFacade.getModel().getInvocationCount((XCallable)o.getObject())))});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilerViewFacade", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$CalleesTreeTableModel", "<init>"));
        }
    }

    private static final class CallTreeTableModel
    extends XProfilerTreeTableModel {
        private CallTreeTableModel(@NotNull XProfilerViewFacade profilerViewFacade, TreeNode root) {
            if (profilerViewFacade == null) {
                CallTreeTableModel.$$$reportNull$$$0(0);
            }
            super(root, new ColumnInfo[]{new CallTreeTableColumnInfo(), new SummaryTimeTreeTableColumnInfo(profilerViewFacade, Comparator.comparingLong(o -> {
                XCall call = (XCall)o.getObject();
                return call != null ? call.getCumulativeTime() : Long.MIN_VALUE;
            })), new SummaryInvocationCountTreeTableColumnInfo(profilerViewFacade, Comparator.comparingLong(o -> {
                XCall call = (XCall)o.getObject();
                return call != null ? call.getInvocationCount() : Long.MIN_VALUE;
            }))});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilerViewFacade", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$CallTreeTableModel", "<init>"));
        }
    }

    public static class XProfilerTreeTableModel
    extends ProfilerTreeTableModel {
        public XProfilerTreeTableModel(@NotNull TreeNode root, ColumnInfo[] columnInfos) {
            if (root == null) {
                XProfilerTreeTableModel.$$$reportNull$$$0(0);
            }
            super(root, columnInfos);
        }

        @Nullable
        protected Comparator getComparator(int column) {
            return this.getColumnInfos()[column].getComparator();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$XProfilerTreeTableModel", "<init>"));
        }
    }

    public static class CallTreeView
    extends XProfilerTreeTableView
    implements DataProvider {
        @NotNull
        protected final XProfilerViewFacade myProfilerViewFacade;

        public CallTreeView(@NotNull XProfilerViewFacade profilerViewFacade) {
            if (profilerViewFacade == null) {
                CallTreeView.$$$reportNull$$$0(0);
            }
            this(new CallTreeTableModel(profilerViewFacade, new CallTreeNode(CallTreeView.createAllScriptsNodeWithAllTreeRoots(profilerViewFacade), profilerViewFacade)), profilerViewFacade);
        }

        private static XCall createAllScriptsNodeWithAllTreeRoots(@NotNull XProfilerViewFacade profilerViewFacade) {
            if (profilerViewFacade == null) {
                CallTreeView.$$$reportNull$$$0(1);
            }
            return new XCall.Builder().setFunction(XCallable.CALLABLE_ROOT).addChildren(profilerViewFacade.getModel().myXModelStorage.getTreeRoots()).setCumulativeTime(profilerViewFacade.getModel().getCumulativeTime()).build(profilerViewFacade.getModel().myXModelStorage);
        }

        protected CallTreeView(@NotNull CallTreeTableModel treeTableModel, @NotNull XProfilerViewFacade profilerViewFacade) {
            if (treeTableModel == null) {
                CallTreeView.$$$reportNull$$$0(2);
            }
            if (profilerViewFacade == null) {
                CallTreeView.$$$reportNull$$$0(3);
            }
            super(treeTableModel);
            this.myProfilerViewFacade = profilerViewFacade;
            this.onModelUpdated();
            new TreeTableSpeedSearch((TreeTable)this, TREE_SPEED_SEARCH_CONVERTOR);
        }

        public Object getData(@NotNull @NonNls String dataId) {
            XCall call;
            if (dataId == null) {
                CallTreeView.$$$reportNull$$$0(4);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && (call = XProfilerView.getSelectedCall((JTable)((Object)this))) != null) {
                return XProfilerView.findElement(this.myProfilerViewFacade, call);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerViewFacade";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeTableModel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$CallTreeView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAllScriptsNodeWithAllTreeRoots";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class XProfilerTreeTableView
    extends ProfilerTreeTableView {
        public XProfilerTreeTableView(@NotNull XProfilerTreeTableModel treeTableModel) {
            if (treeTableModel == null) {
                XProfilerTreeTableView.$$$reportNull$$$0(0);
            }
            super(treeTableModel);
            this.setAutoCreateRowSorter(false);
            TreeTableRowSorter rowSorter = new TreeTableRowSorter(this);
            for (int i = 0; i < this.getSortableTreeTableModel().getColumnCount(); ++i) {
                Comparator comparator = this.getSortableTreeTableModel().getComparator(i);
                if (comparator == null) continue;
                rowSorter.setComparator(i, comparator);
            }
            this.setRowSorter(rowSorter);
        }

        public XProfilerTreeTableModel getSortableTreeTableModel() {
            return (XProfilerTreeTableModel)this.getTableModel();
        }

        public void reload() {
            this.getSortableTreeTableModel().reload();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeTableModel", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$XProfilerTreeTableView", "<init>"));
        }
    }

    private static class SummaryOwnMemoryTableColumnInfo
    extends ColumnInfo<XCallable, XCallable> {
        @NotNull
        private final XModel myModel;
        @NotNull
        private final Comparator<XCallable> myComparator;
        @NotNull
        private final ColoredTableCellRenderer myRenderer;

        SummaryOwnMemoryTableColumnInfo(@NotNull XProfilerViewFacade viewFacade) {
            if (viewFacade == null) {
                SummaryOwnMemoryTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.own.memory.title", new Object[0]));
            this.myModel = viewFacade.getModel();
            this.myComparator = Comparator.comparingLong(this.myModel::getOwnMemory);
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof XCallable) {
                        ProfilerUtil.renderMemoryData(myModel.myXModelStatistics.getStatisticsMap().get((XCallable)value).getOwnMemory(), (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryOwnMemoryTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public XCallable valueOf(XCallable callable) {
            return callable;
        }

        @NotNull
        public Comparator<XCallable> getComparator() {
            Comparator<XCallable> comparator = this.myComparator;
            if (comparator == null) {
                SummaryOwnMemoryTableColumnInfo.$$$reportNull$$$0(1);
            }
            return comparator;
        }

        public TableCellRenderer getRenderer(XCallable callable) {
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            XCallable maxSummaryMemory = this.myModel.getMaxSummaryCumulativeMemory();
            SimpleColoredComponent component = (SimpleColoredComponent)this.myRenderer.getTableCellRendererComponent(table, (Object)maxSummaryMemory, false, false, 0, 0);
            return (int)component.getPreferredSize().getWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryOwnMemoryTableColumnInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryOwnMemoryTableColumnInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SummaryCumulativeMemoryTableColumnInfo
    extends ColumnInfo<XCallable, XCallable> {
        @NotNull
        private final XModel myModel;
        @NotNull
        private final Comparator<XCallable> myComparator;
        @NotNull
        private final ColoredTableCellRenderer myRenderer;

        SummaryCumulativeMemoryTableColumnInfo(@NotNull XProfilerViewFacade viewFacade) {
            if (viewFacade == null) {
                SummaryCumulativeMemoryTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.memory.title", new Object[0]));
            this.myModel = viewFacade.getModel();
            this.myComparator = Comparator.comparingLong(this.myModel::getCumulativeMemory);
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof XCallable) {
                        ProfilerUtil.renderMemoryData(myModel.myXModelStatistics.getStatisticsMap().get((XCallable)value).getCumulativeMemory(), (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryCumulativeMemoryTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public XCallable valueOf(XCallable callable) {
            return callable;
        }

        @NotNull
        public Comparator<XCallable> getComparator() {
            Comparator<XCallable> comparator = this.myComparator;
            if (comparator == null) {
                SummaryCumulativeMemoryTableColumnInfo.$$$reportNull$$$0(1);
            }
            return comparator;
        }

        public TableCellRenderer getRenderer(XCallable callable) {
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            XCallable maxSummaryCumulativeMemory = this.myModel.getMaxSummaryCumulativeMemory();
            SimpleColoredComponent component = (SimpleColoredComponent)this.myRenderer.getTableCellRendererComponent(table, (Object)maxSummaryCumulativeMemory, false, false, 0, 0);
            return (int)component.getPreferredSize().getWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryCumulativeMemoryTableColumnInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryCumulativeMemoryTableColumnInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SummaryCumulativeTimeTableColumnInfo
    extends ColumnInfo<XCallable, XCallable> {
        @NotNull
        private final XModel myModel;
        @NotNull
        private final Comparator<XCallable> myComparator;
        @NotNull
        private final ColoredTableCellRenderer myRenderer;

        SummaryCumulativeTimeTableColumnInfo(final @NotNull XProfilerViewFacade viewFacade) {
            if (viewFacade == null) {
                SummaryCumulativeTimeTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.time.title", new Object[0]));
            this.myModel = viewFacade.getModel();
            this.myComparator = (o1, o2) -> (int)Math.signum(this.myModel.getCumulativeTime((XCallable)o1) - this.myModel.getCumulativeTime((XCallable)o2));
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof XCallable) {
                        ProfilerUtil.renderRelation(myModel.myXModelStatistics.getStatisticsMap().get((XCallable)value).getCumulativeTime(), myModel.getCumulativeTime(), viewFacade.getTimeMeasurementUnit(), (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryCumulativeTimeTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public XCallable valueOf(XCallable callable) {
            return callable;
        }

        @NotNull
        public Comparator<XCallable> getComparator() {
            Comparator<XCallable> comparator = this.myComparator;
            if (comparator == null) {
                SummaryCumulativeTimeTableColumnInfo.$$$reportNull$$$0(1);
            }
            return comparator;
        }

        public TableCellRenderer getRenderer(XCallable callable) {
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            XCallable maxSummaryTime = this.myModel.getMaxSummaryCumulativeTime();
            SimpleColoredComponent component = (SimpleColoredComponent)this.myRenderer.getTableCellRendererComponent(table, (Object)maxSummaryTime, false, false, 0, 0);
            return (int)component.getPreferredSize().getWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryCumulativeTimeTableColumnInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryCumulativeTimeTableColumnInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SummaryOwnTimeTableColumnInfo
    extends ColumnInfo<XCallable, XCallable> {
        @NotNull
        private final XModel myModel;
        @NotNull
        private final ColoredTableCellRenderer myRenderer;

        SummaryOwnTimeTableColumnInfo(final @NotNull XProfilerViewFacade viewFacade) {
            XModel model;
            if (viewFacade == null) {
                SummaryOwnTimeTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.own.time.title", new Object[0]));
            this.myModel = model = viewFacade.getModel();
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof XCallable) {
                        ProfilerUtil.renderRelation(model.getOwnTime((XCallable)value), model.myXModelStatistics.getSnapshotSummaryData().getSummaryTime(), viewFacade.getTimeMeasurementUnit(), (SimpleColoredComponent)this);
                    } else if (value instanceof XCall) {
                        ProfilerUtil.renderRelation(((XCall)value).getOwnTime(), model.myXModelStatistics.getSnapshotSummaryData().getSummaryTime(), viewFacade.getTimeMeasurementUnit(), (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryOwnTimeTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public XCallable valueOf(XCallable entry) {
            return entry;
        }

        public Comparator<XCallable> getComparator() {
            return Comparator.comparingLong(o -> this.myModel.getOwnTime((XCallable)o));
        }

        public TableCellRenderer getRenderer(XCallable callable) {
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            XCallable maxSummaryOwnTime = this.myModel.getMaxOwnTime();
            SimpleColoredComponent component = (SimpleColoredComponent)this.myRenderer.getTableCellRendererComponent(table, (Object)maxSummaryOwnTime, false, false, 0, 0);
            return (int)component.getPreferredSize().getWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewFacade", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryOwnTimeTableColumnInfo", "<init>"));
        }
    }

    private static class SummaryInvocationCountTableColumnInfo
    extends ColumnInfo<XCallable, XCallable> {
        @NotNull
        private final XModel myModel;
        @NotNull
        private final ColoredTableCellRenderer myRenderer;

        SummaryInvocationCountTableColumnInfo(@NotNull XModel model) {
            if (model == null) {
                SummaryInvocationCountTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.invocation.count.title", new Object[0]));
            this.myModel = model;
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof XCallable) {
                        long time = myModel.getInvocationCount((XCallable)value);
                        ProfilerUtil.renderRelation(time, myModel.myXModelStatistics.getSnapshotSummaryData().getNumberOfCalls(), (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryInvocationCountTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public XCallable valueOf(XCallable entry) {
            return entry;
        }

        public Comparator<XCallable> getComparator() {
            return (o1, o2) -> (int)(this.myModel.getInvocationCount((XCallable)o1) - this.myModel.getInvocationCount((XCallable)o2));
        }

        public TableCellRenderer getRenderer(XCallable callable) {
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            XCallable maxSummaryInvocationCount = this.myModel.getMaxSummaryInvocationCount();
            SimpleColoredComponent component = (SimpleColoredComponent)this.myRenderer.getTableCellRendererComponent(table, (Object)maxSummaryInvocationCount, false, false, 0, 0);
            return (int)component.getPreferredSize().getWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$SummaryInvocationCountTableColumnInfo", "<init>"));
        }
    }

    private static class CallableTableColumnInfo
    extends ColumnInfo<XCallable, XCallable> {
        CallableTableColumnInfo() {
            super(PhpBundle.message("profiler.column.invocation.callable", new Object[0]));
        }

        public XCallable valueOf(XCallable entry) {
            return entry;
        }

        public Class getColumnClass() {
            return XCallable.class;
        }

        public Comparator<XCallable> getComparator() {
            return TABLE_CALLABLE_SEARCH_KEY_COMPARATOR;
        }
    }

    public static class ExecutionStatisticView
    extends TableView<XCallable>
    implements DataProvider {
        @NotNull
        final XProfilerViewFacade myProfilerViewFacade;

        public ExecutionStatisticView(@NotNull XProfilerViewFacade profilerViewFacade) {
            if (profilerViewFacade == null) {
                ExecutionStatisticView.$$$reportNull$$$0(0);
            }
            super(new ListTableModel(ExecutionStatisticView.createColumns(profilerViewFacade), new ArrayList(profilerViewFacade.getModel().myXModelStorage.myCallables.getValues()), 0));
            this.myProfilerViewFacade = profilerViewFacade;
            this.getSelectionModel().setSelectionMode(0);
            this.getRowSorter().setSortKeys((List<RowSorter.SortKey>)ImmutableList.of((Object)new RowSorter.SortKey(1, SortOrder.DESCENDING)));
            this.setDefaultRenderer(XCallable.class, (TableCellRenderer)((Object)new MyTableCellRenderer()));
            new TableViewSpeedSearch<XCallable>((TableView)this){

                @Nullable
                protected String getItemText(@NotNull XCallable element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return ProfilerNodePresenter.getSearchKey(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$ExecutionStatisticView$1", "getItemText"));
                }
            };
        }

        private static ColumnInfo @NotNull [] createColumns(@NotNull XProfilerViewFacade profilerViewFacade) {
            if (profilerViewFacade == null) {
                ExecutionStatisticView.$$$reportNull$$$0(1);
            }
            ArrayList<ColumnInfo> infos = new ArrayList<ColumnInfo>(Arrays.asList(new ColumnInfo[]{new CallableTableColumnInfo(), new SummaryCumulativeTimeTableColumnInfo(profilerViewFacade), new SummaryOwnTimeTableColumnInfo(profilerViewFacade), new SummaryInvocationCountTableColumnInfo(profilerViewFacade.getModel())}));
            if (profilerViewFacade.getModel().myXModelStorage.isWithMemory()) {
                infos.add(infos.size() - 1, new SummaryCumulativeMemoryTableColumnInfo(profilerViewFacade));
                infos.add(infos.size() - 1, new SummaryOwnMemoryTableColumnInfo(profilerViewFacade));
            }
            ColumnInfo[] columnInfoArray = infos.toArray(ColumnInfo.EMPTY_ARRAY);
            if (columnInfoArray == null) {
                ExecutionStatisticView.$$$reportNull$$$0(2);
            }
            return columnInfoArray;
        }

        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                ExecutionStatisticView.$$$reportNull$$$0(3);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return XProfilerView.findElement(this.myProfilerViewFacade, (XCallable)this.getSelectedObject());
            }
            return null;
        }

        public void updateColumnSizes() {
            JTableHeader header = this.getTableHeader();
            TableCellRenderer defaultRenderer = header == null ? null : header.getDefaultRenderer();
            ColumnInfo[] columns = this.getListTableModel().getColumnInfos();
            for (int i = 0; i < columns.length; ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                Component headerComponent = defaultRenderer == null ? null : defaultRenderer.getTableCellRendererComponent((JTable)((Object)this), column.getHeaderValue(), false, false, 0, 0);
                Dimension headerSize = headerComponent == null ? new Dimension(0, 0) : headerComponent.getPreferredSize();
                ColumnInfo columnInfo = columns[i];
                int width = columnInfo.getWidth((JTable)((Object)this));
                if (width <= -1) continue;
                int actualWidth = Math.max(width, headerSize.width) + 20;
                column.setMaxWidth(actualWidth);
                column.setPreferredWidth(actualWidth);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerViewFacade";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$ExecutionStatisticView";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/XProfilerView$ExecutionStatisticView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createColumns";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface CallSelectedListener
    extends EventListener {
        public void onCallSelected(@NotNull XCall var1);

        public void onCallableSelected(@NotNull XCallable var1);
    }
}

