/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.coverage;

import com.intellij.coverage.CoverageHelper;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.xdebug.options.XdebugConfigurationOptionsManager;
import com.jetbrains.php.debug.zend.ZendDebuggerExtension;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerConnection;
import com.jetbrains.php.debug.zend.messages.GetCodeCoverageResponse;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfiguration;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.coverage.PhpCoverageRunner;
import com.jetbrains.php.phpunit.coverage.PhpDbgCommandSettingsBuilder;
import com.jetbrains.php.phpunit.coverage.PhpUnitCoverageEngine;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.run.PhpRunConfigurationHolder;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.util.connection.ConnectionHandler;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUntCoverageProgramRunner
extends PhpCoverageRunner {
    public static final String ID = "PhpUnitCoverageRunner";
    private static final Logger LOG = Logger.getInstance(PhpUntCoverageProgramRunner.class);

    @NotNull
    public String getRunnerId() {
        return ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(1);
        }
        return executorId.equals("Coverage") && profile instanceof PhpUnitLocalRunConfiguration;
    }

    @Override
    @NotNull
    protected List<String> createCoverageArguments(@Nullable String targetCoverage) {
        ArrayList<String> coverageArguments = new ArrayList<String>();
        coverageArguments.add("--coverage-clover");
        ContainerUtil.addIfNotNull(coverageArguments, (Object)targetCoverage);
        ArrayList<String> arrayList = coverageArguments;
        if (arrayList == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    protected RunProfileState createState(@NotNull ExecutionEnvironment env, @NotNull PhpInterpreter interpreter, PhpRunConfigurationHolder runConfigurationHolder, List<String> coverageArguments, String localCoverage, String targetCoverage) throws ExecutionException {
        Project project;
        PhpUnitSettings phpUnitSettings;
        if (env == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(3);
        }
        if (interpreter == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(4);
        }
        PhpUnitLocalRunConfiguration runConfiguration = (PhpUnitLocalRunConfiguration)runConfigurationHolder.getRunConfiguration();
        PhpUnitRunConfigurationSettings settings = (PhpUnitRunConfigurationSettings)runConfigurationHolder.getSettings();
        if (!PhpUntCoverageProgramRunner.specifiedConfigurationFile(settings, phpUnitSettings = PhpUnitLocalRunConfiguration.getOrCreateOnTheFlySettings(project = env.getProject(), interpreter.getName(), interpreter.isRemote()))) {
            PhpUntCoverageProgramRunner.specifyWhiteListArg(interpreter, coverageArguments, project);
        }
        boolean phpdbg = settings.getTestRunnerSettings().getCoverageEngine() == PhpUnitCoverageEngine.CoverageEngine.PHPDBG;
        PhpCommandSettings command = PhpUntCoverageProgramRunner.createCommand(runConfiguration, settings, interpreter, Collections.emptyMap(), coverageArguments, phpdbg);
        if (!phpdbg) {
            if (settings.getTestRunnerSettings().getCoverageEngine() == PhpUnitCoverageEngine.CoverageEngine.XDEBUG) {
                command.addConfigurationOptions(XdebugConfigurationOptionsManager.getConfigurationOptionsProvider(project, interpreter).enableCoverage().createXdebugConfigurations());
            } else {
                command.addConfigurationOptions(Collections.singletonList(new PhpConfigurationOption(settings.getTestRunnerSettings().getCoverageEngine().getOption(), 1)));
            }
        }
        this.setAdditionalMapping(localCoverage, targetCoverage, command);
        return runConfiguration.checkAndGetState(env, command);
    }

    private static void specifyWhiteListArg(@NotNull PhpInterpreter interpreter, List<String> coverageArguments, Project project) {
        PhpRemoteInterpreterManager manager;
        PhpSdkAdditionalData data;
        String path;
        if (interpreter == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(5);
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        List sourceRoots = ContainerUtil.filter((Object[])projectRootManager.getContentSourceRoots(), root -> !projectRootManager.getFileIndex().isInTestSourceContent(root));
        coverageArguments.add("--whitelist");
        String string = path = sourceRoots.size() == 1 ? ((VirtualFile)sourceRoots.get(0)).getPath() : project.getBasePath();
        if (path != null && (data = interpreter.getPhpSdkAdditionalData()) instanceof RemoteSdkAdditionalData && (manager = PhpRemoteInterpreterManager.getInstance()) != null) {
            path = manager.createPathMappings(project, data).convertToRemote(path);
        }
        coverageArguments.add(path);
    }

    private static boolean specifiedConfigurationFile(PhpUnitRunConfigurationSettings settings, PhpUnitSettings phpUnitSettings) {
        return settings.getTestRunnerSettings().isUseAlternativeConfigurationFile() ? !StringUtil.isEmpty((String)settings.getTestRunnerSettings().getConfigurationFilePath()) : phpUnitSettings != null && phpUnitSettings.isUseConfigurationFile() && !StringUtil.isEmpty((String)phpUnitSettings.getConfigurationFilePath());
    }

    @NotNull
    private static PhpCommandSettings createCommand(@NotNull PhpUnitLocalRunConfiguration runConfiguration, @NotNull PhpUnitRunConfigurationSettings settings, @NotNull PhpInterpreter interpreter, @NotNull Map<String, String> envParameters, @NotNull List<String> arguments) throws ExecutionException {
        if (runConfiguration == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(7);
        }
        if (interpreter == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(8);
        }
        if (envParameters == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(9);
        }
        if (arguments == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(10);
        }
        return PhpUntCoverageProgramRunner.createCommand(runConfiguration, settings, interpreter, envParameters, arguments, false);
    }

    @NotNull
    private static PhpCommandSettings createCommand(@NotNull PhpUnitLocalRunConfiguration runConfiguration, @NotNull PhpUnitRunConfigurationSettings settings, @NotNull PhpInterpreter interpreter, @NotNull Map<String, String> envParameters, @NotNull List<String> arguments, boolean phpdbg) throws ExecutionException {
        if (runConfiguration == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(12);
        }
        if (interpreter == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(13);
        }
        if (envParameters == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(14);
        }
        if (arguments == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(15);
        }
        Project project = runConfiguration.getProject();
        PhpCommandSettings command = (phpdbg ? new PhpDbgCommandSettingsBuilder(project, interpreter) : new PhpCommandSettingsBuilder(project, interpreter)).loadDebugExtension().build();
        PhpCommandSettings phpCommandSettings = runConfiguration.fillTestArguments(interpreter, command, settings, envParameters, arguments);
        if (phpCommandSettings == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(16);
        }
        return phpCommandSettings;
    }

    @Override
    protected RunContentDescriptor doExecuteWithZendDebugger(final @NotNull ExecutionEnvironment env, @NotNull PhpRunConfigurationHolder runConfigurationHolder, @NotNull PhpInterpreter interpreter) throws ExecutionException {
        if (env == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(17);
        }
        if (runConfigurationHolder == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(18);
        }
        if (interpreter == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(19);
        }
        final PhpUnitLocalRunConfiguration runConfiguration = (PhpUnitLocalRunConfiguration)runConfigurationHolder.getRunConfiguration();
        PhpUnitRunConfigurationSettings settings = (PhpUnitRunConfigurationSettings)runConfigurationHolder.getSettings();
        ZendDebuggerExtension debugExtension = ZendDebuggerExtension.INSTANCE;
        final PhpIncomingDebugConnectionServer debugServer = debugExtension.startLocalDebugServer(env.getProject());
        final ZendDebuggerConnectionHandler handler = new ZendDebuggerConnectionHandler();
        final String sessionId = debugServer.registerSessionHandler(false, handler).getSessionId();
        try {
            Map<String, String> commandLineEnv = ZendDebuggerExtension.getCoverageEnv(env.getProject(), sessionId);
            PhpCommandSettings command = PhpUntCoverageProgramRunner.createCommand(runConfiguration, settings, interpreter, commandLineEnv, (List<String>)new SmartList());
            command.addConfigurationOptions(ZendDebuggerExtension.getCoverageConfigurationsOptions());
            ExecutionResult executionResult = runConfiguration.checkAndGetState(env, command).execute(env.getExecutor(), (ProgramRunner)this);
            if (executionResult == null) {
                throw new ExecutionException(PhpBundle.message("execution.result.is.null", new Object[0]));
            }
            final DefaultDebugProcessHandler processHandler = new DefaultDebugProcessHandler();
            if (command.isRemote()) {
                throw new ExecutionException(PhpBundle.message("validation.ssh.remote.code.coverage.support", "Zend Debugger"));
            }
            CoverageHelper.attachToProcess((RunConfigurationBase)runConfiguration, (ProcessHandler)processHandler, (RunnerSettings)env.getRunnerSettings());
            processHandler.startNotify();
            executionResult.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    debugServer.unregisterSessionHandler(sessionId);
                    ZendDebuggerConnection connection = handler.getConnection();
                    if (connection == null) {
                        String interpreterName = PhpProjectConfigurationFacade.getInstance(env.getProject()).getProjectConfiguration().getInterpreterName();
                        PhpDebugUtil.showFailsToConnectMessage(env.getProject(), interpreterName);
                    } else {
                        ZendDebuggerConnection.CodeCoverageData coverageData = connection.getCodeCoverageData();
                        if (coverageData != null) {
                            String cloverXmlReport = PhpUntCoverageProgramRunner.convertToCloverXmlReport(coverageData.getCodeCoverageResponse().getScriptCodeCoverageDataArray());
                            CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
                            String coverageFilePath = coverageEnabledConfiguration.getCoverageFilePath();
                            assert (coverageFilePath != null);
                            String coverageFileParentDirectory = PathUtil.getParentPath((String)coverageFilePath);
                            String coverageFileName = PathUtil.getFileName((String)coverageFilePath);
                            ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                                VirtualFile parentDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(coverageFileParentDirectory);
                                if (parentDir != null) {
                                    try {
                                        VfsUtil.saveText((VirtualFile)parentDir.findOrCreateChildData(PhpCoverageRunner.class, coverageFileName), (String)cloverXmlReport);
                                    }
                                    catch (IOException e) {
                                        LOG.debug((Throwable)e);
                                    }
                                }
                            }));
                        }
                    }
                    processHandler.destroyProcess();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/phpunit/coverage/PhpUntCoverageProgramRunner$1", "processTerminated"));
                }
            });
            return new RunContentBuilder(executionResult, env).showRunContent(env.getContentToReuse());
        }
        catch (ExecutionException e) {
            debugServer.unregisterSessionHandler(sessionId);
            throw e;
        }
    }

    private static String convertToCloverXmlReport(GetCodeCoverageResponse.ScriptCodeCoverageData @NotNull [] scriptCodeCoverageDataArray) {
        if (scriptCodeCoverageDataArray == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(20);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<coverage>");
        builder.append("<project>");
        for (GetCodeCoverageResponse.ScriptCodeCoverageData data : scriptCodeCoverageDataArray) {
            String filePath = data.getFilePath();
            builder.append("<file name=\"").append(filePath).append("\">");
            byte[] coveredLinesBitmask = data.getCoveredLinesBitmask();
            byte[] executableLinesBitmask = data.getExecutableLinesBitmask();
            int linesNumber = data.getLinesNumber();
            for (int i = 0; i < linesNumber; ++i) {
                if ((executableLinesBitmask[i / 8] >> i % 8 & 1) != 1) continue;
                builder.append("<line num=\"").append(i).append("\" count=\"");
                builder.append((coveredLinesBitmask[i / 8] >> i % 8 & 1) == 1 ? 1 : 0);
                builder.append("\"/>");
            }
            builder.append("</file>");
        }
        builder.append("</project>");
        builder.append("</coverage>");
        return builder.toString();
    }

    @Override
    protected PhpInterpreter getInterpreter(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            PhpUntCoverageProgramRunner.$$$reportNull$$$0(21);
        }
        return runConfiguration instanceof PhpUnitLocalRunConfiguration ? ((PhpUnitLocalRunConfiguration)runConfiguration).getInterpreter() : PhpProjectConfigurationFacade.getInstance(runConfiguration.getProject()).getInterpreter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/coverage/PhpUntCoverageProgramRunner";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 6: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envParameters";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationHolder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptCodeCoverageDataArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/coverage/PhpUntCoverageProgramRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoverageArguments";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "specifyWhiteListArg";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createCommand";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteWithZendDebugger";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertToCloverXmlReport";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ZendDebuggerConnectionHandler
    implements ConnectionHandler<ZendDebuggerConnection> {
        @Nullable
        ZendDebuggerConnection myConnection;

        private ZendDebuggerConnectionHandler() {
        }

        @Override
        public void handle(@NotNull ZendDebuggerConnection connection) {
            if (connection == null) {
                ZendDebuggerConnectionHandler.$$$reportNull$$$0(0);
            }
            this.myConnection = connection;
            connection.startDetach(true);
        }

        @Nullable
        public ZendDebuggerConnection getConnection() {
            return this.myConnection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/jetbrains/php/phpunit/coverage/PhpUntCoverageProgramRunner$ZendDebuggerConnectionHandler", "handle"));
        }
    }
}

