/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.codeGeneration;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.actions.PhpNewBaseAction;
import com.jetbrains.php.actions.statistics.PhpNewClassUsageLogger;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.codeGeneration.PhpNewTestDialog;
import com.jetbrains.php.templates.PhpCreateFileFromTemplateDataProvider;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNewTestAction
extends PhpNewBaseAction {
    public PhpNewTestAction() {
        this(PhpBundle.messagePointer("actions.new.test.class.action.name", new Object[0]), PhpBundle.messagePointer("actions.new.test.class.action.description", new Object[0]), PhpIcons.PHP_TEST_FILE);
    }

    protected PhpNewTestAction(@NotNull @NlsActions.ActionText String actionName, @NotNull @NlsActions.ActionDescription String description, @NotNull Icon icon) {
        if (actionName == null) {
            PhpNewTestAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            PhpNewTestAction.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            PhpNewTestAction.$$$reportNull$$$0(2);
        }
        super(actionName, description, icon);
    }

    protected PhpNewTestAction(@NotNull Supplier<String> actionName, @NotNull Supplier<String> description, @NotNull Icon icon) {
        if (actionName == null) {
            PhpNewTestAction.$$$reportNull$$$0(3);
        }
        if (description == null) {
            PhpNewTestAction.$$$reportNull$$$0(4);
        }
        if (icon == null) {
            PhpNewTestAction.$$$reportNull$$$0(5);
        }
        super(actionName, description, icon);
    }

    @Override
    @Nullable
    protected PhpNewTestDialog getDataProvider(@NotNull Project project, @NotNull PsiDirectory directory, @Nullable PsiFile file, @Nullable Editor editor) {
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(6);
        }
        if (directory == null) {
            PhpNewTestAction.$$$reportNull$$$0(7);
        }
        PhpNamedElement targetElement = PhpNewTestAction.getTargetElement(file, editor);
        PhpNewTestDialog dialog = new PhpNewTestDialog(project, directory, file, this.getDefaultTestCreateInfo(project), targetElement);
        if (!dialog.showAndGet()) {
            return null;
        }
        PhpNewClassUsageLogger.logNewTest(project, this, dialog, targetElement);
        return dialog;
    }

    @Nullable
    private static PhpNamedElement getTargetElement(@Nullable PsiFile file, @Nullable Editor editor) {
        PsiElement targetElement = editor != null && file != null ? TestFinderHelper.findSourceElement((PsiElement)PsiUtilCore.getElementAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset())) : null;
        return (PhpNamedElement)ObjectUtils.tryCast(targetElement, PhpNamedElement.class);
    }

    @Nullable
    protected PhpTestCreateInfo getDefaultTestCreateInfo(@NotNull Project project) {
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Override
    @Nullable
    protected PsiFile createFile(@NotNull Project project, @NotNull PhpCreateFileFromTemplateDataProvider dataProvider) {
        PsiFile createdTestClassFile;
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(9);
        }
        if (dataProvider == null) {
            PhpNewTestAction.$$$reportNull$$$0(10);
        }
        if ((createdTestClassFile = super.createFile(project, dataProvider)) != null && dataProvider instanceof PhpNewTestDialog) {
            PhpNewTestAction.addTestMethods(project, (PhpNewTestDialog)dataProvider, createdTestClassFile);
        }
        return createdTestClassFile;
    }

    @Override
    @Nullable
    protected PhpCreateFileFromTemplateDataProvider getDataProvider(@NotNull Project project, @NotNull PsiDirectory directory, @Nullable PsiFile file) {
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(11);
        }
        if (directory == null) {
            PhpNewTestAction.$$$reportNull$$$0(12);
        }
        return null;
    }

    private static void addTestMethods(@NotNull Project project, @NotNull PhpNewTestDialog dataProvider, @NotNull PsiFile file) {
        Set<PhpClassMember> members;
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(13);
        }
        if (dataProvider == null) {
            PhpNewTestAction.$$$reportNull$$$0(14);
        }
        if (file == null) {
            PhpNewTestAction.$$$reportNull$$$0(15);
        }
        if ((members = dataProvider.getSelectedClassMembers()).isEmpty()) {
            return;
        }
        PhpClass testClass = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)file, PhpClass.class);
        if (testClass == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            PhpTestCreateInfo testCreateInfo = dataProvider.getSelectedTestCreateInfo();
            for (PhpClassMember member : members) {
                Method testMethod = PhpPsiElementFactory.createMethod(project, testCreateInfo.getTestMethodText(project, dataProvider.getTargetClassFqn(), member.getName()));
                PhpCodeEditUtil.insertClassMemberWithPhpDoc(testClass, (PsiElement)testMethod, testMethod.getDocComment());
            }
        });
    }

    @Override
    protected int getOffset(@Nullable PsiFile file) {
        if (file == null) {
            return -1;
        }
        PhpClass firstClass = (PhpClass)ContainerUtil.getFirstItem(PhpPsiUtil.findAllClasses((PhpFile)file));
        if (firstClass != null) {
            Method firstMethod = (Method)ArrayUtil.getFirstElement((Object[])firstClass.getOwnMethods());
            return firstMethod != null ? firstMethod.getTextOffset() : firstClass.getTextOffset();
        }
        return 0;
    }

    @Override
    protected boolean requestFocus() {
        return true;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        PsiFile data;
        PhpClass aClass;
        if (e == null) {
            PhpNewTestAction.$$$reportNull$$$0(16);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isVisible() && (aClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)PhpNewTestAction.getTargetElement(data = this.getFile(e.getDataContext()), (Editor)e.getDataContext().getData(CommonDataKeys.EDITOR)), PhpClass.class, (boolean)false)) != null) {
            String name = aClass.getName();
            PhpTestCreateInfo defaultTestCreateInfo = this.getDefaultTestCreateInfo(aClass.getProject());
            if (defaultTestCreateInfo != null) {
                presentation.setText(defaultTestCreateInfo.getDefaultTestName(name));
            }
        }
    }

    @Override
    public boolean isDumbAware() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultTestCreateInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addTestMethods";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

