/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class PhpUnitVersion {
    private static final Logger LOG = Logger.getInstance(PhpUnitVersion.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String ALPHA = "alpha";
    private static final String BETA = "beta";
    protected final String myVersion;
    protected final HashMap<String, String> myOptionToSupportedVersion;

    public PhpUnitVersion(@NotNull String version) {
        if (version == null) {
            PhpUnitVersion.$$$reportNull$$$0(0);
        }
        this.myOptionToSupportedVersion = new HashMap<String, String>(){
            {
                this.put("--cache-result-file=", "7.3.0");
                this.put("--teamcity", "5.0.0");
            }
        };
        this.myVersion = version;
    }

    public static PhpUnitVersion create(@NotNull String fullVersion) {
        int separator;
        if (fullVersion == null) {
            PhpUnitVersion.$$$reportNull$$$0(1);
        }
        if ((separator = fullVersion.indexOf("-")) < 0) {
            return new PhpUnitVersion(fullVersion);
        }
        String shortVersion = fullVersion.substring(0, separator);
        if (StringUtil.equals((CharSequence)shortVersion, (CharSequence)ALPHA) || StringUtil.equals((CharSequence)shortVersion, (CharSequence)BETA)) {
            try {
                String date = fullVersion.substring(separator + 1);
                return new PhpUnitUnstableVersion(shortVersion, DATE_FORMAT.parse(date));
            }
            catch (ParseException e) {
                LOG.warn("Fail to parse phpunit build date", (Throwable)e);
            }
        }
        return new PhpUnitFromGitVersion(shortVersion);
    }

    public boolean isAfterPrinterChange() {
        return this.supportsOption("--teamcity");
    }

    public boolean isAfterCacheFileOptionAdded() {
        return this.supportsOption("--cache-result-file=");
    }

    protected boolean supportsOption(String option) {
        if (this.myOptionToSupportedVersion.containsKey(option)) {
            String edgeVersion = this.myOptionToSupportedVersion.get(option);
            return PhpTestFrameworkVersionDetector.versionCompare(this.myVersion, edgeVersion) >= 0;
        }
        return false;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            PhpUnitVersion.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpUnitUnstableVersion
    extends PhpUnitVersion {
        private static final Date PRINTER_ADDED_DATE = new GregorianCalendar(2015, 8, 20).getTime();
        private final Date myDate;

        PhpUnitUnstableVersion(@NotNull String version, @NotNull Date date) {
            if (version == null) {
                PhpUnitUnstableVersion.$$$reportNull$$$0(0);
            }
            if (date == null) {
                PhpUnitUnstableVersion.$$$reportNull$$$0(1);
            }
            super(version);
            this.myDate = date;
        }

        @Override
        public boolean isAfterPrinterChange() {
            return this.myDate.after(PRINTER_ADDED_DATE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "date";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/phpunit/PhpUnitVersion$PhpUnitUnstableVersion";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpUnitFromGitVersion
    extends PhpUnitVersion {
        PhpUnitFromGitVersion(@NotNull String version) {
            if (version == null) {
                PhpUnitFromGitVersion.$$$reportNull$$$0(0);
            }
            super(version);
        }

        @Override
        public boolean isAfterPrinterChange() {
            boolean notFullySupported = StringUtil.startsWith((CharSequence)this.myVersion, (CharSequence)"5.0") || StringUtil.startsWith((CharSequence)this.myVersion, (CharSequence)"5.1");
            return !notFullySupported && super.isAfterPrinterChange();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/php/phpunit/PhpUnitVersion$PhpUnitFromGitVersion", "<init>"));
        }
    }
}

