/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.phpunit.PhpUnitTestPattern;
import com.jetbrains.php.phpunit.PhpUnitTestPatternChooserDialog;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.phpunit.coverage.PhpUnitCoverageEngine;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.testFramework.PhpTestFrameworksConfigurable;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitTestRunnerConfigurationEditor
implements PanelWithAnchor {
    private static final Logger LOG = Logger.getInstance(PhpUnitTestRunnerConfigurationEditor.class);
    private static final String TEST_RUNNER_OPTIONS_HELP_URL = "https://phpunit.de/manual/current/en/textui.html";
    private JBRadioButton myScopeDirectoryRadioButton;
    private JBRadioButton myScopeClassRadioButton;
    private JBRadioButton myScopeMethodRadioButton;
    private JRadioButton myScopeXMLRadioButton;
    private JPanel myTestDirectoryPanel;
    private TextFieldWithBrowseButton myDirectoryTextField;
    private JPanel myTestMethodPanel;
    private TextFieldWithCompletion myMethodTextField;
    private JPanel myTestMethodWrapperPanel;
    private JPanel myTestClassPanel;
    private LanguageTextField myClassTextField;
    private JPanel myTestClassWrapperPanel;
    private JPanel myTestFilePanel;
    private ComboBox<String> myFileTextCombo;
    private TextFieldWithBrowseButton myConfigurationFileTextField;
    private TextFieldWithBrowseButton myBootstrapFileTextField;
    private RawCommandLineEditor myTestRunnerOptions;
    private JPanel myMainPanel;
    private JBCheckBox myUseAlternativeConfigurationFileJBCheckBox;
    private JBCheckBox myUseAlternativeBootstrapFileJBCheckBox;
    private JBLabel myTestScopeJBLabel;
    private JBLabel myDirectoryJBLabel;
    private JBLabel myMethodJBLabel;
    private JBLabel myClassJBLabel;
    private JBLabel myFileJBLabel;
    private FixedSizeButton myShowSettingsButton;
    private FixedSizeButton myTestRunnerOptionsHelpButton;
    private JBLabel myTestRunnerOptionsLabel;
    private JBRadioButton myScopePatternRadioButton;
    private JPanel myTestPatternPanel;
    private TextFieldWithBrowseButton myCompositePatternsBasePathTextField;
    private JBCheckBox myUseAlternativePatternsBasePathJBCheckBox;
    private ComboBox<PhpUnitCoverageEngine.CoverageEngine> myCoverageEngineComboBox;
    private JPanel myValidationPanel;
    private JBLabel myValidation;
    private boolean myInitialized = false;
    private boolean myReseted = false;
    private JComponent myAnchor;
    private final TableView<PhpUnitTestPattern> myPatternTestsTable;
    private Supplier<String> myInterpreterNameSupplier;

    public PhpUnitTestRunnerConfigurationEditor() {
        this.$$$setupUI$$$();
        this.myPatternTestsTable = new TableView();
        this.myTestRunnerOptions.setDialogCaption(PhpBundle.message("PhpUnitTestRunnerConfigurationEditor.dialog.caption.test.runner.options", new Object[0]));
        this.myTestRunnerOptionsLabel.setLabelFor((Component)this.myTestRunnerOptions);
    }

    public void init(final @NotNull Project project, @NotNull Disposable disposable, final @NotNull Supplier<String> interpreterNameSupplier) {
        if (project == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(1);
        }
        if (interpreterNameSupplier == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(2);
        }
        this.myInterpreterNameSupplier = interpreterNameSupplier;
        LOG.assertTrue(!this.myInitialized, (Object)"component is already initialized");
        this.myInitialized = true;
        this.myClassTextField = new LanguageTextField((Language)PhpLanguage.INSTANCE, project, "");
        PhpCompletionUtil.installClassCompletion((EditorTextField)this.myClassTextField, null, disposable, (Condition<? super PhpClass>)((Condition)PhpUnitUtil::isTestClass), new String[0]);
        this.myTestClassWrapperPanel.add((Component)this.myClassTextField);
        this.myMethodTextField = new TextFieldWithCompletion(project, (TextCompletionProvider)this.createMethodCompletionProvider(project), "", true, true, true);
        this.myTestMethodWrapperPanel.add((Component)this.myMethodTextField);
        this.myShowSettingsButton.setIcon(AllIcons.General.GearPlain);
        this.myShowSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String interpreterName = (String)interpreterNameSupplier.get();
                PhpInterpreter interpreter = interpreterName != null ? PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName) : PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
                PhpTestFrameworksConfigurable.createFix(project, PhpUnitFrameworkType.getInstance(), interpreter).run();
            }
        });
        this.myTestRunnerOptionsHelpButton.setIcon(UIUtil.getBalloonInformationIcon());
        this.myTestRunnerOptionsHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)PhpUnitTestRunnerConfigurationEditor.TEST_RUNNER_OPTIONS_HELP_URL);
            }
        });
        ActionListener updateStateActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpUnitTestRunnerConfigurationEditor.this.updateState();
            }
        };
        this.myScopeDirectoryRadioButton.addActionListener(updateStateActionListener);
        this.myScopeClassRadioButton.addActionListener(updateStateActionListener);
        this.myScopeMethodRadioButton.addActionListener(updateStateActionListener);
        this.myScopeXMLRadioButton.addActionListener(updateStateActionListener);
        this.myScopePatternRadioButton.addActionListener(updateStateActionListener);
        this.myDirectoryTextField.addActionListener(updateStateActionListener);
        this.myFileTextCombo.addActionListener(updateStateActionListener);
        this.myDirectoryTextField.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        Arrays.asList(PhpUnitCoverageEngine.CoverageEngine.values()).forEach(arg_0 -> this.myCoverageEngineComboBox.addItem(arg_0));
        this.myValidation.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI));
        this.myValidation.setIcon(UIUtil.getBalloonWarningIcon());
        this.validate(project);
        this.myCoverageEngineComboBox.addItemListener(event -> this.validate(project));
        this.myClassTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                PhpUnitTestRunnerConfigurationEditor.this.fillFileFieldVariants(project, PhpLangUtil.toFQN(PhpUnitTestRunnerConfigurationEditor.this.myClassTextField.getText()));
                PhpUnitTestRunnerConfigurationEditor.this.updateFieldsAvailability();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/phpunit/PhpUnitTestRunnerConfigurationEditor$4", "documentChanged"));
            }
        });
        this.myConfigurationFileTextField.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myUseAlternativeConfigurationFileJBCheckBox.addActionListener(updateStateActionListener);
        this.myBootstrapFileTextField.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myUseAlternativeBootstrapFileJBCheckBox.addActionListener(updateStateActionListener);
        this.setAnchor((JComponent)this.myTestScopeJBLabel);
        this.myPatternTestsTable.setTableHeader(null);
        this.myPatternTestsTable.getEmptyText().setText(PhpBundle.message("empty.pattern", new Object[0]));
        this.myPatternTestsTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{new ColumnInfo<PhpUnitTestPattern, PhpUnitTestPattern>(""){
            final TableCellRenderer myRenderer;
            {
                this.myRenderer = new ColoredTableCellRenderer(){

                    protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                        if (table == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (value instanceof PhpUnitTestPattern) {
                            this.append(((PhpUnitTestPattern)value).getPresentation());
                            this.setIcon(StringUtil.isNotEmpty((String)((PhpUnitTestPattern)value).getMethodName()) ? PhpIcons.PHP_TEST_METHOD : PhpIcons.PHP_TEST_CLASS);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/phpunit/PhpUnitTestRunnerConfigurationEditor$5$1", "customizeCellRenderer"));
                    }
                };
            }

            @NotNull
            public PhpUnitTestPattern valueOf(PhpUnitTestPattern s) {
                PhpUnitTestPattern phpUnitTestPattern = s;
                if (phpUnitTestPattern == null) {
                    5.$$$reportNull$$$0(0);
                }
                return phpUnitTestPattern;
            }

            @NotNull
            public TableCellRenderer getRenderer(PhpUnitTestPattern s) {
                TableCellRenderer tableCellRenderer = this.myRenderer;
                if (tableCellRenderer == null) {
                    5.$$$reportNull$$$0(1);
                }
                return tableCellRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/phpunit/PhpUnitTestRunnerConfigurationEditor$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "valueOf";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRenderer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }}));
        ToolbarDecorator patternTableToolbarDecorator = ToolbarDecorator.createDecorator(this.myPatternTestsTable, null).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PhpUnitTestPatternChooserDialog chooser = new PhpUnitTestPatternChooserDialog(project, PhpBundle.message("add.phpunit.test.pattern", new Object[0]));
                if (chooser.showAndGet()) {
                    ListTableModel model = PhpUnitTestRunnerConfigurationEditor.this.myPatternTestsTable.getListTableModel();
                    PhpUnitTestPattern item = PhpUnitTestPattern.create((PsiElement)chooser.getSelected(), chooser.getDataSet());
                    if (item != null) {
                        model.addRow((Object)item);
                        PhpUnitTestRunnerConfigurationEditor.this.myPatternTestsTable.setRowSelectionInterval(model.getRowCount() - 1, model.getRowCount() - 1);
                        PhpUnitTestRunnerConfigurationEditor.this.updatePatternsBasePathTextField();
                    }
                }
            }
        }).setAddActionName(PhpBundle.message("add.test.class.method", new Object[0])).setAddIcon(IconUtil.getAddIcon()).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems(PhpUnitTestRunnerConfigurationEditor.this.myPatternTestsTable);
                PhpUnitTestRunnerConfigurationEditor.this.updatePatternsBasePathTextField();
            }
        }).setEditAction(button -> {
            int selectedRow = this.myPatternTestsTable.getSelectedRow();
            PhpUnitTestPattern pattern = (PhpUnitTestPattern)this.myPatternTestsTable.getSelectedObject();
            PhpUnitTestPatternChooserDialog chooser = new PhpUnitTestPatternChooserDialog(project, pattern, PhpBundle.message("dialog.title.edit.phpunit.test.pattern", new Object[0]));
            if (chooser.showAndGet()) {
                ListTableModel model = this.myPatternTestsTable.getListTableModel();
                PhpUnitTestPattern item = PhpUnitTestPattern.create((PsiElement)chooser.getSelected(), chooser.getDataSet());
                if (item != null) {
                    model.addRow((Object)item);
                    int lastRow = model.getRowCount() - 1;
                    model.exchangeRows(selectedRow, lastRow);
                    model.removeRow(lastRow);
                    this.myPatternTestsTable.setRowSelectionInterval(selectedRow, selectedRow);
                }
            }
        });
        this.myTestPatternPanel.add(patternTableToolbarDecorator.createPanel());
        this.myTestPatternPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)PhpBundle.message("composite.test.patterns", new Object[0]), (boolean)false));
        this.myCompositePatternsBasePathTextField.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor());
        this.myUseAlternativePatternsBasePathJBCheckBox.addActionListener(e -> {
            updateStateActionListener.actionPerformed(e);
            this.updatePatternsBasePathTextField();
        });
    }

    public void validate(@NotNull Project project) {
        PhpInterpreter interpreter;
        if (project == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(3);
        }
        PhpUnitCoverageEngine.CoverageEngine item = (PhpUnitCoverageEngine.CoverageEngine)((Object)this.myCoverageEngineComboBox.getSelectedItem());
        String interpreterName = this.myInterpreterNameSupplier.get();
        PhpInterpreter phpInterpreter = interpreter = interpreterName != null ? PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName) : PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
        if (interpreter != null) {
            try {
                PhpUnitCoverageEngine.CoverageEngine.validateCoverageEngine(interpreter, project, item);
                this.myValidation.setText("");
                this.myValidationPanel.setVisible(false);
            }
            catch (RuntimeConfigurationWarning warning) {
                this.myValidation.setText(warning.getMessage());
                this.myValidationPanel.setVisible(true);
            }
        } else {
            this.myValidation.setText("");
            this.myValidationPanel.setVisible(false);
        }
    }

    private void updatePatternsBasePathTextField() {
        VirtualFile common;
        if (!this.myUseAlternativePatternsBasePathJBCheckBox.isSelected() && (common = PhpUnitTestRunnerConfigurationEditor.getCommonFileOrDirectory(this.myPatternTestsTable.getItems())) != null) {
            this.myCompositePatternsBasePathTextField.setText(common.getPath());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void fillFileFieldVariants(@NotNull Project project, @NotNull String fqn) {
        if (project == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(5);
        }
        String oldText = this.getSelectedFilePath();
        @NlsSafe Set pathsWithClassByFqn = (Set)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> PhpIndex.getInstance((Project)project).getClassesByFQN(fqn).stream().filter(PhpUnitUtil::isTestClass).map(clazz -> clazz.getContainingFile().getVirtualFile().getPath()).collect(Collectors.toSet()));
        if (pathsWithClassByFqn.isEmpty()) {
            return;
        }
        this.myFileTextCombo.removeAllItems();
        for (String path : pathsWithClassByFqn) {
            this.myFileTextCombo.addItem((Object)path);
            if (this.myReseted || !StringUtil.equals((CharSequence)oldText, (CharSequence)path)) continue;
            this.myFileTextCombo.setSelectedItem((Object)path);
        }
    }

    @NotNull
    public TextFieldCompletionProvider createMethodCompletionProvider(@NotNull Project project) {
        if (project == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(6);
        }
        return new MyTextFieldCompletionProvider(project);
    }

    @NotNull
    private String getSelectedFilePath() {
        String string = StringUtil.notNullize((String)((String)this.myFileTextCombo.getSelectedItem()));
        if (string == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void updatePanelsVisibility() {
        if (this.myScopeDirectoryRadioButton.isSelected()) {
            this.setVisiblePanels(true, false, false, false, false);
        } else if (this.myScopeClassRadioButton.isSelected()) {
            this.setVisiblePanels(false, true, true, false, false);
        } else if (this.myScopeMethodRadioButton.isSelected()) {
            this.setVisiblePanels(false, true, true, true, false);
        } else if (this.myScopeXMLRadioButton.isSelected()) {
            this.setVisiblePanels(false, false, false, false, false);
        } else if (this.myScopePatternRadioButton.isSelected()) {
            this.setVisiblePanels(false, false, false, false, true);
        }
    }

    private void updateFieldsAvailability() {
        this.myDirectoryTextField.setEnabled(true);
        this.myMethodTextField.setEnabled(true);
        this.myClassTextField.setEnabled(true);
        if (this.myScopeMethodRadioButton.isSelected() && (StringUtil.isEmpty((String)this.getSelectedFilePath()) || StringUtil.isEmpty((String)this.myClassTextField.getText()))) {
            this.myMethodTextField.setEnabled(false);
        }
        this.myConfigurationFileTextField.setEnabled(this.myUseAlternativeConfigurationFileJBCheckBox.isSelected());
        this.myBootstrapFileTextField.setEnabled(this.myUseAlternativeBootstrapFileJBCheckBox.isSelected());
        this.myFileTextCombo.setEnabled(this.myFileTextCombo.getItemCount() > 1);
        this.myCompositePatternsBasePathTextField.setEnabled(this.myUseAlternativePatternsBasePathJBCheckBox.isSelected());
    }

    private void updateState() {
        this.updatePanelsVisibility();
        this.updateFieldsAvailability();
    }

    private void setVisiblePanels(boolean directory, boolean file, boolean clazz, boolean method, boolean pattern) {
        this.myTestDirectoryPanel.setVisible(directory);
        this.myTestFilePanel.setVisible(file);
        this.myTestClassPanel.setVisible(clazz);
        this.myTestMethodPanel.setVisible(method);
        this.myTestPatternPanel.setVisible(pattern);
    }

    protected void resetEditorFrom(@NotNull PhpUnitTestRunnerSettings testRunnerSettings) {
        if (testRunnerSettings == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(8);
        }
        switch (testRunnerSettings.getScope()) {
            case Directory: {
                this.myScopeDirectoryRadioButton.setSelected(true);
                break;
            }
            case Class: {
                this.myScopeClassRadioButton.setSelected(true);
                break;
            }
            case Method: {
                this.myScopeMethodRadioButton.setSelected(true);
                break;
            }
            case XML: {
                this.myScopeXMLRadioButton.setSelected(true);
                break;
            }
            case Pattern: {
                this.myScopePatternRadioButton.setSelected(true);
            }
        }
        this.myDirectoryTextField.setText(testRunnerSettings.getDirectoryPath());
        this.myFileTextCombo.removeAllItems();
        this.myFileTextCombo.addItem((Object)testRunnerSettings.getFilePath());
        this.myClassTextField.setText(testRunnerSettings.getClassName());
        this.myMethodTextField.setText(testRunnerSettings.getMethodName());
        this.myUseAlternativeConfigurationFileJBCheckBox.setSelected(testRunnerSettings.isUseAlternativeConfigurationFile());
        this.myConfigurationFileTextField.setText(testRunnerSettings.getConfigurationFilePath());
        this.myUseAlternativeBootstrapFileJBCheckBox.setSelected(testRunnerSettings.isUseAlternativeBootstrapFile());
        this.myBootstrapFileTextField.setText(testRunnerSettings.getBootstrapFilePath());
        this.myTestRunnerOptions.setText(testRunnerSettings.getTestRunnerOptions());
        this.myCoverageEngineComboBox.setSelectedItem((Object)testRunnerSettings.getCoverageEngine());
        this.myPatternTestsTable.getListTableModel().setItems(new ArrayList<PhpUnitTestPattern>(testRunnerSettings.getTestPatterns()));
        String basePatternsPath = testRunnerSettings.getFilePath() != null ? testRunnerSettings.getFilePath() : testRunnerSettings.getDirectoryPath();
        this.myCompositePatternsBasePathTextField.setText(basePatternsPath);
        if (!testRunnerSettings.getTestPatterns().isEmpty()) {
            VirtualFile commonFileOrDirectory = PhpUnitTestRunnerConfigurationEditor.getCommonFileOrDirectory(testRunnerSettings.getTestPatterns());
            this.myUseAlternativePatternsBasePathJBCheckBox.setSelected(commonFileOrDirectory == null || !FileUtil.pathsEqual((String)commonFileOrDirectory.getPath(), (String)basePatternsPath));
        }
        this.updateState();
        this.myReseted = true;
    }

    protected void applyEditorTo(@NotNull PhpUnitTestRunnerSettings testRunnerSettings) {
        if (testRunnerSettings == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(9);
        }
        if (this.myScopeDirectoryRadioButton.isSelected()) {
            testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.Directory);
        } else if (this.myScopeClassRadioButton.isSelected()) {
            testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.Class);
        } else if (this.myScopeMethodRadioButton.isSelected()) {
            testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.Method);
        } else if (this.myScopeXMLRadioButton.isSelected()) {
            testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.XML);
        }
        if (this.myScopePatternRadioButton.isSelected()) {
            VirtualFile commonFileOrDirectory;
            testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.Pattern);
            testRunnerSettings.setTestPatterns(this.myPatternTestsTable.getItems());
            String alternativePatternsBasePath = this.myCompositePatternsBasePathTextField.getText();
            VirtualFile commonFile = PhpRunUtil.findFile(alternativePatternsBasePath);
            VirtualFile virtualFile = commonFileOrDirectory = commonFile != null ? commonFile : PhpRunUtil.findDirectory(alternativePatternsBasePath);
            if (commonFileOrDirectory != null) {
                PhpUnitTestRunnerConfigurationEditor.setCommonPath(testRunnerSettings, commonFileOrDirectory);
            } else {
                testRunnerSettings.setFilePath(alternativePatternsBasePath);
                testRunnerSettings.setDirectoryPath(null);
            }
        } else {
            testRunnerSettings.setDirectoryPath(this.myDirectoryTextField.getText());
            testRunnerSettings.setFilePath(this.getSelectedFilePath());
        }
        testRunnerSettings.setClassName(this.myClassTextField.getText());
        testRunnerSettings.setMethodName(this.myMethodTextField.getText());
        testRunnerSettings.setUseAlternativeConfigurationFile(this.myUseAlternativeConfigurationFileJBCheckBox.isSelected());
        testRunnerSettings.setConfigurationFilePath(this.myConfigurationFileTextField.getText());
        testRunnerSettings.setUseAlternativeBootstrapFile(this.myUseAlternativeBootstrapFileJBCheckBox.isSelected());
        testRunnerSettings.setBootstrapFilePath(this.myBootstrapFileTextField.getText());
        testRunnerSettings.setTestRunnerOptions(this.myTestRunnerOptions.getText());
        testRunnerSettings.setCoverageEngine((PhpUnitCoverageEngine.CoverageEngine)((Object)this.myCoverageEngineComboBox.getSelectedItem()));
    }

    public static void setCommonPath(@NotNull PhpUnitTestRunnerSettings testRunnerSettings, @Nullable VirtualFile commonFileOrDirectory) {
        if (testRunnerSettings == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(10);
        }
        if (commonFileOrDirectory != null) {
            if (commonFileOrDirectory.isDirectory()) {
                testRunnerSettings.setDirectoryPath(commonFileOrDirectory.getPath());
                testRunnerSettings.setFilePath(null);
            } else {
                testRunnerSettings.setFilePath(commonFileOrDirectory.getPath());
                testRunnerSettings.setDirectoryPath(null);
            }
        }
    }

    @Nullable
    public static VirtualFile getCommonFileOrDirectory(@NotNull List<? extends PhpUnitTestPattern> items) {
        Set parts;
        if (items == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(11);
        }
        return (parts = ((StreamEx)StreamEx.of(items).map(PhpUnitTestPattern::getContainingFileAbsolutePath).nonNull().distinct()).map(FileUtil::splitPath).toSet()).size() == 1 ? PhpRunUtil.findFile(items.get(0).getContainingFileAbsolutePath()) : PhpUnitTestRunnerConfigurationEditor.getCommonDirectory(parts);
    }

    @Nullable
    private static VirtualFile getCommonDirectory(@NotNull Set<? extends List<String>> parts) {
        if (parts == null) {
            PhpUnitTestRunnerConfigurationEditor.$$$reportNull$$$0(12);
        }
        StringBuilder result = new StringBuilder();
        if (!parts.isEmpty()) {
            List<String> firstPart = parts.iterator().next();
            for (int partIndex = 0; partIndex < firstPart.size(); ++partIndex) {
                for (List<String> list : parts) {
                    if (list.size() > partIndex && StringUtil.equals((CharSequence)list.get(partIndex), (CharSequence)firstPart.get(partIndex))) continue;
                    return PhpRunUtil.findDirectory(result.toString());
                }
                result.append(File.separatorChar);
                result.append(firstPart.get(partIndex));
            }
        }
        return PhpRunUtil.findDirectory(result.toString());
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myTestScopeJBLabel.setAnchor(anchor);
        this.myDirectoryJBLabel.setAnchor(anchor);
        this.myMethodJBLabel.setAnchor(anchor);
        this.myClassJBLabel.setAnchor(anchor);
        this.myFileJBLabel.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterNameSupplier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitTestRunnerConfigurationEditor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitTestRunnerConfigurationEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillFileFieldVariants";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMethodCompletionProvider";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCommonPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommonFileOrDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommonDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        ComboBox comboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        FixedSizeButton fixedSizeButton;
        RawCommandLineEditor rawCommandLineEditor;
        JBLabel jBLabel2;
        FixedSizeButton fixedSizeButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBCheckBox jBCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JBCheckBox jBCheckBox3;
        JPanel jPanel2;
        JPanel jPanel3;
        JBLabel jBLabel3;
        JPanel jPanel4;
        ComboBox comboBox2;
        JBLabel jBLabel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JBLabel jBLabel5;
        JPanel jPanel7;
        TextFieldWithBrowseButton textFieldWithBrowseButton4;
        JBLabel jBLabel6;
        JPanel jPanel8;
        JBRadioButton jBRadioButton;
        JBLabel jBLabel7;
        JRadioButton jRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JBRadioButton jBRadioButton4;
        JPanel jPanel9;
        this.myMainPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel10.putClientProperty("html.disable", Boolean.FALSE);
        jPanel9.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.test.runner"), (int)0, (int)0, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel12, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel12.add((Component)spacer, new GridConstraints(0, 6, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myScopeDirectoryRadioButton = jBRadioButton4 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.scope.directory"));
        jPanel12.add((Component)jBRadioButton4, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myScopeClassRadioButton = jBRadioButton3 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.scope.class"));
        jPanel12.add((Component)jBRadioButton3, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myScopeMethodRadioButton = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.scope.method"));
        jPanel12.add((Component)jBRadioButton2, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myScopeXMLRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.scope.xml"));
        jPanel12.add((Component)jRadioButton, new GridConstraints(0, 5, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTestScopeJBLabel = jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.scope"));
        jPanel12.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myScopePatternRadioButton = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("php.unit.radio.button.composite"));
        jPanel12.add((Component)jBRadioButton, new GridConstraints(0, 4, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myTestDirectoryPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel8, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDirectoryJBLabel = jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.field.directory"));
        jPanel8.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoryTextField = textFieldWithBrowseButton4 = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myTestClassPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel7, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myClassJBLabel = jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.field.class"));
        jPanel7.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestClassWrapperPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new CardLayout(0, 0));
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTestFilePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFileJBLabel = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.field.file"));
        jPanel5.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileTextCombo = comboBox2 = new ComboBox();
        jPanel5.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myTestMethodPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel4, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myMethodJBLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.field.method"));
        jPanel4.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestMethodWrapperPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTestPatternPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel11.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(5, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel13, "South");
        this.myUseAlternativePatternsBasePathJBCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("php.unit.checkbox.use.alternative.patterns.base.path"));
        jPanel13.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BorderLayout(0, 0));
        jPanel13.add((Component)jPanel14, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCompositePatternsBasePathTextField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel14.add((Component)textFieldWithBrowseButton3, "Center");
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel15, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel16, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myUseAlternativeConfigurationFileJBCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.use.alt.configuration.file"));
        jPanel16.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new BorderLayout(0, 0));
        jPanel16.add((Component)jPanel17, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myConfigurationFileTextField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel17.add((Component)textFieldWithBrowseButton2, "Center");
        this.myShowSettingsButton = fixedSizeButton2 = new FixedSizeButton();
        jPanel17.add((Component)fixedSizeButton2, "East");
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel18, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myTestRunnerOptionsLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.field.test.runner.options"));
        jPanel18.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new BorderLayout(0, 0));
        jPanel18.add((Component)jPanel19, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTestRunnerOptions = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("messages/PhpBundle").getString("php.unit.test.runner.options"));
        jPanel19.add((Component)rawCommandLineEditor, "Center");
        this.myTestRunnerOptionsHelpButton = fixedSizeButton = new FixedSizeButton();
        jPanel19.add((Component)fixedSizeButton, "East");
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel20, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myUseAlternativeBootstrapFileJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.use.alt.bootstrap.file"));
        jPanel20.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout(new BorderLayout(0, 0));
        jPanel20.add((Component)jPanel21, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBootstrapFileTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel21.add((Component)textFieldWithBrowseButton, "Center");
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel22, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel8 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel8, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestRunnerConfigurationEditor.class).getString("PhpUnitTestRunnerConfigurationEditor.field.test.runner.coverage.engine"));
        jPanel22.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCoverageEngineComboBox = comboBox = new ComboBox();
        jPanel22.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myValidationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel22.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myValidation = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel10.add((Component)jSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 7, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton4);
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyTextFieldCompletionProvider
    extends TextFieldCompletionProvider
    implements DumbAware {
        @NotNull
        private final Project myProject;

        private MyTextFieldCompletionProvider(Project project) {
            if (project == null) {
                MyTextFieldCompletionProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
            PhpFile selectedFile;
            PhpClass selectedClass;
            if (text == null) {
                MyTextFieldCompletionProvider.$$$reportNull$$$0(1);
            }
            if (prefix == null) {
                MyTextFieldCompletionProvider.$$$reportNull$$$0(2);
            }
            if (result == null) {
                MyTextFieldCompletionProvider.$$$reportNull$$$0(3);
            }
            PhpClass phpClass = selectedClass = (selectedFile = (PhpFile)ObjectUtils.tryCast((Object)PhpRunUtil.findPsiFile(this.myProject, PhpUnitTestRunnerConfigurationEditor.this.getSelectedFilePath(), true), PhpFile.class)) == null ? null : (PhpClass)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> PhpUnitUtil.findClassByFQNInFile(PhpUnitTestRunnerConfigurationEditor.this.myClassTextField.getText(), (PsiFile)selectedFile, this.myProject));
            if (selectedClass != null) {
                PhpClassHierarchyUtils.processMethods((PhpClass)selectedClass, (PhpClass)selectedClass, (method, subClass, baseClass) -> {
                    if (PhpUnitUtil.isTestMethod(selectedClass, method)) {
                        result.addElement((LookupElement)LookupElementBuilder.create((PsiNamedElement)method).withIcon(PhpIcons.PHP_TEST_METHOD));
                    }
                    return true;
                }, (boolean)false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitTestRunnerConfigurationEditor$MyTextFieldCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletionVariants";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

