/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.util.PhpConfigurationUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitSettings
implements PhpTestFrameworkConfiguration {
    @Nls
    public static final String LOCAL = PhpBundle.message("local", new Object[0]);
    private PhpTestFrameworkType myFrameworkType;
    private boolean myUseConfigurationFile = false;
    @NotNull
    private LoadMethod myLoadMethod = LoadMethod.CUSTOM_LOADER;
    @Nullable
    private String myCustomLoaderPath;
    @Nullable
    private String myPhpUnitPharPath;
    @Nullable
    private String myConfigurationFilePath;
    private boolean myUseBootstrapFile = false;
    @Nullable
    private String myBootstrapFilePath;

    public PhpUnitSettings() {
        this.myFrameworkType = PhpUnitFrameworkType.getInstance();
    }

    @Override
    @NotNull
    @Nls
    public String getId() {
        String string = LOCAL;
        if (string == null) {
            PhpUnitSettings.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    public String getPresentableName(@Nullable Project project) {
        String string = this.getId();
        if (string == null) {
            PhpUnitSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Transient
    @NotNull
    public PhpTestFrameworkType getFrameworkType() {
        PhpTestFrameworkType phpTestFrameworkType = this.myFrameworkType;
        if (phpTestFrameworkType == null) {
            PhpUnitSettings.$$$reportNull$$$0(2);
        }
        return phpTestFrameworkType;
    }

    @Override
    public void setFrameworkType(@NotNull PhpTestFrameworkType type) {
        if (type == null) {
            PhpUnitSettings.$$$reportNull$$$0(3);
        }
        this.myFrameworkType = type;
    }

    @Override
    public boolean isLocal() {
        return StringUtil.equals((CharSequence)this.getId(), (CharSequence)LOCAL);
    }

    @Override
    @Transient
    public boolean isProjectLevel() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    @Transient
    @Nullable
    public String getExecutablePath() {
        switch (this.myLoadMethod) {
            case PHPUNIT_PHAR: {
                return this.getPhpUnitPharPath();
            }
            case CUSTOM_LOADER: {
                return this.getCustomLoaderPath();
            }
        }
        return null;
    }

    @Override
    public void setExecutablePath(@Nullable String executable) {
        if (this.myLoadMethod == LoadMethod.PHPUNIT_PHAR) {
            this.setPhpUnitPharPath(executable);
        } else if (this.myLoadMethod == LoadMethod.CUSTOM_LOADER) {
            this.setCustomLoaderPath(executable);
        }
    }

    @Attribute(value="load_method")
    @NotNull
    public LoadMethod getLoadMethod() {
        LoadMethod loadMethod = this.myLoadMethod;
        if (loadMethod == null) {
            PhpUnitSettings.$$$reportNull$$$0(4);
        }
        return loadMethod;
    }

    public void setLoadMethod(@NotNull LoadMethod loadMethod) {
        if (loadMethod == null) {
            PhpUnitSettings.$$$reportNull$$$0(5);
        }
        this.myLoadMethod = loadMethod;
    }

    @Transient
    @Nullable
    @NlsSafe
    public String getCustomLoaderPath() {
        return this.myCustomLoaderPath;
    }

    public void setCustomLoaderPath(@Nullable String path) {
        this.myCustomLoaderPath = path;
    }

    @Attribute(value="custom_loader_path")
    @Nullable
    @NlsSafe
    public String getSerializedCustomLoaderPath() {
        return this.serialize(this.myCustomLoaderPath);
    }

    public void setSerializedCustomLoaderPath(@Nullable String path) {
        this.myCustomLoaderPath = this.deserialize(path);
    }

    @Transient
    @Nullable
    @NlsSafe
    public String getPhpUnitPharPath() {
        return this.myPhpUnitPharPath;
    }

    public void setPhpUnitPharPath(@Nullable String pharArchivePath) {
        this.myPhpUnitPharPath = pharArchivePath;
    }

    @Attribute(value="phpunit_phar_path")
    @Nullable
    @NlsSafe
    public String getSerializedPhpUnitPharPath() {
        return this.serialize(this.myPhpUnitPharPath);
    }

    public void setSerializedPhpUnitPharPath(@Nullable String path) {
        this.myPhpUnitPharPath = this.deserialize(path);
    }

    @Override
    @Attribute(value="use_configuration_file")
    public boolean isUseConfigurationFile() {
        return this.myUseConfigurationFile;
    }

    @Override
    public void setUseConfigurationFile(boolean useConfigurationFile) {
        this.myUseConfigurationFile = useConfigurationFile;
    }

    @Override
    @Transient
    @Nullable
    @NlsSafe
    public String getConfigurationFilePath() {
        return this.myConfigurationFilePath;
    }

    @Override
    public void setConfigurationFilePath(@Nullable String configurationFilePath) {
        this.myConfigurationFilePath = StringUtil.nullize((String)configurationFilePath);
    }

    @Attribute(value="configuration_file_path")
    @Nullable
    @NlsSafe
    public String getSerializedConfigurationFilePath() {
        return this.serialize(this.myConfigurationFilePath);
    }

    public void setSerializedConfigurationFilePath(@Nullable String configurationFilePath) {
        this.myConfigurationFilePath = this.deserialize(configurationFilePath);
    }

    @Attribute(value="use_bootstrap_file")
    public boolean isUseBootstrapFile() {
        return this.myUseBootstrapFile;
    }

    public void setUseBootstrapFile(boolean useBootstrapFile) {
        this.myUseBootstrapFile = useBootstrapFile;
    }

    @Transient
    @Nullable
    @NlsSafe
    public String getBootstrapFilePath() {
        return this.myBootstrapFilePath;
    }

    public void setBootstrapFilePath(@Nullable String bootstrapFilePath) {
        this.myBootstrapFilePath = StringUtil.nullize((String)bootstrapFilePath);
    }

    @Attribute(value="bootstrap_file_path")
    @Nullable
    public String getSerializedBootstrapFilePath() {
        return this.serialize(this.myBootstrapFilePath);
    }

    public void setSerializedBootstrapFilePath(@Nullable String bootstrapFilePath) {
        this.myBootstrapFilePath = this.deserialize(bootstrapFilePath);
    }

    @Override
    @Nullable
    public PhpUnitSettings copyWithSettingsSource(@Nullable Project project) {
        return null;
    }

    protected String serialize(@Nullable String path) {
        return PhpConfigurationUtil.serializePath(path);
    }

    protected String deserialize(@Nullable String path) {
        return PhpConfigurationUtil.deserializePath(path);
    }

    @Override
    @NotNull
    public PhpUnitSettings copy() {
        PhpUnitSettings settings = new PhpUnitSettings();
        this.copyTo(settings);
        PhpUnitSettings phpUnitSettings = settings;
        if (phpUnitSettings == null) {
            PhpUnitSettings.$$$reportNull$$$0(6);
        }
        return phpUnitSettings;
    }

    public PhpUnitSettings copyTo(PhpUnitSettings settings) {
        settings.myFrameworkType = this.myFrameworkType;
        settings.myUseConfigurationFile = this.myUseConfigurationFile;
        settings.myLoadMethod = this.myLoadMethod;
        settings.myCustomLoaderPath = this.myCustomLoaderPath;
        settings.myPhpUnitPharPath = this.myPhpUnitPharPath;
        settings.myConfigurationFilePath = this.myConfigurationFilePath;
        settings.myUseBootstrapFile = this.myUseBootstrapFile;
        settings.myBootstrapFilePath = this.myBootstrapFilePath;
        return settings;
    }

    public static int compareTo(@NotNull PhpUnitSettings o1, @NotNull PhpUnitSettings o2, @Nullable Project project) {
        if (o1 == null) {
            PhpUnitSettings.$$$reportNull$$$0(7);
        }
        if (o2 == null) {
            PhpUnitSettings.$$$reportNull$$$0(8);
        }
        if (StringUtil.equals((CharSequence)o1.getId(), (CharSequence)LOCAL)) {
            return -1;
        }
        if (StringUtil.equals((CharSequence)o2.getId(), (CharSequence)LOCAL)) {
            return 1;
        }
        return StringUtil.compare((String)o1.getPresentableName(project), (String)o2.getPresentableName(project), (boolean)false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpUnitSettings settings = (PhpUnitSettings)o;
        if (this.myUseConfigurationFile != settings.myUseConfigurationFile) {
            return false;
        }
        if (this.myUseBootstrapFile != settings.myUseBootstrapFile) {
            return false;
        }
        if (this.myLoadMethod != settings.myLoadMethod) {
            return false;
        }
        if (this.myCustomLoaderPath != null ? !this.myCustomLoaderPath.equals(settings.myCustomLoaderPath) : settings.myCustomLoaderPath != null) {
            return false;
        }
        if (this.myPhpUnitPharPath != null ? !this.myPhpUnitPharPath.equals(settings.myPhpUnitPharPath) : settings.myPhpUnitPharPath != null) {
            return false;
        }
        if (this.myConfigurationFilePath != null ? !this.myConfigurationFilePath.equals(settings.myConfigurationFilePath) : settings.myConfigurationFilePath != null) {
            return false;
        }
        return !(this.myBootstrapFilePath != null ? !this.myBootstrapFilePath.equals(settings.myBootstrapFilePath) : settings.myBootstrapFilePath != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadMethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkType";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadMethod";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFrameworkType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setLoadMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum LoadMethod {
        CUSTOM_LOADER,
        PHPUNIT_PHAR;

    }
}

