/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.LocationInfo;
import com.jetbrains.php.phpunit.PhpMethodLocation;
import com.jetbrains.php.phpunit.PhpPsiLocationWithDataSet;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitQualifiedNameLocationProvider
implements SMTestLocator {
    private static final String PROTOCOL_ID = "php_qn";
    public static final int WORDS_COUNT_IN_METHOD_WITH_DATASET = 5;
    @NotNull
    protected final PhpPathMapper myPathMapper;

    protected PhpUnitQualifiedNameLocationProvider(@NotNull PhpPathMapper pathMapper) {
        if (pathMapper == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(0);
        }
        this.myPathMapper = pathMapper;
    }

    public static PhpUnitQualifiedNameLocationProvider create(@NotNull Project project, @NotNull String serverName) {
        PhpServer server;
        if (project == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(1);
        }
        if (serverName == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(2);
        }
        if ((server = PhpProjectConfigurationFacade.getInstance(project).findServer(serverName)) == null) {
            return new PhpUnitQualifiedNameLocationProvider(PhpPathMapper.create());
        }
        return new PhpUnitQualifiedNameLocationProvider(PhpPathMapper.create(server));
    }

    public static PhpUnitQualifiedNameLocationProvider create(@NotNull PhpPathMapper pathMapper) {
        if (pathMapper == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(3);
        }
        return new PhpUnitQualifiedNameLocationProvider(pathMapper);
    }

    @NotNull
    public PhpPathMapper getPathMapper() {
        PhpPathMapper phpPathMapper = this.myPathMapper;
        if (phpPathMapper == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(4);
        }
        return phpPathMapper;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        LocationInfo locationInfo;
        PsiElement element;
        if (protocol == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(5);
        }
        if (path == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(8);
        }
        if (PROTOCOL_ID.equals(protocol) && (element = this.findElement(locationInfo = this.getLocationInfo(path), project)) != null) {
            PhpClass containingClass;
            if (element instanceof Method && (containingClass = (PhpClass)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)project).getClassesByFQN(locationInfo.getClassName()))) != null) {
                List<PhpMethodLocation> list = Collections.singletonList(new PhpMethodLocation(project, (Method)element, containingClass, PhpUnitQualifiedNameLocationProvider.getDataSet(locationInfo)));
                if (list == null) {
                    PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(9);
                }
                return list;
            }
            List<PhpPsiLocationWithDataSet<PsiElement>> list = Collections.singletonList(new PhpPsiLocationWithDataSet<PsiElement>(project, element, PhpUnitQualifiedNameLocationProvider.getDataSet(locationInfo)));
            if (list == null) {
                PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    private static String getDataSet(@Nullable LocationInfo locationInfo) {
        String methodName = locationInfo != null ? locationInfo.getMethodName() : null;
        Object[] parts = methodName != null ? methodName.split(" ", 5) : ArrayUtilRt.EMPTY_STRING_ARRAY;
        return parts.length > 1 ? (String)ArrayUtil.getLastElement((Object[])parts) : null;
    }

    @Nullable
    protected LocationInfo getLocationInfo(@NotNull String link) {
        String[] location;
        int tokensNumber;
        if (link == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(12);
        }
        if ((tokensNumber = (location = link.split("::")).length) <= 0 || tokensNumber > 3) {
            return null;
        }
        String filePath = location[0];
        if (filePath == null) {
            return null;
        }
        String className = tokensNumber > 1 ? location[1] : null;
        String methodName = tokensNumber > 2 ? location[2] : null;
        return new LocationInfo(className, methodName, this.myPathMapper.getLocalFile(filePath));
    }

    @Nullable
    @Contract(value="null, _ -> null")
    protected PsiElement findElement(@Nullable LocationInfo locationInfo, Project project) {
        return locationInfo != null ? this.getLocation(project, locationInfo.getFile(), locationInfo.getClassName(), PhpUnitQualifiedNameLocationProvider.firstWord(locationInfo.getMethodName())) : null;
    }

    @Nullable
    private static String firstWord(@Nullable String s) {
        if (s == null) {
            return null;
        }
        String result = StringUtil.substringBefore((String)s, (String)" ");
        return result != null ? result : s;
    }

    @Nullable
    protected PsiElement getLocation(@NotNull Project project, @Nullable VirtualFile virtualFile, @Nullable String className, @Nullable String methodName) {
        if (project == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(13);
        }
        if (virtualFile == null) {
            return null;
        }
        PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)project).findFile(virtualFile), PhpFile.class);
        if (file == null) {
            return null;
        }
        if (className != null) {
            PhpClass phpClass;
            if (StringUtil.isEmpty((String)className)) {
                PhpClass testClass;
                if (methodName != null && !DumbService.isDumb((Project)project) && (testClass = PhpUnitUtil.findTestClass(file)) != null) {
                    return testClass.findOwnMethodByName((CharSequence)methodName);
                }
                return null;
            }
            if (!DumbService.isDumb((Project)project) && (phpClass = PhpPsiUtil.findClass(file, (Condition<? super PhpClass>)((Condition)aClass -> PhpLangUtil.equalsClassNames(aClass.getFQN(), className)))) != null) {
                if (methodName != null) {
                    return phpClass.findMethodByName((CharSequence)methodName);
                }
                return phpClass;
            }
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 1: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitQualifiedNameLocationProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitQualifiedNameLocationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapper";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLocationInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

