/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PhpUnitIconProvider
extends IconProvider {
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        XmlFile xmlFile;
        VirtualFile virtualFile;
        if (element == null) {
            PhpUnitIconProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PhpFile) {
            VirtualFile file = ((PhpFile)element).getVirtualFile();
            if (file != null && PhpUnitUtil.isPhpUnitTestFileName(file.getNameWithoutExtension())) {
                Collection<PhpClass> testClassesCandidates = PhpPsiUtil.findClasses((PhpFile)element, (Condition<? super PhpClass>)((Condition)PhpUnitUtil::extendsRootTestClass));
                PhpClass testClass = (PhpClass)ContainerUtil.find(testClassesCandidates, phpClass -> !phpClass.isAbstract());
                if (testClass != null) {
                    return testClass.isFinal() ? PhpIcons.FINAL_TEST_CLASS : PhpIcons.PHP_TEST_CLASS;
                }
                if (!testClassesCandidates.isEmpty()) {
                    return PhpIcons.ABSTRACT_TEST_CLASS;
                }
            }
        } else if (element instanceof XmlFile && (virtualFile = (xmlFile = (XmlFile)element).getVirtualFile()) != null && PhpUnitIconProvider.isPhpUnitConfigurationFileName(virtualFile.getName()) && PhpUnitUtil.isPhpUnitConfigurationFile((PsiFile)xmlFile)) {
            return PhpIcons.PHPUNIT_CONFIGURATION_FILE;
        }
        return null;
    }

    private static boolean isPhpUnitConfigurationFileName(@NotNull String fileName) {
        if (fileName == null) {
            PhpUnitIconProvider.$$$reportNull$$$0(1);
        }
        return fileName.equalsIgnoreCase("phpunit.xml") || fileName.equalsIgnoreCase("phpunit.xml.dist") || fileName.contains("phpunit") && fileName.contains("xml");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPhpUnitConfigurationFileName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

