/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.PhpUnitConsoleProperties;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitTestPattern;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.filters.PhpUnitFilter;
import com.jetbrains.php.run.filters.XdebugCallStackFilter;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitExecutionUtil {
    private static final Logger LOG = Logger.getInstance(PhpUnitExecutionUtil.class);
    public static final String PHPUNIT_HELPER_SCRIPT_NAME = "phpunit.php";
    public static final String PHPUNIT_VERSION = "IDE_PHPUNIT_VERSION";
    public static final String PHPUNIT_HELPER_ENV_CUSTOM_LOADER = "IDE_PHPUNIT_CUSTOM_LOADER";
    public static final String PHPUNIT_HELPER_ENV_PHPUNIT_PHAR = "IDE_PHPUNIT_PHPUNIT_PHAR";
    public static final String PHPUNIT_HELPER_ENV_PHPUNIT_INCLUDE = "IDE_PHPUNIT_PHPUNIT_INCLUDE";
    private static final String DEPENDS_TAG = "@depends";

    private PhpUnitExecutionUtil() {
    }

    public static ConsoleView createConsole(@NotNull Project project, @NotNull ProcessHandler processHandler, @NotNull PhpUnitConsoleProperties properties) {
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(2);
        }
        PhpPathMapper pathMapper = properties.getPathMapper();
        properties.addStackTraceFilter(new PhpUnitFilter(project, pathMapper));
        properties.addStackTraceFilter(new XdebugCallStackFilter(project, pathMapper));
        BaseTestsOutputConsoleView testsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole((String)"PhpUnit", (TestConsoleProperties)properties);
        testsOutputConsoleView.attachToProcess(processHandler);
        PhpExecutionUtil.addMessageFilters(project, (ConsoleView)testsOutputConsoleView, pathMapper);
        Disposer.register((Disposable)PhpUnitSettingsManager.getInstance(project), (Disposable)testsOutputConsoleView);
        return testsOutputConsoleView;
    }

    @NotNull
    public static VirtualFile getPhpUnitHelperScriptFile() throws ExecutionException {
        String phpunitScriptPath = System.getProperty("phpunit.script.path");
        if (phpunitScriptPath != null) {
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(phpunitScriptPath);
            LOG.assertTrue(file != null, (Object)("Cannot find phpunit script at " + phpunitScriptPath));
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                PhpUnitExecutionUtil.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = PhpExecutionUtil.getHelperScriptFile(PHPUNIT_HELPER_SCRIPT_NAME);
        if (virtualFile == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    public static void fillBootstrapAndConfigurationOptions(@Nullable String bootstrapFilePath, @Nullable String configurationFilePath, @NotNull PhpCommandSettings command, boolean useMappingsForConfigurationFile, boolean useMappingsForBootstrapFile) {
        if (command == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)bootstrapFilePath)) {
            command.addArgument("--bootstrap");
            if (useMappingsForBootstrapFile) {
                command.addPathArgument(bootstrapFilePath);
            } else {
                command.addArgument(bootstrapFilePath);
            }
        }
        if (StringUtil.isNotEmpty((String)configurationFilePath)) {
            command.addArgument("--configuration");
            if (useMappingsForConfigurationFile) {
                command.addPathArgument(configurationFilePath);
            } else {
                command.addArgument(configurationFilePath);
            }
        } else {
            command.addArgument("--no-configuration");
        }
    }

    public static void fillPhpUnitTestRunnerArguments(@NotNull Project project, @NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull List<String> arguments, @NotNull PhpCommandSettings command, @Nullable PhpUnitSettings phpUnitConfiguration) {
        String configurationFilePath;
        String testRunnerOptions;
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(6);
        }
        if (testRunnerSettings == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(7);
        }
        if (arguments == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(8);
        }
        if (command == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(9);
        }
        if (StringUtil.isNotEmpty((String)(testRunnerOptions = testRunnerSettings.getTestRunnerOptions()))) {
            command.addArguments(Arrays.asList(ParametersList.parse((String)testRunnerOptions)));
        }
        command.addArguments(arguments);
        boolean useLocalBootstrapFile = testRunnerSettings.isUseAlternativeBootstrapFile();
        String bootstrapFilePath = useLocalBootstrapFile ? testRunnerSettings.getBootstrapFilePath() : (phpUnitConfiguration != null && phpUnitConfiguration.isUseBootstrapFile() ? phpUnitConfiguration.getBootstrapFilePath() : null);
        boolean useLocalConfigurationFile = testRunnerSettings.isUseAlternativeConfigurationFile();
        if (useLocalConfigurationFile) {
            configurationFilePath = testRunnerSettings.getConfigurationFilePath();
        } else if (phpUnitConfiguration != null && phpUnitConfiguration.isUseConfigurationFile()) {
            configurationFilePath = phpUnitConfiguration.getConfigurationFilePath();
            testRunnerSettings.setConfigurationFilePath(configurationFilePath);
        } else {
            configurationFilePath = null;
        }
        PhpUnitExecutionUtil.fillBootstrapAndConfigurationOptions(bootstrapFilePath, configurationFilePath, command, useLocalConfigurationFile, useLocalBootstrapFile);
        PhpUnitExecutionUtil.fillCommandArguments(project, testRunnerSettings, command);
    }

    public static void fillCommandArguments(@NotNull Project project, @NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull PhpCommandSettings command) {
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(10);
        }
        if (testRunnerSettings == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(11);
        }
        if (command == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(12);
        }
        PhpUnitTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        switch (scope) {
            case Directory: {
                command.addPathArgument(StringUtil.notNullize((String)testRunnerSettings.getDirectoryPath()));
                break;
            }
            case Class: {
                PhpClass aClass = PhpUnitExecutionUtil.findClass(project, testRunnerSettings.getFilePath(), testRunnerSettings.getClassName());
                command.addArgument(aClass != null && PhpUnitUtil.isTestSuite(aClass) ? "--testsuite" : "--filter");
                command.addClassFqnArgument(StringUtil.notNullize((String)testRunnerSettings.getClassName()));
                PhpUnitExecutionUtil.addFilePathArgument(testRunnerSettings, command);
                break;
            }
            case Method: {
                PhpClass aClass = PhpUnitExecutionUtil.findClass(project, testRunnerSettings.getFilePath(), testRunnerSettings.getClassName());
                command.addArgument(aClass != null && PhpUnitUtil.isTestSuite(aClass) ? "--testsuite" : "--filter");
                command.addClassFqnArgument("/" + PhpUnitExecutionUtil.createMethodWithDependenciesFilterArgument(project, testRunnerSettings) + "( .*)?$/");
                PhpUnitExecutionUtil.addFilePathArgument(testRunnerSettings, command);
                break;
            }
            case Pattern: {
                command.addArgument("--filter");
                command.addArgument("/" + PhpUnitExecutionUtil.createFilterArgument(project, testRunnerSettings.getTestPatterns()) + "$/");
                if (testRunnerSettings.getFilePath() != null) {
                    PhpUnitExecutionUtil.addFilePathArgument(testRunnerSettings, command);
                    break;
                }
                if (testRunnerSettings.getDirectoryPath() == null) break;
                command.addPathArgument(testRunnerSettings.getDirectoryPath());
            }
        }
    }

    private static void addFilePathArgument(@NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull PhpCommandSettings command) {
        if (testRunnerSettings == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(13);
        }
        if (command == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(14);
        }
        command.addArgument("--test-suffix");
        command.addArgument(PathUtil.getFileName((String)StringUtil.notNullize((String)testRunnerSettings.getFilePath())));
        String path = PathUtil.getParentPath((String)StringUtil.notNullize((String)testRunnerSettings.getFilePath()));
        if (!StringUtil.isEmpty((String)path)) {
            command.addPathArgument(path);
        }
    }

    @NotNull
    private static String createFilterArgument(@NotNull Project project, @NotNull List<? extends PhpUnitTestPattern> patterns) {
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(15);
        }
        if (patterns == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(16);
        }
        HashSet<? extends PhpUnitTestPattern> patternsWithDependencies = new HashSet<PhpUnitTestPattern>(patterns);
        for (PhpUnitTestPattern phpUnitTestPattern : patterns) {
            Method method = PhpUnitExecutionUtil.findMethod(project, phpUnitTestPattern.getContainingFileAbsolutePath(), phpUnitTestPattern.getClassFqn(), phpUnitTestPattern.getMethodName());
            PhpClass containingClass = method != null ? method.getContainingClass() : null;
            if (containingClass == null) continue;
            for (Method dependencyMethod : PhpUnitExecutionUtil.collectMethodDependencies(method, containingClass)) {
                ContainerUtil.addIfNotNull(patternsWithDependencies, (Object)PhpUnitTestPattern.create((PhpNamedElement)dependencyMethod));
            }
        }
        return PhpUnitExecutionUtil.concatenateTests(patternsWithDependencies);
    }

    @NotNull
    private static String createMethodWithDependenciesFilterArgument(@NotNull Project project, @NotNull PhpUnitTestRunnerSettings testRunnerSettings) {
        PhpClass testClass;
        Method method;
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(17);
        }
        if (testRunnerSettings == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(18);
        }
        if ((method = PhpUnitExecutionUtil.findMethod(project, testRunnerSettings.getFilePath(), testRunnerSettings.getClassName(), testRunnerSettings.getMethodName())) != null && (testClass = method.getContainingClass()) != null) {
            return PhpUnitExecutionUtil.createDependenciesMethodNamesArgument(method, testClass);
        }
        String string = "::" + StringUtil.notNullize((String)testRunnerSettings.getMethodName());
        if (string == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Nullable
    public static Method findMethod(@NotNull Project project, @Nullable String filePath, @Nullable String classFQN, @Nullable String methodName) {
        PhpClass testClass;
        PhpFile file;
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(20);
        }
        if (!DumbService.isDumb((Project)project) && (file = (PhpFile)ObjectUtils.tryCast((Object)PhpRunUtil.findPsiFile(project, filePath, true), PhpFile.class)) != null && (testClass = PhpUnitUtil.findClassByFQNInFile(PhpLangUtil.toFQN(StringUtil.notNullize((String)classFQN)), (PsiFile)file, project)) != null) {
            return testClass.findOwnMethodByName((CharSequence)methodName);
        }
        return null;
    }

    @Nullable
    public static PhpClass findClass(@NotNull Project project, @Nullable String filePath, @Nullable String classFQN) {
        PhpFile file;
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(21);
        }
        if (!DumbService.isDumb((Project)project) && (file = (PhpFile)ObjectUtils.tryCast((Object)PhpRunUtil.findPsiFile(project, filePath, true), PhpFile.class)) != null) {
            return PhpUnitUtil.findClassByFQNInFile(PhpLangUtil.toFQN(StringUtil.notNullize((String)classFQN)), (PsiFile)file, project);
        }
        return null;
    }

    @NotNull
    private static String createDependenciesMethodNamesArgument(@NotNull Method testMethod, @NotNull PhpClass testClass) {
        if (testMethod == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(22);
        }
        if (testClass == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(23);
        }
        String string = "(" + StreamEx.of(PhpUnitExecutionUtil.collectMethodDependencies(testMethod, testClass)).append((Object)testMethod).map(m -> testClass.getPresentableFQN() + "::" + m.getName()).joining((CharSequence)"|") + ")";
        if (string == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static Collection<Method> collectMethodDependencies(@NotNull Method testMethod, @NotNull PhpClass testClass) {
        if (testMethod == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(25);
        }
        if (testClass == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(26);
        }
        String testNamespace = testClass.getNamespaceName();
        String testClassFQN = testClass.getFQN();
        ArrayDeque<Method> dependencies = new ArrayDeque<Method>();
        dependencies.addLast(testMethod);
        HashSet<Method> visited = new HashSet<Method>();
        while (!dependencies.isEmpty()) {
            PhpDocTag[] tags2;
            Method currentMethod = (Method)dependencies.pollFirst();
            if (!visited.add(currentMethod)) continue;
            PhpDocComment docComment = currentMethod.getDocComment();
            for (PhpDocTag tag : tags2 = docComment != null ? docComment.getTagElementsByName(DEPENDS_TAG) : PhpDocTag.EMPTY_ARRAY) {
                Pair<String, String> dependencyPair = PhpUnitUtil.getClassFqnAndMethodName((PhpDocRef)PsiTreeUtil.getChildOfType((PsiElement)tag, PhpDocRef.class), testNamespace);
                String dependencyClassFQN = (String)dependencyPair.getFirst();
                String dependencyMethodName = (String)dependencyPair.getSecond();
                if (dependencyMethodName == null || dependencyClassFQN != null && PhpLangUtil.compareFQN(dependencyClassFQN, testClassFQN) != 0) continue;
                ContainerUtil.addIfNotNull(dependencies, (Object)testClass.findOwnMethodByName((CharSequence)dependencyMethodName));
            }
        }
        visited.remove(testMethod);
        HashSet<Method> hashSet = visited;
        if (hashSet == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(27);
        }
        return hashSet;
    }

    @NotNull
    public static String concatenateTests(@NotNull Collection<? extends PhpUnitTestPattern> testPatterns) {
        if (testPatterns == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(28);
        }
        Map<String, Collection<String>> testMap = PhpUnitExecutionUtil.collectArgumentsForCommandLine(testPatterns);
        int size = testMap.size();
        StringBuilder builder = new StringBuilder(size * 10);
        int added = 0;
        for (Map.Entry<String, Collection<String>> entry : testMap.entrySet()) {
            ++added;
            builder.append(entry.getKey());
            if (entry.getValue().isEmpty()) {
                builder.append("::").append("(.*)");
            } else if (entry.getValue().size() == 1) {
                builder.append("::").append(entry.getValue().iterator().next());
            } else {
                entry.getValue().size();
                builder.append("::(").append(StringUtil.join(entry.getValue(), (String)"|")).append(")");
            }
            if (added >= size) continue;
            builder.append("|");
        }
        Object testNames = builder.toString();
        if (size > 1) {
            testNames = "(" + (String)testNames + ")";
        }
        String string = testNames;
        if (string == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static Map<String, Collection<String>> collectArgumentsForCommandLine(@NotNull Collection<? extends PhpUnitTestPattern> testPatterns) {
        if (testPatterns == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(30);
        }
        Map map = StreamEx.of(testPatterns).groupingBy(PhpUnitTestPattern::getClassFqn, Collectors.toSet());
        for (PhpUnitTestPattern phpUnitTestPattern : testPatterns) {
            if (StringUtil.isEmpty((String)phpUnitTestPattern.getMethodName())) {
                map.put(phpUnitTestPattern.getClassFqn(), Collections.emptySet());
                continue;
            }
            if (!StringUtil.isEmpty((String)phpUnitTestPattern.getDataSet())) continue;
            map.put(phpUnitTestPattern.getClassFqn(), PhpUnitExecutionUtil.removePatternsWithDataSetsByMethodName(phpUnitTestPattern.getMethodName(), (Set)map.get(phpUnitTestPattern.getClassFqn())));
        }
        Map map2 = StreamEx.of(map.keySet()).toMap(StringUtil::escapeBackSlashes, k -> ContainerUtil.map((Collection)((Collection)map.get(k)), PhpUnitExecutionUtil::formatMethodPatternForCommandLine));
        if (map2 == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(31);
        }
        return map2;
    }

    @NotNull
    public static Set<PhpUnitTestPattern> removePatternsWithDataSetsByMethodName(@NotNull String methodName, @NotNull Set<PhpUnitTestPattern> patterns) {
        if (methodName == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(32);
        }
        if (patterns == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(33);
        }
        Set set = ((StreamEx)StreamEx.of(patterns).remove(p -> StringUtil.isNotEmpty((String)p.getDataSet()) && StringUtil.equals((CharSequence)methodName, (CharSequence)p.getMethodName()))).toSet();
        if (set == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(34);
        }
        return set;
    }

    @NotNull
    private static String formatMethodPatternForCommandLine(@NotNull PhpUnitTestPattern pattern) {
        if (pattern == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(35);
        }
        assert (StringUtil.isNotEmpty((String)pattern.getMethodName()));
        StringBuilder sb = new StringBuilder();
        sb.append(pattern.getMethodName());
        String dataSet = pattern.getDataSet();
        if (StringUtil.isNotEmpty((String)dataSet)) {
            sb.append(" with data set ");
            sb.append((String)(dataSet.startsWith("#") ? dataSet : "\"" + StringUtil.escapeToRegexp((String)StringUtil.unquoteString((String)dataSet)) + "\""));
        } else {
            sb.append("( .*)?$");
        }
        String string = sb.toString();
        if (string == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 19: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 19: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: 
            case 4: 
            case 19: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitExecutionUtil";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 16: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethod";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testPatterns";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitExecutionUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpUnitHelperScriptFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodWithDependenciesFilterArgument";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependenciesMethodNamesArgument";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMethodDependencies";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "concatenateTests";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "collectArgumentsForCommandLine";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "removePatternsWithDataSetsByMethodName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethodPatternForCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 3: 
            case 4: 
            case 19: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillBootstrapAndConfigurationOptions";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillPhpUnitTestRunnerArguments";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fillCommandArguments";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addFilePathArgument";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createFilterArgument";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createMethodWithDependenciesFilterArgument";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createDependenciesMethodNamesArgument";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectMethodDependencies";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "concatenateTests";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectArgumentsForCommandLine";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removePatternsWithDataSetsByMethodName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "formatMethodPatternForCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 19: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

