/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.phpunit.codeGeneration.PhpNewTestDialog;
import com.jetbrains.php.roots.PhpPsrNamespaceRootDetector;
import com.jetbrains.php.roots.PhpSourceRootTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="PHPUnit", storages={@Storage(value="phpunit.xml")})
public class PhpUnitDirectoriesManager
implements PersistentStateComponent<State> {
    @NotNull
    private static final List<String> DEFAULT_DIRECTORIES = ContainerUtil.immutableList(Collections.emptyList());
    @NotNull
    private final Project myProject;
    @NotNull
    private State myState;

    public PhpUnitDirectoriesManager(@NotNull Project project) {
        if (project == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myProject = project;
    }

    @NotNull
    public static PhpUnitDirectoriesManager getInstance(@NotNull Project project) {
        if (project == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(1);
        }
        PhpUnitDirectoriesManager phpUnitDirectoriesManager = (PhpUnitDirectoriesManager)ServiceManager.getService((Project)project, PhpUnitDirectoriesManager.class);
        if (phpUnitDirectoriesManager == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(2);
        }
        return phpUnitDirectoriesManager;
    }

    public boolean hasDirectory(@NotNull String directory) {
        if (directory == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(3);
        }
        return ContainerUtil.exists(this.getDirectories(), testDirectory -> FileUtil.pathsEqual((String)testDirectory, (String)directory));
    }

    @NotNull
    public List<String> getDefaultDirectories() {
        List<String> list = DEFAULT_DIRECTORIES;
        if (list == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<String> getDirectories() {
        List<String> list = !this.myState.getDirectories().isEmpty() ? this.myState.getDirectories() : DEFAULT_DIRECTORIES;
        if (list == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void setDirectories(@NotNull List<String> directories) {
        if (directories == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(6);
        }
        this.myState.setDirectories(directories);
    }

    public void updateDirectories(@NotNull List<String> directories) {
        if (directories == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(7);
        }
        this.setDirectories(directories);
        PhpPsrNamespaceRootDetector.addSourceRoots(this.myProject, PhpUnitDirectoriesManager.getTestRoots(this.myProject, directories));
    }

    @NotNull
    private static List<PhpSourceRootTemplate> getTestRoots(@NotNull Project project, @NotNull List<String> directories) {
        if (project == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(8);
        }
        if (directories == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(9);
        }
        ArrayList<PhpSourceRootTemplate> roots = new ArrayList<PhpSourceRootTemplate>();
        Set<String> filePaths = PhpNewTestDialog.getExistedSourceRootPaths(project);
        for (String directory : directories) {
            if (ContainerUtil.exists(filePaths, path -> FileUtil.pathsEqual((String)path, (String)directory))) continue;
            roots.add(PhpSourceRootTemplate.psr4(directory, "", true));
        }
        ArrayList<PhpSourceRootTemplate> arrayList = roots;
        if (arrayList == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(11);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(12);
        }
        this.myState = state;
    }

    public static boolean hasDirectoryPath(@NotNull Collection<String> directories, @NotNull String directory) {
        if (directories == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(13);
        }
        if (directory == null) {
            PhpUnitDirectoriesManager.$$$reportNull$$$0(14);
        }
        return ContainerUtil.exists(directories, path -> FileUtil.pathsEqual((String)path, (String)directory));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitDirectoriesManager";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitDirectoriesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDirectories";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDirectories";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateDirectories";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTestRoots";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasDirectoryPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class State {
        @NotNull
        private List<String> myDirectories = new ArrayList<String>();

        State() {
        }

        @NotNull
        public List<String> getDirectories() {
            List<String> list = this.myDirectories;
            if (list == null) {
                State.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void setDirectories(@NotNull List<String> directories) {
            if (directories == null) {
                State.$$$reportNull$$$0(1);
            }
            this.myDirectories = directories;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.myDirectories.equals(state.myDirectories);
        }

        public int hashCode() {
            return Objects.hash(this.myDirectories);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitDirectoriesManager$State";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectories";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitDirectoriesManager$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDirectories";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

