/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugProcessFactory;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.phpunit.PhpUnitConsoleProperties;
import com.jetbrains.php.phpunit.PhpUnitExecutionUtil;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfiguration;
import com.jetbrains.php.run.PhpDebugRunner;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PhpUnitDebugRunner
extends PhpDebugRunner<PhpUnitLocalRunConfiguration> {
    public PhpUnitDebugRunner() {
        super(PhpUnitLocalRunConfiguration.class);
    }

    @NotNull
    public String getRunnerId() {
        return "PhpUnitDebugRunner";
    }

    @Override
    protected RunContentDescriptor doExecute(@NotNull PhpUnitLocalRunConfiguration runConfiguration, @NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (runConfiguration == null) {
            PhpUnitDebugRunner.$$$reportNull$$$0(0);
        }
        if (state == null) {
            PhpUnitDebugRunner.$$$reportNull$$$0(1);
        }
        if (env == null) {
            PhpUnitDebugRunner.$$$reportNull$$$0(2);
        }
        final Project project = runConfiguration.getProject();
        final PhpDebugExtension debugExtension = PhpProjectConfigurationFacade.getInstance(runConfiguration.getProject()).getInterpreterDebugExtension();
        if (debugExtension == null) {
            throw new ExecutionException(PhpBundle.message("debug.error.unknown.debugger.id", new Object[0]));
        }
        final PhpIncomingDebugConnectionServer debugServer = debugExtension.startLocalDebugServer(project);
        final PhpDebugConnectionManager connectionsManager = debugExtension.createDebugConnectionManager();
        final String sessionId = debugServer.registerSessionHandler(false, connectionsManager).getSessionId();
        try {
            final PhpInterpreter interpreter = runConfiguration.getInterpreter();
            if (interpreter == null) {
                throw new ExecutionException(PhpCommandSettingsBuilder.getInterpreterNotFoundError());
            }
            Map<String, String> commandLineEnv = debugExtension.getDebugEnv(project, false, sessionId);
            PhpCommandSettings command = runConfiguration.createCommand(interpreter, commandLineEnv, true);
            final ProcessHandler processHandler = runConfiguration.createProcessHandler(project, command, PtyCommandLine.isEnabled());
            ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)project);
            final PhpCommandLinePathProcessor pathProcessor = command.getPathProcessor();
            PhpUnitConsoleProperties properties = runConfiguration.createTestConsoleProperties(env.getExecutor(), pathProcessor);
            final ConsoleView console = PhpUnitExecutionUtil.createConsole(project, processHandler, properties);
            runConfiguration.notifyIfTestSuitIsEmpty(project, console, processHandler);
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)project).startSession(env, new XDebugProcessStarter(){

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) {
                    if (session == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PhpUnitDebugRunner.onSessionStart(session, debugServer, sessionId, connectionsManager, project, interpreter, processHandler);
                    PhpDebugDriver driver = debugExtension.getDebugDriver();
                    PhpDebugProcess phpDebugProcess = PhpDebugProcessFactory.forPhpTests(session, sessionId, connectionsManager, driver, console, pathProcessor);
                    if (phpDebugProcess == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return phpDebugProcess;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitDebugRunner$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitDebugRunner$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            processHandler.startNotify();
            return debugSession.getRunContentDescriptor();
        }
        catch (ExecutionException e) {
            debugServer.unregisterSessionHandler(sessionId);
            throw e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/phpunit/PhpUnitDebugRunner";
        objectArray[2] = "doExecute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

