/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.build.events.BuildEventsNls;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpPsiChooserDialog<DialogElement extends PsiElement>
extends DialogWrapper {
    private final Comparator<DialogElement> ELEMENTS_NAME_COMPARATOR = (element1, element2) -> this.getElementName(element1).compareToIgnoreCase(this.getElementName(element2));
    private final SortedListModel<DialogElement> myListModel = new SortedListModel(this.ELEMENTS_NAME_COMPARATOR);
    private final JList<DialogElement> myList = new JBList(this.myListModel);
    private final JPanel myWholePanel = new JPanel(new BorderLayout());

    public abstract Collection<DialogElement> getList();

    public abstract DialogElement getInstanceByName(String var1);

    public PhpPsiChooserDialog(JComponent parent, @BuildEventsNls.Title String title) {
        super((Component)parent, false);
        this.setTitle(title);
    }

    @NlsSafe
    protected abstract String getElementName(@NotNull DialogElement var1);

    public void initialization(Condition<DialogElement> filter, @Nullable String initialSelection) {
        this.createList(this.getList(), filter);
        this.myWholePanel.add(ScrollPaneFactory.createScrollPane(this.myList));
        this.myList.setCellRenderer((ListCellRenderer<DialogElement>)SimpleListCellRenderer.create((String)"", o -> this.getElementName(o)));
        this.myList.setSelectionMode(0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpPsiChooserDialog.this.close(0);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/phpunit/PhpPsiChooserDialog$1", "onDoubleClick"));
            }
        }.installOn(this.myList);
        int index = this.getIndexToSelect(initialSelection);
        if (index == -1) {
            this.myList.clearSelection();
        } else {
            ScrollingUtil.selectItem(this.myList, (int)index);
        }
        this.init();
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PhpPsiChooserDialog.this.updateOkAction();
            }
        });
        this.updateOkAction();
    }

    private void updateOkAction() {
        this.setOKActionEnabled(this.myList.getSelectedIndex() != -1);
    }

    private int getIndexToSelect(@Nullable String name) {
        if (StringUtil.isEmpty((String)name)) {
            return -1;
        }
        DialogElement element = this.getInstanceByName(name);
        if (element == null) {
            return -1;
        }
        return this.myListModel.indexOf(element);
    }

    private void createList(Collection<DialogElement> elements, Condition<DialogElement> filter) {
        for (PsiElement element : elements) {
            if (!filter.value((Object)element)) continue;
            this.myListModel.add((Object)element);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myWholePanel;
    }

    public DialogElement getSelectedElement() {
        return (DialogElement)((PsiElement)this.myList.getSelectedValue());
    }
}

