/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.phar.PharFileSystem;
import com.jetbrains.php.phar.PharFileType;
import com.jetbrains.php.phar.PharLibraryManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPharFileNode
extends PsiFileNode {
    public PsiPharFileNode(Project project, @NotNull PsiFile value, ViewSettings viewSettings) {
        if (value == null) {
            PsiPharFileNode.$$$reportNull$$$0(0);
        }
        super(project, value, viewSettings);
    }

    public Collection<AbstractTreeNode<?>> getChildrenImpl() {
        PsiDirectory psiDirectory;
        Project project;
        VirtualFile pharRoot = this.getPharRoot();
        if (pharRoot != null && (project = this.getProject()) != null && (psiDirectory = PsiManager.getInstance((Project)project).findDirectory(pharRoot)) != null) {
            return ProjectViewDirectoryHelper.getInstance((Project)project).getDirectoryChildren(psiDirectory, this.getSettings(), true);
        }
        return Collections.singletonList(new ProjectViewNode<Object>(this.myProject, new Object(), this.getSettings()){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return false;
            }

            @NotNull
            public Collection<? extends AbstractTreeNode<?>> getChildren() {
                List list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            protected void update(@NotNull PresentationData presentation) {
                if (presentation == null) {
                    1.$$$reportNull$$$0(2);
                }
                presentation.setPresentableText(PhpBundle.message("phar.failed.to.parse", new Object[0]));
                presentation.setAttributesKey(CodeInsightColors.WARNINGS_ATTRIBUTES);
                presentation.setIcon(PlatformIcons.WARNING_INTRODUCTION_ICON);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/phar/PsiPharFileNode$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/phar/PsiPharFileNode$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "contains";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Nullable
    private VirtualFile getPharRoot() {
        VirtualFile file = this.getVirtualFile();
        if (file == null || !file.isValid() || !(file.getFileType() instanceof PharFileType)) {
            return null;
        }
        return PharFileSystem.getInstance().getRootByLocal(file);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            PsiPharFileNode.$$$reportNull$$$0(1);
        }
        return super.contains(file) || this.isArchive() && Comparing.equal((Object)VfsUtil.getLocalFile((VirtualFile)file), (Object)this.getVirtualFile());
    }

    public boolean canRepresent(Object element) {
        if (super.canRepresent(element)) {
            return true;
        }
        if (element instanceof VirtualFile) {
            if (((VirtualFile)element).getParent() != null) {
                return false;
            }
            VirtualFile localFile = VfsUtil.getLocalFile((VirtualFile)((VirtualFile)element));
            return !localFile.equals(element) && super.canRepresent((Object)localFile);
        }
        return false;
    }

    private boolean isArchive() {
        VirtualFile file = this.getVirtualFile();
        return file != null && file.isValid() && file.getFileType() instanceof PharFileType;
    }

    protected void updateImpl(@NotNull PresentationData data) {
        if (data == null) {
            PsiPharFileNode.$$$reportNull$$$0(2);
        }
        super.updateImpl(data);
        VirtualFile pharDirectoryFile = this.getPharRoot();
        if (pharDirectoryFile != null) {
            boolean isExcluded;
            Project project = this.getProject();
            boolean bl = isExcluded = project != null && PharLibraryManager.getInstance(project).isExcluded(pharDirectoryFile);
            if (isExcluded) {
                data.setIcon((Icon)new LayeredIcon(new Icon[]{data.getIcon(false), PlatformIcons.EXCLUDED_FROM_COMPILE_ICON}));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phar/PsiPharFileNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

