/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.jetbrains.php.phar.PharFileSystem;
import com.jetbrains.php.phar.PharFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PharRenameHandler
extends PsiElementRenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PharRenameHandler.$$$reportNull$$$0(0);
        }
        return super.isAvailableOnDataContext(dataContext) && PharRenameHandler.getPharFile(dataContext) != null;
    }

    @Nullable
    private static VirtualFile getPharFile(DataContext dataContext) {
        PsiElement psiElement = PharRenameHandler.getElement((DataContext)dataContext);
        if (!(psiElement instanceof PsiDirectory)) {
            return null;
        }
        VirtualFile file = ((PsiDirectory)psiElement).getVirtualFile();
        if (PharFileType.isPhar(file)) {
            return file;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @NotNull DataContext dataContext) {
        VirtualFile phar;
        if (project == null) {
            PharRenameHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            PharRenameHandler.$$$reportNull$$$0(2);
        }
        if ((phar = PharRenameHandler.getPharFile(dataContext)) == null) {
            return;
        }
        VirtualFile localFile = PharFileSystem.getInstance().getLocalByEntry(phar);
        if (localFile == null) {
            return;
        }
        PsiFile localPsiFile = PsiManager.getInstance((Project)project).findFile(localFile);
        if (localPsiFile == null) {
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)editor.getCaretModel().getOffset());
        PharRenameHandler.invoke((PsiElement)localPsiFile, (Project)project, (PsiElement)nameSuggestionContext, (Editor)editor);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            PharRenameHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            PharRenameHandler.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PharRenameHandler.getElement((DataContext)dataContext);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PharRenameHandler.invoke((PsiElement)element, (Project)project, (PsiElement)element, (Editor)editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phar/PharRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

