/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.config.library.PhpAdditionalLibraryManager;
import com.jetbrains.php.phar.PharFileSystem;
import com.jetbrains.php.phar.PharFileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExcludedPharFiles", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class PharLibraryManager
extends PhpAdditionalLibraryManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(PharLibraryManager.class);
    public static final String PHAR_LIBRARY_NAME = "PHARS";
    private final Object EXCLUSION_WRITE_LOCK;
    private volatile Set<VirtualFile> myExcludedFiles;

    public static PharLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            PharLibraryManager.$$$reportNull$$$0(0);
        }
        return (PharLibraryManager)project.getService(PharLibraryManager.class);
    }

    private PharLibraryManager(@NotNull Project project) {
        if (project == null) {
            PharLibraryManager.$$$reportNull$$$0(1);
        }
        super(project, LOG);
        this.EXCLUSION_WRITE_LOCK = new Object();
        this.myExcludedFiles = new HashSet<VirtualFile>();
    }

    public Collection<VirtualFile> getPhars() {
        List<VirtualFile> phars = this.getRoots();
        LOG.trace("myPhars " + phars);
        if (this.myExcludedFiles.isEmpty()) {
            return phars;
        }
        phars = new ArrayList<VirtualFile>(phars);
        phars.removeAll(this.myExcludedFiles);
        return phars;
    }

    @Override
    public void projectOpened() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new MyLocalVirtualFileListener()));
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new PharFileDeletedListener());
        super.projectOpened();
        PharLibraryManager.deleteOldStyleLibrary(this.myProject, PHAR_LIBRARY_NAME);
    }

    public boolean updateProjectLibraryForUpsource() {
        LOG.trace("updateProjectLibraryForUpsource");
        AtomicBoolean changed = new AtomicBoolean(false);
        this.updateProjectLibrary(changed);
        return changed.get();
    }

    @Override
    @NotNull
    protected Collection<VirtualFile> collectRoots() {
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        Collection collection = (Collection)dumbService.runReadActionInSmartMode(() -> {
            if (this.myProject.isDisposed()) {
                return Collections.emptyList();
            }
            Collection files = FileTypeIndex.getFiles((FileType)PharFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            PharFileSystem pharFileSystem = PharFileSystem.getInstance();
            return ContainerUtil.filter((Collection)files, f -> f.getFileSystem() != pharFileSystem);
        });
        if (collection == null) {
            PharLibraryManager.$$$reportNull$$$0(2);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addPatchedRoots(@NotNull Collection<? extends VirtualFile> rootsToAdd, @NotNull List<? super VirtualFile> newRoots) {
        if (rootsToAdd == null) {
            PharLibraryManager.$$$reportNull$$$0(3);
        }
        if (newRoots == null) {
            PharLibraryManager.$$$reportNull$$$0(4);
        }
        PharFileSystem pharFileSystem = PharFileSystem.getInstance();
        for (VirtualFile virtualFile : rootsToAdd) {
            void var5_5;
            if (virtualFile.getFileSystem() != pharFileSystem) {
                VirtualFile virtualFile2 = pharFileSystem.refreshAndFindFileByPath(virtualFile.getPath());
            }
            if (var5_5 == null) continue;
            LOG.trace("Added " + var5_5.getPath());
            newRoots.add((VirtualFile)var5_5);
        }
    }

    @Nullable
    private static VirtualFile getFile(VirtualFileEvent event, Project project) {
        if (project == null || project.isDisposed()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile file = event.getFile();
        if (!PharFileType.isPhar(file)) {
            return null;
        }
        file = PharFileSystem.getInstance().refreshAndFindFileByPath(file.getPath());
        return file;
    }

    public boolean isExcluded(@NotNull VirtualFile pharFile) {
        if (pharFile == null) {
            PharLibraryManager.$$$reportNull$$$0(5);
        }
        return this.myExcludedFiles.contains(pharFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExcluded(VirtualFile @NotNull [] pharFiles, boolean excluded) {
        if (pharFiles == null) {
            PharLibraryManager.$$$reportNull$$$0(6);
        }
        if (LOG.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("SetExcluded ").append(excluded).append('\n');
            for (VirtualFile file : pharFiles) {
                stringBuilder.append(file.getPath()).append('\n');
            }
            LOG.trace(stringBuilder.toString());
        }
        Object object = this.EXCLUSION_WRITE_LOCK;
        synchronized (object) {
            HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>(this.myExcludedFiles);
            if (excluded) {
                ContainerUtil.addAll(excludedFiles, (Object[])pharFiles);
            } else {
                ContainerUtil.removeAll(excludedFiles, (Object[])pharFiles);
            }
            this.myExcludedFiles = excludedFiles;
        }
        PharLibraryManager.fireLibraryChanged(this.myProject);
    }

    public State getState() {
        return new State(this.myExcludedFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        if (state == null) {
            PharLibraryManager.$$$reportNull$$$0(7);
        }
        HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>();
        PharFileSystem pharFileSystem = PharFileSystem.getInstance();
        for (String path : state.getPaths()) {
            VirtualFile excludedPhar = pharFileSystem.findFileByPath(path);
            if (excludedPhar == null) continue;
            excludedFiles.add(excludedPhar);
        }
        Object object = this.EXCLUSION_WRITE_LOCK;
        synchronized (object) {
            this.myExcludedFiles = excludedFiles;
        }
        if (LOG.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Loaded state ").append('\n');
            for (VirtualFile file : this.myExcludedFiles) {
                stringBuilder.append(file.getPath()).append('\n');
            }
            LOG.trace(stringBuilder.toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phar/PharLibraryManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToAdd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pharFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pharFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phar/PharLibraryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPatchedRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setExcluded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PharFileDeletedListener
    implements VirtualFileListener,
    BulkFileListener {
        private PharFileDeletedListener() {
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                PharFileDeletedListener.$$$reportNull$$$0(0);
            }
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                this.onFileDelete(((VFileDeleteEvent)vFileEvent).getFile());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onFileDelete(@NotNull VirtualFile realPharFile) {
            if (realPharFile == null) {
                PharFileDeletedListener.$$$reportNull$$$0(1);
            }
            if (!realPharFile.getFileSystem().getProtocol().equals("phar")) {
                return;
            }
            LOG.trace("FileDeleted in phar " + realPharFile.getPath());
            Object object = PharLibraryManager.this.EXCLUSION_WRITE_LOCK;
            synchronized (object) {
                HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>(PharLibraryManager.this.myExcludedFiles);
                excludedFiles.remove(realPharFile);
                PharLibraryManager.this.myExcludedFiles = excludedFiles;
            }
            PharLibraryManager.this.modifyLibraries(null, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "realPharFile";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/phar/PharLibraryManager$PharFileDeletedListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFileDelete";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyLocalVirtualFileListener
    implements VirtualFileListener {
        private MyLocalVirtualFileListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                MyLocalVirtualFileListener.$$$reportNull$$$0(0);
            }
            if (!"name".equals(event.getPropertyName())) {
                return;
            }
            VirtualFile file = event.getFile();
            if (!PharFileType.isPhar(file)) {
                return;
            }
            LOG.trace("Property changed on " + file.getPath());
            VirtualFile realPharFile = PharFileSystem.getInstance().refreshAndFindFileByPath(file.getPath());
            if (realPharFile == null) {
                LOG.warn("Failed to find phar file on '" + file.getPath() + "'");
                return;
            }
            Object object = PharLibraryManager.this.EXCLUSION_WRITE_LOCK;
            synchronized (object) {
                for (VirtualFile excludedFile : PharLibraryManager.this.myExcludedFiles) {
                    if (!this.matches(excludedFile, file.getParent(), (String)event.getOldValue())) continue;
                    LOG.trace("Should exclude");
                    HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>(PharLibraryManager.this.myExcludedFiles);
                    excludedFiles.add(realPharFile);
                    PharLibraryManager.this.myExcludedFiles = excludedFiles;
                    break;
                }
            }
            PharLibraryManager.this.modifyLibraries(realPharFile, false);
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            VirtualFile file;
            if (event == null) {
                MyLocalVirtualFileListener.$$$reportNull$$$0(1);
            }
            if ((file = PharLibraryManager.getFile(event, PharLibraryManager.this.myProject)) == null) {
                return;
            }
            LOG.trace("FileCreated " + file.getPath());
            PharLibraryManager.this.modifyLibraries(file, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            VirtualFile file;
            if (event == null) {
                MyLocalVirtualFileListener.$$$reportNull$$$0(2);
            }
            if (!PharFileType.isPhar(file = event.getFile())) {
                return;
            }
            VirtualFile realPharFile = PharFileSystem.getInstance().refreshAndFindFileByPath(file.getPath());
            if (realPharFile == null) {
                LOG.warn("Failed to find phar file on '" + file.getPath() + "'");
                return;
            }
            LOG.trace("FileMoved " + realPharFile.getPath());
            Object object = PharLibraryManager.this.EXCLUSION_WRITE_LOCK;
            synchronized (object) {
                LOG.trace("OldParent path " + event.getOldParent().getPath());
                for (VirtualFile excludedFile : PharLibraryManager.this.myExcludedFiles) {
                    if (!this.matches(excludedFile, event.getOldParent(), file.getName())) continue;
                    LOG.trace("Should exclude");
                    HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>(PharLibraryManager.this.myExcludedFiles);
                    excludedFiles.add(realPharFile);
                    PharLibraryManager.this.myExcludedFiles = excludedFiles;
                    break;
                }
            }
            PharLibraryManager.this.modifyLibraries(file, false);
        }

        private boolean matches(VirtualFile pharFile, VirtualFile localParent, @NotNull String name) {
            if (name == null) {
                MyLocalVirtualFileListener.$$$reportNull$$$0(3);
            }
            if (!name.equals(pharFile.getName())) {
                return false;
            }
            String path = pharFile.getPath();
            String parentPath = PathUtil.getParentPath((String)path);
            VirtualFile localPharParent = LocalFileSystem.getInstance().refreshAndFindFileByPath(parentPath);
            boolean equals = localParent.equals(localPharParent);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Matches phar " + pharFile.getPath() + ", local parent " + localParent.getPath() + ", name " + name + " " + equals);
            }
            return equals;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            VirtualFile file;
            if (event == null) {
                MyLocalVirtualFileListener.$$$reportNull$$$0(4);
            }
            if (!PharFileType.isPhar(file = event.getFile())) {
                return;
            }
            LOG.trace("FileCopied " + file.getPath());
            PharFileSystem pharFileSystem = PharFileSystem.getInstance();
            VirtualFile realPharFile = pharFileSystem.refreshAndFindFileByPath(file.getPath());
            if (realPharFile == null) {
                LOG.warn("Failed to find phar file on '" + file.getPath() + "'");
                return;
            }
            VirtualFile realOriginalPhar = pharFileSystem.refreshAndFindFileByPath(event.getOriginalFile().getPath());
            if (realOriginalPhar != null) {
                Object object = PharLibraryManager.this.EXCLUSION_WRITE_LOCK;
                synchronized (object) {
                    if (PharLibraryManager.this.myExcludedFiles.contains(realOriginalPhar)) {
                        LOG.trace("Should exclude");
                        HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>(PharLibraryManager.this.myExcludedFiles);
                        excludedFiles.add(realOriginalPhar);
                        PharLibraryManager.this.myExcludedFiles = excludedFiles;
                    }
                }
            }
            PharLibraryManager.this.modifyLibraries(realPharFile, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/phar/PharLibraryManager$MyLocalVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        private List<String> myPaths = new ArrayList<String>();

        public State() {
        }

        public State(Collection<? extends VirtualFile> files) {
            for (VirtualFile virtualFile : files) {
                this.myPaths.add(virtualFile.getPath());
            }
        }

        @XCollection(propertyElementName="excludedPaths", elementName="path")
        public List<String> getPaths() {
            return this.myPaths;
        }

        public void setPaths(List<String> paths) {
            this.myPaths = paths;
        }
    }

    public static class PharStartupActivity
    implements StartupActivity.DumbAware {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                PharStartupActivity.$$$reportNull$$$0(0);
            }
            PharLibraryManager.getInstance(project).projectOpened();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/phar/PharLibraryManager$PharStartupActivity", "runActivity"));
        }
    }
}

