/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.jetbrains.php.phar.PharCompression;
import com.jetbrains.php.phar.PharHandler;
import com.jetbrains.php.phar.TarHandler;
import org.jetbrains.annotations.NotNull;

public class PharHandlers {
    public static int fileNameEndIndex(@NotNull String path) {
        if (path == null) {
            PharHandlers.$$$reportNull$$$0(0);
        }
        path = FileUtil.toSystemIndependentName((String)path);
        int p = path.indexOf(".phar");
        while (p > 0) {
            if ((p += ".phar".length()) == path.length() || path.charAt(p) == '/') {
                return p;
            }
            if (PharHandlers.fileNameEndsWith(path, p, ".gz")) {
                return p + 3;
            }
            if (PharHandlers.fileNameEndsWith(path, p, ".bz2") || PharHandlers.fileNameEndsWith(path, p, ".zip") || PharHandlers.fileNameEndsWith(path, p, ".tar")) {
                return p + 4;
            }
            if (PharHandlers.fileNameEndsWith(path, p, ".tar.gz")) {
                return p + 7;
            }
            if (PharHandlers.fileNameEndsWith(path, p, ".tar.bz2")) {
                return p + 8;
            }
            p = path.indexOf(".phar", p);
        }
        return -1;
    }

    private static boolean fileNameEndsWith(String path, int p, String ext) {
        int end = p + ext.length();
        return path.length() >= end && (path.length() == end || path.charAt(end) == '/') && path.regionMatches(p, ext, 0, ext.length());
    }

    @NotNull
    public static ArchiveHandler create(@NotNull String path) {
        if (path == null) {
            PharHandlers.$$$reportNull$$$0(1);
        }
        if (path.endsWith(".phar")) {
            return new PharHandler(path, PharCompression.NONE);
        }
        if (path.endsWith(".phar.gz")) {
            return new PharHandler(path, PharCompression.GZ);
        }
        if (path.endsWith(".phar.bz2")) {
            return new PharHandler(path, PharCompression.BZ2);
        }
        if (path.endsWith(".phar.tar")) {
            return new TarHandler(path, PharCompression.NONE);
        }
        if (path.endsWith(".phar.tar.gz")) {
            return new TarHandler(path, PharCompression.GZ);
        }
        if (path.endsWith(".phar.tar.bz2")) {
            return new TarHandler(path, PharCompression.BZ2);
        }
        if (path.endsWith(".phar.zip")) {
            return new ZipHandler(path);
        }
        throw new IllegalArgumentException("Unsupported format: " + path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "path";
        objectArray2[1] = "com/jetbrains/php/phar/PharHandlers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fileNameEndIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

