/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.jetbrains.php.phar.PharCompression;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jetbrains.annotations.NotNull;

abstract class PharHandlerBase
extends ArchiveHandler {
    private static final String TEMP_DIR = "phar";
    protected final PharCompression myCompression;

    protected PharHandlerBase(@NotNull String path, @NotNull PharCompression compression) {
        if (path == null) {
            PharHandlerBase.$$$reportNull$$$0(0);
        }
        if (compression == null) {
            PharHandlerBase.$$$reportNull$$$0(1);
        }
        super(path);
        this.myCompression = compression;
    }

    public byte @NotNull [] contentsToByteArray(@NotNull String relativePath) throws IOException {
        byte[] byArray;
        InputStream stream;
        block21: {
            if (relativePath == null) {
                PharHandlerBase.$$$reportNull$$$0(2);
            }
            File file = this.getFile();
            PharCompression compression = this.myCompression;
            if (compression == PharCompression.GZ || compression == PharCompression.BZ2) {
                File copy = PharHandlerBase.getTempFile(file);
                if (!copy.exists() || copy.lastModified() != file.lastModified()) {
                    FileUtil.createParentDirs((File)copy);
                    try (InputStream in = compression.wrapStream(new FileInputStream(file));
                         FileOutputStream out = new FileOutputStream(copy);){
                        FileUtil.copy((InputStream)in, (OutputStream)out);
                    }
                    Files.setLastModifiedTime(copy.toPath(), Files.getLastModifiedTime(file.toPath(), new LinkOption[0]));
                }
                file = copy;
                compression = PharCompression.NONE;
            }
            stream = compression.wrapStream(new FileInputStream(file));
            byArray = this.readContentsFromStream(relativePath, stream);
            if (byArray != null) break block21;
            PharHandlerBase.$$$reportNull$$$0(3);
        }
        return byArray;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected abstract byte @NotNull [] readContentsFromStream(@NotNull String var1, @NotNull InputStream var2) throws IOException;

    public void dispose() {
        super.dispose();
        FileUtil.delete((File)PharHandlerBase.getTempFile(this.getFile()));
    }

    private static File getTempFile(File file) {
        String hash = Integer.toHexString(file.getPath().hashCode());
        return new File(PathManager.getSystemPath() + "/phar/" + file.getName() + "_" + hash);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phar/PharHandlerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phar/PharHandlerBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

