/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.phar.PharCompression;
import com.jetbrains.php.phar.PharHandlerBase;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class PharHandler
extends PharHandlerBase {
    private static final String STUB_END = "__HALT_COMPILER();";
    private static final String STUB_NAME = ".phar/stub.php";
    private static final String META_NAME = ".phar/.metadata.bin";
    private static final String SIGN_NAME = ".phar/signature.bin";
    private static final byte[] SIGN_MAGIC = new byte[]{71, 66, 77, 66};

    PharHandler(@NotNull String path, @NotNull PharCompression compression) {
        if (path == null) {
            PharHandler.$$$reportNull$$$0(0);
        }
        if (compression == null) {
            PharHandler.$$$reportNull$$$0(1);
        }
        super(path, compression);
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        THashMap map = new THashMap();
        File file = this.getFile();
        try (MyInputStream stream = new MyInputStream(this.myCompression.wrapStream(new FileInputStream(file)));){
            long stubLength = PharHandler.readStub(stream);
            long fileStamp = file.lastModified();
            this.processEntry((Map)map, STUB_NAME, (parent, name) -> PharHandler.entry(parent, name, stubLength, fileStamp, 0L, stubLength, 0L));
            long[] manifest = PharHandler.readManifest(stream);
            if (manifest[3] > 0L) {
                this.processEntry((Map)map, META_NAME, (parent, name) -> PharHandler.entry(parent, name, manifest[3], fileStamp, stubLength + manifest[2], manifest[3], 0L));
            }
            long offset = stubLength + manifest[0];
            int i = 0;
            while ((long)i < manifest[1]) {
                long nameLength = stream.readInt();
                if (nameLength <= 0L || nameLength > 4096L) {
                    throw new IOException("Invalid file name length");
                }
                byte[] bytes = FileUtil.loadBytes((InputStream)stream, (int)((int)nameLength));
                String entryName = FileUtilRt.toSystemIndependentName((String)new String(bytes, Charset.defaultCharset()));
                long length = stream.readInt();
                long timestamp = stream.readInt();
                long rawLength = stream.readInt();
                stream.forward(4L);
                long flags = stream.readInt();
                long metadataLength = stream.readInt();
                stream.forward(metadataLength);
                boolean isDirectory = entryName.endsWith("/");
                long _offset = offset;
                this.processEntry((Map)map, entryName, isDirectory ? null : (parent, name) -> PharHandler.entry(parent, name, length, timestamp, _offset, rawLength, flags));
                offset += rawLength;
                ++i;
            }
            stream.forward(offset - stubLength - manifest[0]);
            byte[] signBuf = new byte[256];
            int signLength = stream.read(signBuf);
            if (signLength > 20 && PharHandler.endsWith(signBuf, signLength - SIGN_MAGIC.length, SIGN_MAGIC)) {
                long _offset = offset;
                this.processEntry((Map)map, SIGN_NAME, (parent, name) -> PharHandler.entry(parent, name, signLength, fileStamp, _offset, signLength, 0L));
            }
        }
        THashMap tHashMap = map;
        if (tHashMap == null) {
            PharHandler.$$$reportNull$$$0(2);
        }
        return tHashMap;
    }

    private static PharEntryInfo entry(ArchiveHandler.EntryInfo parent, String name, long length, long timestamp, long offset, long compressed, long flags) {
        return new PharEntryInfo(parent, name, length, timestamp, offset, compressed, PharCompression.fromFlags(flags));
    }

    private static long readStub(MyInputStream stream) throws IOException {
        long length;
        boolean matched = true;
        for (length = 0L; length < 0x100000L; ++length) {
            if (stream.matches(STUB_END)) {
                length += (long)STUB_END.length();
                break;
            }
            if (stream.skip(1L) == 1L) continue;
            matched = false;
            break;
        }
        if (!matched) {
            throw new IOException("Stub end marker missing");
        }
        if (stream.matches(" ?>") || stream.matches("\n?>")) {
            length += 3L;
        }
        if (stream.matches("\r\n")) {
            length += 2L;
        } else if (stream.matches("\n")) {
            ++length;
        }
        return length;
    }

    private static long[] readManifest(MyInputStream stream) throws IOException {
        long manifestLength = stream.readInt();
        if (manifestLength < 18L || manifestLength > 0x100000L) {
            throw new IOException("Invalid manifest size");
        }
        long numFiles = stream.readInt();
        stream.forward(6L);
        long aliasLength = stream.readInt();
        stream.forward(aliasLength);
        long metadataLength = stream.readInt();
        long metadataOffset = 18L + aliasLength + 4L;
        stream.forward(metadataLength);
        if (manifestLength < 18L + numFiles * 24L + aliasLength + metadataLength) {
            throw new IOException("Invalid manifest size");
        }
        return new long[]{manifestLength + 4L, numFiles, metadataOffset, metadataLength};
    }

    private static boolean endsWith(byte[] bytes, int offset, byte[] magic) {
        if (offset + magic.length == bytes.length) {
            for (int i = 0; i < magic.length; ++i) {
                if (bytes[offset + i] == magic[i]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected byte @NotNull [] readContentsFromStream(@NotNull String relativePath, @NotNull InputStream inputStream) throws IOException {
        block9: {
            ArchiveHandler.EntryInfo info;
            if (relativePath == null) {
                PharHandler.$$$reportNull$$$0(3);
            }
            if (inputStream == null) {
                PharHandler.$$$reportNull$$$0(4);
            }
            if ((info = this.getEntryInfo(relativePath)) instanceof PharEntryInfo) {
                byte[] byArray;
                BufferedInputStream stream;
                block10: {
                    long length;
                    byte[] buf;
                    stream = new BufferedInputStream(inputStream);
                    long offset = ((PharEntryInfo)info).offset;
                    if (stream.skip(offset) != offset || (long)(buf = FileUtil.loadBytes((InputStream)stream, (int)((int)(length = ((PharEntryInfo)info).rawLength)))).length != length) break block9;
                    byArray = ((PharEntryInfo)info).format.unpack(buf, info.length);
                    if (byArray != null) break block10;
                    PharHandler.$$$reportNull$$$0(5);
                }
                return byArray;
                finally {
                    stream.close();
                }
            }
        }
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            PharHandler.$$$reportNull$$$0(6);
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compression";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phar/PharHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phar/PharHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentsFromStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readContentsFromStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyInputStream
    extends BufferedInputStream {
        MyInputStream(InputStream stream) {
            super(stream);
        }

        public long readInt() throws IOException {
            long b0 = this.read();
            long b1 = this.read();
            long b2 = this.read();
            long b3 = this.read();
            if (b0 == -1L || b1 == -1L || b2 == -1L || b3 == -1L) {
                throw new IOException("Premature end of file");
            }
            return b3 << 24 | b2 << 16 | b1 << 8 | b0;
        }

        public void forward(long offset) throws IOException {
            while (offset > 0L) {
                long n = super.skip(offset);
                if (n <= 0L) {
                    throw new IOException("Premature end of file");
                }
                offset -= n;
            }
        }

        public boolean matches(String sequence) throws IOException {
            this.mark(sequence.length());
            for (int i = 0; i < sequence.length(); ++i) {
                if (this.read() == sequence.charAt(i)) continue;
                this.reset();
                return false;
            }
            return true;
        }
    }

    private static final class PharEntryInfo
    extends ArchiveHandler.EntryInfo {
        private final long offset;
        private final long rawLength;
        private final PharCompression format;

        private PharEntryInfo(ArchiveHandler.EntryInfo parent, CharSequence shortName, long length, long timestamp, long offset, long rawLength, PharCompression fmt) {
            super(shortName, false, length, timestamp, parent);
            this.offset = offset;
            this.rawLength = rawLength;
            this.format = fmt;
        }
    }
}

