/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.navigation;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import com.jetbrains.php.lang.classAlias.PhpClassAliasIndex;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCaseSensitiveConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassAliasNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInterfaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUseIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableNameIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpGoToSymbolContributor
implements GotoClassContributor,
ChooseByNameContributorEx {
    public void processNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        FileBasedIndex index;
        if (processor == null) {
            PhpGoToSymbolContributor.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            PhpGoToSymbolContributor.$$$reportNull$$$0(1);
        }
        if (!(index = FileBasedIndex.getInstance()).processAllKeys(PhpClassNameIndex.KEY, processor, scope, filter)) {
            return;
        }
        if (!index.processAllKeys(PhpMethodNameIndex.KEY, processor, scope, filter)) {
            return;
        }
        if (!index.processAllKeys(PhpFunctionNameIndex.KEY, processor, scope, filter)) {
            return;
        }
        if (!index.processAllKeys(PhpVariableNameIndex.KEY, processor, scope, filter)) {
            return;
        }
        if (!index.processAllKeys(PhpConstantNameIndex.KEY, processor, scope, filter)) {
            return;
        }
        if (!index.processAllKeys(PhpClassAliasNameIndex.KEY, processor, scope, filter)) {
            return;
        }
        StubIndex stubIndex = StubIndex.getInstance();
        if (!stubIndex.processAllKeys(PhpUseIndex.KEY, processor, scope, filter)) {
            return;
        }
        if (!stubIndex.processAllKeys(PhpFieldIndex.KEY, processor, scope, filter)) {
            return;
        }
        if (!stubIndex.processAllKeys(PhpClassConstantIndex.KEY, processor, scope, filter)) {
            return;
        }
    }

    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        String lcName;
        if (name == null) {
            PhpGoToSymbolContributor.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            PhpGoToSymbolContributor.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            PhpGoToSymbolContributor.$$$reportNull$$$0(4);
        }
        Project project = parameters.getProject();
        GlobalSearchScope scope = parameters.getSearchScope();
        IdFilter filter = parameters.getIdFilter();
        StubIndex stubIndex = StubIndex.getInstance();
        if (!stubIndex.processElements(PhpUseIndex.KEY, (Object)(lcName = StringUtil.toLowerCase((String)name)), project, scope, filter, PhpUse.class, processor)) {
            return;
        }
        if (!stubIndex.processElements(PhpConstantIndex.KEY, (Object)lcName, project, scope, filter, Constant.class, processor)) {
            return;
        }
        if (!stubIndex.processElements(PhpCaseSensitiveConstantIndex.KEY, (Object)name, project, scope, filter, Constant.class, processor)) {
            return;
        }
        if (!stubIndex.processElements(PhpFunctionIndex.KEY, (Object)lcName, project, scope, filter, Function.class, processor)) {
            return;
        }
        if (!stubIndex.processElements(PhpClassIndex.KEY, (Object)lcName, project, scope, filter, PhpClass.class, processor)) {
            return;
        }
        if (!stubIndex.processElements(PhpInterfaceIndex.KEY, (Object)lcName, project, scope, filter, PhpClass.class, processor)) {
            return;
        }
        if (!stubIndex.processElements(PhpTraitIndex.KEY, (Object)lcName, project, scope, filter, PhpClass.class, processor)) {
            return;
        }
        if (!stubIndex.processElements(PhpMethodIndex.KEY, (Object)lcName, project, scope, filter, Method.class, processor)) {
            return;
        }
        if (!stubIndex.processElements(PhpFieldIndex.KEY, (Object)name, project, scope, filter, Field.class, processor)) {
            return;
        }
        if (!stubIndex.processElements(PhpClassConstantIndex.KEY, (Object)name, project, scope, filter, Field.class, processor)) {
            return;
        }
        if (!stubIndex.processElements(PhpVariableIndex.KEY, (Object)name, project, scope, filter, Variable.class, processor)) {
            return;
        }
        ContainerUtil.process((Iterable)PhpClassAliasIndex.getInstance((Project)project).getAliasesByName(name, null, scope), processor);
    }

    @Nullable
    public String getQualifiedName(NavigationItem item) {
        if (item instanceof PhpClass) {
            PhpClass phpClass = (PhpClass)item;
            return phpClass.getFQN();
        }
        if (item instanceof Function) {
            return ((Function)item).getFQN();
        }
        if (item instanceof Field) {
            return ((Field)item).getFQN();
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "\\";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/navigation/PhpGoToSymbolContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementsWithName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

