/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.macro;

import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.run.PhpRunUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExecutableMacro
extends Macro {
    @NotNull
    public String getName() {
        return "PhpExecutable";
    }

    @NotNull
    public String getDescription() {
        String string = PhpBundle.message("php.executable.macro.description", new Object[0]);
        if (string == null) {
            PhpExecutableMacro.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String expand(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PhpExecutableMacro.$$$reportNull$$$0(1);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return PhpExecutableMacro.getPhpCommand(project);
    }

    @NotNull
    public static String getPhpCommand(@Nullable Project project) {
        if (project == null) {
            String string = PhpProjectConfigurationFacade.PHP_EXECUTABLE;
            if (string == null) {
                PhpExecutableMacro.$$$reportNull$$$0(2);
            }
            return string;
        }
        String phpHome = PhpProjectConfigurationFacade.getInstance(project).getPhpHome();
        if (!StringUtil.isEmpty((String)phpHome)) {
            VirtualFile binary = PhpRunUtil.findFileOrDirectory(phpHome, false);
            if (binary != null && binary.isDirectory()) {
                String string = StringUtil.trimEnd((String)FileUtil.toSystemDependentName((String)phpHome), (String)File.separator) + File.separator + PhpProjectConfigurationFacade.PHP_EXECUTABLE;
                if (string == null) {
                    PhpExecutableMacro.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = FileUtil.toSystemDependentName((String)phpHome);
            if (string == null) {
                PhpExecutableMacro.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = PhpProjectConfigurationFacade.PHP_EXECUTABLE;
        if (string == null) {
            PhpExecutableMacro.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/macro/PhpExecutableMacro";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/macro/PhpExecutableMacro";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpCommand";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

