/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.liveTemplates.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.liveTemplates.macro.PhpMacroBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassFQNMacro
extends PhpMacroBase {
    private static final Condition<PsiElement> NON_ANONYMOUS_CLASS = a -> a instanceof PhpClass && !((PhpClass)a).isAnonymous();

    public PhpClassFQNMacro() {
        super("phpQualifiedClassName", "phpQualifiedClassName()");
    }

    @Nullable
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context, boolean quick) {
        PhpClass phpClass;
        if (params == null) {
            PhpClassFQNMacro.$$$reportNull$$$0(0);
        }
        return (phpClass = PhpClassFQNMacro.findClass(context)) != null ? new TextResult(phpClass.getFQN()) : null;
    }

    public static PhpClass findClass(ExpressionContext context) {
        PsiElement elementAt = context.getPsiElementAtStartOffset();
        if (elementAt == null) {
            return null;
        }
        PhpClass aClass = (PhpClass)PhpPsiUtil.getParentByCondition(elementAt, NON_ANONYMOUS_CLASS);
        if (aClass != null) {
            return aClass;
        }
        PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)elementAt.getContainingFile(), PhpFile.class);
        if (file == null) {
            return null;
        }
        return (PhpClass)ContainerUtil.getOnlyItem(PhpPsiUtil.findAllClasses(file));
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        return "FQN";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/php/liveTemplates/macro/PhpClassFQNMacro", "calculateResult"));
    }
}

