/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.liveTemplates;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.highlighter.PhpFileSyntaxHighlighter;
import com.jetbrains.php.lang.lexer.PhpCodeFragmentLexer;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTemplateContextType
extends TemplateContextType {
    protected PhpTemplateContextType(@NotNull @NonNls String id, @NotNull @Nls String presentableName, @Nullable Class<? extends TemplateContextType> baseContextType) {
        if (id == null) {
            PhpTemplateContextType.$$$reportNull$$$0(0);
        }
        if (presentableName == null) {
            PhpTemplateContextType.$$$reportNull$$$0(1);
        }
        super(id, presentableName, baseContextType);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            PhpTemplateContextType.$$$reportNull$$$0(2);
        }
        if (PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset).isKindOf((Language)PhpLanguage.INSTANCE)) {
            PsiElement element = file.findElementAt(offset);
            if (element instanceof PsiWhiteSpace && offset > 0) {
                element = file.findElementAt(offset - 1);
            }
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected abstract boolean isInContext(@NotNull PsiElement var1);

    @NotNull
    public SyntaxHighlighter createHighlighter() {
        return new PhpFileSyntaxHighlighter((Lexer)new PhpCodeFragmentLexer(true, null));
    }

    private static boolean isStringLiteral(@NotNull PsiElement element) {
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(3);
        }
        return PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF) != null;
    }

    private static boolean isComment(@NotNull PsiElement element) {
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(4);
        }
        return PhpPsiUtil.getParentByCondition(element, false, PhpPsiUtil.PSI_COMMENT_INSTANCEOF) != null;
    }

    private static boolean isFunctionParameter(@NotNull PsiElement element) {
        Parameter parameter;
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(5);
        }
        return PhpPsiUtil.getParentByCondition((PsiElement)(parameter = (Parameter)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)Parameter.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)), true, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
    }

    private static boolean isFieldReference(@NotNull PsiElement element) {
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(6);
        }
        return PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)FieldReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
    }

    private static boolean isExpression(@NotNull PsiElement element) {
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(7);
        }
        return PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
    }

    private static boolean isStatement(@NotNull PsiElement element) {
        Statement statement;
        if (element == null) {
            PhpTemplateContextType.$$$reportNull$$$0(8);
        }
        return (statement = (Statement)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)Statement.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF)) != null && statement.getTextRange().getStartOffset() == element.getTextRange().getStartOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/liveTemplates/PhpTemplateContextType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringLiteral";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isComment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionParameter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isFieldReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpTraitMemberTemplateContextType
    extends PhpClassMemberTemplateContextTypeBase {
        protected PhpTraitMemberTemplateContextType() {
            super("PHP Trait Member", PhpBundle.message("live.template.trait.member", new Object[0]), PhpCodeTemplateContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PhpClass phpClass) {
            if (phpClass == null) {
                PhpTraitMemberTemplateContextType.$$$reportNull$$$0(0);
            }
            return phpClass.isTrait();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phpClass", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpTraitMemberTemplateContextType", "isInContext"));
        }
    }

    public static class PhpInterfaceMemberTemplateContextType
    extends PhpClassMemberTemplateContextTypeBase {
        protected PhpInterfaceMemberTemplateContextType() {
            super("PHP Interface Member", PhpBundle.message("live.template.interface.member", new Object[0]), PhpCodeTemplateContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PhpClass phpClass) {
            if (phpClass == null) {
                PhpInterfaceMemberTemplateContextType.$$$reportNull$$$0(0);
            }
            return phpClass.isInterface();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phpClass", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpInterfaceMemberTemplateContextType", "isInContext"));
        }
    }

    public static class PhpClassMemberTemplateContextType
    extends PhpClassMemberTemplateContextTypeBase {
        protected PhpClassMemberTemplateContextType() {
            super("PHP Class Member", PhpBundle.message("live.template.class.member", new Object[0]), PhpCodeTemplateContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PhpClass phpClass) {
            if (phpClass == null) {
                PhpClassMemberTemplateContextType.$$$reportNull$$$0(0);
            }
            return !phpClass.isInterface() && !phpClass.isTrait();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phpClass", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpClassMemberTemplateContextType", "isInContext"));
        }
    }

    private static abstract class PhpClassMemberTemplateContextTypeBase
    extends PhpTemplateContextType {
        protected PhpClassMemberTemplateContextTypeBase(@NotNull String id, @NotNull @Nls String presentableName, @Nullable Class<? extends TemplateContextType> baseContextType) {
            if (id == null) {
                PhpClassMemberTemplateContextTypeBase.$$$reportNull$$$0(0);
            }
            if (presentableName == null) {
                PhpClassMemberTemplateContextTypeBase.$$$reportNull$$$0(1);
            }
            super(id, presentableName, baseContextType);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                PhpClassMemberTemplateContextTypeBase.$$$reportNull$$$0(2);
            }
            return (parent = element.getParent()) instanceof PhpClass && this.isInContext((PhpClass)parent);
        }

        protected abstract boolean isInContext(@NotNull PhpClass var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpClassMemberTemplateContextTypeBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpStatementTemplateContextType
    extends PhpTemplateContextType {
        protected PhpStatementTemplateContextType() {
            super("PHP Statement", PhpBundle.message("live.template.name.statement", new Object[0]), PhpCodeTemplateContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpStatementTemplateContextType.$$$reportNull$$$0(0);
            }
            if (PhpTemplateContextType.isStringLiteral(element) || PhpTemplateContextType.isComment(element)) {
                return false;
            }
            return PhpTemplateContextType.isStatement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpStatementTemplateContextType", "isInContext"));
        }
    }

    public static class PhpExpressionTemplateContextType
    extends PhpTemplateContextType {
        protected PhpExpressionTemplateContextType() {
            super("PHP Expression", PhpBundle.message("live.template.name.expression", new Object[0]), PhpCodeTemplateContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpExpressionTemplateContextType.$$$reportNull$$$0(0);
            }
            if (PhpTemplateContextType.isFunctionParameter(element) || PhpTemplateContextType.isFieldReference(element) || PhpTemplateContextType.isStringLiteral(element) || PhpTemplateContextType.isComment(element)) {
                return false;
            }
            return PhpTemplateContextType.isExpression(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpExpressionTemplateContextType", "isInContext"));
        }
    }

    public static class PhpCommentTemplateContextType
    extends PhpTemplateContextType {
        protected PhpCommentTemplateContextType() {
            super("PHP Comment", PhpBundle.message("live.template.name.comment", new Object[0]), PhpCodeTemplateContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpCommentTemplateContextType.$$$reportNull$$$0(0);
            }
            return PhpTemplateContextType.isComment(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpCommentTemplateContextType", "isInContext"));
        }
    }

    public static class PhpStringLiteralTemplateContextType
    extends PhpTemplateContextType {
        protected PhpStringLiteralTemplateContextType() {
            super("PHP String Literal", PhpBundle.message("live.template.name.string.literal", new Object[0]), PhpCodeTemplateContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpStringLiteralTemplateContextType.$$$reportNull$$$0(0);
            }
            return PhpTemplateContextType.isStringLiteral(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpStringLiteralTemplateContextType", "isInContext"));
        }
    }

    public static class PhpCodeTemplateContextType
    extends PhpTemplateContextType {
        @NlsSafe
        private static final String PHP = "PHP";

        protected PhpCodeTemplateContextType() {
            super(PHP, PHP, EverywhereContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                PhpCodeTemplateContextType.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/liveTemplates/PhpTemplateContextType$PhpCodeTemplateContextType", "isInContext"));
        }
    }
}

