/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantsFromClassArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionValuesFromConstantArguments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExpectedFunctionArgumentsCollector
extends PhpControlFlowUtil.PhpRecursiveInstructionProcessor {
    public static final String POSSIBLE_ARGUMENTS_NAME = "expectedArguments";
    public static final String ARGUMENTS_SET_FUNCTION_NAME = "argumentsSet";
    protected final Map<String, Collection<PhpExpectedFunctionArgument>> myMap;
    protected final Map<String, Collection<PhpExpectedFunctionArgument>> myRegisteredArguments;

    PhpExpectedFunctionArgumentsCollector(Map<String, Collection<PhpExpectedFunctionArgument>> map, Map<String, Collection<PhpExpectedFunctionArgument>> registeredArguments) {
        this.myMap = map;
        this.myRegisteredArguments = registeredArguments;
    }

    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
        FunctionReference targetFunctionReference = this.getMetaFunctionReferenceWithName(instruction, POSSIBLE_ARGUMENTS_NAME);
        if (targetFunctionReference == null) {
            return true;
        }
        PsiElement[] parameters = instruction.getFunctionReference().getParameters();
        if (parameters.length < 3) {
            return true;
        }
        String fqn = PhpExpectedFunctionArgumentsCollector.getFQN(targetFunctionReference);
        if (fqn != null) {
            int argumentIndex = PhpExpectedFunctionArgumentsCollector.getExpectedArgumentIndexValue(parameters[1]);
            Collection<PhpExpectedFunctionArgument> arguments = this.getExpectedArguments(Arrays.copyOfRange(parameters, 2, parameters.length), argumentIndex);
            this.myMap.computeIfAbsent(fqn, k -> new SmartList()).addAll(arguments);
        }
        return super.processPhpCallInstruction(instruction);
    }

    protected FunctionReference getMetaFunctionReferenceWithName(PhpCallInstruction instruction, String name) {
        FunctionReference reference = instruction.getFunctionReference();
        if (!PhpExpectedFunctionArgumentsIndex.metaFunctionWithName(reference, name)) {
            return null;
        }
        return (FunctionReference)ObjectUtils.tryCast((Object)reference.getParameter(0), FunctionReference.class);
    }

    @Nullable
    public static String getFQN(FunctionReference targetFunctionReference) {
        PhpReference classReference;
        if (targetFunctionReference instanceof MethodReference && (classReference = (PhpReference)ObjectUtils.tryCast((Object)((MethodReference)targetFunctionReference).getClassReference(), PhpReference.class)) != null) {
            return PhpCodeInsightUtil.getImmediateFQN(classReference) + "." + targetFunctionReference.getName();
        }
        return PhpCodeInsightUtil.getImmediateFQN((PhpReference)targetFunctionReference);
    }

    protected Collection<PhpExpectedFunctionArgument> getExpectedArguments(PsiElement[] parameters, int argumentIndex) {
        if (argumentIndex < 0) {
            return Collections.emptyList();
        }
        ArrayList<PhpExpectedFunctionArgument> expectedFunctionArguments = new ArrayList<PhpExpectedFunctionArgument>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof FunctionReference) {
                expectedFunctionArguments.addAll(this.getArgumentsFromRegisteredArgumentsSet(argumentIndex, (FunctionReference)parameters[i]));
                continue;
            }
            expectedFunctionArguments.addAll(PhpExpectedFunctionArgumentsIndex.getExpectedFunctionArguments(parameters[i], argumentIndex, i, null));
        }
        return expectedFunctionArguments;
    }

    @NotNull
    private Collection<PhpExpectedFunctionArgument> getArgumentsFromRegisteredArgumentsSet(int argumentIndex, FunctionReference argumentsSet) {
        StringLiteralExpression argumentsSetName;
        if (PhpExpectedFunctionArgumentsIndex.metaFunctionWithName(argumentsSet, ARGUMENTS_SET_FUNCTION_NAME) && (argumentsSetName = (StringLiteralExpression)ObjectUtils.tryCast((Object)argumentsSet.getParameter(0), StringLiteralExpression.class)) != null) {
            List list = ContainerUtil.map(this.getRegisteredArguments(argumentsSetName.getContents()), argument -> PhpExpectedFunctionArgumentsCollector.copyWithIndex(argument, argumentIndex));
            if (list == null) {
                PhpExpectedFunctionArgumentsCollector.$$$reportNull$$$0(0);
            }
            return list;
        }
        Set<PhpExpectedFunctionArgument> set = Collections.emptySet();
        if (set == null) {
            PhpExpectedFunctionArgumentsCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    private Collection<PhpExpectedFunctionArgument> getRegisteredArguments(String name) {
        return this.myRegisteredArguments.getOrDefault(name, Collections.emptyList());
    }

    @NotNull
    public static PhpExpectedFunctionArgument copyWithIndex(@NotNull PhpExpectedFunctionArgument argument, int argumentIndex) {
        if (argument == null) {
            PhpExpectedFunctionArgumentsCollector.$$$reportNull$$$0(2);
        }
        switch (PhpExpectedFunctionArgumentsIndex.getKind(argument)) {
            case CONSTANT: {
                return new PhpExpectedFunctionConstantArgument(argument.getValue(), argumentIndex, argument.getOrder(), argument.getArgumentSet(), argument.isFlag(), argument.isFromAttribute());
            }
            case CLASS_CONSTANT: {
                PhpExpectedFunctionClassConstantArgument classConstantArgument = (PhpExpectedFunctionClassConstantArgument)argument;
                return new PhpExpectedFunctionClassConstantArgument(classConstantArgument.getClassFqn(), classConstantArgument.getConstantName(), argumentIndex, argument.getOrder(), argument.getArgumentSet(), argument.isFlag(), argument.isFromAttribute());
            }
            case CONSTANTS_FROM_CLASS: {
                PhpExpectedFunctionConstantsFromClassArgument constantsFromClassArgument = (PhpExpectedFunctionConstantsFromClassArgument)argument;
                return new PhpExpectedFunctionConstantsFromClassArgument(constantsFromClassArgument.getValue(), argumentIndex, constantsFromClassArgument.isFlag(), argument.isFromAttribute());
            }
            case VALUES_FROM_CONSTANT: {
                PhpExpectedFunctionValuesFromConstantArguments valuesFromConstant = (PhpExpectedFunctionValuesFromConstantArguments)argument;
                return new PhpExpectedFunctionValuesFromConstantArguments(valuesFromConstant.getValue(), argumentIndex, valuesFromConstant.isFlag(), valuesFromConstant.isFromAttribute());
            }
        }
        PhpExpectedFunctionScalarArgument scalarArgument = (PhpExpectedFunctionScalarArgument)argument;
        return new PhpExpectedFunctionScalarArgument(argument.getValue(), argumentIndex, argument.getOrder(), argument.getArgumentSet(), argument.isFlag(), scalarArgument.getType(), argument.isFromAttribute());
    }

    private static int getExpectedArgumentIndexValue(PsiElement expectedArgumentIndex) {
        try {
            return Integer.parseInt(expectedArgumentIndex.getText());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedFunctionArgumentsCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsFromRegisteredArgumentsSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedFunctionArgumentsCollector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyWithIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

