/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpGeneratorsOperandsTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpConstantsArrayShapesDefaultValuesIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrayShapeEntriesIndex
extends FileBasedIndexExtension<String, Collection<PhpArrayShapeEntry>> {
    public static final String ARRAY_SHAPE_ATTRIBUTE_FQN = "\\JetBrains\\PhpStorm\\ArrayShape";
    @NonNls
    public static final ID<String, Collection<PhpArrayShapeEntry>> KEY = ID.create((String)"php.array.shapes.entries");
    public static final DataExternalizer<Collection<PhpArrayShapeEntry>> MY_EXTERNALIZER = new DataExternalizer<Collection<PhpArrayShapeEntry>>(){

        public void save(@NotNull DataOutput out, Collection<PhpArrayShapeEntry> value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (PhpArrayShapeEntry entry : value) {
                PhpExpectedFunctionArgumentsIndex.EXTERNALIZER.save(out, (Object)entry.myKey);
                PhpGeneratorsOperandsTypeIndex.saveType(out, entry.myType);
            }
        }

        public Collection<PhpArrayShapeEntry> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            ArrayList<PhpArrayShapeEntry> res = new ArrayList<PhpArrayShapeEntry>();
            for (int i = 0; i < size; ++i) {
                PhpExpectedFunctionArgument key = (PhpExpectedFunctionArgument)PhpExpectedFunctionArgumentsIndex.EXTERNALIZER.read(in);
                PhpType type = PhpGeneratorsOperandsTypeIndex.readType(in);
                res.add(new PhpArrayShapeEntry(key, type));
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpArrayShapeEntriesIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public ID<String, Collection<PhpArrayShapeEntry>> getName() {
        ID<String, Collection<PhpArrayShapeEntry>> iD = KEY;
        if (iD == null) {
            PhpArrayShapeEntriesIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Collection<PhpArrayShapeEntry>, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            PhpFile phpFile = (PhpFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PhpFile.class);
            if (phpFile == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Collection<PhpArrayShapeEntry>> map = new HashMap<String, Collection<PhpArrayShapeEntry>>();
            for (PhpNamedElement value : phpFile.getTopLevelDefs().values()) {
                if (value instanceof Function) {
                    PhpArrayShapeEntriesIndex.processFunction(map, (Function)value);
                    continue;
                }
                if (!(value instanceof PhpClass)) continue;
                for (Field field : ((PhpClass)value).getOwnFields()) {
                    PhpArrayShapeEntriesIndex.process(map, (PhpNamedElement)field);
                }
                for (Field field : ((PhpClass)value).getOwnMethods()) {
                    PhpArrayShapeEntriesIndex.processFunction(map, (Function)field);
                }
            }
            return map;
        };
        if (dataIndexer == null) {
            PhpArrayShapeEntriesIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    private static void processFunction(Map<String, Collection<PhpArrayShapeEntry>> map, Function function) {
        PhpArrayShapeEntriesIndex.process(map, (PhpNamedElement)function);
        for (Parameter parameter : function.getParameters()) {
            PhpArrayShapeEntriesIndex.process(map, (PhpNamedElement)parameter);
        }
    }

    public static List<PhpArrayShapeEntry> getArrayShapes(Project project, PhpNamedElement element) {
        if (element == null) {
            return Collections.emptyList();
        }
        return FileBasedIndex.getInstance().getValues(KEY, (Object)PhpArrayShapeEntriesIndex.getSignature(element), GlobalSearchScope.allScope((Project)project)).stream().flatMap(Collection::stream).flatMap(e -> PhpArrayShapeEntriesIndex.inlineConstants(project, e)).collect(Collectors.toList());
    }

    private static Stream<PhpArrayShapeEntry> inlineConstants(Project project, PhpArrayShapeEntry entry) {
        if (PhpArrayShapeEntriesIndex.isConstantToBeInlined(entry)) {
            PhpNamedElement element = entry.getKey().getNamedElement(project);
            if (element == null) {
                return Stream.empty();
            }
            return PhpConstantsArrayShapesDefaultValuesIndex.shapes(project, element);
        }
        return Stream.of(entry);
    }

    public static boolean isConstantToBeInlined(@NotNull PhpArrayShapeEntry entry) {
        PhpExpectedFunctionArgument key;
        if (entry == null) {
            PhpArrayShapeEntriesIndex.$$$reportNull$$$0(2);
        }
        return ((key = entry.getKey()) instanceof PhpExpectedFunctionClassConstantArgument || key instanceof PhpExpectedFunctionConstantArgument) && entry.getType().isEmpty();
    }

    private static void process(Map<String, Collection<PhpArrayShapeEntry>> map, PhpNamedElement value) {
        List<PhpArrayShapeEntry> arrayShapes = PhpArrayShapeEntriesIndex.getArrayShapes((PhpAttributesOwner)value);
        if (!arrayShapes.isEmpty()) {
            map.put(PhpArrayShapeEntriesIndex.getSignature(value), arrayShapes);
        }
    }

    public static List<PhpArrayShapeEntry> getArrayShapes(@Nullable PhpAttributesOwner owner) {
        if (owner == null) {
            return Collections.emptyList();
        }
        return owner.getAttributes(ARRAY_SHAPE_ATTRIBUTE_FQN).stream().map(attr -> attr.getParameter(0)).flatMap(PhpArrayShapeEntriesIndex::createShapes).collect(Collectors.toList());
    }

    public static Stream<PhpArrayShapeEntry> createShapes(ArrayCreationExpression array) {
        ArrayList<PhpArrayShapeEntry> res = new ArrayList<PhpArrayShapeEntry>();
        Iterator iterator = ArrayCreationExpressionImpl.children(array).iterator();
        int i = 0;
        while (iterator.hasNext()) {
            PhpPsiElement value;
            PhpPsiElement child = (PhpPsiElement)iterator.next();
            PhpExpectedFunctionArgument key = PhpArrayShapeEntriesIndex.createArrayShapeKeyFromArrayChild(child, i);
            PhpPsiElement phpPsiElement = value = child instanceof ArrayHashElement ? ((ArrayHashElement)child).getValue() : child.getFirstPsiChild();
            if (value instanceof StringLiteralExpression && value.getTextRange().getLength() < 1000) {
                String content = StringUtil.unescapeBackSlashes((String)((StringLiteralExpression)value).getContents());
                res.add(new PhpArrayShapeEntry(key, new PhpType().add(PhpLangUtil.toFQN(content))));
            } else if (value instanceof ClassConstantReference && PhpLangUtil.equalsConstantNames(((ClassConstantReference)value).getName(), "class")) {
                ClassReference classReference = (ClassReference)ObjectUtils.tryCast((Object)((ClassConstantReference)value).getClassReference(), ClassReference.class);
                if (classReference != null) {
                    res.add(new PhpArrayShapeEntry(key, new PhpType().add((PsiElement)classReference)));
                }
            } else {
                return Stream.empty();
            }
            ++i;
        }
        return res.stream();
    }

    @NotNull
    public static PhpExpectedFunctionArgument createArrayShapeKeyFromArrayChild(PhpPsiElement child, int index) {
        if (child instanceof ArrayHashElement) {
            PhpExpectedFunctionArgument phpExpectedFunctionArgument = PhpExpectedFunctionArgumentsIndex.getExpectedArgument((PsiElement)((ArrayHashElement)child).getKey(), 0, 0, null, false);
            if (phpExpectedFunctionArgument == null) {
                PhpArrayShapeEntriesIndex.$$$reportNull$$$0(3);
            }
            return phpExpectedFunctionArgument;
        }
        return new PhpExpectedFunctionScalarArgument(String.valueOf(index), 0, 0, null, false, "\\int", true);
    }

    private static Stream<PhpArrayShapeEntry> createShapes(PsiElement array) {
        if (array instanceof ArrayCreationExpression) {
            return PhpArrayShapeEntriesIndex.createShapes((ArrayCreationExpression)array);
        }
        if (array instanceof ConstantReference || array instanceof ClassConstantReference) {
            PhpExpectedFunctionArgument argument = PhpExpectedFunctionArgumentsIndex.getExpectedArgument(array, 0, 0, null, false);
            return Stream.of(new PhpArrayShapeEntry(argument, PhpType.EMPTY));
        }
        return Stream.empty();
    }

    private static String getSignature(PhpNamedElement value) {
        String fqn = value.getFQN();
        if (value instanceof Field) {
            return PhpTypeSignatureKey.FIELD.sign((CharSequence)fqn);
        }
        if (value instanceof Parameter) {
            return PhpTypeSignatureKey.PARAMETER.sign((CharSequence)fqn) + "." + value.getName();
        }
        return PhpTypeSignatureKey.FUNCTION.sign((CharSequence)fqn);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpArrayShapeEntriesIndex.$$$reportNull$$$0(4);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<PhpArrayShapeEntry>> getValueExternalizer() {
        DataExternalizer<Collection<PhpArrayShapeEntry>> dataExternalizer = MY_EXTERNALIZER;
        if (dataExternalizer == null) {
            PhpArrayShapeEntriesIndex.$$$reportNull$$$0(5);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 2;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpArrayShapeEntriesIndex.$$$reportNull$$$0(6);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpArrayShapeEntriesIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpArrayShapeEntriesIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayShapeKeyFromArrayChild";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConstantToBeInlined";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpArrayShapeEntry {
        @NotNull
        private final PhpExpectedFunctionArgument myKey;
        @NotNull
        private final PhpType myType;

        public PhpArrayShapeEntry(@NotNull PhpExpectedFunctionArgument key, @NotNull PhpType type) {
            if (key == null) {
                PhpArrayShapeEntry.$$$reportNull$$$0(0);
            }
            if (type == null) {
                PhpArrayShapeEntry.$$$reportNull$$$0(1);
            }
            this.myKey = key;
            this.myType = type;
        }

        @NotNull
        public PhpExpectedFunctionArgument getKey() {
            PhpExpectedFunctionArgument phpExpectedFunctionArgument = this.myKey;
            if (phpExpectedFunctionArgument == null) {
                PhpArrayShapeEntry.$$$reportNull$$$0(2);
            }
            return phpExpectedFunctionArgument;
        }

        @NotNull
        public PhpType getType() {
            PhpType phpType = this.myType;
            if (phpType == null) {
                PhpArrayShapeEntry.$$$reportNull$$$0(3);
            }
            return phpType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpArrayShapeEntry entry = (PhpArrayShapeEntry)o;
            return this.myKey.equals((Object)entry.myKey) && this.myType.equals((Object)entry.myType);
        }

        public int hashCode() {
            return Objects.hash(this.myKey, this.myType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpArrayShapeEntriesIndex$PhpArrayShapeEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpArrayShapeEntriesIndex$PhpArrayShapeEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

