/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFlatCollectionIndexBase;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInvokeCallsOffsetsIndex;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PhpSerializeFunctionCallsOffsetsIndex
extends PhpFlatCollectionIndexBase<TIntArrayList> {
    @NonNls
    public static final ID<Boolean, TIntArrayList> KEY = ID.create((String)"php.serialize.function.calls.offsets");

    @NotNull
    public ID<Boolean, TIntArrayList> getName() {
        ID<Boolean, TIntArrayList> iD = KEY;
        if (iD == null) {
            PhpSerializeFunctionCallsOffsetsIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    protected TIntArrayList collectValues(@NotNull PhpFile file) {
        if (file == null) {
            PhpSerializeFunctionCallsOffsetsIndex.$$$reportNull$$$0(1);
        }
        MyFunctionCallsAccessCollector collector = new MyFunctionCallsAccessCollector();
        PhpControlFlowUtil.processFile(file, collector);
        return collector.myList;
    }

    @NotNull
    public DataExternalizer<TIntArrayList> getValueExternalizer() {
        PhpInvokeCallsOffsetsIndex.IntArrayExternalizer intArrayExternalizer = PhpInvokeCallsOffsetsIndex.IntArrayExternalizer.INSTANCE;
        if (intArrayExternalizer == null) {
            PhpSerializeFunctionCallsOffsetsIndex.$$$reportNull$$$0(2);
        }
        return intArrayExternalizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpSerializeFunctionCallsOffsetsIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpSerializeFunctionCallsOffsetsIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFunctionCallsAccessCollector
    extends PhpControlFlowUtil.PhpRecursiveInstructionProcessor {
        private final TIntArrayList myList = new TIntArrayList();

        private MyFunctionCallsAccessCollector() {
        }

        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
            FunctionReference reference = instruction.getFunctionReference();
            if (reference instanceof MethodReference) {
                return true;
            }
            String name = reference.getName();
            if (name == null) {
                return true;
            }
            if (name.equalsIgnoreCase("serialize") || name.equalsIgnoreCase("unserialize")) {
                this.myList.add(reference.getTextRange().getStartOffset());
            }
            return true;
        }
    }
}

