/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.intentions.strings.converters.PhpConcatenationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInvokeCallsOffsetsIndex;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PhpPutEnvArgumentsIndex
extends FileBasedIndexExtension<String, PhpEnvArgument> {
    public static final ID<String, PhpEnvArgument> KEY = ID.create((String)"php.putenv.arguments");

    @NotNull
    public ID<String, PhpEnvArgument> getName() {
        ID<String, PhpEnvArgument> iD = KEY;
        if (iD == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    private static Pair<String, String> getArgumentNameAndValue(@NotNull FunctionReference reference) {
        PsiElement parameter;
        String argumentText;
        int indexOfEquals;
        if (reference == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(1);
        }
        String argumentName = (indexOfEquals = (argumentText = PhpPutEnvArgumentsIndex.getArgumentText(parameter = reference.getParameter(0))).indexOf("=")) >= 0 ? argumentText.substring(0, indexOfEquals) : argumentText;
        String argumentValue = indexOfEquals >= 0 ? argumentText.substring(indexOfEquals + 1) : "";
        Variable type = (Variable)PsiTreeUtil.findChildOfType((PsiElement)parameter, Variable.class);
        if (type != null && type.getText().equals(argumentName)) {
            Pair pair = Pair.create((Object)"", (Object)argumentValue);
            if (pair == null) {
                PhpPutEnvArgumentsIndex.$$$reportNull$$$0(2);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)argumentName, (Object)argumentValue);
        if (pair == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @NotNull
    public DataIndexer<String, PhpEnvArgument, FileContent> getIndexer() {
        return new DataIndexer<String, PhpEnvArgument, FileContent>(){

            @NotNull
            public Map<String, PhpEnvArgument> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                THashMap map = new THashMap();
                PsiFile file = inputData.getPsiFile();
                if (file instanceof PhpFile && file.getText().contains("putenv")) {
                    PhpControlFlowUtil.processFile((PhpFile)file, new PhpControlFlowUtil.PhpRecursiveInstructionProcessor((Map)map){
                        final /* synthetic */ Map val$map;
                        {
                            this.val$map = map;
                        }

                        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                            Pair<String, String> nameAndValue;
                            String argumentName;
                            FunctionReference reference = instruction.getFunctionReference();
                            if (StringUtil.equalsIgnoreCase((CharSequence)reference.getName(), (CharSequence)"putenv") && StringUtil.isNotEmpty((String)(argumentName = (String)(nameAndValue = PhpPutEnvArgumentsIndex.getArgumentNameAndValue(reference)).getFirst()))) {
                                this.val$map.computeIfAbsent(argumentName, s -> new PhpEnvArgument(new TIntArrayList(), (String)nameAndValue.getSecond())).getPutValueOffsets().add(reference.getTextOffset());
                            }
                            return true;
                        }
                    });
                }
                THashMap tHashMap = map;
                if (tHashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return tHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    private static String getArgumentText(PsiElement parameter) {
        if (parameter instanceof StringLiteralExpression) {
            String contents = ((StringLiteralExpression)parameter).getContents();
            String string = ((StringLiteralExpression)parameter).isSingleQuote() ? StringUtil.unescapeBackSlashes((String)contents) : contents;
            if (string == null) {
                PhpPutEnvArgumentsIndex.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (parameter instanceof BinaryExpression && PhpConcatenationStringRepresentationConverter.isConcatenation(parameter)) {
            List<PhpStringPartDescriptor> parts = PhpConcatenationStringRepresentationConverter.INSTANCE.getStringParts((BinaryExpression)parameter, (Editor)null);
            String string = parts.stream().map(descriptor -> PhpPutEnvArgumentsIndex.getArgumentText(descriptor.getElement())).collect(Collectors.joining());
            if (string == null) {
                PhpPutEnvArgumentsIndex.$$$reportNull$$$0(5);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(6);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<PhpEnvArgument> getValueExternalizer() {
        DataExternalizer<PhpEnvArgument> dataExternalizer = PhpEnvArgument.EXTERNALIZER;
        if (dataExternalizer == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(7);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(8);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentNameAndValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentNameAndValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpEnvArgument {
        private static final DataExternalizer<PhpEnvArgument> EXTERNALIZER = new DataExternalizer<PhpEnvArgument>(){

            public void save(@NotNull DataOutput out, PhpEnvArgument value) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                out.writeUTF(value.getValue());
                PhpInvokeCallsOffsetsIndex.IntArrayExternalizer.INSTANCE.save(out, value.getPutValueOffsets());
            }

            public PhpEnvArgument read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                String value = in.readUTF();
                TIntArrayList putValueOffsets = PhpInvokeCallsOffsetsIndex.IntArrayExternalizer.INSTANCE.read(in);
                return new PhpEnvArgument(putValueOffsets, value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex$PhpEnvArgument$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        @NotNull
        private final TIntArrayList myPutValueOffsets;
        @NotNull
        private final String myValue;

        public PhpEnvArgument(@NotNull TIntArrayList putValueOffsets, @NotNull String value) {
            if (putValueOffsets == null) {
                PhpEnvArgument.$$$reportNull$$$0(0);
            }
            if (value == null) {
                PhpEnvArgument.$$$reportNull$$$0(1);
            }
            this.myPutValueOffsets = putValueOffsets;
            this.myValue = value;
        }

        @NotNull
        public TIntArrayList getPutValueOffsets() {
            TIntArrayList tIntArrayList = this.myPutValueOffsets;
            if (tIntArrayList == null) {
                PhpEnvArgument.$$$reportNull$$$0(2);
            }
            return tIntArrayList;
        }

        @NotNull
        public String getValue() {
            String string = this.myValue;
            if (string == null) {
                PhpEnvArgument.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpEnvArgument argument = (PhpEnvArgument)o;
            return this.myPutValueOffsets.equals((Object)argument.myPutValueOffsets) && this.myValue.equals(argument.myValue);
        }

        public int hashCode() {
            return Objects.hash(this.myPutValueOffsets, this.myValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "putValueOffsets";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex$PhpEnvArgument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex$PhpEnvArgument";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPutValueOffsets";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

