/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.util.PhpStringUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParametersDefaultValueMatchersIndex
extends FileBasedIndexExtension<String, TIntObjectHashMap<PhpParameterDefaultValueMatcher>> {
    @NonNls
    private static final ID<String, TIntObjectHashMap<PhpParameterDefaultValueMatcher>> KEY = ID.create((String)"php.parameters.default.value.matchers");
    public static final MyDefaultValueMatcherExternalizer MATCHER_EXTERNALIZER = new MyDefaultValueMatcherExternalizer();
    public static final MyExternalizer EXTERNALIZER = new MyExternalizer();
    public static final TIntObjectHashMap<PhpParameterDefaultValueMatcher> EMPTY = new TIntObjectHashMap();

    @NotNull
    public ID<String, TIntObjectHashMap<PhpParameterDefaultValueMatcher>> getName() {
        ID<String, TIntObjectHashMap<PhpParameterDefaultValueMatcher>> iD = KEY;
        if (iD == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, TIntObjectHashMap<PhpParameterDefaultValueMatcher>, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> PhpFuncGetArgUsageProvider.findTopLevelFunctions(inputData.getPsiFile()).mapToEntry(PhpNamedElement::getFQN, e -> PhpParametersDefaultValueMatchersIndex.getDefaultValueMatchers(e.getParameters())).filterValues(e -> !e.isEmpty()).distinctKeys().toMap();
        if (dataIndexer == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    private static TIntObjectHashMap<PhpParameterDefaultValueMatcher> getDefaultValueMatchers(Parameter @NotNull [] parameters) {
        if (parameters == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(2);
        }
        TIntObjectHashMap res = new TIntObjectHashMap();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            PsiElement defaultValue = parameter.isOptional() ? parameter.getDefaultValue() : null;
            PhpParameterDefaultValueMatcher matcher = PhpParametersDefaultValueMatchersIndex.createDefaultValueMatcher(defaultValue);
            if (matcher == null) continue;
            res.put(i, (Object)matcher);
        }
        TIntObjectHashMap tIntObjectHashMap = res;
        if (tIntObjectHashMap == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(3);
        }
        return tIntObjectHashMap;
    }

    @Nullable
    protected static PhpParameterDefaultValueMatcher createDefaultValueMatcher(@Nullable PsiElement parameter) {
        if (parameter instanceof StringLiteralExpression) {
            String text = PhpStringUtil.unescapeText((StringLiteralExpression)parameter);
            if (text.length() > 1000) {
                return null;
            }
            return new PhpParameterStringDefaultValueMatcher(text);
        }
        if (PhpLangUtil.isNull(parameter)) {
            return PhpParameterNullDefaultValueMatcher.INSTANCE;
        }
        if (PhpPsiUtil.isOfType(parameter, PhpElementTypes.NUMBER)) {
            return new PhpParameterNumberDefaultValueMatcher(parameter.getText());
        }
        if (parameter instanceof ConstantReference || parameter instanceof ClassConstantReference && ((ClassConstantReference)parameter).getClassReference() instanceof ClassReference) {
            return new PhpParameterConstantDefaultValueMatcher(((PhpReference)parameter).getSignature());
        }
        return null;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(4);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<TIntObjectHashMap<PhpParameterDefaultValueMatcher>> getValueExternalizer() {
        MyExternalizer myExternalizer = EXTERNALIZER;
        if (myExternalizer == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(5);
        }
        return myExternalizer;
    }

    public int getVersion() {
        return 1;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(6);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public static List<TIntObjectHashMap<PhpParameterDefaultValueMatcher>> getParameterDefaultValuesMatchers(@NotNull Function function) {
        if (function == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(7);
        }
        Project project = function.getProject();
        List list = FileBasedIndex.getInstance().getValues(KEY, (Object)function.getFQN(), GlobalSearchScope.allScope((Project)project));
        if (list == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueMatchers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterDefaultValuesMatchers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValueMatchers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParameterDefaultValuesMatchers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpParameterConstantDefaultValueMatcher
    implements PhpParameterDefaultValueMatcher {
        @NotNull
        private final String mySignature;

        private PhpParameterConstantDefaultValueMatcher(@NotNull String signature) {
            if (signature == null) {
                PhpParameterConstantDefaultValueMatcher.$$$reportNull$$$0(0);
            }
            this.mySignature = signature;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpParameterConstantDefaultValueMatcher matcher = (PhpParameterConstantDefaultValueMatcher)o;
            return this.mySignature.equals(matcher.mySignature);
        }

        @Override
        @NotNull
        public String getValue() {
            String string = this.mySignature;
            if (string == null) {
                PhpParameterConstantDefaultValueMatcher.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int hashCode() {
            return Objects.hash(this.mySignature);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterConstantDefaultValueMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterConstantDefaultValueMatcher";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpParameterNumberDefaultValueMatcher
    implements PhpParameterDefaultValueMatcher {
        @NotNull
        private final String myText;

        private PhpParameterNumberDefaultValueMatcher(@NotNull String text) {
            if (text == null) {
                PhpParameterNumberDefaultValueMatcher.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpParameterNumberDefaultValueMatcher matcher = (PhpParameterNumberDefaultValueMatcher)o;
            return this.myText.equals(matcher.myText);
        }

        @Override
        @NotNull
        public String getValue() {
            String string = this.myText;
            if (string == null) {
                PhpParameterNumberDefaultValueMatcher.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int hashCode() {
            return Objects.hash(this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterNumberDefaultValueMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterNumberDefaultValueMatcher";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpParameterStringDefaultValueMatcher
    implements PhpParameterDefaultValueMatcher {
        @NotNull
        private final String myStringUnescapedText;

        private PhpParameterStringDefaultValueMatcher(@NotNull String text) {
            if (text == null) {
                PhpParameterStringDefaultValueMatcher.$$$reportNull$$$0(0);
            }
            this.myStringUnescapedText = text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpParameterStringDefaultValueMatcher matcher = (PhpParameterStringDefaultValueMatcher)o;
            return this.myStringUnescapedText.equals(matcher.myStringUnescapedText);
        }

        @Override
        @NotNull
        public String getValue() {
            String string = this.myStringUnescapedText;
            if (string == null) {
                PhpParameterStringDefaultValueMatcher.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int hashCode() {
            return Objects.hash(this.myStringUnescapedText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterStringDefaultValueMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterStringDefaultValueMatcher";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpParameterNullDefaultValueMatcher
    implements PhpParameterDefaultValueMatcher {
        private static final PhpParameterNullDefaultValueMatcher INSTANCE = new PhpParameterNullDefaultValueMatcher();

        private PhpParameterNullDefaultValueMatcher() {
        }

        @Override
        @NotNull
        public String getValue() {
            return "null";
        }
    }

    public static interface PhpParameterDefaultValueMatcher {
        default public boolean matches(@Nullable PsiElement argument) {
            PhpParameterDefaultValueMatcher matcher = PhpParametersDefaultValueMatchersIndex.createDefaultValueMatcher(argument);
            return matcher != null && matcher.equals(this);
        }

        @NotNull
        public String getValue();
    }

    private static class MyExternalizer
    implements DataExternalizer<TIntObjectHashMap<PhpParameterDefaultValueMatcher>> {
        private MyExternalizer() {
        }

        public void save(@NotNull DataOutput out, TIntObjectHashMap<PhpParameterDefaultValueMatcher> value) throws IOException {
            if (out == null) {
                MyExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (int key : value.keys()) {
                out.writeInt(key);
                MATCHER_EXTERNALIZER.save(out, (PhpParameterDefaultValueMatcher)value.get(key));
            }
        }

        public TIntObjectHashMap<PhpParameterDefaultValueMatcher> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            TIntObjectHashMap map = new TIntObjectHashMap(size);
            for (int i = 0; i < size; ++i) {
                int key = in.readInt();
                PhpParameterDefaultValueMatcher matcher = MATCHER_EXTERNALIZER.read(in);
                map.put(key, (Object)matcher);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$MyExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyDefaultValueMatcherExternalizer
    implements DataExternalizer<PhpParameterDefaultValueMatcher> {
        private MyDefaultValueMatcherExternalizer() {
        }

        public void save(@NotNull DataOutput out, PhpParameterDefaultValueMatcher value) throws IOException {
            if (out == null) {
                MyDefaultValueMatcherExternalizer.$$$reportNull$$$0(0);
            }
            if (value instanceof PhpParameterStringDefaultValueMatcher) {
                out.writeUTF("string");
                out.writeUTF(((PhpParameterStringDefaultValueMatcher)value).myStringUnescapedText);
                return;
            }
            if (value == PhpParameterNullDefaultValueMatcher.INSTANCE) {
                out.writeUTF("null");
                return;
            }
            if (value instanceof PhpParameterNumberDefaultValueMatcher) {
                out.writeUTF("num");
                out.writeUTF(((PhpParameterNumberDefaultValueMatcher)value).myText);
                return;
            }
            if (value instanceof PhpParameterConstantDefaultValueMatcher) {
                out.writeUTF("const");
                out.writeUTF(((PhpParameterConstantDefaultValueMatcher)value).mySignature);
                return;
            }
            throw new IllegalStateException(value.getClass().toString());
        }

        public PhpParameterDefaultValueMatcher read(@NotNull DataInput in) throws IOException {
            String s;
            if (in == null) {
                MyDefaultValueMatcherExternalizer.$$$reportNull$$$0(1);
            }
            if ("string".equals(s = in.readUTF())) {
                return new PhpParameterStringDefaultValueMatcher(in.readUTF());
            }
            if ("null".equals(s)) {
                return PhpParameterNullDefaultValueMatcher.INSTANCE;
            }
            if ("num".equals(s)) {
                return new PhpParameterNumberDefaultValueMatcher(in.readUTF());
            }
            if ("const".equals(s)) {
                return new PhpParameterConstantDefaultValueMatcher(in.readUTF());
            }
            throw new IllegalStateException(s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$MyDefaultValueMatcherExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

