/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpCallInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpHostInstructionImpl;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PhpFunctionsWithNotCatchedDynamicPassedCallsIndex
extends FileBasedIndexExtension<String, TIntHashSet> {
    @NonNls
    public static final ID<String, TIntHashSet> KEY = ID.create((String)"php.functions.with.not.catched.dynamic.passed.calls");
    public static final DataExternalizer<TIntHashSet> EXTERNALIZER = new DataExternalizer<TIntHashSet>(){

        public void save(@NotNull DataOutput out, TIntHashSet value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (int i : value.toArray()) {
                out.writeInt(i);
            }
        }

        public TIntHashSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            TIntHashSet set = new TIntHashSet(size);
            for (int i = 0; i < size; ++i) {
                set.add(in.readInt());
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFunctionsWithNotCatchedDynamicPassedCallsIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final TIntHashSet EMPTY = new TIntHashSet();

    @NotNull
    public ID<String, TIntHashSet> getName() {
        ID<String, TIntHashSet> iD = KEY;
        if (iD == null) {
            PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, TIntHashSet, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            HashMap<String, TIntHashSet> map = new HashMap<String, TIntHashSet>();
            PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PhpFile.class);
            if (file != null) {
                for (Function function : PhpFuncGetArgUsageProvider.findTopLevelFunctions((PsiFile)file)) {
                    TIntHashSet parameterIndicesCalledWithoutCatch = PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.getParameterIndicesCalledWithoutCatch(function);
                    if (parameterIndicesCalledWithoutCatch.isEmpty()) continue;
                    map.put(function.getFQN(), parameterIndicesCalledWithoutCatch);
                }
            }
            return map;
        };
        if (dataIndexer == null) {
            PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    private static TIntHashSet getParameterIndicesCalledWithoutCatch(Function function) {
        Parameter[] parameters = function.getParameters();
        if (parameters.length == 0) {
            TIntHashSet tIntHashSet = EMPTY;
            if (tIntHashSet == null) {
                PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.$$$reportNull$$$0(2);
            }
            return tIntHashSet;
        }
        final TObjectIntHashMap nonOverwrittenParameterNamesWithIndices = new TObjectIntHashMap(parameters.length);
        final HashSet nonCatchedCalledParameters = new HashSet(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            nonOverwrittenParameterNamesWithIndices.put((Object)parameters[i].getName(), i);
        }
        PhpControlFlowUtil.processFlow(function.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (nonOverwrittenParameterNamesWithIndices.isEmpty()) {
                    return false;
                }
                CharSequence name = instruction.getVariableName();
                if (!nonOverwrittenParameterNamesWithIndices.containsKey((Object)name)) {
                    return true;
                }
                if (instruction.getAccess().isWrite()) {
                    nonOverwrittenParameterNamesWithIndices.remove((Object)name);
                    return true;
                }
                return true;
            }

            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                FunctionReference reference = instruction.getFunctionReference();
                if (reference.getNameNode() == null) {
                    String variableName;
                    Variable variable = (Variable)ObjectUtils.tryCast((Object)reference.getFirstPsiChild(), Variable.class);
                    String string = variableName = variable != null ? variable.getName() : null;
                    if (variableName != null && nonOverwrittenParameterNamesWithIndices.containsKey((Object)variableName) && !PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.insideTryStatement(instruction)) {
                        nonCatchedCalledParameters.add(variableName);
                    }
                }
                return true;
            }
        });
        if (nonCatchedCalledParameters.isEmpty() || nonOverwrittenParameterNamesWithIndices.isEmpty()) {
            TIntHashSet tIntHashSet = EMPTY;
            if (tIntHashSet == null) {
                PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.$$$reportNull$$$0(3);
            }
            return tIntHashSet;
        }
        TIntHashSet res = new TIntHashSet();
        nonCatchedCalledParameters.forEach(name -> {
            if (nonOverwrittenParameterNamesWithIndices.containsKey(name)) {
                res.add(nonOverwrittenParameterNamesWithIndices.get(name));
            }
        });
        TIntHashSet tIntHashSet = res;
        if (tIntHashSet == null) {
            PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.$$$reportNull$$$0(4);
        }
        return tIntHashSet;
    }

    private static boolean insideTryStatement(PhpCallInstruction instruction) {
        return ((PhpCallInstructionImpl)instruction).getSuccessors().stream().anyMatch(PhpFunctionsWithNotCatchedDynamicPassedCallsIndex::isCatchHostInstruction);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isCatchHostInstruction(PhpInstruction instruction) {
        if (!(instruction instanceof PhpHostInstructionImpl)) return false;
        if (!((PhpHostInstructionImpl)instruction).getSuccessors().stream().anyMatch(PhpCatchConditionInstruction.class::isInstance)) return false;
        return true;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.$$$reportNull$$$0(5);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<TIntHashSet> getValueExternalizer() {
        DataExternalizer<TIntHashSet> dataExternalizer = EXTERNALIZER;
        if (dataExternalizer == null) {
            PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.$$$reportNull$$$0(6);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 1;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.$$$reportNull$$$0(7);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFunctionsWithNotCatchedDynamicPassedCallsIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterIndicesCalledWithoutCatch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

