/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.StringSetDataExternalizer;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFieldNamesAssignedByTheConstructorIndex
extends FileBasedIndexExtension<String, PhpAssignedFieldNamesData> {
    @NotNull
    @NonNls
    public static final ID<String, PhpAssignedFieldNamesData> KEY = ID.create((String)"php.field.names.accessed.by.the.constructor");

    @NotNull
    public ID<String, PhpAssignedFieldNamesData> getName() {
        ID<String, PhpAssignedFieldNamesData> iD = KEY;
        if (iD == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(1);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public DataIndexer<String, PhpAssignedFieldNamesData, FileContent> getIndexer() {
        return new DataIndexer<String, PhpAssignedFieldNamesData, FileContent>(){

            @NotNull
            public Map<String, PhpAssignedFieldNamesData> map(@NotNull FileContent inputData) {
                PhpFile file;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((file = (PhpFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PhpFile.class)) == null) {
                    Map<String, PhpAssignedFieldNamesData> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                Map map = ContainerUtil.map2Map(PhpPsiUtil.findClasses(file, (Condition<? super PhpClass>)Conditions.not(PhpClass::isInterface)), phpClass -> Pair.pair((Object)phpClass.getFQN(), (Object)PhpFieldNamesAssignedByTheConstructorIndex.getAssignedFieldsData(phpClass)));
                if (map == null) {
                    1.$$$reportNull$$$0(2);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFieldNamesAssignedByTheConstructorIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFieldNamesAssignedByTheConstructorIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    private static PhpAssignedFieldNamesData getAssignedFieldsData(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(2);
        }
        return new PhpAssignedFieldNamesData(PhpFieldNamesAssignedByTheConstructorIndex.getAssignedFieldNames(phpClass), PhpFieldNamesAssignedByTheConstructorIndex.canContainTransitiveFieldAssignmentsByConstructor(phpClass));
    }

    @NotNull
    private static Collection<String> getAssignedFieldNames(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(3);
        }
        Set assignedFieldNames = PhpClassImpl.getConstructorAssignmentsPerField(phpClass).keySet();
        Set nonAssignedFieldNames = ((StreamEx)((StreamEx)StreamEx.of((Object[])phpClass.getOwnFields()).filter(field -> !field.getModifier().isStatic())).map(PhpNamedElement::getName).filter(fieldName -> !assignedFieldNames.contains(fieldName))).toSet();
        Collection<String> implicitlyAssignedFieldNames = PhpFieldNamesAssignedByTheConstructorIndex.collectAssignedInConstructorViaArrayAccessWrite(phpClass, nonAssignedFieldNames);
        if (!implicitlyAssignedFieldNames.isEmpty()) {
            implicitlyAssignedFieldNames.addAll(assignedFieldNames);
            Collection<String> collection = implicitlyAssignedFieldNames;
            if (collection == null) {
                PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(4);
            }
            return collection;
        }
        Set set = assignedFieldNames;
        if (set == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    private static Collection<String> collectAssignedInConstructorViaArrayAccessWrite(@NotNull PhpClass phpClass, final @NotNull Set<String> nonAssignedFieldNames) {
        Method constructor;
        if (phpClass == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(6);
        }
        if (nonAssignedFieldNames == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(7);
        }
        if ((constructor = phpClass.getOwnConstructor()) == null || nonAssignedFieldNames.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(8);
            }
            return list;
        }
        THashSet assignedFieldNames = new THashSet();
        PhpExitPointInstruction exitPoint = constructor.getControlFlow().getExitPoint();
        PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)exitPoint, false, new PhpInstructionProcessor((Collection)assignedFieldNames){
            final /* synthetic */ Collection val$assignedFieldNames;
            {
                this.val$assignedFieldNames = collection;
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                if (this.isWriteInstruction((PhpAccessInstruction)instruction)) {
                    PhpAccessFieldByVariableInstruction nestedFieldInstruction = PhpFieldNamesAssignedByTheConstructorIndex.findFieldReadNestedInArrayAccess(instruction);
                    return this.processImplicitlyAssignedField(nestedFieldInstruction);
                }
                return true;
            }

            private boolean processImplicitlyAssignedField(@Nullable PhpAccessFieldByVariableInstruction fieldInstruction) {
                if (fieldInstruction == null || !PhpLangUtil.equalsVariableNames(fieldInstruction.getVariableName(), "this") || !nonAssignedFieldNames.contains(fieldInstruction.getFieldName())) {
                    return true;
                }
                String fieldName = fieldInstruction.getFieldName().toString();
                this.val$assignedFieldNames.add(fieldName);
                nonAssignedFieldNames.remove(fieldName);
                return !nonAssignedFieldNames.isEmpty();
            }

            private boolean isWriteInstruction(@NotNull PhpAccessInstruction instruction) {
                PhpAccessInstruction.Access access;
                if (instruction == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (access = instruction.getAccess()).isWrite() || access.isWriteRef();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/php/lang/psi/stubs/indexes/PhpFieldNamesAssignedByTheConstructorIndex$2", "isWriteInstruction"));
            }
        });
        THashSet tHashSet = assignedFieldNames;
        if (tHashSet == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(9);
        }
        return tHashSet;
    }

    @Nullable
    public static PhpAccessFieldByVariableInstruction findFieldReadNestedInArrayAccess(@NotNull PhpArrayAccessInstruction instruction) {
        ArrayAccessExpression arrayAccess;
        PhpPsiElement value;
        if (instruction == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(10);
        }
        PhpPsiElement phpPsiElement = value = (arrayAccess = (ArrayAccessExpression)ObjectUtils.tryCast((Object)instruction.getAnchor(), ArrayAccessExpression.class)) != null ? arrayAccess.getValue() : null;
        while (value instanceof ArrayAccessExpression) {
            value = ((ArrayAccessExpression)value).getValue();
        }
        return value != null ? PhpControlFlowUtil.getAccessInstruction(value, PhpAccessFieldByVariableInstruction.class) : null;
    }

    private static boolean canContainTransitiveFieldAssignmentsByConstructor(@NotNull PhpClass phpClass) {
        Method constructor;
        if (phpClass == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(11);
        }
        if ((constructor = phpClass.getOwnConstructor()) == null) {
            return false;
        }
        final Ref assignmentsCanHappenTransitively = Ref.create((Object)Boolean.FALSE);
        PhpControlFlowUtil.processFlow(constructor.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                if (PhpFieldNamesAssignedByTheConstructorIndex.canAffectTheInstanceStateByVariableName(instruction, "this")) {
                    assignmentsCanHappenTransitively.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }
        });
        return assignmentsCanHappenTransitively.get() == Boolean.TRUE;
    }

    public static boolean canAffectTheInstanceStateByVariableName(@NotNull PhpCallInstruction instruction, @NotNull CharSequence variableName) {
        FunctionReference reference;
        if (instruction == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(12);
        }
        if (variableName == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(13);
        }
        return (reference = instruction.getFunctionReference()) instanceof MethodReference && PhpFieldNamesAssignedByTheConstructorIndex.isSameInstanceReference((PsiElement)((MethodReference)reference).getClassReference(), variableName) || ContainerUtil.exists((Object[])reference.getParameters(), parameter -> PhpFieldNamesAssignedByTheConstructorIndex.isSameInstanceReference(parameter, variableName));
    }

    private static boolean isSameInstanceReference(@Nullable PsiElement variable, @NotNull CharSequence variableName) {
        if (variableName == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(14);
        }
        if ((variable = PhpPsiUtil.unparenthesize(variable)) instanceof ArrayCreationExpression) {
            Collection variables = PsiTreeUtil.findChildrenOfType((PsiElement)variable, PhpReference.class);
            return ContainerUtil.exists((Iterable)variables, v -> PhpFieldNamesAssignedByTheConstructorIndex.isSameInstanceReference((PsiElement)v, variableName));
        }
        if (variable instanceof AssignmentExpression) {
            return PhpFieldNamesAssignedByTheConstructorIndex.isSameInstanceReference((PsiElement)((AssignmentExpression)variable).getVariable(), variableName) || PhpFieldNamesAssignedByTheConstructorIndex.isSameInstanceReference((PsiElement)((AssignmentExpression)variable).getValue(), variableName);
        }
        return variable instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)variable).getNameCS(), variableName) || variable instanceof ClassReference && PhpLangUtil.isThisReference(variableName) && PhpLangUtil.isClassNameSpecial(((ClassReference)variable).getName());
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(15);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<PhpAssignedFieldNamesData> getValueExternalizer() {
        DataExternalizer<PhpAssignedFieldNamesData> dataExternalizer = PhpAssignedFieldNamesData.EXTERNALIZER;
        if (dataExternalizer == null) {
            PhpFieldNamesAssignedByTheConstructorIndex.$$$reportNull$$$0(16);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFieldNamesAssignedByTheConstructorIndex";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonAssignedFieldNames";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFieldNamesAssignedByTheConstructorIndex";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignedFieldNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAssignedInConstructorViaArrayAccessWrite";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedFieldsData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedFieldNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAssignedInConstructorViaArrayAccessWrite";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFieldReadNestedInArrayAccess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canContainTransitiveFieldAssignmentsByConstructor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canAffectTheInstanceStateByVariableName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSameInstanceReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpAssignedFieldNamesData {
        private static final DataExternalizer<PhpAssignedFieldNamesData> EXTERNALIZER = new DataExternalizer<PhpAssignedFieldNamesData>(){

            public void save(@NotNull DataOutput out, PhpAssignedFieldNamesData value) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                StringSetDataExternalizer.INSTANCE.save(out, value.myAssignedFieldNames);
                out.writeBoolean(value.isArbitraryFieldNameCouldBeAssigned);
            }

            public PhpAssignedFieldNamesData read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                Object assignedFields = StringSetDataExternalizer.INSTANCE.read(in);
                boolean isArbitraryFieldNameCouldBeAssigned = in.readBoolean();
                return new PhpAssignedFieldNamesData((Collection<String>)assignedFields, isArbitraryFieldNameCouldBeAssigned);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFieldNamesAssignedByTheConstructorIndex$PhpAssignedFieldNamesData$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        private final boolean isArbitraryFieldNameCouldBeAssigned;
        @NotNull
        private final Set<String> myAssignedFieldNames;

        public PhpAssignedFieldNamesData(@NotNull Collection<String> assignedFieldNames, boolean arbitraryFieldNameCouldBeAssigned) {
            if (assignedFieldNames == null) {
                PhpAssignedFieldNamesData.$$$reportNull$$$0(0);
            }
            this.myAssignedFieldNames = new HashSet<String>(assignedFieldNames);
            this.isArbitraryFieldNameCouldBeAssigned = arbitraryFieldNameCouldBeAssigned;
        }

        public boolean canBeAssigned(@NotNull String fieldName) {
            if (fieldName == null) {
                PhpAssignedFieldNamesData.$$$reportNull$$$0(1);
            }
            return this.isArbitraryFieldNameCouldBeAssigned || this.myAssignedFieldNames.contains(fieldName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpAssignedFieldNamesData data = (PhpAssignedFieldNamesData)o;
            return this.isArbitraryFieldNameCouldBeAssigned == data.isArbitraryFieldNameCouldBeAssigned && this.myAssignedFieldNames.equals(data.myAssignedFieldNames);
        }

        public int hashCode() {
            return Objects.hash(this.isArbitraryFieldNameCouldBeAssigned, this.myAssignedFieldNames);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignedFieldNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFieldNamesAssignedByTheConstructorIndex$PhpAssignedFieldNamesData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canBeAssigned";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

